/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.util;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.Startup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="GuiLogAppender", category="Core", elementType="appender", printObject=true)
public class GuiLogAppender
extends AbstractAppender {
    private static ArrayList<String> preBuffer = null;
    private static Startup startup = null;
    private Context context = null;
    private boolean hasBeenShown = false;

    public GuiLogAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    @Override
    public synchronized void append(LogEvent event) {
        byte[] data = this.getLayout().toByteArray(event);
        String line = new String(data).trim() + System.getProperty("line.separator");
        if (this.isGuiInitializing()) {
            this.preBuffer(line);
            if (this.context.cfg.isDefaultNavigator() || this.context.cfg.isGui()) {
                this.showStartup(line);
            }
        } else {
            if (preBuffer != null) {
                this.hideStartup();
                this.dumpPreBuffer();
            }
            this.appendGuiLogs(line);
        }
    }

    private void appendGuiLogs(String line) {
        this.context.mainFrame.textAreaLog.append(line);
    }

    @PluginFactory
    public static GuiLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="otherAttribute") String otherAttribute) {
        if (name == null) {
            LOGGER.error("No name provided for GuiLogAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        GuiLogAppender appender = new GuiLogAppender(name, filter, layout, true);
        return appender;
    }

    private void dumpPreBuffer() {
        for (String preLine : preBuffer) {
            if (preLine == null) continue;
            this.appendGuiLogs(preLine);
        }
        preBuffer = null;
    }

    public Context getContext() {
        return this.context;
    }

    public Component getStartup() {
        return startup;
    }

    private void hideStartup() {
        if (startup != null) {
            startup.setVisible(false);
        }
        this.hasBeenShown = true;
        startup = null;
    }

    public boolean isGuiInitializing() {
        return !this.hasBeenShown && (this.context == null || this.context.mainFrame == null || this.context.navigator == null || this.context.mainFrame.textAreaLog == null || (this.context.main.primaryExecution ? !this.context.mainFrame.textAreaLog.isVisible() : !this.context.mainFrame.textAreaLog.isShowing()));
    }

    public boolean isStartupActive() {
        return startup != null && startup.isVisible();
    }

    private void preBuffer(String line) {
        if (preBuffer == null) {
            preBuffer = new ArrayList();
        }
        preBuffer.add(line);
    }

    private void redraw() {
        Graphics gfx = GuiLogAppender.startup.startupTextField.getGraphics();
        if (gfx != null) {
            GuiLogAppender.startup.startupTextField.update(gfx);
        }
        GuiLogAppender.startup.startupTextField.repaint();
        startup.repaint();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private void showStartup(String msg) {
        if (startup == null) {
            try {
                Configuration cfr_ignored_0 = this.context.cfg;
                this.context.preferences.initLookAndFeel("ELS", true);
                startup = new Startup();
                if (startup != null) {
                    startup.setIconImage(new ImageIcon(this.getClass().getResource("/els-logo-98px.png")).getImage());
                    startup.setTitle(this.context.cfg.getNavigatorName());
                    GuiLogAppender.startup.labelVersion.setText("Version " + Configuration.getBuildVersionName());
                    if (this.context.preferences != null && Utils.isOnScreen(this.context.preferences.getAppXpos(), this.context.preferences.getAppYpos())) {
                        int x = this.context.preferences.getAppXpos() + this.context.preferences.getAppWidth() / 2 - startup.getWidth() / 2;
                        int y = this.context.preferences.getAppYpos() + this.context.preferences.getAppHeight() / 2 - startup.getHeight() / 2;
                        startup.setLocation(x, y);
                    } else {
                        int y;
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        int x = screenSize.width / 2 - startup.getWidth() / 2;
                        if (x < 0) {
                            x = 1;
                        }
                        if ((y = screenSize.height / 2 - startup.getHeight() / 2) < 0) {
                            y = 1;
                        }
                        startup.setLocation(x, y);
                    }
                    startup.setVisible(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GuiLogAppender.startup.startupTextField.setText(msg.substring(29));
        this.redraw();
    }

    @Override
    public void stop() {
    }
}

