/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.hints;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.hints.HintKey;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HintKeys {
    private Context context;
    private String filename;
    private ArrayList<HintKey> keys;
    private transient Logger logger = LogManager.getLogger("applog");

    public HintKeys(Context context) {
        this.context = context;
        this.keys = new ArrayList();
    }

    public HintKey findKey(String uuid) {
        for (HintKey key : this.keys) {
            if (!key.uuid.equals(uuid)) continue;
            return key;
        }
        return null;
    }

    public HintKey findSystem(String system) {
        for (HintKey key : this.keys) {
            if (!key.system.equals(system)) continue;
            return key;
        }
        return null;
    }

    public ArrayList<HintKey> get() {
        return this.keys;
    }

    public String getFilename() {
        return this.filename;
    }

    public void read(String file) throws Exception {
        String line;
        this.filename = Utils.getFullPathLocal(file);
        BufferedReader br = new BufferedReader(new FileReader(this.filename));
        int count = 0;
        boolean foundPublisher = false;
        boolean foundSubscriber = false;
        while ((line = br.readLine()) != null) {
            String part;
            ++count;
            String[] parts = line.split("[\\s]+");
            if (parts.length <= 0 || (part = parts[0].trim()).length() < 1 || part.equals("#")) continue;
            if (parts.length != 2) {
                throw new MungeException(MessageFormat.format(this.context.cfg.gs("HintKeys.malformed.line.reading.els.keys.file"), count) + file);
            }
            if (!this.context.cfg.isStatusServer() && !this.context.cfg.isNavigator()) {
                if (this.context.publisherRepo != null && parts[1].equals(this.context.publisherRepo.getLibraryData().libraries.key)) {
                    foundPublisher = true;
                }
                if (this.context.subscriberRepo != null && parts[1].equals(this.context.subscriberRepo.getLibraryData().libraries.key)) {
                    foundSubscriber = true;
                }
            }
            HintKey key = new HintKey();
            key.system = parts[0].trim();
            key.uuid = parts[1].trim();
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.add(key);
        }
        if (!this.context.cfg.isStatusServer() && !this.context.cfg.isNavigator()) {
            String which = "";
            if (this.context.publisherRepo != null && !foundPublisher) {
                which = "publisher";
            }
            if (this.context.subscriberRepo != null && !foundSubscriber) {
                which = "subscriber";
            }
            if (which.length() > 0) {
                String msg = MessageFormat.format(this.context.cfg.gs("Hints.the.current.key.was.not.found.in.hint.keys.file"), which, file);
                throw new MungeException(msg);
            }
        }
        this.logger.info(MessageFormat.format(this.context.cfg.gs("HintKeys.read.keys.successfully"), file));
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int size() {
        if (this.keys != null) {
            return this.keys.size();
        }
        return 0;
    }

    public void write(String header) throws Exception {
        String base = FilenameUtils.getFullPathNoEndSeparator(this.filename);
        File outdir = new File(base);
        outdir.mkdirs();
        BufferedWriter fw = new BufferedWriter(new FileWriter(this.filename));
        fw.write(header);
        fw.write(System.getProperty("line.separator"));
        for (int i = 0; i < this.keys.size(); ++i) {
            HintKey hintKey = this.keys.get(i);
            if (hintKey.system == null || hintKey.system.length() <= 0 || hintKey.uuid == null || hintKey.uuid.length() <= 0) continue;
            String line = hintKey.system + "\t\t" + hintKey.uuid + System.getProperty("line.separator");
            fw.write(line);
        }
        fw.write(System.getProperty("line.separator"));
        fw.close();
    }
}

