/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.hints;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.gui.hints.HintsTableModel;
import com.corionis.els.hints.Hint;
import com.corionis.els.hints.HintKey;
import com.corionis.els.hints.HintKeys;
import com.corionis.els.hints.HintStatus;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Hints {
    private final Marker SHORT = MarkerManager.getMarker("SHORT");
    private final Marker SIMPLE = MarkerManager.getMarker("SIMPLE");
    private final Logger logger = LogManager.getLogger("applog");
    private Context context;
    private int executedHints = 0;
    private Gson gsonBuilder = new GsonBuilder().create();
    private Gson gsonParser = new Gson();
    private HintKeys keys;
    private int trues = 0;

    public Hints(Context context, HintKeys hintKeys) {
        this.context = context;
        this.keys = hintKeys;
    }

    public ArrayList<Hint> checkConflicts(String library, String itemPath) throws Exception {
        ArrayList<Hint> results = new ArrayList();
        if (this.context.cfg.isRemoteStatusServer()) {
            String line = "conflict \"" + library + "\" \"" + itemPath + "\"";
            String response = this.context.hintsStty.roundTrip(line + "\n", null, 10000);
            if (!response.toLowerCase().equals("false")) {
                results = (ArrayList)this.gsonParser.fromJson(response, results.getClass());
            }
        } else {
            Hint conflicter = new Hint();
            conflicter.fromLibrary = library;
            conflicter.fromItemPath = itemPath;
            results = this.context.datastore.getAll(conflicter, "conflict");
        }
        return results;
    }

    private String execute(Repository repo, Hint hint) throws Exception {
        int forIndex = -2;
        String result = "false";
        boolean success = false;
        HintKey hk = this.context.hintsHandler.findHintKey(repo);
        forIndex = hint.isFor(hk.system);
        if (forIndex >= -1) {
            Library fromLib = repo.getLibrary(hint.fromLibrary);
            if (fromLib.items == null || fromLib.itemMap == null || fromLib.rescanNeeded) {
                repo.scan(fromLib.name);
            }
            if (hint.toLibrary != null && hint.toLibrary.length() > 0) {
                Library toLib = repo.getLibrary(hint.toLibrary);
                if (toLib.items == null || toLib.itemMap == null || toLib.rescanNeeded) {
                    repo.scan(toLib.name);
                }
            }
            if (hint.action.trim().toLowerCase().equals("mv")) {
                success = this.context.transfer.move(repo, hint);
            } else if (hint.action.trim().toLowerCase().equals("rm")) {
                success = this.context.transfer.remove(repo, hint);
            } else {
                throw new MungeException(this.context.cfg.gs("Hints.action.must.be.mv.or.rm"));
            }
            if (success) {
                result = "true";
            }
        }
        return result;
    }

    public HintKey findHintKey(Repository repo) {
        HintKey hintKey = this.keys.findKey(repo.getLibraryData().libraries.key);
        return hintKey;
    }

    public ArrayList<Hint> getAll() throws Exception {
        ArrayList results = null;
        if (this.context.cfg.isHintTrackingEnabled()) {
            if (this.context.cfg.isRemoteStatusServer()) {
                String line = "get \"all\"";
                String response = this.context.hintsStty.roundTrip(line + "\n", null, 10000);
                if (!response.toLowerCase().equals("false")) {
                    Type listType = new TypeToken<ArrayList<Hint>>(){}.getType();
                    results = (ArrayList)this.gsonParser.fromJson(response, listType);
                }
            } else if (this.context.datastore.hints != null) {
                results = new ArrayList();
                results.addAll(this.context.datastore.hints);
            }
        }
        return results;
    }

    public int getCount(String system) throws Exception {
        int count = 0;
        if (this.context.cfg.isHintTrackingEnabled()) {
            if (this.context.cfg.isRemoteStatusServer()) {
                String line = "count \"" + system + "\"";
                String response = this.context.hintsStty.roundTrip(line + "\n", null, 10000);
                if (!response.toLowerCase().equals("false")) {
                    count = Integer.valueOf(response);
                }
            } else if (this.context.datastore.hints != null) {
                count = this.context.datastore.count(system);
            }
        }
        return count;
    }

    public ArrayList<Hint> getFor(String hintSystemName) throws Exception {
        ArrayList results = null;
        if (this.context.cfg.isRemoteStatusServer()) {
            String line = "get \"for\" \"" + hintSystemName + "\"";
            String response = this.context.hintsStty.roundTrip(line + "\n", null, 10000);
            if (!response.toLowerCase().equals("false")) {
                Type listType = new TypeToken<ArrayList<Hint>>(){}.getType();
                results = (ArrayList)this.gsonParser.fromJson(response, listType);
            }
        } else if (this.context.datastore.hints != null) {
            results = this.context.datastore.getFor(hintSystemName);
        }
        return results;
    }

    public int getPerformed() {
        return this.trues;
    }

    public String hintsMunge(boolean publisherOnly, PrintWriter mismatches, PrintWriter mismatchFileHtml) throws Exception {
        String result = this.hintsMunge(null, true, null, null, null);
        if (!result.toLowerCase().equals("false")) {
            this.rescanLibraries(true);
        }
        if (!publisherOnly) {
            result = this.hintsMunge(null, false, null, mismatches, mismatchFileHtml);
        }
        return result;
    }

    public String hintsMunge(ArrayList<Hint> pending) throws Exception {
        String response = null;
        Repository repo = this.context.subscriberRepo;
        HintKey key = this.findHintKey(repo);
        if (key != null && key.system != null && pending != null && pending.size() > 0) {
            for (int i = 0; i < pending.size(); ++i) {
                try {
                    Hint hint = pending.get(i);
                    ++this.executedHints;
                    this.logger.info(this.context.cfg.gs("Hints.executing.hint") + this.executedHints + ": " + hint.getLocalUtc(this.context));
                    response = this.execute(repo, hint);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(Utils.getStackTrace(e));
                    response = "fault";
                }
            }
            this.logger.info(this.context.cfg.gs("Hints.execution.complete") + response);
        }
        return response;
    }

    public String hintsMunge(ArrayList<Hint> pending, boolean forMe, HintsTableModel model, PrintWriter mismatchesFile, PrintWriter mismatchesFileHtml) throws Exception {
        int falses = 0;
        int faults = 0;
        int forIndex = -2;
        int nots = 0;
        String response = "false";
        Repository repo = forMe ? this.context.publisherRepo : this.context.subscriberRepo;
        if (this.context.cfg.isDryRun()) {
            this.logger.info(this.context.cfg.gs("Hints.skipping.munge.of.hints.to") + repo.getLibraryData().libraries.description + " (--dry-run)");
        } else {
            this.logger.info(this.context.cfg.gs("Hints.munging.hints.to") + repo.getLibraryData().libraries.description);
            HintKey key = this.findHintKey(repo);
            if (key != null && key.system != null) {
                if (pending == null || pending.size() < 1) {
                    pending = this.getFor(key.system);
                }
                if (pending != null && pending.size() > 0) {
                    if (mismatchesFile != null) {
                        mismatchesFile.println(this.context.cfg.gs("Hints.hints") + "\n");
                        mismatchesFile.println(this.context.cfg.gs("Hints.munging.hints.to") + repo.getLibraryData().libraries.description + "\n");
                        mismatchesFileHtml.println("<h3>" + this.context.cfg.gs("Hints.hints") + "</h3>");
                        mismatchesFileHtml.println(this.context.cfg.gs("Hints.munging.hints.to") + repo.getLibraryData().libraries.description);
                        mismatchesFileHtml.println("<br/><br/>");
                        mismatchesFileHtml.println("<span style=\"font-family: monospace; font-size: 110%;\">");
                    }
                    this.executedHints = 0;
                    for (int i = 0; i < pending.size(); ++i) {
                        Hint hint = pending.get(i);
                        forIndex = hint.isFor(key.system);
                        if (forIndex >= -1) {
                            try {
                                ++this.executedHints;
                                this.logger.info(this.context.cfg.gs("Hints.executing.hint") + this.executedHints + ": " + hint.getLocalUtc(this.context));
                                if (!forMe && this.context.cfg.isRemoteSubscriber()) {
                                    String json = this.gsonBuilder.toJson(hint);
                                    String line = "\"execute\" " + json;
                                    response = this.context.clientStty.roundTrip(line + "\n", null, 20000);
                                    if (response.trim().toLowerCase().equals("true")) {
                                        if (hint.action.trim().toLowerCase().equals("mv")) {
                                            repo.getLibrary((String)hint.fromLibrary).rescanNeeded = true;
                                            repo.getLibrary((String)hint.toLibrary).rescanNeeded = true;
                                        } else {
                                            repo.getLibrary((String)hint.fromLibrary).rescanNeeded = true;
                                        }
                                    }
                                } else {
                                    response = this.execute(repo, hint);
                                }
                            }
                            catch (Exception e) {
                                this.logger.error(Utils.getStackTrace(e));
                                response = "fault";
                            }
                            Object summary = hint.getActionSummary(this.context, key.system);
                            if (response.trim().toLowerCase().equals("true")) {
                                ++this.trues;
                                summary = "True, " + (String)summary;
                                hint.setStatus(key.system, "Done");
                            } else if (!response.trim().toLowerCase().equals("false")) {
                                ++faults;
                                summary = "Fault, " + (String)summary;
                                hint.setStatus(key.system, "Fault");
                            } else {
                                ++falses;
                                summary = "False, " + (String)summary;
                                hint.setStatus(key.system, "Done");
                            }
                            if (mismatchesFile != null) {
                                mismatchesFile.println((String)summary);
                                mismatchesFileHtml.println((String)summary + "<br/>");
                            }
                            if (model != null) {
                                model.fireTableDataChanged();
                            }
                            this.writeOrUpdateHint(hint, key.uuid);
                            continue;
                        }
                        ++nots;
                    }
                    if (mismatchesFileHtml != null) {
                        mismatchesFileHtml.println("</span>");
                    }
                    if (faults > 0) {
                        response = "fault";
                        if (mismatchesFile != null) {
                            mismatchesFile.println("Faults: " + faults);
                            mismatchesFileHtml.println("Faults: " + faults + "<br/>");
                        }
                    } else {
                        response = this.trues > 0 ? "true" : "false";
                    }
                    this.logger.info("------------------------------------------");
                    this.logger.info(this.context.cfg.gs("Hints.hint.execution.complete.result") + response);
                    if (falses > 0) {
                        this.logger.info(this.context.cfg.gs("Hints.not.performed") + falses);
                    }
                    if (this.trues > 0) {
                        this.logger.info(this.context.cfg.gs("Hints.performed") + this.trues);
                    }
                    if (nots > 0) {
                        this.logger.info(this.context.cfg.gs("Hints.not.for") + nots);
                    }
                    if (faults > 0) {
                        this.logger.info(this.context.cfg.gs("Hints.faults") + faults);
                    }
                    this.logger.info(this.context.cfg.gs("Hints.total") + this.executedHints);
                    this.logger.info("------------------------------------------");
                    if (mismatchesFile != null) {
                        mismatchesFile.println("------------------------------------------");
                        mismatchesFile.println(this.context.cfg.gs("Hints.hint.execution.complete.result") + response);
                        if (falses > 0) {
                            mismatchesFile.println(this.context.cfg.gs("Hints.not.performed") + falses);
                        }
                        if (this.trues > 0) {
                            mismatchesFile.println(this.context.cfg.gs("Hints.performed") + this.trues);
                        }
                        if (nots > 0) {
                            mismatchesFile.println(this.context.cfg.gs("Hints.not.for") + nots);
                        }
                        if (faults > 0) {
                            mismatchesFile.println(this.context.cfg.gs("Hints.faults") + faults);
                        }
                        mismatchesFile.println(this.context.cfg.gs("Hints.total") + this.executedHints);
                        mismatchesFile.println("");
                        mismatchesFileHtml.println("<hr style=\"margin-left: 0; margin-right: auto; width: 50%;\">");
                        mismatchesFileHtml.println(this.context.cfg.gs("Hints.hint.execution.complete.result") + response + "<br/>");
                        if (falses > 0) {
                            mismatchesFileHtml.println(this.context.cfg.gs("Hints.not.performed") + falses + "<br/>");
                        }
                        if (this.trues > 0) {
                            mismatchesFileHtml.println(this.context.cfg.gs("Hints.performed") + this.trues + "<br/>");
                        }
                        if (nots > 0) {
                            mismatchesFileHtml.println(this.context.cfg.gs("Hints.not.for") + nots + "<br/>");
                        }
                        if (faults > 0) {
                            mismatchesFileHtml.println(this.context.cfg.gs("Hints.faults") + faults + "<br/>");
                        }
                        mismatchesFileHtml.println(this.context.cfg.gs("Hints.total") + this.executedHints + "<br/>");
                        mismatchesFileHtml.println("");
                    }
                }
            }
        }
        return response;
    }

    private boolean isDone(Hint hint) {
        if (hint.statuses != null && hint.statuses.size() > 0) {
            if (hint.statuses.size() != this.context.hintKeys.size()) {
                return false;
            }
            for (int i = 0; i < hint.statuses.size(); ++i) {
                HintStatus hs = hint.statuses.get(i);
                if (hs.status.trim().toLowerCase().equals("done")) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void rescanLibraries(boolean scanPublisher) throws Exception {
        Repository repo = scanPublisher ? this.context.publisherRepo : this.context.subscriberRepo;
        for (Library lib : repo.getLibraryData().libraries.bibliography) {
            if (!lib.rescanNeeded) continue;
            repo.scan(lib.name);
        }
    }

    public String save(ArrayList<Hint> hints) throws Exception {
        String response = "true";
        if (this.context.cfg.isHintTrackingEnabled()) {
            if (this.context.cfg.isRemoteStatusServer()) {
                Type listType = new TypeToken<ArrayList<Hint>>(){}.getType();
                String json = this.gsonBuilder.toJson(hints, listType);
                String line = "\"save\" " + json;
                response = this.context.hintsStty.roundTrip(line + "\n", null, 10000);
            } else {
                this.context.datastore.hints = hints;
                this.context.datastore.write();
            }
        }
        return response;
    }

    public void writeHint(String action, boolean isWorkstation, NavTreeUserObject sourceTuo, NavTreeUserObject targetTuo) throws Exception {
        boolean targetIsCollection;
        if (isWorkstation && !sourceTuo.isSubscriber()) {
            return;
        }
        boolean sourceIsCollection = sourceTuo.node.getMyTree().getName().toLowerCase().contains("collection");
        boolean bl = targetIsCollection = targetTuo != null ? targetTuo.node.getMyTree().getName().toLowerCase().contains("collection") : false;
        if (sourceTuo.isSubscriber() && !sourceIsCollection) {
            return;
        }
        if (sourceIsCollection || targetIsCollection) {
            String act;
            HintKey hk = this.context.hintKeys.findKey(sourceTuo.node.getMyRepo().getLibraryData().libraries.key);
            if (hk == null) {
                return;
            }
            Hint hint = new Hint();
            hint.author = "User";
            hint.system = hk.system;
            hint.action = act = action.trim().toLowerCase();
            hint.fromLibrary = sourceTuo.getParentLibrary().getUserObject().name;
            hint.fromItemPath = this.context.navigator.reduceCollectionPath(sourceTuo);
            hint.directory = sourceTuo.isDir;
            if (act.equals("mv")) {
                Object moveTo = this.context.navigator.reduceCollectionPath(targetTuo);
                if (sourceTuo.node != targetTuo.node) {
                    if (((String)moveTo).length() > 0 && !((String)moveTo).trim().endsWith("|")) {
                        moveTo = (String)moveTo + targetTuo.getRepo().getSeparator();
                    }
                    moveTo = (String)moveTo + Utils.getRightPath(sourceTuo.getPath(), sourceTuo.getRepo().getSeparator());
                }
                hint.toLibrary = targetTuo.getParentLibrary().getUserObject().name;
                hint.toItemPath = moveTo;
            } else if (!act.equals("rm")) {
                throw new MungeException(this.context.cfg.gs("Hints.action.must.be.mv.or.rm"));
            }
            hint.setStatus(hk.system, "Done");
            String sourceKey = sourceTuo.isSubscriber() ? this.context.subscriberRepo.getLibraryData().libraries.key : this.context.publisherRepo.getLibraryData().libraries.key;
            this.writeOrUpdateHint(hint, sourceKey);
        }
    }

    public boolean writeOrUpdateHint(Hint hint, String sourceKey) throws Exception {
        String response;
        String line;
        Object json;
        Hint dsHint = null;
        boolean found = false;
        boolean success = false;
        if (this.context.cfg.isRemoteStatusServer()) {
            json = this.gsonBuilder.toJson(hint);
            line = "get \"full\" " + (String)json;
            response = this.context.hintsStty.roundTrip(line + "\n", "Sending remote Hint Server: " + line, 10000);
            this.logger.debug("Hint Server response: " + response);
            if (!response.equals("false")) {
                dsHint = this.gsonParser.fromJson(response, Hint.class);
            }
        } else {
            dsHint = this.context.datastore.get(hint, "full");
        }
        if (dsHint != null) {
            found = true;
            dsHint.copyStatusFrom(hint);
            hint = dsHint;
        } else if (sourceKey != null) {
            for (HintKey key : this.context.hintKeys.get()) {
                HintStatus stat = new HintStatus();
                if (key.uuid.equalsIgnoreCase(sourceKey)) {
                    hint.setStatus(key.system, "Done");
                    continue;
                }
                hint.setStatus(key.system, "For");
            }
        }
        if (this.context.cfg.isRemoteStatusServer()) {
            json = this.gsonBuilder.toJson(hint);
            line = "\"hint\" " + (String)json;
            response = this.context.hintsStty.roundTrip(line + "\n", "Sending remote Hint Server: " + line, 10000);
            this.logger.info("Hint Server response: " + response);
            if (response.toLowerCase().equals("true")) {
                success = true;
            }
        } else {
            if (!found) {
                this.context.datastore.add(hint);
            }
            if (this.isDone(hint)) {
                this.context.datastore.hints.remove(hint);
                if (this.executedHints < 1) {
                    this.executedHints = 1;
                }
                this.logger.info(this.context.cfg.gs("Hints.hint.done.and.removed") + this.executedHints + ": " + hint.getLocalUtc(this.context) + ", " + this.context.datastore.hints.size() + " remaining");
            }
            this.context.datastore.write();
            success = true;
        }
        if (this.context.cfg.isNavigator()) {
            this.context.navigator.checkForHints();
            if (this.context.navigator.dialogHints != null && this.context.navigator.dialogHints.isShowing()) {
                this.context.navigator.dialogHints.refresh();
            }
        }
        return success;
    }
}

