/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.jobs;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Persistent;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Job;
import com.corionis.els.jobs.Origin;
import com.corionis.els.repository.RepoMeta;
import com.corionis.els.repository.Repositories;
import com.corionis.els.repository.Repository;
import com.corionis.els.tools.AbstractTool;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Task
implements Comparable,
Serializable {
    public static final String ANY_SERVER = "_ANY_SERVER_";
    public static final String CACHEDLASTTASK = "_CACHEDLASTTASK_";
    public String configName = null;
    public String internalName = null;
    public String emailTool = "";
    public String hintsKey = "";
    public boolean hintsOverrideHost = false;
    public String hintsPath = "";
    public boolean hintsRemote = false;
    public String publisherKey = "";
    public String publisherPath = "";
    public String subscriberKey = "";
    public String subscriberOverride = "";
    public String subscriberPath = "";
    public boolean subscriberRemote = false;
    public ArrayList<Origin> origins;
    public transient AbstractTool currentTool = null;
    public transient boolean dryRun = false;
    public transient Repository hintsRepo = null;
    public transient Context localContext = null;
    public transient Task previousTask = null;
    public transient Repository publisherRepo = null;
    public transient String remoteType = null;
    public transient Repository subscriberRepo = null;
    private transient Logger logger = LogManager.getLogger("applog");

    private Task() {
    }

    public Task(String internalName, String configName) {
        this.internalName = internalName;
        this.configName = configName;
        this.origins = new ArrayList();
    }

    public Task(AbstractTool currentTool) {
        this.currentTool = currentTool;
        this.configName = currentTool.getConfigName();
        this.internalName = currentTool.getInternalName();
        this.origins = new ArrayList();
    }

    public void addOrigins(ArrayList<Origin> origins) {
        this.origins.addAll(origins);
    }

    public Task clone() {
        Task task = new Task(this.getInternalName(), this.getConfigName());
        task.setContext(this.localContext);
        task.setEmailTool(this.getEmailTool());
        task.setHintsKey(this.getHintsKey());
        task.setHintsOverrideHost(this.isHintsOverrideHost());
        task.setHintsPath(this.getHintsPath());
        task.setHintsRemote(this.isHintsRemote());
        task.setPublisherKey(this.getPublisherKey());
        task.setPublisherPath(this.getPublisherPath());
        task.setSubscriberKey(this.getSubscriberKey());
        task.setSubscriberOverride(this.getSubscriberOverride());
        task.setSubscriberPath(this.getSubscriberPath());
        task.setSubscriberRemote(this.isSubscriberRemote());
        ArrayList<Origin> origins = new ArrayList<Origin>();
        for (Origin origin : this.getOrigins()) {
            origins.add(origin.clone());
        }
        task.setOrigins(origins);
        task.currentTool = this.currentTool;
        task.dryRun = this.dryRun;
        task.previousTask = this.previousTask;
        task.publisherRepo = this.publisherRepo;
        task.remoteType = this.remoteType;
        task.subscriberRepo = this.subscriberRepo;
        return task;
    }

    public int compareTo(Object o) {
        return this.getConfigName().compareTo(((Task)o).getConfigName());
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getEmailTool() {
        return this.emailTool;
    }

    public String getHintsKey() {
        return this.hintsKey;
    }

    public String getHintsPath() {
        return this.hintsPath;
    }

    public Repository getHintsRepo() {
        return this.hintsRepo;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public ArrayList<Origin> getOrigins() {
        return this.origins;
    }

    public String getPublisherKey() {
        return this.publisherKey;
    }

    public String getPublisherPath() {
        return this.publisherPath;
    }

    private Repository getRepo(String key, String path, int purpose) throws Exception {
        Repository repo = null;
        if (key != null && key.length() > 0) {
            if (key.equals(ANY_SERVER)) {
                if (purpose == 1) {
                    repo = this.localContext.publisherRepo;
                } else if (purpose == 2) {
                    repo = this.localContext.subscriberRepo;
                    this.setSubscriberOverride(this.localContext.cfg.getOverrideSubscriberHost());
                    this.setSubscriberRemote(this.localContext.cfg.isRemoteSubscriber());
                } else {
                    repo = this.localContext.hintsRepo;
                    this.setHintsOverrideHost(this.localContext.cfg.isOverrideHintsHost());
                    this.setHintsRemote(this.localContext.cfg.isRemoteStatusServer());
                }
            } else if (purpose == 1 && this.localContext.publisherRepo != null && this.localContext.publisherRepo.getLibraryData().libraries.key.equals(key)) {
                repo = this.localContext.publisherRepo;
            } else if (purpose == 2 && this.localContext.subscriberRepo != null && this.localContext.subscriberRepo.getLibraryData().libraries.key.equals(key)) {
                repo = this.localContext.subscriberRepo;
            } else if (purpose == 3 && this.localContext.hintsRepo != null && this.localContext.hintsRepo.getLibraryData().libraries.key.equals(key)) {
                repo = this.localContext.hintsRepo;
            } else {
                Repositories repositories = new Repositories();
                repositories.loadList(this.localContext);
                if (path.length() > 0) {
                    RepoMeta repoMeta = repositories.findMetaPath(path);
                    if (repoMeta != null) {
                        repo = new Repository(this.localContext, purpose);
                        repo.read(repoMeta.path, purpose == 1 ? "Publisher" : (purpose == 2 ? "Subscriber" : "Hint Status Server"), false);
                    } else {
                        throw new MungeException(path + ", " + key + this.localContext.cfg.gs("Z.not.found"));
                    }
                }
            }
        }
        this.localContext.cfg.setPublisherCollectionFilename("");
        this.localContext.cfg.setSubscriberCollectionFilename("");
        if (repo != null) {
            switch (purpose) {
                case 1: {
                    this.localContext.cfg.setPublisherLibrariesFileName(repo.getJsonFilename());
                    this.localContext.publisherRepo = repo;
                    break;
                }
                case 2: {
                    this.localContext.cfg.setSubscriberLibrariesFileName(repo.getJsonFilename());
                    this.localContext.subscriberRepo = repo;
                    break;
                }
                case 3: {
                    this.localContext.cfg.setHintsDaemonFilename("");
                    this.localContext.cfg.setHintTrackerFilename("");
                    if (this.isHintsRemote()) {
                        this.localContext.cfg.setHintsDaemonFilename(repo.getJsonFilename());
                        break;
                    }
                    this.localContext.cfg.setHintTrackerFilename(repo.getJsonFilename());
                }
            }
        }
        return repo;
    }

    public String getSubscriberKey() {
        return this.subscriberKey;
    }

    public String getSubscriberOverride() {
        return this.subscriberOverride;
    }

    public String getSubscriberPath() {
        return this.subscriberPath;
    }

    public AbstractTool getTool() throws Exception {
        this.currentTool = this.localContext.tools.loadTool(this.localContext, this.getInternalName(), this.getConfigName());
        return this.currentTool;
    }

    public boolean isHintsOverrideHost() {
        return this.hintsOverrideHost;
    }

    public boolean isHintsRemote() {
        return this.hintsRemote;
    }

    public boolean isJob() {
        return this.getInternalName().equalsIgnoreCase(Job.INTERNAL_NAME) && this.getOrigins().size() == 0;
    }

    public boolean isSubscriberRemote() {
        return this.subscriberRemote;
    }

    public boolean isToolCachedOrigins(Context context) {
        AbstractTool tool = context.tools.makeTempTool(this.getInternalName(), context);
        return tool.isToolCachedOrigins();
    }

    public boolean process(Context context) throws Exception {
        if (this.logger == null) {
            this.logger = LogManager.getLogger("applog");
        }
        if (this.currentTool == null) {
            this.currentTool = this.getTool();
        } else {
            this.currentTool.setContext(this.localContext);
        }
        if (this.currentTool != null) {
            if ((this.origins == null || this.origins.size() == 0) && !this.useCachedLastTask(this.localContext) && this.currentTool.isToolOriginsUsed()) {
                if (this.localContext.navigator != null) {
                    String msg = this.localContext.cfg.gs("JobsUI.task.has.no.origins") + this.currentTool.getDisplayName() + ", " + this.currentTool.getConfigName();
                    this.logger.info(msg);
                    JOptionPane.showMessageDialog(this.localContext.mainFrame, msg, this.localContext.cfg.gs("JobsUI.title"), 2);
                } else {
                    this.logger.info(this.localContext.cfg.gs("JobsUI.task.has.no.origins") + this.currentTool.getDisplayName() + ", " + this.currentTool.getConfigName());
                }
                return false;
            }
            if (this.useCachedLastTask(this.localContext)) {
                this.setPublisherKey(this.previousTask.getPublisherKey());
                if (this.previousTask.publisherRepo != null) {
                    this.publisherPath = this.previousTask.publisherRepo.getJsonFilename();
                    this.publisherRepo = this.previousTask.publisherRepo;
                } else {
                    this.publisherPath = "";
                }
                this.remoteType = this.previousTask.remoteType;
                if (this.previousTask.subscriberRepo != null) {
                    this.subscriberPath = this.previousTask.subscriberRepo.getJsonFilename();
                    this.setSubscriberKey(this.previousTask.getSubscriberKey());
                    this.setSubscriberOverride(this.previousTask.subscriberOverride);
                    this.setSubscriberRemote(this.previousTask.subscriberRemote);
                } else {
                    this.subscriberPath = "";
                }
                this.subscriberRepo = this.previousTask.subscriberRepo;
                this.setHintsKey(this.previousTask.getHintsKey());
                this.setHintsOverrideHost(this.previousTask.isHintsOverrideHost());
                this.setHintsRemote(this.previousTask.isHintsRemote());
                this.hintsPath = this.previousTask.hintsPath;
                this.setOrigins(this.previousTask.getOrigins());
            } else {
                this.publisherRepo = this.getRepo(this.getPublisherKey(), this.getPublisherPath(), 1);
                if (this.publisherRepo != null) {
                    this.publisherPath = this.publisherRepo.getJsonFilename();
                } else if (this.getPublisherKey().equals(ANY_SERVER)) {
                    throw new MungeException("\"Any Server\" defined for Publisher but none specified");
                }
                this.subscriberRepo = this.getRepo(this.getSubscriberKey(), this.getSubscriberPath(), 2);
                if (this.subscriberRepo != null) {
                    this.subscriberPath = this.subscriberRepo.getJsonFilename();
                } else if (this.getSubscriberKey().equals(ANY_SERVER)) {
                    throw new MungeException("\"Any Server\" defined for Subscriber but none specified");
                }
                this.remoteType = this.isSubscriberRemote() || this.getSubscriberKey().equals(ANY_SERVER) && this.localContext.cfg.isRemoteOperation() ? "P" : "-";
                this.hintsRepo = this.getRepo(this.getHintsKey(), this.getHintsPath(), 3);
                if (this.hintsRepo != null) {
                    this.hintsPath = this.hintsRepo.getJsonFilename();
                } else if (this.getHintsKey().equals(ANY_SERVER)) {
                    throw new MungeException("\"Any Server\" defined for Hint Status Server but none specified");
                }
            }
            if (this.publisherRepo != null) {
                Persistent.lastPublisherRepo = this.publisherRepo;
            }
            if (this.subscriberRepo != null) {
                Persistent.lastSubscriberRepo = this.subscriberRepo;
            }
            this.localContext.cfg.setOperation(this.remoteType);
            this.currentTool.processTool(this);
            if (this.currentTool.isRequestStop()) {
                return false;
            }
        } else {
            throw new MungeException(this.localContext.cfg.gs("Task.tool.not.found") + this.getInternalName() + ": " + this.getConfigName());
        }
        context.fault = this.localContext.fault;
        return true;
    }

    public void requestStop() {
        if (this.currentTool != null) {
            this.currentTool.requestStop();
        }
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setContext(Context context) {
        this.localContext = context;
    }

    public void setDryRun(boolean sense) {
        this.dryRun = sense;
    }

    public void setEmailTool(String emailTool) {
        this.emailTool = emailTool;
    }

    public void setHintsKey(String hintsKey) {
        this.hintsKey = hintsKey;
    }

    public void setHintsOverrideHost(boolean hintsOverrideHost) {
        this.hintsOverrideHost = hintsOverrideHost;
    }

    public void setHintsPath(String hintsPath) {
        this.hintsPath = Utils.makeRelativePath(this.localContext.cfg.getWorkingDirectory(), hintsPath);
    }

    public void setHintsRemote(boolean isHintsRemote) {
        this.hintsRemote = isHintsRemote;
    }

    public void setHintsRepo(Repository hintsRepo) {
        this.hintsRepo = hintsRepo;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public void setOrigins(ArrayList<Origin> origins) {
        this.origins = origins;
    }

    public void setPreviousTask(Task previousTask) {
        this.previousTask = previousTask;
    }

    public void setPublisherKey(String publisherKey) {
        this.publisherKey = publisherKey;
    }

    public void setPublisherPath(String publisherPath) {
        this.publisherPath = Utils.makeRelativePath(this.localContext.cfg.getWorkingDirectory(), publisherPath);
    }

    public void setSubscriberKey(String subscriberKey) {
        this.subscriberKey = subscriberKey;
    }

    public void setSubscriberOverride(String subscriberOverride) {
        this.subscriberOverride = subscriberOverride;
    }

    public void setSubscriberPath(String subscriberPath) {
        this.subscriberPath = Utils.makeRelativePath(this.localContext.cfg.getWorkingDirectory(), subscriberPath);
    }

    public void setSubscriberRemote(boolean isSubscriberRemote) {
        this.subscriberRemote = isSubscriberRemote;
    }

    public boolean useCachedLastTask(Context context) {
        return this.isToolCachedOrigins(context) && this.previousTask != null && this.publisherKey.equalsIgnoreCase(CACHEDLASTTASK);
    }
}

