/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.storage;

import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.storage.Target;
import com.corionis.els.storage.TargetData;
import com.corionis.els.storage.Targets;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Storage {
    public static final long MINIMUM_BYTES = 0x280000000L;
    private String jsonFilename = "";
    private transient Logger logger = LogManager.getLogger("applog");
    private TargetData targetData = null;

    public String getJsonFilename() {
        return this.jsonFilename;
    }

    public void setJsonFilename(String jsonFilename) {
        this.jsonFilename = jsonFilename;
    }

    public Target getLibraryTarget(String libraryName) throws MungeException {
        Target target = null;
        if (this.targetData != null) {
            boolean has = false;
            for (Target tar : this.targetData.targets.storage) {
                if (!tar.name.equalsIgnoreCase(libraryName)) continue;
                if (has) {
                    throw new MungeException("Storage name " + tar.name + " found more than once in " + this.getJsonFilename());
                }
                has = true;
                target = tar;
            }
        }
        return target;
    }

    private void normalize(String flavor) {
        if (this.targetData != null) {
            String from = "";
            String to = "";
            if (flavor.equalsIgnoreCase("Linux") || flavor.equalsIgnoreCase("Mac")) {
                from = "\\\\";
                to = "/";
            } else if (flavor.equalsIgnoreCase("Windows")) {
                from = "/";
                to = "\\\\";
            }
            for (Target tar : this.targetData.targets.storage) {
                for (int j = 0; j < tar.locations.length; ++j) {
                    tar.locations[j] = tar.locations[j].replaceAll(from, to);
                    if (!tar.locations[j].endsWith(to)) continue;
                    tar.locations[j].substring(0, tar.locations[j].length() - 2);
                }
            }
        }
    }

    public void read(String filename, String flavor) throws MungeException {
        try {
            Gson gson = new Gson();
            this.logger.info("Reading Targets file " + filename);
            filename = Utils.getFullPathLocal(filename);
            this.setJsonFilename(filename);
            String json = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
            this.targetData = gson.fromJson(json, TargetData.class);
            this.normalize(flavor);
        }
        catch (IOException ioe) {
            throw new MungeException("Exception while reading targets: " + filename + " trace: " + Utils.getStackTrace(ioe));
        }
    }

    public void validate() throws MungeException {
        if (this.targetData == null) {
            throw new MungeException("TargetData are null");
        }
        Targets targets = this.targetData.targets;
        if (targets.description == null || targets.description.length() == 0) {
            throw new MungeException("targets.description must be defined");
        }
        for (int i = 0; i < targets.storage.length; ++i) {
            Target t = targets.storage[i];
            if (t.name == null || t.name.length() == 0) {
                throw new MungeException("storage.name [" + i + "] must be defined");
            }
            if (t.minimum == null || t.minimum.length() == 0) {
                throw new MungeException("storage.minimum [" + i + "] must be defined");
            }
            long min = Utils.getScaledValue(t.minimum);
            if (min < 0x280000000L) {
                this.logger.warn("Storage.minimum [" + i + "] " + t.name + " of " + t.minimum + " is less than allowed minimum of 10240MB. Using allowed minimum.");
            }
            if (t.locations == null || t.locations.length == 0) {
                throw new MungeException("storage.locations [" + i + "] " + t.name + " must be defined");
            }
            for (int j = 0; j < t.locations.length; ++j) {
                if (t.locations[j].length() == 0) {
                    throw new MungeException("storage[" + i + "].locations[" + j + "] " + t.name + " must be defined");
                }
                if (Files.notExists(Paths.get(t.locations[j], new String[0]), new LinkOption[0])) {
                    throw new MungeException("storage[" + i + "].locations[" + j + "]: " + t.locations[j] + " does not exist");
                }
                this.logger.debug("  loc: " + t.locations[j]);
            }
        }
        this.logger.debug("Targets validation successful: " + this.getJsonFilename());
    }
}

