/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.repository.Repository;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDaemon {
    protected static Logger logger = LogManager.getLogger("applog");
    protected InetAddress address;
    protected boolean authorized = false;
    protected int commandCount = 0;
    protected boolean connected = false;
    protected Context context;
    protected boolean fault = false;
    private Thread heartBeat = null;
    private boolean heartBeatEnabled = true;
    protected DataInputStream in = null;
    protected String myKey;
    protected Repository myRepo;
    protected DataOutputStream out = null;
    protected int port;
    protected String response = "";
    protected Socket socket;
    protected int status = 0;
    protected Repository theirRepo;

    public AbstractDaemon(Context context, Repository mine, Repository theirs) {
        this.context = context;
        this.myRepo = mine;
        if (theirs != null) {
            this.theirRepo = theirs;
        }
        this.myKey = this.myRepo.getLibraryData().libraries.key;
    }

    protected void createHeartBeat() {
        this.heartBeat = new Thread(){

            @Override
            public void run() {
                String exceptionMessage = "";
                String errorMessage = "";
                try {
                    1.sleep(20000L);
                    String desc = AbstractDaemon.this.theirRepo != null ? AbstractDaemon.this.context.cfg.gs("Z.to") + AbstractDaemon.this.theirRepo.getLibraryData().libraries.description : "";
                    while (true) {
                        1.sleep(60000L);
                        if (!AbstractDaemon.this.heartBeatEnabled) continue;
                        AbstractDaemon.this.send("ping", (String)(AbstractDaemon.this.context.trace ? AbstractDaemon.this.context.cfg.gs("Stty.heartbeat.sent") + desc : ""));
                    }
                }
                catch (InterruptedException e) {
                    logger.trace(AbstractDaemon.this.context.cfg.gs("Stty.heartbeat.interrupted"));
                }
                catch (Exception e) {
                    if (!AbstractDaemon.this.context.cfg.isKeepGoing()) {
                        AbstractDaemon.this.context.fault = true;
                    }
                    errorMessage = e.getMessage();
                    exceptionMessage = Utils.getStackTrace(e);
                    AbstractDaemon.this.heartBeat.interrupt();
                }
                if (AbstractDaemon.this.commandCount == 1 || !AbstractDaemon.this.context.cfg.isKeepGoing()) {
                    AbstractDaemon.this.stopDaemon(errorMessage, exceptionMessage);
                }
            }
        };
        logger.trace(this.context.cfg.gs("Stty.starting.heartbeat"));
        this.heartBeat.start();
    }

    private void disableHeartBeat() {
        if (this.heartBeat != null) {
            if (!this.heartBeatEnabled) {
                logger.warn(this.context.cfg.gs("Stty.daemon.heartbeat.already.disabled"));
            } else {
                logger.trace(this.context.cfg.gs("Stty.daemon.heartbeat.disabled"));
            }
            this.heartBeatEnabled = false;
        }
    }

    private void enableHeartBeat() {
        if (this.heartBeat != null) {
            if (this.heartBeatEnabled) {
                logger.warn(this.context.cfg.gs("Stty.heartbeat.already.enabled"));
            } else {
                logger.trace(this.context.cfg.gs("Stty.heartbeat.enabled"));
            }
            this.heartBeatEnabled = true;
        }
    }

    public boolean getFault() {
        return this.fault;
    }

    public String getName() {
        return "Daemon";
    }

    public Socket getSocket() {
        return this.socket;
    }

    public abstract String handshake();

    public abstract int process() throws IOException, Exception;

    public String receive(String log, int timeout) throws Exception {
        if (this.getSocket().isOutputShutdown()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.output.shutdown.keep.alive") + this.getSocket().getKeepAlive());
        }
        if (!this.getSocket().isBound()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.not.bound"));
        }
        if (!this.getSocket().isConnected()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.not.connected"));
        }
        if (this.getSocket().isClosed()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.closed"));
        }
        if (timeout < 0) {
            timeout = this.myRepo.getLibraryData().libraries.timeout * 60 * 1000;
        }
        this.getSocket().setSoTimeout(timeout);
        if (log != null && log.length() > 0) {
            logger.debug(log + ", " + timeout + " ms");
        }
        logger.trace("sotimeout " + this.getSocket().getSoTimeout());
        String response = null;
        while ((response = this.context.main.readStream(this.in, this.myRepo.getLibraryData().libraries.key)) != null && response.startsWith("ping")) {
            logger.trace(this.context.cfg.gs("Stty.heartbeat.received") + (String)(this.theirRepo != null ? this.context.cfg.gs("Z.from") + this.theirRepo.getLibraryData().libraries.description : ""));
        }
        return response;
    }

    public void requestStop() {
        this.status = 1;
        logger.debug(this.context.cfg.gs("Stty.requesting.stop.for.stty.session") + Utils.formatAddresses(this.socket));
    }

    public void send(String message, String log) throws Exception {
        if (log != null && log.length() > 0) {
            logger.debug(log);
        }
        if (this.getSocket().isOutputShutdown()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.output.shutdown.keep.alive") + this.getSocket().getKeepAlive());
        }
        if (!this.getSocket().isBound()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.not.bound"));
        }
        if (!this.getSocket().isConnected()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.not.connected"));
        }
        if (this.getSocket().isClosed()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.closed"));
        }
        if (!message.equalsIgnoreCase("ping")) {
            this.disableHeartBeat();
        }
        this.context.main.writeStream(this.out, this.myRepo.getLibraryData().libraries.key, message);
        if (!message.equalsIgnoreCase("ping")) {
            this.enableHeartBeat();
        }
    }

    protected void stopHeartBeat() {
        if (this.heartBeat != null && this.heartBeat.isAlive()) {
            logger.trace(this.context.cfg.gs("Stty.stopping.heartbeat.thread"));
            this.heartBeat.interrupt();
        }
    }

    private void stopDaemon(String errorMessage, String exceptionMessage) {
        if (this.context.fault) {
            if (this.heartBeat.isAlive()) {
                this.stopHeartBeat();
            }
            if (this.context.mainFrame != null && errorMessage.length() > 0) {
                JOptionPane.showMessageDialog(this.context.mainFrame, "Daemon Stty: " + errorMessage, this.context.cfg.getNavigatorName(), 0);
            }
            if (this.context.serveStty != null && this.context.serveStty.isAlive()) {
                if (exceptionMessage.length() > 0) {
                    logger.error(this.context.cfg.gs("Z.fault") + exceptionMessage);
                }
                this.context.serveStty.requestStop();
                this.context.serveStty.stopServer();
            }
        }
    }
}

