/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.repository.Repository;
import com.corionis.els.stty.gui.TerminalGui;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientStty {
    private Context context;
    protected TerminalGui gui = null;
    private Thread heartBeat = null;
    private boolean heartBeatEnabled = true;
    private String hostListen = "";
    protected DataInputStream in = null;
    private ClientStty instance = null;
    private boolean isConnected = false;
    private boolean isHintServer = false;
    private boolean isTerminal = false;
    private String myKey;
    private Repository myRepo;
    protected DataOutputStream out = null;
    private boolean primaryServers;
    private Socket socket;
    private Repository theirRepo;
    private transient Logger logger = LogManager.getLogger("applog");

    public ClientStty(Context context, boolean isManualTerminal, boolean primaryServers, boolean isHintServer) {
        this.context = context;
        this.instance = this;
        this.isTerminal = isManualTerminal;
        this.primaryServers = primaryServers;
        this.isHintServer = isHintServer;
    }

    public long availableSpace(String location) throws Exception {
        long space = 0L;
        String response = this.roundTrip("space \"" + location + "\"", "", 5000);
        if (response != null && response.length() > 0) {
            space = Long.parseLong(response);
        }
        return space;
    }

    public boolean checkBannerCommands() throws Exception {
        boolean hasCommands = false;
        String response = this.receive("", 5000);
        if (!this.context.cfg.isNavigator() && !response.startsWith("Enter ")) {
            String[] cmdSplit = response.split(":");
            if (cmdSplit.length > 0) {
                if (cmdSplit[0].equals("CMD")) {
                    for (int i = 1; i < cmdSplit.length; ++i) {
                        if (cmdSplit[i].equals("RequestCollection")) {
                            hasCommands = true;
                            this.setupCollectionRequest();
                            continue;
                        }
                        if (!cmdSplit[i].equals("RequestTargets")) continue;
                        hasCommands = true;
                        this.context.cfg.setRequestTargets(true);
                    }
                }
            } else {
                throw new MungeException(this.context.cfg.gs("Stty.unknown.banner.receive"));
            }
            if (!this.context.subscriberRepo.hasContent() && !this.context.cfg.isRequestCollection()) {
                this.logger.info(this.context.cfg.gs("ClientStty.forcing.request.of.collection.with.s"));
                this.setupCollectionRequest();
            }
        }
        return hasCommands;
    }

    public boolean connect(Repository mine, Repository theirs) throws Exception {
        this.myRepo = mine;
        this.theirRepo = theirs;
        if (this.theirRepo != null && this.theirRepo.getLibraryData() != null && this.theirRepo.getLibraryData().libraries != null && this.theirRepo.getLibraryData().libraries.host != null) {
            String address;
            String override;
            this.myKey = this.myRepo.getLibraryData().libraries.key;
            String string = this.isHintServer ? (this.context.cfg.isOverrideHintsHost() ? "true" : "") : (override = this.context.cfg.getOverrideSubscriberHost().trim());
            if (!override.isEmpty()) {
                if (override.equals("true")) {
                    address = this.theirRepo.getLibraryData().libraries.listen;
                    if (address == null || address.isEmpty()) {
                        address = this.theirRepo.getLibraryData().libraries.host;
                    }
                    this.hostListen = this.context.cfg.gs("Z.listen");
                } else {
                    address = this.context.cfg.getOverrideSubscriberHost();
                    this.hostListen = this.context.cfg.gs("Z.custom");
                }
            } else {
                address = this.theirRepo.getLibraryData().libraries.host;
                this.hostListen = this.context.cfg.gs("Z.host");
            }
            String hostname = Utils.parseHost(address);
            int hostport = Utils.getPort(address) + (this.primaryServers ? 0 : 2);
            this.logger.info(this.context.cfg.gs("Stty.opening.stty.connection.to") + (hostname == null ? "localhost" : hostname) + ":" + hostport + this.hostListen);
            try {
                this.socket = new Socket();
                InetSocketAddress socketAddress = new InetSocketAddress(hostname, hostport);
                this.socket.connect(socketAddress, 10000);
                this.socket.setKeepAlive(true);
                this.socket.setSoTimeout(this.myRepo.getLibraryData().libraries.timeout * 60 * 1000);
                this.socket.setSoLinger(true, 10000);
                this.in = new DataInputStream(this.socket.getInputStream());
                this.out = new DataOutputStream(this.socket.getOutputStream());
                this.logger.info(this.context.cfg.gs("Stty.successfully.connected.stty.to") + Utils.formatAddresses(this.socket));
            }
            catch (Exception e) {
                this.context.fault = true;
                this.logger.error(e.getMessage());
            }
            if (this.in != null && this.out != null) {
                if (this.handshake()) {
                    this.isConnected = true;
                    this.createHeartBeat();
                } else {
                    this.logger.error(MessageFormat.format(this.context.cfg.gs("Stty.connection.to.failed.handshake"), Utils.formatAddresses(this.socket)));
                }
            }
        } else {
            throw new MungeException(this.context.cfg.gs("Stty.cannot.get.site.from.s.s.specified.remote.subscriber.library"));
        }
        return this.isConnected;
    }

    private void createHeartBeat() {
        this.heartBeat = new Thread(){
            boolean stopped = false;

            @Override
            public void run() {
                String errorMessage;
                String exceptionMessage;
                while (true) {
                    exceptionMessage = "";
                    errorMessage = "";
                    try {
                        1.sleep(40000L);
                        String desc = ClientStty.this.theirRepo != null ? ClientStty.this.context.cfg.gs("Z.to") + ClientStty.this.theirRepo.getLibraryData().libraries.description : "";
                        while (true) {
                            1.sleep(60000L);
                            if (!ClientStty.this.heartBeatEnabled) continue;
                            ClientStty.this.send("ping", (String)(ClientStty.this.context.trace ? ClientStty.this.context.cfg.gs("Stty.heartbeat.sent") + desc : ""));
                        }
                    }
                    catch (InterruptedException e) {
                        errorMessage = ClientStty.this.context.cfg.gs("Stty.heartbeat.interrupted");
                        ClientStty.this.logger.trace(errorMessage);
                    }
                    catch (Exception e) {
                        errorMessage = e.getMessage();
                        if (this.isAlive()) {
                            ClientStty.this.logger.trace(errorMessage);
                            ClientStty.this.logger.trace(ClientStty.this.context.cfg.gs("Stty.connection.is.alive.continuing"));
                            continue;
                        }
                        ClientStty.this.context.fault = true;
                        if (ClientStty.this.instance == ClientStty.this.context.hintsStty && ClientStty.this.context.cfg.isNavigator()) {
                            ClientStty.this.context.browser.toggleHintTracking(false);
                            ClientStty.this.context.mainFrame.buttonHintTracking.setEnabled(false);
                        }
                        exceptionMessage = Utils.getStackTrace(e);
                        ClientStty.this.heartBeat.interrupt();
                    }
                    break;
                }
                this.stopped = true;
                ClientStty.this.stopClient(errorMessage, exceptionMessage);
                ClientStty.this.heartBeat.interrupt();
                if (!this.stopped) {
                    ClientStty.this.stopClient(ClientStty.this.context.cfg.gs("Stty.error.count.exceeded"), "");
                }
            }
        };
        this.logger.trace(this.context.cfg.gs("Stty.starting.heartbeat.for") + Utils.formatAddresses(this.socket));
        this.heartBeat.start();
    }

    private void disableHeartBeat() {
        if (this.heartBeat != null) {
            if (!this.heartBeatEnabled) {
                this.logger.warn(this.context.cfg.gs("Stty.client.heartbeat.already.disabled"));
            } else {
                this.logger.trace(this.context.cfg.gs("Stty.client.heartbeat.disabled"));
            }
            this.heartBeatEnabled = false;
        }
    }

    public void disconnect() {
        try {
            this.stopHeartBeat();
            if (this.isConnected) {
                this.isConnected = false;
                this.logger.debug(this.context.cfg.gs("Stty.disconnecting.stty") + Utils.formatAddresses(this.socket));
                if (this.gui != null) {
                    this.gui.stop();
                }
                this.out.flush();
                this.out.close();
                this.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void enableHeartBeat() {
        if (this.heartBeat != null) {
            if (this.heartBeatEnabled) {
                this.logger.warn(this.context.cfg.gs("Stty.heartbeat.already.enabled"));
            } else {
                this.logger.trace(this.context.cfg.gs("Stty.heartbeat.enabled"));
            }
            this.heartBeatEnabled = true;
        }
    }

    public String getMyKey() {
        return this.myKey;
    }

    public Repository getMyRepo() {
        return this.myRepo;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getTheirKey() {
        return this.theirRepo.getLibraryData().libraries.key;
    }

    public Repository getTheirRepo() {
        return this.theirRepo;
    }

    public String getWorkingDirectoryRemote() throws Exception {
        String response = this.roundTrip("directory", "", 5000);
        return response;
    }

    private boolean handshake() throws Exception {
        boolean valid = false;
        this.logger.trace(this.context.cfg.gs("Stty.handshake"));
        String input = this.receive("", 5000);
        if (input != null && input.equals("HELO")) {
            this.send(this.isTerminal ? "DribNit" : "DribNlt", "");
            input = this.receive("", 5000);
            if (input.equals(this.theirRepo.getLibraryData().libraries.key)) {
                this.send(this.myKey, "");
                input = this.receive("", 5000);
                try {
                    Utils.getFileSeparator(input);
                    this.logger.info(MessageFormat.format(this.context.cfg.gs("Stty.client.authenticated.choice.terminal.automated.session"), this.isTerminal ? 0 : 1) + this.theirRepo.getLibraryData().libraries.description);
                    valid = true;
                    this.theirRepo.getLibraryData().libraries.flavor = input;
                }
                catch (Exception exception) {}
            } else if (input.equalsIgnoreCase("Terminal session not allowed")) {
                this.logger.warn(this.context.cfg.gs("Stty.attempt.to.login.interactively.but.terminal.sessions.are.not.allowed"));
            }
        }
        return valid;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public String receive(String log, int timeout) throws Exception {
        if (this.getSocket().isOutputShutdown()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.output.shutdown.keep.alive") + this.getSocket().getKeepAlive());
        }
        if (!this.getSocket().isBound()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.not.bound"));
        }
        if (!this.getSocket().isConnected()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.not.connected"));
        }
        if (this.getSocket().isClosed()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.closed"));
        }
        if (timeout < 0) {
            timeout = this.myRepo.getLibraryData().libraries.timeout * 60 * 1000;
        }
        this.getSocket().setSoTimeout(timeout);
        if (log != null && log.length() > 0) {
            this.logger.debug(log + ", " + timeout + " ms");
        }
        this.logger.trace("sotimeout " + this.getSocket().getSoTimeout());
        String response = null;
        while ((response = this.context.main.readStream(this.in, this.theirRepo.getLibraryData().libraries.key)) != null && response.startsWith("ping")) {
            this.logger.trace(this.context.cfg.gs("Stty.heartbeat.received") + (String)(this.theirRepo != null ? this.context.cfg.gs("Z.from") + this.theirRepo.getLibraryData().libraries.description : ""));
        }
        return response;
    }

    public String retrieveRemoteData(String message, String log, int timeout) throws Exception {
        Object location = null;
        String response = "";
        response = this.roundTrip(message, log, timeout);
        if (response != null && response.length() > 0) {
            location = Utils.scrubFilename(this.theirRepo.getLibraryData().libraries.description).replaceAll(" ", "");
            location = Utils.getStampedFilename(this.myRepo, (String)location + "_" + message + "-received");
            location = Utils.getTemporaryFilePrefix(this.myRepo, (String)location) + ".json";
            try {
                PrintWriter outputStream = new PrintWriter((String)location);
                outputStream.println(response);
                outputStream.close();
            }
            catch (FileNotFoundException fnf) {
                this.context.fault = true;
                throw new MungeException(MessageFormat.format(this.context.cfg.gs("Stty.exception.while.writing.file"), message, location) + Utils.getStackTrace(fnf));
            }
        }
        return location;
    }

    public synchronized String roundTrip(String message, String log, int timeout) throws Exception {
        this.send(message, "");
        String response = this.receive(log, timeout);
        return response;
    }

    public void send(String message, String log) throws Exception {
        if (log != null && log.length() > 0) {
            this.logger.debug(log);
        }
        if (this.getSocket().isOutputShutdown()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.output.shutdown.keep.alive") + this.getSocket().getKeepAlive());
        }
        if (!this.getSocket().isBound()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.not.bound"));
        }
        if (!this.getSocket().isConnected()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.not.connected"));
        }
        if (this.getSocket().isClosed()) {
            throw new MungeException(this.context.cfg.gs("Stty.socket.closed"));
        }
        if (!message.equalsIgnoreCase("ping")) {
            this.disableHeartBeat();
        }
        if (this.out != null && this.theirRepo != null && this.theirRepo.getLibraryData() != null && this.theirRepo.getLibraryData().libraries != null && this.theirRepo.getLibraryData().libraries.key != null && this.theirRepo.getLibraryData().libraries.key.length() > 0) {
            this.context.main.writeStream(this.out, this.theirRepo.getLibraryData().libraries.key, message);
        }
        if (!message.equalsIgnoreCase("ping")) {
            this.enableHeartBeat();
        }
    }

    private void setupCollectionRequest() {
        this.context.cfg.setRequestCollection(true);
        String location = this.context.cfg.getSubscriberCollectionFilename().length() > 0 ? this.context.cfg.getSubscriberCollectionFilename() : this.context.cfg.getSubscriberLibrariesFileName();
        this.context.cfg.setSubscriberLibrariesFileName(location);
        this.context.cfg.setSubscriberCollectionFilename("");
    }

    private void stopClient(String errorMessage, String exceptionMessage) {
        if (this.context.fault) {
            if (errorMessage.length() == 0 && exceptionMessage.length() == 0) {
                this.logger.error(this.context.cfg.gs("Z.fault"));
            } else {
                this.logger.error(this.context.cfg.gs("Z.fault") + errorMessage + ": " + exceptionMessage);
            }
            this.disconnect();
            if (this.context.mainFrame != null && errorMessage.length() > 0) {
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Stty.client.stty") + errorMessage, this.context.cfg.getNavigatorName(), 0);
            }
            if (this.context.serveStty != null && this.context.serveStty.isAlive()) {
                this.context.serveStty.requestStop();
                this.context.serveStty.stopServer();
            }
        }
    }

    private void stopHeartBeat() {
        if (this.heartBeat != null && this.heartBeat.isAlive()) {
            this.logger.trace(this.context.cfg.gs("Stty.stopping.heartbeat.thread.for") + Utils.formatAddresses(this.socket));
            this.heartBeat.interrupt();
        }
    }

    public int terminalSession() throws Exception {
        int returnValue = 0;
        this.gui = new TerminalGui(this, this.context, this.in, this.out);
        returnValue = this.gui.run(this.myRepo, this.theirRepo);
        return returnValue;
    }
}

