/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.stty.AbstractDaemon;
import com.corionis.els.stty.ServeStty;
import java.net.Socket;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Connection
extends Thread {
    private Context context;
    protected static Logger logger = LogManager.getLogger("applog");
    private ServeStty instance = null;
    protected AbstractDaemon service;
    protected Socket socket;

    public Connection(Context context, ServeStty instance, Socket aSocket, String name, AbstractDaemon aService) {
        super("stty." + name + (String)(aService.context.trace ? ":" + Utils.formatAddresses(aSocket) : ""));
        this.context = context;
        this.instance = instance;
        this.socket = aSocket;
        this.service = aService;
    }

    public AbstractDaemon getConsole() {
        return this.service;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void run() {
        int status = 0;
        try {
            this.service.socket = this.socket;
            this.service.context.main.setListening(true);
            status = this.service.process();
        }
        catch (Exception e) {
            logger.error(Utils.getStackTrace(e));
        }
        finally {
            block17: {
                if (this.instance != null && this.instance.isAlive()) {
                    logger.info(this.context.cfg.gs("Stty.closing.stty.connection.to") + Utils.formatAddresses(this.socket));
                    Vector conns = this.instance.getAllConnections();
                    conns.remove(this);
                }
                if (status > 0) {
                    try {
                        logger.trace(this.context.cfg.gs("Stty.shutdown.via.stty"));
                        if (status == 1 && !this.service.context.cfg.isKeepGoing() || status == 2) {
                            if (this.service.context.main.context.fault) {
                                logger.error(this.context.cfg.gs("Main.exiting.with.error.code"));
                            }
                            this.service.context.main.shutdown();
                            if (!this.service.context.cfg.isLoggerView()) {
                                System.exit(0);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.service.context.fault = true;
                        logger.error(Utils.getStackTrace(e));
                        if (status != 2) break block17;
                        this.service.context.main.shutdown();
                        if (this.service.context.cfg.isLoggerView()) break block17;
                        System.exit(0);
                    }
                }
            }
        }
    }
}

