/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.repository.Repository;
import com.corionis.els.stty.Connection;
import com.corionis.els.stty.Listener;
import com.corionis.els.stty.hintServer.Daemon;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServeStty
extends Thread {
    protected int maxConnections;
    private boolean _stop = false;
    private Vector<Connection> allConnections;
    private ThreadGroup allSessionThreads;
    private Hashtable<String, Listener> allSessions;
    private Configuration cfg;
    private Context context;
    private int listenPort;
    private transient Logger logger = LogManager.getLogger("applog");
    private boolean primaryServers;
    private int totalConnections = 0;

    public ServeStty(ThreadGroup aGroup, int aMaxConnections, Context context, boolean primaryServers) {
        super(aGroup, "stty." + aGroup.getName());
        this.context = context;
        this.cfg = context.cfg;
        this.primaryServers = primaryServers;
        this.setDaemon(true);
        this.setMaxConnections(aMaxConnections);
        this.allConnections = new Vector();
        this.allSessions = new Hashtable();
        this.allSessionThreads = aGroup;
    }

    public synchronized void addConnection(Socket aSocket) throws MungeException {
        if (this.allConnections.size() >= this.maxConnections) {
            try {
                PrintWriter clientOut = new PrintWriter(aSocket.getOutputStream());
                clientOut.println("Connection request denied; maximum users exceeded");
                clientOut.flush();
                this.logger.info("Maximum connections (" + this.maxConnections + ") exceeded");
                this.logger.info("Connection refused from: " + Utils.formatAddresses(aSocket));
                aSocket.close();
            }
            catch (IOException e) {
                this.logger.info(e);
            }
        } else {
            Connection theConnection;
            if (this.cfg.isPublisherListener()) {
                theConnection = new Connection(this.context, this, aSocket, "publisher", new com.corionis.els.stty.publisher.Daemon(this, this.context, this.context.publisherRepo, this.context.subscriberRepo));
            } else if (this.cfg.isSubscriberListener() || this.cfg.isSubscriberTerminal()) {
                theConnection = new Connection(this.context, this, aSocket, "subscriber", new com.corionis.els.stty.subscriber.Daemon(this, this.context, this.context.subscriberRepo, this.context.publisherRepo));
            } else if (this.cfg.isStatusServer()) {
                theConnection = new Connection(this.context, this, aSocket, "hintserver", new Daemon(this, this.context, this.context.hintsRepo, null));
            } else {
                throw new MungeException("FATAL: Unknown connection type");
            }
            this.allConnections.add(theConnection);
            this.logger.info((this.cfg.isStatusServer() ? "Status Server" : (this.cfg.isPublisherListener() ? "Publisher" : "Subscriber")) + " daemon opened stty: " + Utils.formatAddresses(aSocket));
            theConnection.start();
            ++this.totalConnections;
        }
    }

    protected void addListener(String host, int aPort, String where) throws Exception {
        if (this.allSessions.get("listener:" + host + ":" + aPort) != null) {
            throw new IllegalArgumentException("Port " + aPort + " already in use");
        }
        Listener listener = new Listener(this.allSessionThreads, this, host, aPort, this.context);
        this.allSessions.put("listener:" + host + ":" + aPort, listener);
        this.logger.info("Stty server is listening on: " + (host == null ? "localhost" : listener.getInetAddr()) + ":" + aPort + where);
        this.context.main.setListening(true);
        listener.start();
    }

    public synchronized String dumpStatistics() {
        String data = "Listening on: " + this.listenPort + "\r\nActive connections: " + this.allConnections.size() + "\r\n";
        for (int index = 0; index < this.allConnections.size(); ++index) {
            Connection c = this.allConnections.elementAt(index);
            data = data + "  " + c.service.getName() + " to " + Utils.formatAddresses(c.socket) + "\r\n";
        }
        data = data + "  Total connections since started: " + this.totalConnections + "\r\n";
        data = data + "  Maximum allowed connections: " + this.maxConnections + "\r\n";
        return data;
    }

    public synchronized void endConnection() {
        this.notify();
    }

    public Vector getAllConnections() {
        return this.allConnections;
    }

    public void requestStop() {
        this._stop = true;
        for (int index = 0; index < this.allConnections.size(); ++index) {
            Connection c = this.allConnections.elementAt(index);
            if (!c.isAlive()) continue;
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info("Starting stty server for up to " + this.maxConnections + " incoming connections");
        while (!this._stop) {
            for (int index = 0; index < this.allConnections.size(); ++index) {
                Connection c = this.allConnections.elementAt(index);
                if (c.isAlive()) continue;
                this.allConnections.removeElementAt(index);
            }
            try {
                ServeStty index = this;
                synchronized (index) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                this.logger.trace("stty interrupted, stop=" + (this._stop ? "true" : "false"));
                this._stop = true;
                break;
            }
        }
    }

    public synchronized void setMaxConnections(int aMax) {
        this.maxConnections = aMax;
    }

    public void startListening(Repository listenerRepo) throws Exception {
        String hostListen;
        String address;
        if (listenerRepo != null && listenerRepo.getLibraryData() != null && listenerRepo.getLibraryData().libraries != null) {
            if (this.context.cfg.getOverrideSubscriberHost().isEmpty() || this.context.cfg.getOverrideSubscriberHost().trim().equals("true")) {
                address = listenerRepo.getLibraryData().libraries.listen;
                hostListen = this.context.cfg.gs("Z.listen");
                if (address == null || address.isEmpty()) {
                    address = listenerRepo.getLibraryData().libraries.host;
                    hostListen = this.context.cfg.gs("Z.host");
                }
            } else {
                address = this.context.cfg.getOverrideSubscriberHost();
                hostListen = this.context.cfg.gs("Z.custom");
            }
        } else {
            throw new MungeException("cannot get site from -r specified remote library");
        }
        this.startServer(address, hostListen);
    }

    private void startServer(String listen, String where) throws Exception {
        String host = Utils.parseHost(listen);
        if (host == null || host.isEmpty()) {
            host = null;
            this.logger.info("Host not defined, using default: localhost");
        }
        this.listenPort = Utils.getPort(listen) + (this.primaryServers ? 0 : 2);
        if (this.listenPort > 0) {
            this.start();
            this.addListener(host, this.listenPort, where);
        } else {
            this.logger.warn("Stty is disabled");
        }
    }

    public void stopServer() {
        if (this.allSessions != null) {
            this.logger.debug("stopping all stty listener threads");
            Collection<Listener> lc = this.allSessions.values();
            for (Listener listener : lc) {
                if (listener == null || !listener.isAlive()) continue;
                listener.requestStop();
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.requestStop();
            this.allSessions = null;
        }
    }
}

