/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty.subscriber;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Transfer;
import com.corionis.els.Utils;
import com.corionis.els.hints.Hint;
import com.corionis.els.hints.HintKey;
import com.corionis.els.hints.HintKeys;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import com.corionis.els.stty.AbstractDaemon;
import com.corionis.els.stty.ServeStty;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Daemon
extends AbstractDaemon {
    protected static Logger logger = LogManager.getLogger("applog");
    private boolean isTerminal = false;
    private ServeStty instance = null;

    public Daemon(ServeStty instance, Context context, Repository mine, Repository theirs) {
        super(context, mine, theirs);
        this.instance = instance;
    }

    public synchronized String dumpStatistics() {
        String data = this.context.cfg.gs("Stty.r.nconsole.currently.connected") + (this.connected ? "true" : "false") + "\r\n";
        data = data + this.context.cfg.gs("Stty.connected.on.port") + this.port + "\r\n";
        data = data + this.context.cfg.gs("Stty.connected.to.address") + String.valueOf(this.address) + "\r\n";
        return data;
    }

    public void exportLibrary(String filename) throws MungeException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File outFile = new File(Utils.getFullPathLocal(filename));
        outFile.getParentFile().mkdirs();
        logger.info(this.context.cfg.gs("Stty.writing.library.file") + filename);
        Repository repo = this.myRepo.cloneNoItems();
        String json = gson.toJson(repo.getLibraryData());
        try {
            PrintWriter outputStream = new PrintWriter(outFile.getPath());
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(MessageFormat.format(this.context.cfg.gs("Stty.exception.while.writing.library.file.trace"), outFile.getPath(), Utils.getStackTrace(fnf)));
        }
    }

    private String getNextToken(StringTokenizer t) {
        String value = "";
        if (t.hasMoreTokens() && (value = t.nextToken()).trim().length() == 0 && t.hasMoreTokens()) {
            value = t.nextToken();
        }
        return value;
    }

    @Override
    public String handshake() {
        String system = "";
        try {
            logger.trace(this.context.cfg.gs("Stty.subscriber.listener.handshake"));
            this.send("HELO", "");
            String input = this.receive("", 5000);
            if (input != null && (input.equals("DribNit") || input.equals("DribNlt"))) {
                this.isTerminal = input.equals("DribNit");
                if (this.isTerminal && this.myRepo.getLibraryData().libraries.terminal_allowed != null && !this.myRepo.getLibraryData().libraries.terminal_allowed.booleanValue()) {
                    this.send("Terminal session not allowed", "");
                    logger.warn(this.context.cfg.gs("Stty.attempt.to.login.interactively.but.terminal.sessions.are.not.allowed"));
                    return system;
                }
                this.send(this.myKey, "");
                input = this.receive("", 5000);
                if (this.context.authKeys != null) {
                    HintKey connectedKey = this.context.authKeys.findKey(input);
                    if (connectedKey != null) {
                        this.send(this.myRepo.getLibraryData().libraries.flavor, "");
                        system = connectedKey.system;
                        logger.info(MessageFormat.format(this.context.cfg.gs("Stty.server.authenticated.choice.terminal.automated.session"), this.isTerminal ? 0 : 1) + system);
                        this.context.fault = false;
                        this.context.timeout = false;
                    }
                } else if (this.theirRepo != null && input.equals(this.theirRepo.getLibraryData().libraries.key)) {
                    this.send(this.myRepo.getLibraryData().libraries.flavor, "");
                    system = this.theirRepo.getLibraryData().libraries.description;
                    logger.info(MessageFormat.format(this.context.cfg.gs("Stty.server.authenticated.choice.terminal.automated.session"), this.isTerminal ? 0 : 1) + system);
                    this.context.fault = false;
                    this.context.timeout = false;
                }
            }
        }
        catch (Exception e) {
            this.fault = true;
            logger.error(Utils.getStackTrace(e));
        }
        return system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int process() throws Exception {
        String basePrompt;
        int attempts = 0;
        String prompt = basePrompt = ": ";
        boolean trace = this.context.cfg.getDebugLevel().trim().equalsIgnoreCase("trace");
        this.port = this.getSocket().getPort();
        this.address = this.getSocket().getInetAddress();
        try {
            if (this.context.cfg.getAuthKeysFile().length() > 0) {
                this.context.authKeys = new HintKeys(this.context);
                this.context.authKeys.read(this.context.cfg.getAuthKeysFile());
            }
        }
        catch (Exception e) {
            this.context.fault = true;
            throw e;
        }
        this.context.transfer = new Transfer(this.context);
        this.getSocket().setKeepAlive(true);
        this.getSocket().setSoTimeout(this.myRepo.getLibraryData().libraries.timeout * 60 * 1000);
        this.getSocket().setSoLinger(true, 10000);
        this.in = new DataInputStream(this.getSocket().getInputStream());
        this.out = new DataOutputStream(this.getSocket().getOutputStream());
        this.connected = true;
        String system = this.handshake();
        if (system.length() == 0) {
            if (!this.context.cfg.isKeepGoing()) {
                this.status = 1;
            }
            logger.error(MessageFormat.format(this.context.cfg.gs("Stty.connection.to.failed.handshake"), Utils.formatAddresses(this.socket)));
        } else {
            if (this.isTerminal) {
                this.response = this.context.cfg.gs("Stty.enter.help.for.information.r.n");
            } else {
                this.createHeartBeat();
                this.response = "CMD";
                if (this.context.cfg.isForceCollection()) {
                    this.response = this.response + ":RequestCollection";
                }
                if (this.context.cfg.isForceTargets()) {
                    this.response = this.response + ":RequestTargets";
                }
            }
            Gson gsonBuilder = new GsonBuilder().create();
            Gson gsonParser = new Gson();
            try {
                while (this.status == 0) {
                    try {
                        File f;
                        if (this.context.fault || this.context.cfg.isKeepGoing() && this.context.timeout) {
                            this.fault = true;
                            this.status = 1;
                            logger.warn(this.context.cfg.gs("Stty.process.fault.ending.stty"));
                            break;
                        }
                        this.send(this.response + (this.isTerminal ? prompt : ""), (String)(trace ? "writing response " + this.response.length() + " bytes to " + system : ""));
                        this.response = "";
                        String line = this.receive(trace ? "Reading command" : "", -1);
                        if (line == null) {
                            if (!this.context.cfg.isKeepGoing()) {
                                this.fault = true;
                                this.status = 2;
                                logger.warn(this.context.cfg.gs("Stty.eof.line.process.ended.prematurely"));
                            } else {
                                logger.info(this.context.cfg.gs("Stty.eof.line.listener.keep.going.enabled"));
                            }
                            break;
                        }
                        if ((line = line.trim()).length() < 1) {
                            this.response = "\r";
                            continue;
                        }
                        ++this.commandCount;
                        logger.info(MessageFormat.format(this.context.cfg.gs("Stty.processing.command.from"), line) + system);
                        StringTokenizer t = new StringTokenizer(line, "\"");
                        if (!t.hasMoreTokens()) continue;
                        String theCommand = t.nextToken().trim();
                        if (theCommand.equalsIgnoreCase("auth")) {
                            ++attempts;
                            String pw = "";
                            if (t.hasMoreTokens()) {
                                pw = t.nextToken();
                            }
                            if (this.context.cfg.getAuthorizedPassword().equals(pw.trim())) {
                                this.response = "password accepted\r\n";
                                this.authorized = true;
                                prompt = "$ ";
                                logger.info("Command auth accepted");
                                continue;
                            }
                            logger.warn("auth password attempt failed using: " + pw);
                            if (attempts < 3) continue;
                            logger.error("Too many authentication failures, disconnecting");
                            break;
                        }
                        if (theCommand.equalsIgnoreCase("logout")) {
                            if (this.authorized) {
                                this.authorized = false;
                                prompt = basePrompt;
                                continue;
                            }
                            theCommand = this.context.cfg.isKeepGoing() ? "bye" : "quit";
                        }
                        if (theCommand.equalsIgnoreCase("bye")) {
                            this.out.flush();
                            Thread.sleep(1500L);
                            break;
                        }
                        if (theCommand.equalsIgnoreCase("collection")) {
                            try {
                                Object location = Utils.scrubFilename(this.myRepo.getLibraryData().libraries.description).replaceAll(" ", "");
                                location = Utils.getStampedFilename(this.myRepo, (String)location + "_collection-generated");
                                location = Utils.getTemporaryFilePrefix(this.myRepo, (String)location) + ".json";
                                this.context.cfg.setExportCollectionFilename((String)location);
                                for (Library subLib : this.myRepo.getLibraryData().libraries.bibliography) {
                                    if (!(this.context.cfg.isSpecificLibrary() && !this.context.cfg.isSelectedLibrary(subLib.name) || this.context.cfg.isSpecificExclude() && this.context.cfg.isExcludedLibrary(subLib.name))) {
                                        if (subLib.items != null) {
                                            subLib.items = null;
                                        }
                                        this.myRepo.scan(subLib.name);
                                        continue;
                                    }
                                    logger.info(this.context.cfg.gs("Stty.skipping.subscriber.library") + subLib.name);
                                    subLib.name = "ELS-SUBSCRIBER-SKIP_" + subLib.name;
                                }
                                this.myRepo.exportItems(true);
                                Thread.sleep(1500L);
                                Path jsonPath = Paths.get(Utils.getFullPathLocal(this.context.cfg.getExportCollectionFilename()), new String[0]);
                                this.response = new String(Files.readAllBytes(jsonPath));
                                continue;
                            }
                            catch (MungeException e) {
                                logger.error(e.getMessage());
                                continue;
                            }
                        }
                        if (theCommand.equalsIgnoreCase("copy")) {
                            boolean valid = false;
                            if (t.hasMoreTokens()) {
                                String from = this.getNextToken(t);
                                String to = this.getNextToken(t);
                                if (from.length() > 0 && to.length() > 0) {
                                    boolean success = true;
                                    try {
                                        valid = true;
                                        f = new File(Utils.getFullPathLocal(from));
                                        this.context.transfer.copyFile(this.context.clientSftp, Utils.getFullPathLocal(from), Files.getLastModifiedTime(f.toPath(), new LinkOption[0]), Utils.getFullPathLocal(to), false, true);
                                    }
                                    catch (Exception e) {
                                        success = false;
                                        logger.error(Utils.getStackTrace(e));
                                    }
                                    Object object = this.isTerminal ? "ok" + (success ? ", copied" : "") + "\r\n" : (this.response = Boolean.toString(success));
                                }
                            }
                            if (valid) continue;
                            this.response = this.isTerminal ? "copy command requires a 2 arguments, from and to\r\n" : "false";
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("directory")) {
                            this.response = this.context.cfg.getWorkingDirectory();
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("drives")) {
                            this.response = Utils.getLocalHardDrives();
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("execute")) {
                            if (this.context.hintKeys == null) {
                                this.response = this.isTerminal ? "execute command requires a --keys file\r\n" : "false";
                                logger.warn(this.context.cfg.gs("Stty.execute.command.received.with.no.keys.file.specified"));
                                continue;
                            }
                            boolean valid = false;
                            if (t.hasMoreTokens()) {
                                Hint hint = null;
                                if (line.length() > 8) {
                                    valid = true;
                                    String json = line.substring(9);
                                    hint = gsonParser.fromJson(json, Hint.class);
                                    ArrayList<Hint> pending = new ArrayList<Hint>();
                                    pending.add(hint);
                                    this.response = this.context.hintsHandler.hintsMunge(pending);
                                }
                            }
                            if (valid) continue;
                            this.response = this.isTerminal ? "execute command requires a 3 arguments, libName, itemPath, fullPath\r\n" : "false";
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("fault")) {
                            if (!this.context.cfg.isKeepGoing()) {
                                this.fault = true;
                                this.status = 1;
                            }
                            if (!this.context.timeout) {
                                this.send("End-Execution", trace ? "send End-Execution" : "");
                            }
                            Thread.sleep(1500L);
                            throw new MungeException(this.context.cfg.gs("Stty.fault.received.from.publisher"));
                        }
                        if (theCommand.equalsIgnoreCase("library")) {
                            try {
                                Object location = Utils.scrubFilename(this.myRepo.getLibraryData().libraries.description).replaceAll(" ", "");
                                location = Utils.getStampedFilename(this.myRepo, (String)location + "_library-generated");
                                location = Utils.getTemporaryFilePrefix(this.myRepo, (String)location) + ".json";
                                this.exportLibrary((String)location);
                                Thread.sleep(2500L);
                                Path jsonPath = Paths.get((String)location, new String[0]).toAbsolutePath();
                                this.response = new String(Files.readAllBytes(jsonPath));
                                continue;
                            }
                            catch (MungeException e) {
                                logger.error(e.getMessage());
                                continue;
                            }
                        }
                        if (theCommand.equalsIgnoreCase("quit") || theCommand.equalsIgnoreCase("exit")) {
                            this.out.flush();
                            Thread.sleep(1500L);
                            if (this.context.cfg.isKeepGoing()) {
                                logger.info(this.context.cfg.gs("Stty.ignoring.quit.command.listener.keep.going.enabled"));
                            } else {
                                this.status = 1;
                            }
                            break;
                        }
                        if (theCommand.equalsIgnoreCase("move")) {
                            boolean valid = false;
                            if (t.hasMoreTokens()) {
                                String from = this.getNextToken(t);
                                String to = this.getNextToken(t);
                                if (from.length() > 0 && to.length() > 0) {
                                    boolean success = true;
                                    try {
                                        valid = true;
                                        f = new File(Utils.getFullPathLocal(from));
                                        this.context.transfer.moveFile(Utils.getFullPathLocal(from), Files.getLastModifiedTime(f.toPath(), new LinkOption[0]), Utils.getFullPathLocal(to), true);
                                    }
                                    catch (Exception e) {
                                        success = false;
                                        logger.error(Utils.getStackTrace(e));
                                    }
                                    Object object = this.isTerminal ? "ok" + (success ? ", moved" : "") + "\r\n" : (this.response = Boolean.toString(success));
                                }
                            }
                            if (valid) continue;
                            this.response = this.isTerminal ? "move command requires a 2 arguments, from and to\r\n" : "false";
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("read")) {
                            String filename;
                            boolean valid = false;
                            if (t.hasMoreTokens() && (filename = this.getNextToken(t)).length() > 0) {
                                valid = true;
                                this.response = Utils.readString(Utils.getFullPathLocal(filename));
                            }
                            if (valid) continue;
                            this.response = this.isTerminal ? "read command requires a 1 argument, filename\r\n" : "false";
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("remove")) {
                            String location = "";
                            if (t.hasMoreTokens()) {
                                location = t.nextToken();
                                this.context.transfer.remove(location, false);
                                logger.info("  deleted: " + Utils.getFullPathLocal(location));
                                this.response = "true";
                                continue;
                            }
                            this.response = "false";
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("space")) {
                            String location = "";
                            if (t.hasMoreTokens()) {
                                location = t.nextToken();
                                long space = Utils.availableSpace(Utils.getFullPathLocal(location));
                                logger.info("  space: " + Utils.formatLong(space, true, this.context.cfg.getLongScale()) + " at " + location);
                                if (this.isTerminal) {
                                    this.response = Utils.formatLong(space, true, this.context.cfg.getLongScale());
                                    continue;
                                }
                                this.response = String.valueOf(space);
                                continue;
                            }
                            this.response = this.isTerminal ? "space command requires a location\r\n" : "0";
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("status")) {
                            if (!this.authorized) {
                                this.response = "not authorized\r\n";
                                continue;
                            }
                            this.response = this.instance.dumpStatistics();
                            this.response = this.response + this.dumpStatistics();
                            continue;
                        }
                        if (theCommand.equalsIgnoreCase("stop")) {
                            this.send("End-Execution", trace ? "send End-Execution" : "");
                            Thread.sleep(1500L);
                            this.status = 2;
                            break;
                        }
                        if (theCommand.equalsIgnoreCase("targets")) {
                            try {
                                if (this.context.cfg.getTargetsFilename().length() > 0) {
                                    this.response = new String(Files.readAllBytes(Paths.get(Utils.getFullPathLocal(this.context.cfg.getTargetsFilename()), new String[0])));
                                    continue;
                                }
                                this.response = "";
                                continue;
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage());
                                continue;
                            }
                        }
                        if (theCommand.equalsIgnoreCase("help") || theCommand.equals("?")) {
                            this.response = "\r\nAvailable commands, not case sensitive:\r\n";
                            if (this.authorized) {
                                this.response = this.response + "  status = server and console status information\r\n\r\n And:\r\n";
                            }
                            this.response = this.response + "  auth \"password\" = access Authorized commands, enclose password with quotes\r\n  collection = get collection data from remote, can take a few moments to scan\r\n  library = get library data from remote\r\n  space \"[location]\" = free space at location on remote\r\n  targets = get targets file from remote\r\n\r\n  help or ? = this list\r\n  bye = disconnect and leave remote end running\r\n  copy \"[from]\" \"[to]\" = copy file from to\r\n  directory = get working directory\r\n  drives = get available drives\r\n  logout = exit current level\r\n  move \"[from]\" \"[to]\" = move file from to\r\n  quit, exit = disconnect and quit remote end\r\n  remove \"[from]\" = remove file from\r\n  stop = force stop of remote and end\r\n\r\n";
                            continue;
                        }
                        this.response = "\r\nunknown command '" + theCommand + "', use 'help' for information\r\n";
                    }
                    catch (SocketTimeoutException toe) {
                        this.context.timeout = true;
                        this.connected = false;
                        logger.error(this.context.cfg.gs("Stty.sockettimeoutexception") + Utils.getStackTrace(toe));
                        if (!this.context.cfg.isKeepGoing()) {
                            this.fault = true;
                            this.status = 1;
                        } else {
                            logger.info(this.context.cfg.gs("Stty.ignoring.exception.listener.keep.going.enabled"));
                        }
                        break;
                    }
                    catch (SocketException se) {
                        if (se.toString().contains("timed out")) {
                            this.context.timeout = true;
                        }
                        this.connected = false;
                        logger.debug(this.context.cfg.gs("Stty.socketexception.timeout.is") + this.context.timeout);
                        if (!this.context.cfg.isKeepGoing()) {
                            this.fault = true;
                            this.status = 1;
                        } else {
                            logger.info(this.context.cfg.gs("Stty.ignoring.exception.listener.keep.going.enabled"));
                        }
                        break;
                    }
                    catch (Exception e) {
                        logger.error(this.context.cfg.gs("Stty.subscriber.listener.exception"));
                        logger.error(Utils.getStackTrace(e));
                        try {
                            if (!this.context.timeout) {
                                this.send(e.getMessage(), null);
                                Thread.sleep(1500L);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!this.context.cfg.isKeepGoing()) {
                            this.fault = true;
                            this.status = 1;
                        }
                        break;
                    }
                }
            }
            finally {
                this.stopHeartBeat();
            }
        }
        if (this.fault) {
            this.context.fault = true;
        }
        String statMsg = this.status == 0 ? "Success" : (this.status == 1 ? "Quit" : "Stop");
        logger.trace(MessageFormat.format(this.context.cfg.gs("Stty.server.session.done.status.fault"), statMsg) + this.context.fault);
        return this.status;
    }

    @Override
    public void requestStop() {
        this.status = 1;
        logger.debug(this.context.cfg.gs("Stty.requesting.stop.for.stty.session") + Utils.formatAddresses(this.socket) + ":" + this.socket.getPort());
    }
}

