/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools.archiver;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Persistent;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Task;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiverTool
extends AbstractTool {
    public static final String INTERNAL_NAME = "Archiver";
    public static final String SUBSYSTEM = "tools";
    private String configName;
    private final String internalName = "Archiver";
    private boolean appendPubSub = true;
    private boolean appendDate = true;
    private boolean deleteFiles = true;
    private String format = "zip";
    private String target = "";
    private transient int count = 0;
    private transient int deleteCount = 0;
    private transient ArrayList<String> filesToCompress = null;
    private transient Logger logger = LogManager.getLogger("applog");
    private transient String outputFilename = "";
    private transient Repository pubRepo = null;
    private transient Repository subRepo = null;
    private transient ArrayList<String> toolPaths;

    public ArchiverTool(Context context) {
        super(context);
        this.setDisplayName(this.getCfg().gs("Archiver.displayName"));
        this.context = context;
        this.dataHasChanged = false;
    }

    @Override
    public ArchiverTool clone() {
        assert (this.context != null);
        ArchiverTool tool = new ArchiverTool(this.context);
        tool.setConfigName(this.getConfigName());
        tool.setDisplayName(this.getDisplayName());
        tool.setAppendPubSub(this.isAppendPubSub());
        tool.setAppendDate(this.isAppendDate());
        tool.setDeleteFiles(this.isDeleteFiles());
        tool.setFormat(this.getFormat());
        tool.setTarget(this.getTarget());
        tool.setDataHasChanged();
        tool.setRemote(this.isRemote());
        return tool;
    }

    private void deleteFiles() {
        Object msg = "";
        for (String path : this.filesToCompress) {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
                msg = "  - " + this.context.cfg.gs("Z.deleted") + path;
                this.logger.info((String)msg);
                ++this.deleteCount;
                continue;
            }
            this.logger.warn(this.context.cfg.gs("Archiver.file.disappeared") + path);
        }
    }

    private void expandOrigins(ArrayList<Origin> origins) throws MungeException {
        if (this.pubRepo == null) {
            return;
        }
        for (Origin origin : origins) {
            if (origin.getType() == 1) {
                if (origin.getLocation().length() > 0 && !this.pubRepo.getLibraryData().libraries.description.equalsIgnoreCase(origin.getLocation())) {
                    throw new MungeException(this.context.cfg.gs("Archiver.task.definition.and.loaded.repository.do.not.match"));
                }
                for (Library lib : this.pubRepo.getLibraryData().libraries.bibliography) {
                    for (String source : lib.sources) {
                        this.toolPaths.add(source);
                    }
                }
                continue;
            }
            if (origin.getType() == 5) {
                for (Library lib : this.pubRepo.getLibraryData().libraries.bibliography) {
                    if (!lib.name.equalsIgnoreCase(origin.getLocation())) continue;
                    for (String source : lib.sources) {
                        this.toolPaths.add(source);
                    }
                }
                continue;
            }
            if (origin.getType() != 6) continue;
            this.toolPaths.add(origin.getLocation());
        }
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String formatArchiveFilename() {
        Object archiveName = "";
        String name = "";
        if (this.getTarget().length() > 0) {
            int p;
            String sep = Utils.getSeparatorFromPath(this.getTarget());
            name = sep.length() > 0 ? ((p = (name = Utils.pipe(this.getTarget(), sep)).lastIndexOf("|")) >= 0 && p < name.length() - 1 ? name.substring(p + 1) : "") : this.getTarget();
        }
        archiveName = name;
        if (this.isAppendPubSub()) {
            if (this.pubRepo != null) {
                archiveName = (String)archiveName + this.pubRepo.getLibraryData().libraries.description;
            }
            if (this.pubRepo != null && this.subRepo != null) {
                archiveName = (String)archiveName + "-";
            }
            if (this.subRepo != null) {
                archiveName = (String)archiveName + this.subRepo.getLibraryData().libraries.description;
            }
        }
        if (this.isAppendDate()) {
            long utc = Instant.now().toEpochMilli();
            Instant instant = Instant.ofEpochMilli(utc);
            ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
            if (((String)archiveName).length() > 0) {
                archiveName = (String)archiveName + " ";
            }
            archiveName = (String)archiveName + zdt.format(DateTimeFormatter.ofPattern(this.context.preferences.getDateFormat()));
        }
        if (((String)archiveName).length() > 0) {
            archiveName = this.getFormat().equals("tar") ? (String)archiveName + ".tar" : (String)archiveName + ".zip";
        }
        return archiveName;
    }

    public String formatArchiveFilename(Repository pubRepo, Repository subRepo) {
        this.pubRepo = pubRepo;
        this.subRepo = subRepo;
        return this.formatArchiveFilename();
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public String getInternalName() {
        return INTERNAL_NAME;
    }

    @Override
    public String getSubsystem() {
        return SUBSYSTEM;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargetDirectory() {
        Object directory = "";
        String sep = Utils.getSeparatorFromPath(this.getTarget());
        if (sep.length() > 0) {
            directory = Utils.getLeftPath(this.getTarget(), sep);
            if (Utils.isRelativePath((String)directory)) {
                directory = this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + (String)directory;
            }
        } else {
            directory = this.context.cfg.getWorkingDirectory();
        }
        return directory;
    }

    public boolean isAppendDate() {
        return this.appendDate;
    }

    public boolean isAppendPubSub() {
        return this.appendPubSub;
    }

    @Override
    public boolean isDataChanged() {
        return this.dataHasChanged;
    }

    public boolean isDeleteFiles() {
        return this.deleteFiles;
    }

    @Override
    public boolean isToolOriginsUsed() {
        return true;
    }

    @Override
    public boolean isToolSubscriber() {
        return false;
    }

    @Override
    public void processTool(Task task) throws Exception {
        this.reset();
        if (this.pubRepo == null) {
            this.pubRepo = this.context.publisherRepo;
        }
        if (this.pubRepo == null) {
            this.pubRepo = Persistent.lastPublisherRepo;
        }
        if (this.subRepo == null) {
            this.subRepo = this.context.subscriberRepo;
        }
        if (this.subRepo == null) {
            this.subRepo = Persistent.lastSubscriberRepo;
        }
        if (this.pubRepo == null) {
            this.logger.error(MessageFormat.format(this.context.cfg.gs("Archiver.has.no.repository.defined"), this.getConfigName()));
            return;
        }
        this.expandOrigins(task.origins);
        if (this.toolPaths == null || this.toolPaths.size() == 0) {
            return;
        }
        for (String path : this.toolPaths) {
            if (this.isRequestStop()) break;
            this.logger.info(this.getDisplayName() + ", " + this.getConfigName() + ": " + path);
            this.scanForFiles(path);
        }
        if (!this.filesToCompress.isEmpty()) {
            if (this.getFormat().equalsIgnoreCase("zip")) {
                this.zipFiles();
            } else if (this.getFormat().equalsIgnoreCase("tar")) {
                this.tarFiles();
            } else {
                throw new MungeException(this.context.cfg.gs("Archiver.unknown.archiver.format") + this.getFormat());
            }
            if (this.isDeleteFiles()) {
                this.deleteFiles();
            }
            String msg = this.getDisplayName() + ", " + this.getConfigName() + this.context.cfg.gs("Archiver.compressed") + this.count + this.context.cfg.gs("Archiver.deleted") + this.deleteCount + this.context.cfg.gs("Archiver.files.successfully.to") + this.outputFilename;
            this.logger.info(msg);
            if (this.context != null && this.context.cfg.isNavigator() && !this.context.cfg.isLoggerView()) {
                if (this.context.navigator.dialogArchiver != null && this.context.navigator.dialogArchiver.isShowing()) {
                    this.context.navigator.dialogArchiver.labelStatus.setText(msg);
                }
                if (this.deleteCount > 0) {
                    this.context.browser.loadCollectionTree(this.context.mainFrame.treeCollectionOne, this.context.publisherRepo, false);
                    this.context.browser.loadSystemTree(this.context.mainFrame.treeSystemOne, this.context.publisherRepo, false);
                }
            }
        } else {
            this.logger.warn(this.context.cfg.gs("Archiver.no.files.found.to.compress"));
        }
    }

    @Override
    public boolean isToolPublisher() {
        return false;
    }

    public void reset() {
        this.count = 0;
        this.deleteCount = 0;
        this.resetStop();
        this.toolPaths = new ArrayList();
        this.filesToCompress = new ArrayList();
        if (this.logger == null) {
            this.logger = LogManager.getLogger("applog");
        }
    }

    private boolean scanForFiles(String path) {
        boolean hadError;
        block6: {
            hadError = false;
            try {
                File file = new File(Utils.getFullPathLocal(path));
                if (!file.isDirectory()) {
                    this.filesToCompress.add(Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), file.getAbsoluteFile().toString()));
                    return true;
                }
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(path, new String[0]));
                for (Path entry : directoryStream) {
                    if (!this.isRequestStop()) {
                        String filename = entry.toAbsolutePath().toString();
                        boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                        if (isDir) {
                            this.scanForFiles(filename);
                            continue;
                        }
                        this.filesToCompress.add(Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), filename));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                int reply;
                hadError = true;
                String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                this.logger.error(msg);
                if (this.context == null) break block6;
                msg = this.context.cfg.gs("Z.exception") + " " + e.getMessage();
                if (this.context.navigator == null || (reply = JOptionPane.showConfirmDialog(this.context.navigator.dialogArchiver, msg, this.context.cfg.gs("ArchiverUI.title"), 0)) != 0) break block6;
                this.requestStop();
            }
        }
        return hadError;
    }

    public void setAppendDate(boolean appendDate) {
        this.appendDate = appendDate;
    }

    public void setAppendPubSub(boolean appendPubSub) {
        this.appendPubSub = appendPubSub;
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setDeleteFiles(boolean deleteFiles) {
        this.deleteFiles = deleteFiles;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    private void tarFiles() throws Exception {
        if (this.filesToCompress != null && !this.filesToCompress.isEmpty()) {
            String directory = this.getTargetDirectory();
            Object tarFilePath = this.formatArchiveFilename();
            tarFilePath = directory + System.getProperty("file.separator") + (String)tarFilePath;
            tarFilePath = Utils.pipe((String)tarFilePath);
            tarFilePath = Utils.unpipe((String)tarFilePath, System.getProperty("file.separator"));
            File parent = new File(directory);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File outputFile = new File((String)tarFilePath);
            this.outputFilename = tarFilePath = outputFile.getAbsolutePath();
            TarArchiveOutputStream taos = new TarArchiveOutputStream(new FileOutputStream((String)tarFilePath));
            for (String path : this.filesToCompress) {
                File input = new File(path);
                if (!input.exists()) {
                    this.logger.warn(this.context.cfg.gs("Repository.file.does.not.exist") + path);
                    continue;
                }
                TarArchiveEntry entry = new TarArchiveEntry(input, path);
                entry.setModTime(input.lastModified());
                taos.putArchiveEntry(entry);
                try (FileInputStream fis = new FileInputStream(path);){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = fis.read(buffer)) > 0) {
                        taos.write(buffer, 0, len);
                    }
                    ++this.count;
                    this.logger.info("  + " + this.context.cfg.gs("Archiver.compressed.file") + path);
                }
                taos.closeArchiveEntry();
            }
            taos.close();
            this.logger.info(this.context.cfg.gs("Archiver.compressed") + this.count + this.context.cfg.gs("Archiver.files.successfully.to") + (String)tarFilePath);
        }
    }

    public void write() throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            File f = new File(this.getFullPath());
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(this.getFullPath());
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.getCfg().gs("Z.error.writing") + this.getFullPath() + ": " + Utils.getStackTrace(fnf));
        }
    }

    private void zipFiles() throws Exception {
        if (this.filesToCompress != null && !this.filesToCompress.isEmpty()) {
            String directory = this.getTargetDirectory();
            Object zipFilePath = this.formatArchiveFilename();
            zipFilePath = directory + System.getProperty("file.separator") + (String)zipFilePath;
            zipFilePath = Utils.pipe((String)zipFilePath);
            zipFilePath = Utils.unpipe((String)zipFilePath, System.getProperty("file.separator"));
            File parent = new File(directory);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File outputFile = new File((String)zipFilePath);
            this.outputFilename = zipFilePath = outputFile.getAbsolutePath();
            ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(new FileOutputStream((String)zipFilePath));
            for (String path : this.filesToCompress) {
                File input = new File(path);
                if (!input.exists()) {
                    this.logger.warn(this.context.cfg.gs("Repository.file.does.not.exist") + path);
                    continue;
                }
                ZipArchiveEntry entry = new ZipArchiveEntry(path);
                entry.setLastModifiedTime(FileTime.fromMillis(input.lastModified()));
                zaos.putArchiveEntry(entry);
                try (FileInputStream fis = new FileInputStream(path);){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = fis.read(buffer)) > 0) {
                        zaos.write(buffer, 0, len);
                    }
                    ++this.count;
                    this.logger.info("  + " + this.context.cfg.gs("Archiver.compressed.file") + path);
                }
                zaos.closeArchiveEntry();
            }
            zaos.close();
        }
    }
}

