/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools.email;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Task;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.Instant;

public class EmailTool
extends AbstractTool {
    public static final String INTERNAL_NAME = "Email";
    public static final String SUBSYSTEM = "local";
    private String configName;
    private String internalName = "Email";
    private String profile = "Apple";
    private String server = "";
    private String username = "";
    private byte[] password = new byte[0];
    private String port = "";
    private String security = "STARTTLS";
    private String authMethod = "Password";
    private long accessExpires = 0L;
    private long refreshExpires = 0L;
    private String refreshUrl = "";
    private byte[] accessToken = new byte[0];
    private byte[] refreshToken = new byte[0];

    public EmailTool(Context context) {
        super(context);
        this.context = context;
        this.setDisplayName(this.getCfg().gs("Email.displayName"));
        this.setDataHasChanged(false);
    }

    @Override
    public EmailTool clone() {
        EmailTool clone = new EmailTool(this.context);
        clone.configName = this.configName;
        clone.internalName = this.internalName;
        clone.profile = this.profile;
        clone.server = this.server;
        clone.username = this.username;
        clone.password = this.password;
        clone.port = this.port;
        clone.security = this.security;
        clone.authMethod = this.authMethod;
        clone.accessExpires = this.accessExpires;
        clone.refreshExpires = this.refreshExpires;
        clone.accessToken = new byte[this.accessToken.length];
        System.arraycopy(this.accessToken, 0, clone.accessToken, 0, this.accessToken.length);
        clone.refreshToken = new byte[this.refreshToken.length];
        System.arraycopy(this.refreshToken, 0, clone.refreshToken, 0, this.refreshToken.length);
        return clone;
    }

    public long getAccessExpires() {
        return this.accessExpires;
    }

    public String getAccessToken() {
        return this.context.main.decrypt(this.context.main.systemKey, this.accessToken);
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String getServer() {
        return this.server;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public String getPassword() {
        if (this.password.length == 0) {
            return "";
        }
        return this.context.main.decrypt(this.context.main.systemKey, this.password);
    }

    public String getPort() {
        return this.port;
    }

    public String getProfile() {
        return this.profile;
    }

    public long getRefreshExpires() {
        return this.refreshExpires;
    }

    public String getRefreshToken() {
        return this.context.main.decrypt(this.context.main.systemKey, this.refreshToken);
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public String getSecurity() {
        return this.security;
    }

    @Override
    public String getSubsystem() {
        return SUBSYSTEM;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isDataChanged() {
        return this.dataHasChanged;
    }

    @Override
    public void processTool(Task task) throws Exception {
        this.context.fault = false;
    }

    public boolean isExpired(long value) {
        long utc = Instant.now().toEpochMilli();
        return utc > value;
    }

    public void setAccessExpires(long accessExpires) {
        long utc = Instant.now().toEpochMilli();
        accessExpires = (accessExpires -= 120L) > 0L ? utc + accessExpires * 1000L : utc;
        this.accessExpires = accessExpires;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = !accessToken.isEmpty() ? this.context.main.encrypt(this.context.main.systemKey, accessToken) : new byte[0];
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPassword(String password) {
        this.password = !password.isEmpty() ? this.context.main.encrypt(this.context.main.systemKey, password) : new byte[0];
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setRefreshExpires(long refreshExpires) {
        long utc = Instant.now().toEpochMilli();
        refreshExpires = (refreshExpires -= 120L) > 0L ? utc + refreshExpires * 1000L : utc;
        this.refreshExpires = refreshExpires;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = !refreshToken.isEmpty() ? this.context.main.encrypt(this.context.main.systemKey, refreshToken) : new byte[0];
    }

    public void setRefreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
    }

    public void setSecurity(String security) {
        this.security = security;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void write() throws Exception {
        if (!this.getAuthMethod().equalsIgnoreCase("oauth2")) {
            this.setAccessToken("");
            this.setAccessExpires(-1L);
            this.setRefreshToken("");
            this.setRefreshExpires(-1L);
            this.setRefreshUrl("");
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            File f = new File(this.getFullPath());
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(this.getFullPath());
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.getCfg().gs("Z.error.writing") + this.getFullPath() + ": " + Utils.getStackTrace(fnf));
        }
    }
}

