/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import mslinks.ShellLinkException;
import mslinks.UnsupportedCLSIDException;
import mslinks.data.GUID;
import mslinks.data.ItemID;
import mslinks.data.Registry;

public abstract class ItemIDRegItem
extends ItemID {
    protected GUID clsid;

    public ItemIDRegItem(int flags) {
        super(flags);
    }

    @Override
    public void load(ByteReader br, int maxSize) throws IOException, ShellLinkException {
        super.load(br, maxSize);
        br.read();
        this.setClsid(new GUID(br));
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        super.serialize(bw);
        bw.write(0);
        this.clsid.serialize(bw);
    }

    @Override
    public String toString() {
        String name;
        try {
            name = Registry.getName(this.clsid);
        }
        catch (UnsupportedCLSIDException e) {
            name = this.getClass().getSimpleName();
        }
        return "<" + name + ">\\";
    }

    public GUID getClsid() {
        return this.clsid;
    }

    public ItemIDRegItem setClsid(GUID clsid) throws UnsupportedCLSIDException {
        if (!Registry.canUseClsidIn(clsid, this.getClass())) {
            throw new UnsupportedCLSIDException(clsid);
        }
        this.clsid = clsid;
        return this;
    }
}

