/*
 * Decompiled with CFR 0.152.
 */
package mslinks.extra;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.util.LinkedList;
import mslinks.Serializable;
import mslinks.ShellLinkException;

public class VistaIDList
implements Serializable {
    public static final int signature = -1610612724;
    private LinkedList<byte[]> list = new LinkedList();

    public VistaIDList() {
    }

    public VistaIDList(ByteReader br, int size) throws ShellLinkException, IOException {
        if (size < 10) {
            throw new ShellLinkException();
        }
        int s = (int)br.read2bytes();
        while (s != 0) {
            byte[] b = new byte[s -= 2];
            for (int i = 0; i < s; ++i) {
                b[i] = (byte)br.read();
            }
            this.list.add(b);
            s = (int)br.read2bytes();
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        int size = 10;
        for (byte[] i : this.list) {
            size += i.length + 2;
        }
        bw.write2bytes(size);
        for (byte[] i : this.list) {
            bw.write2bytes(i.length + 2);
            for (byte j : i) {
                bw.write(j);
            }
        }
        bw.write2bytes(0L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (byte[] b : this.list) {
            sb.append(new String(b) + "\n");
        }
        return sb.toString();
    }
}

