/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ChannelToPortHandler
extends AbstractLoggingBean {
    private final IoSession port;
    private final Channel channel;

    public ChannelToPortHandler(IoSession port, Channel channel) {
        this.port = Objects.requireNonNull(port, "No port IoSession");
        this.channel = Objects.requireNonNull(channel, "No Channel");
    }

    public IoSession getPortSession() {
        return this.port;
    }

    public void handleEof() throws IOException {
        this.port.shutdownOutputStream();
    }

    public void sendToPort(byte cmd, byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone(data, off, (int)len);
        this.port.writeBuffer(buf).addListener(future -> {
            if (future.isWritten()) {
                this.handleWriteDataSuccess(cmd, buf.array(), 0, (int)len);
            } else {
                this.handleWriteDataFailure(cmd, buf.array(), 0, (int)len, future.getException());
            }
        });
    }

    protected void handleWriteDataSuccess(byte cmd, byte[] data, int off, int len) {
        this.checkWindow(cmd, len);
    }

    protected void handleWriteDataFailure(byte cmd, byte[] data, int off, int len, Throwable t) {
        this.debug("handleWriteDataFailure({}, {})[{}] failed ({}) to write len={}: {}", this.channel, this.port, SshConstants.getCommandMessageName(cmd & 0xFF), t.getClass().getSimpleName(), len, t.getMessage(), t);
        if (this.port.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] closing session={}", this.channel, SshConstants.getCommandMessageName(cmd & 0xFF), this.port);
            }
            this.checkWindow(cmd, len);
            this.channel.close(false);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] ignoring writeDataFailure {} because ioSession {} is already closing ", this.channel, SshConstants.getCommandMessageName(cmd & 0xFF), t, this.port);
            }
            this.checkWindow(cmd, len);
        }
    }

    private void checkWindow(byte cmd, long len) {
        try {
            LocalWindow wLocal = this.channel.getLocalWindow();
            if (wLocal.isOpen()) {
                wLocal.release(len);
            }
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataSuccess({})[{}] failed ({}) to check local window: {}", this.channel, SshConstants.getCommandMessageName(cmd & 0xFF), e.getClass().getSimpleName(), e.getMessage());
            }
            this.channel.getSession().exceptionCaught(e);
        }
    }
}

