/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Persistent;
import com.corionis.els.Process;
import com.corionis.els.Transfer;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.Navigator;
import com.corionis.els.gui.Preferences;
import com.corionis.els.gui.update.DownloadUpdater;
import com.corionis.els.gui.util.GuiLogAppender;
import com.corionis.els.hints.HintKeys;
import com.corionis.els.hints.Hints;
import com.corionis.els.jobs.Job;
import com.corionis.els.jobs.Task;
import com.corionis.els.repository.Repository;
import com.corionis.els.sftp.ClientSftp;
import com.corionis.els.sftp.ServeSftp;
import com.corionis.els.stty.ClientStty;
import com.corionis.els.stty.ServeStty;
import com.corionis.els.stty.hintServer.Datastore;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.Tools;
import com.corionis.els.tools.email.EmailHandler;
import com.corionis.els.tools.email.EmailTool;
import com.corionis.els.tools.operations.OperationsTool;
import java.awt.Component;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Main {
    public Context context;
    public String localeAbbrev;
    public Logger logger = null;
    public boolean mockMode = false;
    public String operationName = "";
    public boolean primaryExecution = true;
    public boolean secondaryNavigator = false;
    public Date stamp = new Date();
    public String systemKey = "";
    public String whatsRunning = "";
    private boolean catchExceptions = true;
    private boolean isListening = false;
    public Job job = null;

    private Main() {
    }

    public Main(String[] args) {
        this.context = new Context();
        this.context.main = this;
        this.primaryExecution = true;
        this.process(args);
        if (this.context.mainFrame == null && !this.context.cfg.isNavigator() && !this.isListening) {
            System.exit(this.context.fault ? 1 : 0);
        }
    }

    public Main(String[] args, Context context, String operationName) {
        this.context = context;
        this.context.main = this;
        this.primaryExecution = false;
        this.operationName = operationName;
        this.process(args);
    }

    public static void main(String[] args) {
        new Main(args);
    }

    private void checkEmptyArguments() {
        if (this.context.cfg.getPublisherFilename().length() == 0 && this.context.cfg.getSubscriberFilename().length() == 0 && this.context.cfg.getOperation() != 8 && !this.context.cfg.isStatusServer()) {
            this.context.cfg.setDefaultNavigator(true);
        }
        if (this.context.cfg.getOperation() != 8 && this.context.preferences.isUseLastPublisherSubscriber() && this.context.cfg.isNavigator() && (this.context.cfg.getOperation() == 0 || this.context.cfg.getOperation() == 1) && this.context.cfg.getPublisherFilename().length() == 0 && this.context.cfg.getSubscriberFilename().length() == 0) {
            if (this.context.preferences.isLastPublisherIsOpen() && this.context.preferences.getLastPublisherOpenPath().length() > 0) {
                if (this.context.preferences.isLastPublisherIsWorkstation()) {
                    this.context.cfg.setPublisherCollectionFilename("");
                    this.context.cfg.setPublisherLibrariesFileName(this.context.preferences.getLastPublisherOpenFile());
                } else {
                    this.context.cfg.setPublisherCollectionFilename(this.context.preferences.getLastPublisherOpenFile());
                    this.context.cfg.setPublisherLibrariesFileName("");
                }
            }
            if (this.context.preferences.isLastSubscriberIsOpen() && this.context.preferences.getLastSubscriberOpenFile().length() > 0) {
                this.context.cfg.setSubscriberLibrariesFileName(this.context.preferences.getLastSubscriberOpenFile());
                if (this.context.preferences.isLastSubscriberIsRemote() && this.context.cfg.getSubscriberFilename().length() > 0) {
                    this.context.cfg.setOperation("P");
                }
                this.context.cfg.setOverrideSubscriberHost(this.context.preferences.getLastOverrideSubscriber());
            }
            if (this.context.preferences.isLastHintKeysIsOpen() && this.context.cfg.getHintKeysFile().length() == 0 && this.context.preferences.getLastHintKeysOpenFile().length() > 0) {
                this.context.cfg.setHintKeysFile(this.context.preferences.getLastHintKeysOpenFile());
                if (this.context.preferences.isLastHintTrackingIsOpen() && this.context.cfg.getHintHandlerFilename().length() == 0 && this.context.preferences.getLastHintTrackingOpenFile().length() > 0) {
                    if (this.context.preferences.isLastHintTrackingIsRemote()) {
                        this.context.cfg.setHintsDaemonFilename(this.context.preferences.getLastHintTrackingOpenFile());
                        this.context.cfg.setOverrideHintsHost(this.context.preferences.isLastOverrideHintHost());
                    } else {
                        this.context.cfg.setHintTrackerFilename(this.context.preferences.getLastHintTrackingOpenFile());
                    }
                }
            }
        }
    }

    public boolean checkForUpdates(boolean checkOnly) {
        URL url = null;
        boolean gui = this.context.cfg.isNavigator() && this.context.navigator != null && !this.context.cfg.isCheckForUpdate() && !this.context.cfg.isInstallUpdate();
        ArrayList<String> version = new ArrayList<String>();
        try {
            String flags;
            Object message;
            String prefix;
            String updateInfoPath;
            File installed;
            URI uri = new URI("https://corionis.github.io/ELS/");
            if (gui) {
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            }
            if (!(installed = new File(updateInfoPath = this.context.cfg.getInstalledPath() + System.getProperty("file.separator") + "bin")).canWrite()) {
                if (gui) {
                    this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
                Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                String message2 = this.context.cfg.gs("Updater.application.path.not.writable");
                this.logger.info(message2);
                if (!checkOnly) {
                    if (gui) {
                        JOptionPane.showOptionDialog(this.context.mainFrame, message2, this.context.cfg.gs("Navigator.update"), -1, 2, null, opts, opts[0]);
                    } else {
                        System.out.println(message2);
                    }
                }
                return false;
            }
            updateInfoPath = this.context.cfg.getInstalledPath() + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "update.info";
            File updateInfo = new File(updateInfoPath);
            if (updateInfo.exists()) {
                prefix = new String(Files.readAllBytes(Paths.get(updateInfoPath, new String[0])));
                prefix = prefix.trim();
            } else {
                prefix = this.context.cfg.getUrlPrefix();
                message = MessageFormat.format(this.context.cfg.gs("Main.update.info.not.found"), updateInfoPath, prefix);
                this.logger.warn((String)message);
                if (!gui) {
                    System.out.println((String)message);
                }
            }
            Object versionPath = "";
            BufferedReader bufferedReader = null;
            try {
                String buf;
                if (!this.mockMode) {
                    versionPath = prefix + "/version.info";
                    url = new URL((String)versionPath);
                    bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
                } else {
                    versionPath = this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "version.info";
                    bufferedReader = new BufferedReader(new FileReader((String)versionPath));
                }
                while ((buf = bufferedReader.readLine()) != null) {
                    version.add(buf.trim());
                }
                bufferedReader.close();
            }
            catch (Exception e) {
                if (gui) {
                    this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
                message = MessageFormat.format(this.context.cfg.gs("Navigator.update.info.not.found"), versionPath);
                this.logger.error((String)message);
                Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                if (gui) {
                    JOptionPane.showOptionDialog(this.context.mainFrame, message, this.context.cfg.gs("Navigator.update"), -1, 0, null, opts, opts[0]);
                } else {
                    System.out.println((String)message);
                }
                return false;
            }
            if (gui) {
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (version.size() < 6) {
                message = MessageFormat.format(this.context.cfg.gs("Navigator.version.info.missing.or.malformed"), versionPath);
                this.logger.info((String)message);
                Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                if (gui) {
                    JOptionPane.showOptionDialog(this.context.mainFrame, message, this.context.cfg.gs("Navigator.update"), -1, 0, null, opts, opts[0]);
                } else {
                    System.out.println((String)message);
                }
                return false;
            }
            String string = flags = version.size() > 6 ? (String)version.get(6) : "";
            if (checkOnly) {
                if (flags.toLowerCase().contains("ignore") || ((String)version.get(1)).equals(Configuration.getBuildNumber())) {
                    message = this.context.cfg.gs("Navigator.installed.up.to.date");
                    if (gui) {
                        this.context.mainFrame.labelStatusMiddle.setText((String)message);
                    } else {
                        System.out.println((String)message);
                    }
                    return false;
                }
                message = this.context.cfg.gs("Navigator.update.available");
                if (gui) {
                    this.context.mainFrame.labelStatusMiddle.setText((String)message);
                } else {
                    String note = this.context.cfg.gs("Navigator.install.use.option.y.to.install.update");
                    message = MessageFormat.format(this.context.cfg.gs("Navigator.install.update.version.text"), Configuration.getBuildDate(), version.get(2)) + note;
                    System.out.println((String)message);
                }
                return true;
            }
            if (!this.context.cfg.isInstallUpdate() && (flags.toLowerCase().contains("ignore") || ((String)version.get(1)).equals(Configuration.getBuildNumber()))) {
                message = this.context.cfg.gs("Navigator.installed.up.to.date");
                this.logger.info((String)message);
                if (gui) {
                    this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Navigator.installed.up.to.date"));
                    this.context.mainFrame.labelAlertUpdateMenu.setVisible(false);
                    this.context.mainFrame.labelAlertUpdateToolbar.setVisible(false);
                    Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                    JOptionPane.showOptionDialog(this.context.mainFrame, message, this.context.cfg.gs("Navigator.update"), -1, 1, null, opts, opts[0]);
                } else {
                    System.out.println((String)message);
                }
                return false;
            }
            if (gui) {
                this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Navigator.update.available"));
                this.context.mainFrame.labelAlertUpdateMenu.setVisible(true);
                this.context.mainFrame.labelAlertUpdateToolbar.setVisible(true);
            }
            while (true) {
                int reply = 0;
                if (gui) {
                    String prompt = this.context.cfg.gs("Navigator.install.update.version");
                    message = MessageFormat.format(prompt, Configuration.getBuildDate(), version.get(2));
                    Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no"), this.context.cfg.gs("Navigator.recent.changes")};
                    reply = JOptionPane.showOptionDialog(this.context.mainFrame, message, this.context.cfg.gs("Navigator.update"), -1, 1, null, opts, opts[0]);
                }
                if (reply == 0) {
                    message = MessageFormat.format(this.context.cfg.gs("Navigator.install.update.version.download.text"), Configuration.getBuildDate(), version.get(2));
                    System.out.println((String)message);
                    new DownloadUpdater(this.context, gui ? this.context.navigator : null, version, prefix);
                } else if (reply == 2) {
                    this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                    NavHelp helpDialog = new NavHelp(this.context.mainFrame, this.context.mainFrame, this.context, this.context.cfg.gs("Navigator.recent.changes"), (String)version.get(5), true);
                    if (helpDialog.fault) continue;
                    helpDialog.buttonFocus();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String message = this.context.cfg.gs("Main.error.downloading.update") + Utils.getStackTrace(e);
            this.logger.error(message);
            if (gui) {
                this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(this.context.mainFrame, message + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
            } else {
                System.out.println(message);
            }
            return false;
        }
        if (gui) {
            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
        return true;
    }

    public void checkWorkingDirectories() throws Exception {
        String[] stdDirs = new String[]{"jobs", "libraries", "local", "system", "tools"};
        String working = this.context.cfg.getWorkingDirectory();
        for (int i = 0; i < stdDirs.length; ++i) {
            Path dir = Paths.get(working, stdDirs[i]);
            if (Files.exists(dir, new LinkOption[0])) continue;
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        String[] localDirs = new String[]{"Email"};
        for (int i = 0; i < localDirs.length; ++i) {
            Path dir = Paths.get(working, "local", localDirs[i]);
            if (Files.exists(dir, new LinkOption[0])) continue;
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        String[] toolDirs = new String[]{"Archiver", "JunkRemover", "Operations", "Renamer", "Sleep"};
        for (int i = 0; i < toolDirs.length; ++i) {
            Path dir = Paths.get(working, "tools", toolDirs[i]);
            if (Files.exists(dir, new LinkOption[0])) continue;
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        this.systemKey = this.getSystemKey();
    }

    public void connectHints(Repository repo) throws Exception {
        Object msg = "";
        try {
            if (this.context.cfg.isHintTrackingEnabled() || this.context.cfg.getHintKeysFile().length() > 0) {
                if (this.context.cfg.getHintKeysFile().length() > 0) {
                    this.context.hintKeys = new HintKeys(this.context);
                    msg = this.context.cfg.gs("Main.exception.while.reading.hint.keys");
                    this.context.hintKeys.read(this.context.cfg.getHintKeysFile());
                    this.context.hintsHandler = new Hints(this.context, this.context.hintKeys);
                    this.context.preferences.setLastHintKeysIsOpen(true);
                } else if (!this.context.cfg.isQuitStatusServer()) {
                    throw new MungeException(this.context.cfg.gs("Main.hint.keys.are.required.to.use.hint.tracking"));
                }
                if (this.context.cfg.isHintTrackingEnabled()) {
                    this.context.hintsRepo = new Repository(this.context, 3);
                    if (this.context.cfg.getHintsDaemonFilename().length() > 0 && repo != null) {
                        this.catchExceptions = false;
                        msg = this.context.cfg.gs("Main.exception.while.reading.hint.server");
                        if (this.context.hintsRepo.read(this.context.cfg.getHintsDaemonFilename(), "Hint Status Server", true)) {
                            this.catchExceptions = true;
                            this.context.hintsStty = new ClientStty(this.context, false, true, true);
                            if (!this.context.hintsStty.connect(repo, this.context.hintsRepo)) {
                                msg = "";
                                throw new MungeException(MessageFormat.format(this.context.cfg.gs("Main.hint.status.server.failed.to.connect"), this.context.hintsRepo.getLibraryData().libraries.description));
                            }
                            String response = this.context.hintsStty.receive("", 5000);
                            if (!response.startsWith("CMD")) {
                                msg = "";
                                throw new MungeException(this.context.cfg.gs("Main.bad.initial.response.from.hint.status.server") + this.context.hintsRepo.getLibraryData().libraries.description);
                            }
                            this.context.preferences.setLastHintTrackingIsRemote(true);
                            this.context.preferences.setLastHintTrackingIsOpen(true);
                        } else {
                            this.catchExceptions = true;
                            this.context.cfg.setHintsDaemonFilename("");
                        }
                    } else {
                        this.catchExceptions = false;
                        msg = this.context.cfg.gs("Main.exception.while.reading.hint.tracker");
                        if (this.context.hintsRepo.read(this.context.cfg.getHintTrackerFilename(), "Hint Tracker", true)) {
                            this.catchExceptions = true;
                            this.context.datastore = new Datastore(this.context);
                            boolean valid = this.context.datastore.initialize();
                            if (!valid) {
                                throw new MungeException(this.context.cfg.gs("Main.error.initializing.from.hint.status.server.json.file"));
                            }
                            this.context.preferences.setLastHintTrackingIsRemote(false);
                            this.context.preferences.setLastHintTrackingIsOpen(true);
                        } else {
                            this.catchExceptions = true;
                            this.context.cfg.setHintTrackerFilename("");
                        }
                    }
                }
            } else {
                this.context.preferences.setLastHintKeysIsOpen(false);
                this.context.preferences.setLastHintTrackingIsOpen(false);
            }
        }
        catch (Exception e) {
            if (this.catchExceptions) {
                int opt;
                msg = (String)(((String)msg).length() > 0 ? msg : "") + e.getMessage();
                this.logger.error((String)msg);
                this.context.cfg.setHintsDaemonFilename("");
                this.context.cfg.setHintTrackerFilename("");
                this.context.hintsRepo = null;
                if (this.isStartupActive() && (opt = JOptionPane.showConfirmDialog(this.context.guiLogAppender.getStartup(), "<html><body>" + (String)msg + "<br/><br/>" + this.context.cfg.gs("Main.continue") + "</body></html>", this.context.cfg.getNavigatorName(), 0)) == 0) {
                    this.context.preferences.setLastHintTrackingIsOpen(false);
                    this.context.fault = false;
                    return;
                }
                this.catchExceptions = false;
            }
            throw new MungeException((String)msg);
        }
    }

    public boolean connectSubscriber(boolean isTerminal, boolean promptOnFailure) throws Exception {
        block5: {
            try {
                Persistent.couldNotConnect = false;
                if (this.context.publisherRepo != null && this.context.subscriberRepo != null) {
                    this.context.clientStty = new ClientStty(this.context, isTerminal, true, false);
                    if (!this.context.clientStty.connect(this.context.publisherRepo, this.context.subscriberRepo)) {
                        Persistent.couldNotConnect = true;
                        throw new MungeException(MessageFormat.format(this.context.cfg.gs("Main.remote.subscriber.failed.to.connect"), this.context.subscriberRepo.getLibraryData().libraries.description));
                    }
                    break block5;
                }
                throw new MungeException(this.context.publisherRepo == null ? this.context.cfg.gs("Main.publisher.library.or.collection.file.is.required.for.remote.publish") : this.context.cfg.gs("Main.subscriber.library.or.collection.file.is.required.for.remote.publish"));
            }
            catch (Exception e) {
                int opt;
                String msg = e.getMessage();
                this.logger.error(msg);
                this.context.clientStty = null;
                this.context.clientSftp = null;
                this.context.clientSftpMetadata = null;
                this.context.cfg.setOperation("-");
                if (this.isStartupActive() && promptOnFailure && (opt = JOptionPane.showConfirmDialog(this.context.guiLogAppender.getStartup(), "<html><body>" + msg + "<br/><br/>" + this.context.cfg.gs("Main.continue") + "</body></html>", this.context.cfg.getNavigatorName(), 0)) == 0) {
                    this.context.preferences.setLastSubscriberIsOpen(false);
                    this.context.fault = false;
                    return false;
                }
                this.catchExceptions = false;
                throw new MungeException(msg);
            }
        }
        return true;
    }

    public synchronized String decrypt(String key, byte[] encrypted) {
        String output = "";
        try {
            key = key.replaceAll("-", "");
            if (key.length() > 16) {
                key = key.substring(0, 16);
            }
            SecretKeySpec aesKey = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, aesKey);
            output = new String(cipher.doFinal(encrypted));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return output;
    }

    public synchronized byte[] encrypt(String key, String text) {
        byte[] encrypted = new byte[]{};
        if (text.length() > 0) {
            try {
                key = key.replaceAll("-", "");
                if (key.length() > 16) {
                    key = key.substring(0, 16);
                }
                SecretKeySpec aesKey = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
                Cipher cipher = Cipher.getInstance("AES");
                cipher.init(1, aesKey);
                encrypted = cipher.doFinal(text.getBytes("UTF-8"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return encrypted;
    }

    public boolean execExternalExe(final Component comp, final Configuration cfg, String[] parms) {
        block7: {
            Object cl = "";
            for (int i = 0; i < parms.length; ++i) {
                cl = (String)cl + parms[i] + " ";
            }
            final String cmdline = cl;
            try {
                final java.lang.Process proc = Runtime.getRuntime().exec(parms);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        try {
                            String line;
                            while ((line = input.readLine()) != null) {
                                System.out.println(line);
                            }
                            input.close();
                        }
                        catch (IOException e) {
                            Main.this.logger.error(cfg.gs("Z.process.failed") + cmdline + System.getProperty("line.separator") + Utils.getStackTrace(e));
                            if (comp != null) {
                                JOptionPane.showMessageDialog(comp, cfg.gs("Z.exception") + Utils.getStackTrace(e), cfg.getNavigatorName(), 0);
                            }
                            System.out.println(Utils.getStackTrace(e));
                        }
                    }
                };
                thread.start();
                int result = proc.waitFor();
                thread.join();
                if (result != 0) {
                    String message = cfg.gs("Z.process.failed") + result + ", : " + cmdline;
                    this.logger.error(message);
                    if (comp != null) {
                        JOptionPane.showMessageDialog(comp, message, cfg.getNavigatorName(), 0);
                    } else {
                        System.out.println(message);
                    }
                    break block7;
                }
                return true;
            }
            catch (Exception e) {
                String message = cfg.gs("Z.process.failed") + Utils.getStackTrace(e);
                this.logger.error(message);
                if (comp != null) {
                    JOptionPane.showMessageDialog(comp, message, cfg.getNavigatorName(), 0);
                }
                System.out.println(message);
            }
        }
        return false;
    }

    public boolean execUpdater(String updaterJar, boolean fromNavigator) {
        try {
            Object cmd = "";
            String[] parms = new String[]{Utils.getTempUpdaterDirectory() + System.getProperty("file.separator") + "rt" + System.getProperty("file.separator") + (Utils.isOsMac() ? "Contents/Home/" : "") + "bin" + System.getProperty("file.separator") + "java" + (Utils.isOsWindows() ? ".exe" : ""), "-jar", updaterJar, fromNavigator ? "" : "-Y"};
            for (int i = 0; i < parms.length; ++i) {
                cmd = (String)cmd + parms[i] + " ";
            }
            String logFile = Utils.getTempUpdaterDirectory() + System.getProperty("file.separator") + "ELS-Updater.log";
            String message = this.context.cfg.gs("Navigator.starting.els.updater") + (String)cmd;
            this.logger.info(message);
            if (this.context.navigator == null) {
                System.out.println(message);
            }
            if (this.context.navigator != null || Utils.isOsWindows()) {
                Runtime.getRuntime().exec(parms);
            } else {
                this.execExternalExe(null, this.context.cfg, parms);
            }
            if (this.context.navigator == null) {
                if (Utils.isOsWindows()) {
                    System.out.println(this.context.cfg.gs("Main.exiting.so.files"));
                }
                System.out.println(this.context.cfg.gs("Main.see.els.updater.log.at") + logFile);
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
            String message = this.context.cfg.gs("Navigator.error.launching.els.updater") + e.getMessage();
            if (this.context.navigator != null) {
                Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                JOptionPane.showOptionDialog(this.context.mainFrame, message, this.context.cfg.gs("Navigator.update"), -1, 0, null, opts, opts[0]);
            } else {
                System.err.println(message);
            }
            return false;
        }
        return true;
    }

    public void flushLogger() {
        if (this.context.rollingFileAppender != null) {
            ((RollingFileManager)this.context.rollingFileAppender.getManager()).flush();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignore) {
                this.logger.error("OOPS!");
            }
        }
    }

    public void getAppenders() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext(false);
        AbstractConfiguration loggerContextConfiguration = (AbstractConfiguration)loggerContext.getConfiguration();
        LoggerConfig loggerConfig = loggerContextConfiguration.getLoggerConfig("applog");
        Map<String, Appender> appenders = loggerConfig.getAppenders();
        this.context.guiLogAppender = (GuiLogAppender)appenders.get("GuiLogAppender");
        this.context.rollingFileAppender = (RollingFileAppender)appenders.get("applog");
    }

    public String getSystemKey() {
        String key = null;
        boolean writeNew = false;
        String fileName = System.getProperty("user.dir") + System.getProperty("file.separator") + "local" + System.getProperty("file.separator") + "els.key";
        File file = new File(fileName);
        if (file.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                    key = line;
                }
            }
            catch (IOException e) {
                writeNew = true;
            }
        } else {
            writeNew = true;
        }
        if (writeNew) {
            boolean gui = this.context.cfg.isNavigator() && this.context.navigator != null && !this.context.cfg.isCheckForUpdate() && !this.context.cfg.isInstallUpdate();
            UUID uuid = UUID.randomUUID();
            key = uuid.toString();
            try {
                BufferedWriter fw = new BufferedWriter(new FileWriter(fileName));
                String header = "# ELS System Key" + System.getProperty("line.separator");
                header = header + "# Auto-generated when ELS is first launched." + System.getProperty("line.separator");
                header = header + "# Used for encrypting passwords and tokens." + System.getProperty("line.separator");
                header = header + "# ***DO NOT*** change this key." + System.getProperty("line.separator");
                header = header + "#" + System.getProperty("line.separator");
                fw.write(header + System.getProperty("line.separator"));
                fw.write(key + System.getProperty("line.separator") + System.getProperty("line.separator"));
                fw.close();
            }
            catch (Exception e) {
                String message = this.context.cfg.gs("Main.error.writing.system.key") + Utils.getStackTrace(e);
                this.logger.error(message);
                if (gui) {
                    this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(this.context.mainFrame, message + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                }
                System.out.println(message);
            }
        }
        return key;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public boolean isStartupActive() {
        return this.context.guiLogAppender != null && this.context.guiLogAppender.isStartupActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void process(String[] args) {
        block116: {
            block112: {
                block113: {
                    ThreadGroup sessionThreads = null;
                    new Configuration(this.context);
                    MungeException cfgException2333333332 = null;
                    try {
                        this.context.cfg.parseCommandLine(args);
                    }
                    catch (MungeException e) {
                        cfgException2333333332 = e;
                    }
                    this.context.cfg.configureWorkingDirectory();
                    this.context.cfg.setOperation("");
                    if (this.primaryExecution) {
                        File delLog;
                        System.setProperty("jdk.lang.Process.launchMechanism", "POSIX_SPAWN");
                        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
                            System.setProperty("apple.laf.useScreenMenuBar", "true");
                            System.setProperty("apple.awt.application.name", "ELS");
                            System.setProperty("apple.awt.application.appearance", "system");
                        }
                        this.context.cfg.configureLoggerPath();
                        if (this.context.cfg.isLogOverwrite() && (delLog = new File(this.context.cfg.getLogFileFullPath())).exists()) {
                            delLog.delete();
                        }
                        System.setProperty("logFilename", this.context.cfg.getLogFileFullPath());
                        System.setProperty("consoleLevel", this.context.cfg.isCheckForUpdate() || this.context.cfg.isInstallUpdate() ? "OFF" : this.context.cfg.getConsoleLevel());
                        System.setProperty("debugLevel", this.context.cfg.getDebugLevel());
                        System.setProperty("pattern", this.context.cfg.getPattern());
                        LoggerContext loggerContext = (LoggerContext)LogManager.getContext(!this.primaryExecution);
                        loggerContext.reconfigure();
                        this.getAppenders();
                        this.context.guiLogAppender.setContext(this.context);
                        loggerContext.updateLoggers();
                    } else {
                        this.context.cfg.setConsoleLevel(this.context.previousContext.cfg.getConsoleLevel());
                        this.context.cfg.setDebugLevel(this.context.previousContext.cfg.getDebugLevel());
                        this.context.cfg.setLogFileName(this.context.previousContext.cfg.getLogFileName());
                        this.context.cfg.setLogFilePath(this.context.previousContext.cfg.getLogFilePath());
                        this.context.cfg.setLogFileFullPath(this.context.previousContext.cfg.getLogFileFullPath());
                        this.context.cfg.setLogOverwrite(this.context.previousContext.cfg.isLogOverwrite());
                        this.context.guiLogAppender.setContext(this.context);
                    }
                    this.logger = LogManager.getLogger("applog");
                    this.context.trace = this.context.cfg.getDebugLevel().trim().equalsIgnoreCase("trace");
                    Persistent.couldNotConnect = false;
                    this.context.preferences = new Preferences();
                    Utils.readPreferences(this.context);
                    this.context.preferences.setContext(this.context);
                    if (cfgException2333333332 != null) {
                        throw cfgException2333333332;
                    }
                    this.checkWorkingDirectories();
                    if (this.context.cfg.isCheckForUpdate() || this.context.cfg.isInstallUpdate()) {
                        this.logger.info("+------------------------------------------");
                        this.whatsRunning = "ELS: " + (this.context.cfg.isCheckForUpdate() ? this.context.cfg.gs("Main.check.for.update") : this.context.cfg.gs("Main.install.update"));
                        this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                        System.out.println(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                        this.context.cfg.dump();
                        boolean update = this.checkForUpdates(!this.context.cfg.isInstallUpdate());
                        System.exit(update ? 1 : 0);
                    }
                    this.checkEmptyArguments();
                    switch (this.context.cfg.getOperation()) {
                        case 0: {
                            if (this.context.cfg.isNavigator()) {
                                this.logger.info("+------------------------------------------");
                                this.whatsRunning = "ELS: Local Navigator";
                                this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                                this.context.cfg.dump();
                                if (this.context.cfg.getPublisherFilename().length() > 0) {
                                    this.context.publisherRepo = this.readRepo(this.context, 1, true);
                                }
                                if (this.context.cfg.getSubscriberFilename().length() > 0) {
                                    this.context.subscriberRepo = this.readRepo(this.context, 2, false);
                                }
                                this.context.tools = new Tools();
                                this.context.tools.loadAllTools(this.context, null);
                                this.connectHints(this.context.publisherRepo);
                                this.context.navigator = new Navigator(this.context);
                                if (this.context.fault) break;
                                this.context.navigator.run();
                                break;
                            }
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Local Publish";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            if (this.context.cfg.getPublisherFilename().length() <= 0) {
                                throw new MungeException(this.context.cfg.gs("Process.a.p.publisher.library.or.p.collection.file.is.required.for.local.publish"));
                            }
                            this.context.publisherRepo = this.readRepo(this.context, 1, true);
                            if (!this.context.cfg.isValidation() && this.context.cfg.getSubscriberFilename().length() > 0) {
                                this.context.subscriberRepo = this.readRepo(this.context, 2, false);
                            } else if (this.context.cfg.isTargetsEnabled()) {
                                this.context.subscriberRepo = this.context.publisherRepo;
                            }
                            this.connectHints(this.context.publisherRepo);
                            this.context.process = new Process(this.context);
                            this.context.process.process();
                            this.context.process = null;
                            break;
                        }
                        case 4: {
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Publisher Listener";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            this.context.publisherRepo = this.readRepo(this.context, 1, true);
                            this.context.subscriberRepo = this.readRepo(this.context, 2, false);
                            if (this.context.publisherRepo.isInitialized() && this.context.subscriberRepo.isInitialized()) {
                                if (this.context.cfg.isHintTrackingEnabled()) {
                                    this.context.cfg.disableHintTracking();
                                    this.logger.warn(this.context.cfg.gs("Main.hint.tracker.server.not.used.for.this.operation"));
                                }
                                this.connectHints(this.context.publisherRepo);
                                sessionThreads = new ThreadGroup("publisher.listener");
                                this.context.serveStty = new ServeStty(sessionThreads, 100, this.context, true);
                                this.context.serveStty.startListening(this.context.publisherRepo);
                                this.isListening = true;
                                this.context.serveSftp = new ServeSftp(this.context, this.context.publisherRepo, this.context.subscriberRepo, true);
                                this.context.serveSftp.startServer();
                                break;
                            }
                            throw new MungeException(this.context.cfg.gs("Main.a.publisher.library.p.or.collection.file.p.is.required.for"));
                        }
                        case 3: {
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Publisher Terminal";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            this.context.publisherRepo = this.readRepo(this.context, 1, true);
                            this.context.subscriberRepo = this.readRepo(this.context, 2, false);
                            if (!this.context.publisherRepo.isInitialized() || !this.context.subscriberRepo.isInitialized()) break;
                            if (this.context.cfg.isHintTrackingEnabled()) {
                                this.context.cfg.disableHintTracking();
                                this.logger.warn(this.context.cfg.gs("Main.hint.tracker.server.not.used.for.this.operation"));
                            }
                            this.connectHints(this.context.publisherRepo);
                            if (!this.connectSubscriber(true, false)) break;
                            String directory = this.context.clientStty.getWorkingDirectoryRemote();
                            this.context.cfg.setWorkingDirectorySubscriber(directory);
                            this.context.clientSftp = new ClientSftp(this.context, this.context.publisherRepo, this.context.subscriberRepo, true);
                            if (!this.context.clientSftp.startClient("transfer")) {
                                throw new MungeException(MessageFormat.format(this.context.cfg.gs("Main.publisher.sftp.transfer.client.to.failed.to.connect"), this.context.subscriberRepo.getLibraryData().libraries.description));
                            }
                            this.context.clientStty.terminalSession();
                            this.setListening(true);
                            break;
                        }
                        case 1: {
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = this.context.cfg.isNavigator() ? "ELS: Remote Navigator" : "ELS: Remote Publish";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            this.context.publisherRepo = this.readRepo(this.context, 1, true);
                            this.context.subscriberRepo = this.readRepo(this.context, 2, false);
                            if (this.context.cfg.isNavigator() || this.context.publisherRepo.isInitialized() && this.context.subscriberRepo.isInitialized()) {
                                boolean commOk = true;
                                this.connectHints(this.context.publisherRepo);
                                if (this.connectSubscriber(false, true)) {
                                    this.context.clientSftp = new ClientSftp(this.context, this.context.publisherRepo, this.context.subscriberRepo, true);
                                    if (!this.context.clientSftp.startClient("transfer")) {
                                        throw new MungeException(MessageFormat.format(this.context.cfg.gs("Main.subscriber.sftp.transfer.to.failed.to.connect"), this.context.subscriberRepo.getLibraryData().libraries.description));
                                    }
                                } else {
                                    commOk = false;
                                }
                                if (this.context.cfg.isNavigator()) {
                                    this.context.tools = new Tools();
                                    this.context.tools.loadAllTools(this.context, null);
                                    if (commOk) {
                                        this.context.clientSftpMetadata = new ClientSftp(this.context, this.context.publisherRepo, this.context.subscriberRepo, true);
                                        if (!this.context.clientSftpMetadata.startClient("metadata")) {
                                            throw new MungeException(MessageFormat.format(this.context.cfg.gs("Main.subscriber.sftp.metadata.to.failed.to.connect"), this.context.subscriberRepo.getLibraryData().libraries.description));
                                        }
                                    }
                                    this.context.navigator = new Navigator(this.context);
                                    if (this.context.fault) break;
                                    this.context.navigator.run();
                                    break;
                                }
                                if (!commOk) break;
                                this.context.process = new Process(this.context);
                                this.context.process.process();
                                this.context.process = null;
                                break;
                            }
                            throw new MungeException(this.context.cfg.gs("Main.publisher.and.subscriber.options.are.required.for"));
                        }
                        case 2: {
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Subscriber Listener";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            if (!this.context.cfg.isTargetsEnabled()) {
                                throw new MungeException(this.context.cfg.gs("Main.targets.required"));
                            }
                            if (this.context.cfg.getPublisherFilename().length() > 0) {
                                this.context.publisherRepo = this.readRepo(this.context, 1, false);
                            } else if (this.context.cfg.getAuthKeysFile() == null || this.context.cfg.getAuthKeysFile().isEmpty()) {
                                throw new MungeException(this.context.cfg.gs("Main.either.a.publisher.or.authentication.keys.file.is.required"));
                            }
                            this.context.subscriberRepo = this.readRepo(this.context, 2, true);
                            if (this.context.subscriberRepo.isInitialized() && (this.context.publisherRepo == null || this.context.publisherRepo.isInitialized())) {
                                if (this.context.cfg.isHintTrackingEnabled()) {
                                    this.context.cfg.disableHintTracking();
                                    this.logger.warn(this.context.cfg.gs("Main.hint.tracker.server.not.used.for.this.operation"));
                                }
                                this.connectHints(this.context.subscriberRepo);
                                sessionThreads = new ThreadGroup("subscriber.listener");
                                this.context.serveStty = new ServeStty(sessionThreads, 100, this.context, true);
                                this.context.serveStty.startListening(this.context.subscriberRepo);
                                this.isListening = true;
                                this.context.serveSftp = new ServeSftp(this.context, this.context.subscriberRepo, this.context.publisherRepo, true);
                                this.context.serveSftp.startServer();
                                break;
                            }
                            throw new MungeException(this.context.cfg.gs("Main.subscriber.and.publisher.or.authentication.options.are.required.for"));
                        }
                        case 5: {
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Subscriber Terminal";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            this.context.publisherRepo = this.readRepo(this.context, 1, false);
                            this.context.subscriberRepo = this.readRepo(this.context, 2, true);
                            if (this.context.subscriberRepo.isInitialized() && this.context.publisherRepo.isInitialized()) {
                                if (this.context.cfg.isHintTrackingEnabled()) {
                                    this.context.cfg.disableHintTracking();
                                    this.logger.warn(this.context.cfg.gs("Main.hint.tracker.server.not.used.for.this.operation"));
                                }
                                this.connectHints(this.context.subscriberRepo);
                                if (!this.connectSubscriber(true, false)) break;
                                String directory = this.context.clientStty.getWorkingDirectoryRemote();
                                this.context.cfg.setWorkingDirectorySubscriber(directory);
                                this.context.clientSftp = new ClientSftp(this.context, this.context.subscriberRepo, this.context.publisherRepo, true);
                                if (!this.context.clientSftp.startClient("transfer")) {
                                    throw new MungeException(MessageFormat.format(this.context.cfg.gs("Main.publisher.sftp.transfer.to.failed.to.connect"), this.context.publisherRepo.getLibraryData().libraries.description));
                                }
                                sessionThreads = new ThreadGroup("subscriber.terminal");
                                this.context.serveStty = new ServeStty(sessionThreads, 100, this.context, false);
                                this.context.serveStty.startListening(this.context.subscriberRepo);
                                this.isListening = true;
                                this.context.serveSftp = new ServeSftp(this.context, this.context.subscriberRepo, this.context.publisherRepo, false);
                                this.context.serveSftp.startServer();
                                this.context.clientStty.terminalSession();
                                this.setListening(true);
                                break;
                            }
                            throw new MungeException(this.context.cfg.gs("Main.a.subscriber.s.or.s.file.and.publisher.p.or.p.is.required.for.r.t"));
                        }
                        case 6: {
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Hint Status Server";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            if (this.context.cfg.getHintKeysFile() == null || this.context.cfg.getHintKeysFile().length() == 0) {
                                throw new MungeException(this.context.cfg.gs("Main.h.status.server.requires.a.k.k.hint.keys.file"));
                            }
                            if (this.context.cfg.getHintsDaemonFilename() == null || this.context.cfg.getHintsDaemonFilename().length() == 0) {
                                throw new MungeException(this.context.cfg.gs("Main.h.status.server.requires.hint.server.json.file"));
                            }
                            if (this.context.cfg.getAuthKeysFile() == null || this.context.cfg.getAuthKeysFile().length() == 0) {
                                throw new MungeException(this.context.cfg.gs("Main.h.status.server.requires.a.a.auth.keys.file"));
                            }
                            if (this.context.cfg.getPublisherFilename().length() > 0) {
                                throw new MungeException(this.context.cfg.gs("Main.h.status.server.does.not.use.p.p"));
                            }
                            if (this.context.cfg.getSubscriberFilename().length() > 0) {
                                throw new MungeException(this.context.cfg.gs("Main.h.status.server.does.not.use.s.s"));
                            }
                            if (this.context.cfg.isTargetsEnabled()) {
                                throw new MungeException(this.context.cfg.gs("Main.h.status.server.does.not.use.targets"));
                            }
                            this.context.hintKeys = new HintKeys(this.context);
                            this.context.hintKeys.read(this.context.cfg.getHintKeysFile());
                            this.context.hintsHandler = new Hints(this.context, this.context.hintKeys);
                            this.context.hintsRepo = new Repository(this.context, 3);
                            this.context.hintsRepo.read(this.context.cfg.getHintsDaemonFilename(), "Hint Status Server", true);
                            this.context.datastore = new Datastore(this.context);
                            boolean valid = this.context.datastore.initialize();
                            if (valid && this.context.hintsRepo.isInitialized()) {
                                sessionThreads = new ThreadGroup("hint.status.server");
                                this.context.serveStty = new ServeStty(sessionThreads, 100, this.context, true);
                                this.context.serveStty.startListening(this.context.hintsRepo);
                                this.isListening = true;
                                break;
                            }
                            throw new MungeException(this.context.cfg.gs("Main.h.error.initializing.from.hint.status.server.json.file"));
                        }
                        case 7: {
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Hint Status Server Quit";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            if (this.context.cfg.getPublisherFilename() == null || this.context.cfg.getPublisherFilename().length() == 0) {
                                throw new MungeException(this.context.cfg.gs("Main.q.force.quit.requires.a.p.p.publisher.to.connect.from"));
                            }
                            if (this.context.cfg.getHintsDaemonFilename() == null || this.context.cfg.getHintsDaemonFilename().length() == 0) {
                                throw new MungeException(this.context.cfg.gs("Main.q.force.quit.requires.h.hint.server"));
                            }
                            this.context.publisherRepo = this.readRepo(this.context, 1, false);
                            this.connectHints(this.context.publisherRepo);
                            if (!this.context.publisherRepo.isInitialized() || !this.context.hintsStty.isConnected()) break;
                            try {
                                this.context.hintsStty.send("stop", this.context.cfg.gs("Main.sending.stop.command.to.remote.hint.status.server"));
                                Thread.sleep(1500L);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 9: {
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Subscriber Listener Quit";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            if (this.context.cfg.getPublisherFilename() == null || this.context.cfg.getPublisherFilename().length() == 0) {
                                throw new MungeException(this.context.cfg.gs("Main.g.listener.quit.requires.a.p.p.publisher.to.connect.from"));
                            }
                            if (this.context.cfg.getSubscriberFilename() == null || this.context.cfg.getSubscriberFilename().length() == 0) {
                                throw new MungeException(this.context.cfg.gs("Main.g.listener.quit.requires.a.s.s.subscriber.json.file"));
                            }
                            this.context.publisherRepo = this.readRepo(this.context, 1, false);
                            this.context.subscriberRepo = this.readRepo(this.context, 2, false);
                            if (!this.context.publisherRepo.isInitialized() || !this.context.subscriberRepo.isInitialized() || !this.connectSubscriber(false, false)) break;
                            try {
                                this.context.clientStty.send("stop", this.context.cfg.gs("Main.sending.stop.command.to.remote.subscriber"));
                                Thread.sleep(1500L);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 8: {
                            Task task;
                            ArrayList<Task> tasks;
                            if (this.context.cfg.getPublisherFilename().length() > 0) {
                                this.context.publisherRepo = this.readRepo(this.context, 1, true);
                            }
                            if (this.context.cfg.getSubscriberFilename().length() > 0) {
                                this.context.subscriberRepo = this.readRepo(this.context, 2, false);
                            }
                            Job tmpJob = new Job(this.context, this.context.cfg.getJobName());
                            this.job = tmpJob.load(this.context.cfg.getJobName());
                            if (this.job == null) {
                                throw new MungeException(MessageFormat.format(this.context.cfg.gs("Main.job.could.not.be.loaded"), this.context.cfg.getJobName()));
                            }
                            this.context.tools = new Tools();
                            this.context.tools.loadAllTools(this.context, null);
                            if (!this.job.getTasks().isEmpty() && (tasks = this.job.getTasks()).size() > 0 && (task = tasks.get(0)).getInternalName().equals("Operations")) {
                                task.setContext(this.context);
                                AbstractTool tool = task.getTool();
                                if (tool instanceof OperationsTool && ((OperationsTool)tool).isOptNavigator()) {
                                    this.context.cfg.setNavigator(true);
                                    this.context.cfg.setLoggerView(false);
                                }
                            }
                            if (this.context.cfg.isLoggerView() && this.primaryExecution) {
                                this.logger.info(this.context.cfg.gs("Main.logger.display.mode"));
                                this.context.navigator = new Navigator(this.context);
                                if (this.context.fault) break;
                                this.context.navigator.run();
                                break;
                            }
                            this.logger.info("+------------------------------------------");
                            this.whatsRunning = "ELS: Job";
                            this.logger.info(this.whatsRunning + this.context.cfg.gs("Main.version") + Configuration.getBuildVersionName() + ", " + Configuration.getBuildDate());
                            this.context.cfg.dump();
                            this.connectHints(this.context.publisherRepo);
                            this.context.transfer = new Transfer(this.context);
                            this.context.transfer.initialize();
                            this.whatsRunning = this.whatsRunning + ", " + this.job.getConfigName();
                            this.job.process(this.context);
                            break;
                        }
                        default: {
                            throw new MungeException(this.context.cfg.gs("Main.unknown.operation"));
                        }
                    }
                    if (this.isListening || this.context.cfg.isNavigator()) break block112;
                    if (!this.context.fault || this.context.clientStty == null || !this.context.clientStty.isConnected() || this.context.timeout) break block113;
                    try {
                        this.context.clientStty.roundTrip("fault", this.context.cfg.gs("Main.sending.remote.fault.command.1"), 5000);
                    }
                    catch (Exception cfgException2333333332) {
                        // empty catch block
                    }
                }
                if (this.primaryExecution && !this.context.cfg.isLoggerView()) {
                    this.shutdown();
                }
                this.flushLogger();
                break block116;
            }
            if (!this.primaryExecution && !this.isListening && this.context.cfg.isNavigator()) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            Main.this.logger.trace(Main.this.context.cfg.gs("Main.navigator.shutdown.hook"));
                        }
                        catch (Exception e) {
                            Main.this.logger.error(Utils.getStackTrace(e));
                        }
                    }
                });
            } else if (this.isListening) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (Main.this.primaryExecution) {
                            Runtime.getRuntime().halt(Main.this.context.fault ? 1 : 0);
                        }
                    }
                });
                this.logger.trace(this.context.cfg.gs("Main.listener.shutdown.hook.added") + this.whatsRunning);
            }
            break block116;
            catch (Exception e222222222) {
                block114: {
                    block115: {
                        try {
                            if (this.primaryExecution) {
                                this.context.fault = true;
                            }
                            if (this.catchExceptions) {
                                if (this.logger != null) {
                                    this.logger.error(Utils.getStackTrace(e222222222));
                                }
                                if (this.context.cfg.isNavigator()) {
                                    Component centerOn = null;
                                    if (this.context.mainFrame != null) {
                                        centerOn = this.context.mainFrame;
                                    } else if (this.isStartupActive()) {
                                        centerOn = this.context.guiLogAppender.getStartup();
                                    }
                                    JOptionPane.showMessageDialog(centerOn, e222222222.getMessage(), this.context.cfg.getNavigatorName(), 0);
                                }
                            }
                            this.isListening = false;
                            if (this.isListening || this.context.cfg.isNavigator()) break block114;
                            if (!this.context.fault || this.context.clientStty == null || !this.context.clientStty.isConnected() || this.context.timeout) break block115;
                        }
                        catch (Throwable throwable) {
                            if (!this.isListening && !this.context.cfg.isNavigator()) {
                                if (this.context.fault && this.context.clientStty != null && this.context.clientStty.isConnected() && !this.context.timeout) {
                                    try {
                                        this.context.clientStty.roundTrip("fault", this.context.cfg.gs("Main.sending.remote.fault.command.1"), 5000);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (this.primaryExecution && !this.context.cfg.isLoggerView()) {
                                    this.shutdown();
                                }
                                this.flushLogger();
                            } else if (!this.primaryExecution && !this.isListening && this.context.cfg.isNavigator()) {
                                Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
                            } else if (this.isListening) {
                                Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
                                this.logger.trace(this.context.cfg.gs("Main.listener.shutdown.hook.added") + this.whatsRunning);
                            }
                            throw throwable;
                        }
                        try {
                            this.context.clientStty.roundTrip("fault", this.context.cfg.gs("Main.sending.remote.fault.command.1"), 5000);
                        }
                        catch (Exception e222222222) {
                            // empty catch block
                        }
                    }
                    if (this.primaryExecution && !this.context.cfg.isLoggerView()) {
                        this.shutdown();
                    }
                    this.flushLogger();
                }
                if (!this.primaryExecution && !this.isListening && this.context.cfg.isNavigator()) {
                    Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
                } else if (this.isListening) {
                    Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
                    this.logger.trace(this.context.cfg.gs("Main.listener.shutdown.hook.added") + this.whatsRunning);
                }
            }
        }
        if (!this.context.fault) {
            if (this.context.cfg.isNavigator() && (this.context.cfg.isUpdateSuccessful() || this.context.cfg.isUpdateFailed())) {
                try {
                    while (this.context.navigator == null || this.context.mainFrame == null || !this.context.mainFrame.isVisible()) {
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception e222222222) {
                    // empty catch block
                }
                String logFilename = Utils.getTempUpdaterDirectory() + System.getProperty("file.separator") + "ELS-Updater.log";
                String message = this.context.cfg.isUpdateSuccessful() ? "Corionis ELS : Entertainment Library Synchronizer " + this.context.cfg.gs("Navigator.updated") : MessageFormat.format(this.context.cfg.gs("Navigator.update.failed"), logFilename);
                this.logger.info(message);
                Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                JOptionPane.showOptionDialog(this.context.mainFrame, message, this.context.cfg.gs("Navigator.update.status"), -1, this.context.cfg.isUpdateSuccessful() ? 1 : 2, null, opts, opts[0]);
            } else if (this.context.cfg.isNavigator() && this.context.preferences.isShowGettingStarted()) {
                try {
                    while (this.context.navigator == null || this.context.mainFrame == null || !this.context.mainFrame.isVisible()) {
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception logFilename) {
                    // empty catch block
                }
                NavHelp dialog = new NavHelp(this.context.mainFrame, this.context.mainFrame, this.context, this.context.cfg.gs("Navigator.getting.started"), "gettingstarted_" + this.context.preferences.getLocale() + ".html", false);
                if (!dialog.fault) {
                    dialog.buttonFocus();
                }
            }
        }
        this.flushLogger();
        if (this.primaryExecution && this.context.fault) {
            this.logger.error(this.context.cfg.gs("Main.exiting.with.error.code"));
            Runtime.getRuntime().halt(1);
        }
    }

    public Repository readRepo(Context context, int purpose, boolean validate) throws Exception {
        Repository repo = new Repository(context, purpose);
        if (purpose == 1) {
            if (context.cfg.getPublisherLibrariesFileName().length() > 0 && context.cfg.getPublisherCollectionFilename().length() > 0) {
                throw new MungeException(context.cfg.gs("Main.cannot.use.both.p.and.p"));
            }
            if (context.cfg.getPublisherLibrariesFileName().length() == 0 && context.cfg.getPublisherCollectionFilename().length() == 0) {
                if (!context.cfg.isNavigator()) {
                    if (context.cfg.isRemoteOperation()) {
                        throw new MungeException(context.cfg.gs("Main.a.p.publisher.library.or.p.collection.file.is.required.for.r.p"));
                    }
                    throw new MungeException(context.cfg.gs("Main.a.p.publisher.library.or.p.collection.file.is.required.or.the.filename.missing.from.p.or.p"));
                }
                return null;
            }
            repo.read(context.cfg.getPublisherFilename(), "Publisher", true);
            context.preferences.setLastPublisherIsOpen(true);
        } else {
            if (context.cfg.getSubscriberLibrariesFileName().length() > 0 && context.cfg.getSubscriberCollectionFilename().length() > 0) {
                throw new MungeException(context.cfg.gs("Main.cannot.use.both.s.and.s"));
            }
            if (context.cfg.getSubscriberLibrariesFileName().length() == 0 && context.cfg.getSubscriberCollectionFilename().length() == 0 && !context.cfg.isNavigator()) {
                if (context.cfg.isRemoteOperation()) {
                    throw new MungeException(context.cfg.gs("Main.a.s.subscriber.library.or.s.collection.file.is.required.for.r.s"));
                }
                if (context.cfg.isPublishOperation()) {
                    throw new MungeException(context.cfg.gs("Main.a.s.subscriber.library.or.s.collection.file.is.required.or.the.filename.missing.for.s.or.s"));
                }
                return null;
            }
            repo.read(context.cfg.getSubscriberFilename(), "Subscriber", true);
            context.preferences.setLastSubscriberIsOpen(true);
        }
        if (validate && repo.isInitialized()) {
            repo.validate();
        }
        return repo;
    }

    public String readStream(DataInputStream in, String key) throws Exception {
        byte[] buf = new byte[]{};
        String input = "";
        try {
            this.logger.trace(this.context.cfg.gs("Main.read.waiting") + this.whatsRunning);
            int count = in.readInt();
            this.logger.trace(MessageFormat.format(this.context.cfg.gs("Main.receiving.encrypted.bytes"), count) + this.whatsRunning);
            int pos = 0;
            if (count > 0) {
                int readCount;
                buf = new byte[count];
                int remaining = count;
                while ((readCount = in.read(buf, pos, remaining)) >= 0) {
                    remaining -= readCount;
                    if ((pos += readCount) != count) continue;
                    break;
                }
                if (pos != count) {
                    this.logger.warn(MessageFormat.format(this.context.cfg.gs("Main.read.counts.do.not.match.expected.received"), count) + pos);
                }
            }
        }
        catch (SocketTimeoutException e) {
            this.logger.error(this.context.cfg.gs("Main.read.timed.out"));
            input = null;
            throw e;
        }
        catch (EOFException e) {
            this.logger.error(this.context.cfg.gs("Main.read.eof"));
            input = null;
        }
        catch (IOException e) {
            if (e.getMessage().toLowerCase().contains("connection reset")) {
                this.logger.warn(this.context.cfg.gs("Main.connection.closed.during.read"));
            }
            input = null;
            throw e;
        }
        if (buf.length > 0 && input != null) {
            input = this.decrypt(key, buf);
        }
        this.logger.trace(MessageFormat.format(this.context.cfg.gs("Main.read.done.choice.bytes"), input.length(), input != null ? 0 : 1) + this.whatsRunning);
        return input;
    }

    public void sendFaultEmail() {
        String toolName = "";
        if (Persistent.faultEmailSent) {
            return;
        }
        Persistent.faultEmailSent = true;
        toolName = this.context.cfg.getEmailServer().length() > 0 ? this.context.cfg.getEmailServer() : this.context.preferences.getDefaultEmailServer();
        if (toolName == null || toolName.length() == 0) {
            this.logger.warn(this.context.cfg.gs(this.context.cfg.gs("Main.cannot.send.fault.email")));
            return;
        }
        Tools emailTools = new Tools();
        try {
            emailTools.loadAllTools(this.context, "Email");
        }
        catch (Exception ex) {
            this.logger.error(Utils.getStackTrace(ex));
            return;
        }
        EmailTool tool = (EmailTool)emailTools.getTool("Email", toolName);
        if (tool != null) {
            EmailHandler emailHandler = new EmailHandler(this.context, null, tool, EmailHandler.Function.FAULT);
            emailHandler.start();
            try {
                while (emailHandler.isAlive()) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.logger.error(this.context.cfg.gs("Process.email.tool.not.found") + toolName);
        }
    }

    public void setListening(boolean listening) {
        Context prev = this.context;
        while (prev != null) {
            prev.main.isListening = listening;
            prev = prev.previousContext;
        }
    }

    public void shutdown() {
        try {
            if (this.context.fault && !this.context.cfg.isNavigator() && !Persistent.faultEmailSent) {
                this.sendFaultEmail();
            }
            this.logger.trace(this.context.cfg.gs("Main.shutdown.via.main"));
            if (this.context.main.job != null || this.context.previousContext != null && this.context.previousContext.main.job != null) {
                Job theJob = this.job != null ? this.job : this.context.previousContext.main.job;
                String msg = MessageFormat.format(this.context.cfg.gs(this.context.fault ? "Job.failed.job" : "Job.completed.job"), theJob.getConfigName() + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : ""));
                this.logger.info(msg);
                if (this.context.mainFrame != null) {
                    this.context.mainFrame.labelStatusMiddle.setText(msg);
                    this.context.navigator.setWorkerRunning(false);
                }
            }
            this.stopServices();
            this.stopVerbiage();
            this.flushLogger();
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
            this.flushLogger();
        }
    }

    private void stopServices() {
        this.logger.trace(MessageFormat.format(this.context.cfg.gs("Main.stopservices"), this.whatsRunning));
        try {
            if (this.context.hintsStty != null) {
                if (this.context.cfg.getOperation() != 7) {
                    if (this.context.cfg.isQuitStatusServer() && this.context.hintsStty.isConnected()) {
                        this.context.hintsStty.send("quit", this.context.cfg.gs("Process.sending.quit.command.to.remote.hint.status.server"));
                    } else if (this.context.hintsStty.isConnected()) {
                        this.context.hintsStty.send("bye", this.context.cfg.gs("Process.sending.bye.command.to.remote.hint.status.server"));
                    }
                    Thread.sleep(1500L);
                }
                this.context.hintsStty.disconnect();
                this.context.hintsStty = null;
            }
            if (this.context.clientSftp != null) {
                this.logger.trace(this.context.cfg.gs("Main.sftp.client"));
                this.context.clientSftp.stopClient();
                this.context.clientSftp = null;
                Thread.sleep(1500L);
            }
            if (this.context.clientSftpMetadata != null) {
                this.logger.trace(this.context.cfg.gs("Main.sftp.client.transfer"));
                this.context.clientSftpMetadata.stopClient();
                this.context.clientSftpMetadata = null;
                Thread.sleep(1500L);
            }
            if (this.context.serveSftp != null) {
                this.logger.trace(this.context.cfg.gs("Main.sftp.server"));
                this.context.serveSftp.stopServer();
                this.context.serveSftp = null;
            }
            if (this.context.clientStty != null) {
                this.logger.trace(this.context.cfg.gs("Main.stty.client"));
                this.context.clientStty.disconnect();
                this.context.clientStty = null;
            }
            if (this.context.serveStty != null) {
                this.logger.trace(this.context.cfg.gs("Main.stty.server"));
                this.context.serveStty.stopServer();
                this.context.serveStty = null;
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
        }
        this.isListening = false;
    }

    public void stopVerbiage() {
        Date done = new Date();
        long millis = Math.abs(done.getTime() - this.stamp.getTime());
        this.logger.fatal(MessageFormat.format(this.context.cfg.gs("Main.runtime"), Utils.getDuration(millis)));
        if (!this.context.fault) {
            this.logger.fatal(this.context.cfg.gs("Main.process.completed.normally"));
        } else {
            this.logger.fatal(this.context.cfg.gs("Main.process.failed.see") + this.context.cfg.getLogFileFullPath());
        }
        this.flushLogger();
    }

    public void writeStream(DataOutputStream out, String key, String message) throws Exception {
        this.logger.trace(MessageFormat.format(this.context.cfg.gs("Main.writing.bytes"), message.length()) + this.whatsRunning);
        byte[] buf = this.encrypt(key, message);
        this.logger.trace(MessageFormat.format(this.context.cfg.gs("Main.sending.encrypted.bytes"), buf.length) + this.whatsRunning);
        out.writeInt(buf.length);
        out.flush();
        out.write(buf);
        out.flush();
        this.logger.trace(this.context.cfg.gs("Main.write.done") + this.whatsRunning);
    }
}

