/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Transfer;
import com.corionis.els.Utils;
import com.corionis.els.repository.Item;
import com.corionis.els.repository.Library;
import com.corionis.els.tools.Tools;
import com.corionis.els.tools.email.EmailHandler;
import com.corionis.els.tools.email.EmailTool;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Process {
    private Marker SHORT = MarkerManager.getMarker("SHORT");
    private Marker SIMPLE = MarkerManager.getMarker("SIMPLE");
    private Context context;
    private String currentWhatsNew = "";
    private int differentSizes = 0;
    private int errorCount = 0;
    private boolean fault = false;
    private ArrayList<String> ignoredList = new ArrayList();
    private boolean isInitialized = false;
    private boolean justScannedPublisher = false;
    private PrintWriter mismatchesFile = null;
    private PrintWriter mismatchesFileHtml = null;
    private long totalDirectories = 0L;
    private long totalItems = 0L;
    private int warnings = 0;
    private PrintWriter whatsNewFile = null;
    private PrintWriter whatsNewFileHtml = null;
    private long whatsNewTotal = 0L;
    private transient Logger logger = LogManager.getLogger("applog");

    private Process() {
    }

    public Process(Context context) {
        this.context = context;
    }

    private void createOutputFiles(String filename, boolean isMismatches) throws MungeException {
        if (filename.length() > 0) {
            Object where = Utils.getFullPathLocal(filename);
            where = Utils.pipe((String)where);
            where = Utils.unpipe(this.context.publisherRepo, (String)where);
            try {
                if (isMismatches) {
                    this.mismatchesFile = new PrintWriter((String)where);
                } else {
                    this.whatsNewFile = new PrintWriter((String)where);
                }
                this.logger.info(this.context.cfg.gs("Process.writing.to.file") + (String)where);
                where = (String)where + ".html";
                if (isMismatches) {
                    this.mismatchesFileHtml = new PrintWriter((String)where);
                } else {
                    this.whatsNewFileHtml = new PrintWriter((String)where);
                }
                this.logger.info(this.context.cfg.gs("Process.writing.to.file") + (String)where);
            }
            catch (FileNotFoundException fnf) {
                this.fault = true;
                String s = this.context.cfg.gs("Process.file.not.found.exception.for.output.file") + (String)where;
                this.logger.error(s);
                throw new MungeException(s);
            }
        }
    }

    private void duplicatesCheck() throws Exception {
        if (this.context.cfg.getPublisherLibrariesFileName().length() > 0 && !this.justScannedPublisher) {
            this.context.publisherRepo.scan();
            this.justScannedPublisher = true;
        }
        this.totalDirectories = 0L;
        this.totalItems = 0L;
        for (Library pubLib : this.context.publisherRepo.getLibraryData().libraries.bibliography) {
            this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.analyzing.library.for.duplicates"), pubLib.name));
            for (Item item : pubLib.items) {
                if (item.isDirectory()) {
                    ++this.totalDirectories;
                } else {
                    ++this.totalItems;
                }
                this.context.publisherRepo.hasPublisherDuplicate(item, Utils.pipe(this.context.publisherRepo, item.getItemPath()));
            }
        }
        this.reportIgnored();
        int duplicates = 0;
        for (Library pubLib : this.context.publisherRepo.getLibraryData().libraries.bibliography) {
            for (Item item : pubLib.items) {
                if (item.getHas().size() <= 0) continue;
                duplicates = this.reportDuplicates("Publisher", item, duplicates);
            }
        }
        int empties = 0;
        for (Library library : this.context.publisherRepo.getLibraryData().libraries.bibliography) {
            for (Item item : library.items) {
                if (!item.isDirectory() || item.getSize() != 0L) continue;
                empties = this.reportEmpties("Publisher", item, empties);
            }
        }
        this.logger.info(this.SIMPLE, this.context.cfg.gs("Process.total.files") + this.totalItems);
        this.logger.info(this.SIMPLE, this.context.cfg.gs("Process.total.directories") + this.totalDirectories);
        this.logger.info(this.SIMPLE, this.context.cfg.gs("Process.total.items") + (this.totalItems + this.totalDirectories));
        this.logger.info(this.SIMPLE, this.context.cfg.gs("Process.total.duplicates") + duplicates);
        this.logger.info(this.SIMPLE, this.context.cfg.gs("Process.total.empty.directories") + empties);
    }

    private void exportCollection() throws Exception {
        if (this.context.cfg.getPublisherLibrariesFileName().length() > 0 && !this.justScannedPublisher) {
            this.context.publisherRepo.scan();
            this.justScannedPublisher = true;
        }
        this.context.publisherRepo.exportItems(true);
    }

    private void exportText() throws Exception {
        if (this.context.cfg.getPublisherLibrariesFileName().length() > 0 && !this.justScannedPublisher) {
            this.context.publisherRepo.scan();
            this.justScannedPublisher = true;
        }
        this.context.publisherRepo.exportText();
    }

    public int getWarnings() {
        return this.warnings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void munge() throws Exception {
        String currLibWhat;
        block58: {
            String currLibMismatch = "";
            currLibWhat = "";
            ArrayList<Item> group = new ArrayList<Item>();
            long totalSize = 0L;
            String intro = this.context.cfg.gs("Process.munging.back.up") + this.context.publisherRepo.getLibraryData().libraries.description + this.context.cfg.gs("Process.to") + this.context.subscriberRepo.getLibraryData().libraries.description + (this.context.cfg.isDryRun() ? " (--dry-run)" : "");
            if (this.mismatchesFile != null) {
                this.mismatchesFile.println(this.context.cfg.gs("Process.mismatches") + "\n\n" + intro);
                this.mismatchesFile.println("");
                this.mismatchesFileHtml.println("<h3>" + this.context.cfg.gs("Process.mismatches") + "</h3>\n" + intro);
                this.mismatchesFileHtml.println("<br/><br/>");
            }
            if (this.whatsNewFile != null) {
                this.whatsNewFile.println(this.context.cfg.gs("Process.whats.new") + "\n\n" + intro);
                this.whatsNewFile.println("");
                this.whatsNewFileHtml.println("<h3>" + this.context.cfg.gs("Process.whats.new") + "</h3>\n" + intro);
                this.whatsNewFileHtml.println("<br/><br/>");
            }
            boolean rescan = false;
            for (Library subLib : this.context.subscriberRepo.getLibraryData().libraries.bibliography) {
                if (!subLib.rescanNeeded) continue;
                rescan = true;
                break;
            }
            if (rescan) {
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.hints.executed.on.subscriber.updated.data.required"), this.context.subscriberRepo.getLibraryData().libraries.description));
                if (this.context.cfg.isRemoteSubscriber()) {
                    this.context.transfer.requestCollection();
                }
            }
            this.logger.info(intro);
            boolean firstLibraryMismatch = true;
            boolean firstLibraryWhats = true;
            try {
                block9: for (Library subLib : this.context.subscriberRepo.getLibraryData().libraries.bibliography) {
                    if (this.fault) break;
                    Library pubLib = null;
                    if (!(this.context.cfg.isSpecificLibrary() && !this.context.cfg.isSelectedLibrary(subLib.name) || this.context.cfg.isSpecificExclude() && this.context.cfg.isExcludedLibrary(subLib.name))) {
                        if (subLib.name.startsWith(this.context.subscriberRepo.SUB_EXCLUDE)) {
                            Iterator<Item> n = subLib.name.replaceFirst(this.context.subscriberRepo.SUB_EXCLUDE, "");
                            this.logger.info(this.context.cfg.gs("Process.skipping.subscriber.library") + (String)((Object)n));
                            continue;
                        }
                        pubLib = this.context.publisherRepo.getLibrary(subLib.name);
                        if (pubLib != null) {
                            if (pubLib.items == null || pubLib.items.size() < 1 || pubLib.rescanNeeded) {
                                this.context.publisherRepo.scan(pubLib.name);
                            }
                            if (subLib.items == null || subLib.items.size() < 1 || subLib.rescanNeeded) {
                                this.context.subscriberRepo.scan(subLib.name);
                            }
                            this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.munge.publisher.items.with.subscriber.items"), subLib.name, pubLib.items.size(), subLib.items.size(), subLib.items != null ? 0 : 1));
                            for (Item item : pubLib.items) {
                                if (this.fault) continue block9;
                                if (this.context.publisherRepo.ignore(item)) {
                                    this.logger.debug(this.context.cfg.gs("Process.ignoring") + item.getItemPath());
                                    this.ignoredList.add(item.getFullPath());
                                    continue;
                                }
                                if (!item.isDirectory()) {
                                    boolean diffDates = false;
                                    ++this.totalItems;
                                    Item has = this.context.subscriberRepo.hasItem(item, item.getLibrary(), Utils.pipe(this.context.publisherRepo, item.getItemPath()));
                                    if (has != null && item.getHas().size() == 1) {
                                        if (subLib.matchDates && item.getModifiedDate().compareTo(has.getModifiedDate()) > 0) {
                                            diffDates = true;
                                            has = null;
                                        } else if (item.getSize() != has.getSize()) {
                                            this.logger.warn(MessageFormat.format(this.context.cfg.gs("Process.subscriber.has.different.size"), subLib.name, item.getItemPath()));
                                            ++this.differentSizes;
                                        } else {
                                            this.logger.debug(MessageFormat.format(this.context.cfg.gs("Process.subscriber.has"), subLib.name, item.getItemPath()));
                                        }
                                    }
                                    if (has != null) continue;
                                    if (diffDates) {
                                        this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.subscriber.out.of.date"), subLib.name, item.getItemPath()));
                                    } else {
                                        this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.subscriber.missing"), subLib.name, item.getItemPath()));
                                    }
                                    if (this.context.transfer.isNewGrouping(item)) {
                                        this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.switching.groups.from.to"), this.context.transfer.getLastGroupName(), this.context.transfer.getCurrentGroupName()));
                                        this.context.transfer.copyGroup(group, totalSize, this.context.cfg.isOverwrite(), this.whatsNewFile, this.whatsNewFileHtml, this.mismatchesFile, this.mismatchesFileHtml);
                                        totalSize = 0L;
                                        if (this.mismatchesFile != null && !item.getLibrary().equals(currLibWhat)) {
                                            currLibMismatch = item.getLibrary();
                                            if (!firstLibraryMismatch) {
                                                this.mismatchesFile.println("");
                                            }
                                            this.mismatchesFile.println(currLibMismatch);
                                            if (!firstLibraryMismatch) {
                                                this.mismatchesFileHtml.println("</span><br/>");
                                            }
                                            this.mismatchesFileHtml.println("<span style=\"font-family: Arial, Helvetica, sans-serif;\"><b>" + currLibMismatch + "</b><br/>");
                                            this.mismatchesFileHtml.println("</span><span style=\"font-family: monospace; font-size: 110%;\">");
                                            firstLibraryMismatch = false;
                                        }
                                        if (this.whatsNewFile != null) {
                                            if (!item.getLibrary().equals(currLibWhat)) {
                                                if (!currLibWhat.equals("")) {
                                                    this.whatsNewFile.println("    ------------------------------------------");
                                                    this.whatsNewFile.println(MessageFormat.format(this.context.cfg.gs("Process.total.for"), currLibWhat, this.whatsNewTotal));
                                                    this.whatsNewFile.println("");
                                                    this.whatsNewFileHtml.println("</span><span style=\"font-family: Arial, Helvetica, sans-serif;\">");
                                                    this.whatsNewFileHtml.println("<hr style=\"margin-left: 30px; margin-right: auto; width: 50%;\">");
                                                    this.whatsNewFileHtml.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(this.context.cfg.gs("Process.total.for"), currLibWhat, this.whatsNewTotal));
                                                    this.whatsNewFileHtml.println("<br/><br/>");
                                                    this.whatsNewTotal = 0L;
                                                }
                                                currLibWhat = item.getLibrary();
                                                this.whatsNewFile.println(currLibWhat);
                                                this.whatsNewFileHtml.println("<b>" + currLibWhat + "</b><br/>");
                                                if (firstLibraryWhats) {
                                                    this.whatsNewFileHtml.println("<span style=\"font-family: monospace; font-size: 110%;\">");
                                                } else {
                                                    this.whatsNewFileHtml.println("</span><span style=\"font-family: monospace; font-size: 110%;\">");
                                                }
                                                firstLibraryWhats = false;
                                            }
                                            String path = Utils.getLastPath(item.getItemPath(), this.context.publisherRepo.getSeparator());
                                            if (this.context.cfg.isWhatsNewAll() || !this.currentWhatsNew.equalsIgnoreCase(path)) {
                                                this.whatsNewFile.println("    " + (this.context.cfg.isWhatsNewAll() ? item.getItemPath() : path));
                                                this.whatsNewFileHtml.println("&nbsp;&nbsp;&nbsp;&nbsp;" + (this.context.cfg.isWhatsNewAll() ? item.getItemPath() : path) + "<br/>");
                                                this.currentWhatsNew = path;
                                                ++this.whatsNewTotal;
                                            }
                                        }
                                        if (this.whatsNewFile != null) {
                                            this.whatsNewFile.flush();
                                            this.whatsNewFileHtml.flush();
                                        }
                                        if (this.mismatchesFile != null) {
                                            this.mismatchesFile.flush();
                                            this.mismatchesFileHtml.flush();
                                        }
                                    }
                                    totalSize += item.getSize();
                                    group.add(item);
                                    if (this.context.cfg.isDryRun()) continue;
                                    subLib.rescanNeeded = true;
                                    continue;
                                }
                                ++this.totalDirectories;
                            }
                            continue;
                        }
                        this.logger.warn(MessageFormat.format(this.context.cfg.gs("Process.subscribed.publisher.library.not.found"), subLib.name));
                        ++this.warnings;
                        continue;
                    }
                    this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.skipping.publisher.library"), subLib.name));
                }
                if (this.fault || group.size() <= 0) break block58;
            }
            catch (Exception e) {
                try {
                    this.fault = true;
                    ++this.errorCount;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!this.fault && group.size() > 0) {
                        try {
                            this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.processing.last.group"), this.context.transfer.getCurrentGroupName()));
                            this.context.transfer.copyGroup(group, totalSize, this.context.cfg.isOverwrite(), this.whatsNewFile, this.whatsNewFileHtml, this.mismatchesFile, this.mismatchesFileHtml);
                        }
                        catch (Exception e2) {
                            this.fault = true;
                            ++this.errorCount;
                            throw e2;
                        }
                        totalSize = 0L;
                    }
                    if (this.mismatchesFile != null) {
                        this.mismatchesFile.println("------------------------------------------");
                        if (this.getWarnings() > 0) {
                            this.mismatchesFile.println(MessageFormat.format(this.context.cfg.gs("Process.warnings"), this.getWarnings()));
                        }
                        if (this.errorCount > 0) {
                            this.mismatchesFile.println(MessageFormat.format(this.context.cfg.gs("Process.errors"), this.errorCount));
                        }
                        this.mismatchesFile.println(this.context.cfg.gs("Process.total.items") + this.context.transfer.getGrandTotalItems());
                        this.mismatchesFile.println(this.context.cfg.gs("Process.total.size") + Utils.formatLong(this.context.transfer.getGrandTotalSize(), true, this.context.cfg.getLongScale()));
                        this.mismatchesFile.println("\n");
                        this.mismatchesFile.println("------- " + this.context.cfg.gs("Email.do.not.reply") + " -------\n");
                        this.mismatchesFile.close();
                        this.mismatchesFileHtml.println("</span><span style=\"font-family: Arial, Helvetica, sans-serif;\">");
                        this.mismatchesFileHtml.println("<hr style=\"margin-left: 0; margin-right: auto; width: 50%;\">");
                        if (this.getWarnings() > 0) {
                            this.mismatchesFileHtml.println(MessageFormat.format(this.context.cfg.gs("Process.warnings"), this.getWarnings()) + "<br/>");
                        }
                        if (this.errorCount > 0) {
                            this.mismatchesFileHtml.println(MessageFormat.format(this.context.cfg.gs("Process.errors"), this.errorCount) + "<br/>");
                        }
                        this.mismatchesFileHtml.println(this.context.cfg.gs("Process.total.items") + this.context.transfer.getGrandTotalItems() + "<br/>");
                        this.mismatchesFileHtml.println(this.context.cfg.gs("Process.total.size") + Utils.formatLong(this.context.transfer.getGrandTotalSize(), true, this.context.cfg.getLongScale()) + "<br/>");
                        this.mismatchesFileHtml.println("</span>");
                        this.mismatchesFileHtml.println("<br/><br/>------- " + this.context.cfg.gs("Email.do.not.reply") + " -------<br/><br/>");
                        this.mismatchesFileHtml.println("</body></html>");
                        this.mismatchesFileHtml.close();
                    }
                    if (this.whatsNewFile != null) {
                        this.whatsNewFile.println("    ------------------------------------------");
                        this.whatsNewFile.println(MessageFormat.format(this.context.cfg.gs("Process.total.for"), currLibWhat, this.whatsNewTotal));
                        this.whatsNewFile.println("\n");
                        this.whatsNewFile.println("------- " + this.context.cfg.gs("Email.do.not.reply") + " -------\n");
                        this.whatsNewFile.close();
                        this.whatsNewFileHtml.println("</span><span style=\"font-family: Arial, Helvetica, sans-serif;\">");
                        this.whatsNewFileHtml.println("<hr style=\"margin-left: 30px; margin-right: auto; width: 50%;\">");
                        this.whatsNewFileHtml.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(this.context.cfg.gs("Process.total.for"), currLibWhat, this.whatsNewTotal));
                        this.whatsNewFileHtml.println("</span>");
                        this.whatsNewFileHtml.println("<br/><br/><br/>------- " + this.context.cfg.gs("Email.do.not.reply") + " -------<br/><br/>");
                        this.whatsNewFileHtml.println("</body></html>");
                        this.whatsNewFileHtml.close();
                    }
                    throw throwable;
                }
            }
            try {
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Process.processing.last.group"), this.context.transfer.getCurrentGroupName()));
                this.context.transfer.copyGroup(group, totalSize, this.context.cfg.isOverwrite(), this.whatsNewFile, this.whatsNewFileHtml, this.mismatchesFile, this.mismatchesFileHtml);
            }
            catch (Exception e) {
                this.fault = true;
                ++this.errorCount;
                throw e;
            }
            totalSize = 0L;
        }
        if (this.mismatchesFile != null) {
            this.mismatchesFile.println("------------------------------------------");
            if (this.getWarnings() > 0) {
                this.mismatchesFile.println(MessageFormat.format(this.context.cfg.gs("Process.warnings"), this.getWarnings()));
            }
            if (this.errorCount > 0) {
                this.mismatchesFile.println(MessageFormat.format(this.context.cfg.gs("Process.errors"), this.errorCount));
            }
            this.mismatchesFile.println(this.context.cfg.gs("Process.total.items") + this.context.transfer.getGrandTotalItems());
            this.mismatchesFile.println(this.context.cfg.gs("Process.total.size") + Utils.formatLong(this.context.transfer.getGrandTotalSize(), true, this.context.cfg.getLongScale()));
            this.mismatchesFile.println("\n");
            this.mismatchesFile.println("------- " + this.context.cfg.gs("Email.do.not.reply") + " -------\n");
            this.mismatchesFile.close();
            this.mismatchesFileHtml.println("</span><span style=\"font-family: Arial, Helvetica, sans-serif;\">");
            this.mismatchesFileHtml.println("<hr style=\"margin-left: 0; margin-right: auto; width: 50%;\">");
            if (this.getWarnings() > 0) {
                this.mismatchesFileHtml.println(MessageFormat.format(this.context.cfg.gs("Process.warnings"), this.getWarnings()) + "<br/>");
            }
            if (this.errorCount > 0) {
                this.mismatchesFileHtml.println(MessageFormat.format(this.context.cfg.gs("Process.errors"), this.errorCount) + "<br/>");
            }
            this.mismatchesFileHtml.println(this.context.cfg.gs("Process.total.items") + this.context.transfer.getGrandTotalItems() + "<br/>");
            this.mismatchesFileHtml.println(this.context.cfg.gs("Process.total.size") + Utils.formatLong(this.context.transfer.getGrandTotalSize(), true, this.context.cfg.getLongScale()) + "<br/>");
            this.mismatchesFileHtml.println("</span>");
            this.mismatchesFileHtml.println("<br/><br/>------- " + this.context.cfg.gs("Email.do.not.reply") + " -------<br/><br/>");
            this.mismatchesFileHtml.println("</body></html>");
            this.mismatchesFileHtml.close();
        }
        if (this.whatsNewFile != null) {
            this.whatsNewFile.println("    ------------------------------------------");
            this.whatsNewFile.println(MessageFormat.format(this.context.cfg.gs("Process.total.for"), currLibWhat, this.whatsNewTotal));
            this.whatsNewFile.println("\n");
            this.whatsNewFile.println("------- " + this.context.cfg.gs("Email.do.not.reply") + " -------\n");
            this.whatsNewFile.close();
            this.whatsNewFileHtml.println("</span><span style=\"font-family: Arial, Helvetica, sans-serif;\">");
            this.whatsNewFileHtml.println("<hr style=\"margin-left: 30px; margin-right: auto; width: 50%;\">");
            this.whatsNewFileHtml.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(this.context.cfg.gs("Process.total.for"), currLibWhat, this.whatsNewTotal));
            this.whatsNewFileHtml.println("</span>");
            this.whatsNewFileHtml.println("<br/><br/><br/>------- " + this.context.cfg.gs("Email.do.not.reply") + " -------<br/><br/>");
            this.whatsNewFileHtml.println("</body></html>");
            this.whatsNewFileHtml.close();
        }
        this.reportIgnored();
        int duplicates = 0;
        for (Library pubLib : this.context.publisherRepo.getLibraryData().libraries.bibliography) {
            if (pubLib.items == null) continue;
            for (Item item : pubLib.items) {
                if (item.getHas().size() <= 1) continue;
                duplicates = this.reportDuplicates("Subscriber", item, duplicates);
            }
        }
        int empties = 0;
        for (Library subLib : this.context.subscriberRepo.getLibraryData().libraries.bibliography) {
            if (subLib.items == null) continue;
            for (Item item : subLib.items) {
                if (!item.isDirectory() || item.getSize() != 0L) continue;
                empties = this.reportEmpties("Subscriber", item, empties);
            }
        }
        this.logger.info(this.SHORT, "+------------------------------------------");
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.different.sizes") + this.differentSizes);
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.duplicates") + duplicates);
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.empty.directories") + empties);
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.ignored.files") + this.ignoredList.size());
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.directories") + this.totalDirectories);
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.files") + this.totalItems);
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.copies") + this.context.transfer.getCopyCount() + (String)(!this.context.cfg.isDryRun() && this.context.transfer.getCopyCount() > 0 ? ", " + this.context.transfer.getGrandTotalOriginalLocation() + " of which went to original locations" : "") + (this.context.cfg.isDryRun() ? " (--dry-run)" : ""));
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.warnings.fin") + this.getWarnings());
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.errors.fin") + this.errorCount);
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.items.processed") + this.context.transfer.getGrandTotalItems());
        this.logger.info(this.SHORT, this.context.cfg.gs("Process.total.size.fin") + Utils.formatLong(this.context.transfer.getGrandTotalSize(), true, this.context.cfg.getLongScale()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        boolean lined = false;
        boolean localHints = false;
        String result = "";
        try {
            if (!this.isInitialized) {
                this.context.transfer = new Transfer(this.context);
                this.context.transfer.initialize();
                this.isInitialized = true;
            }
            Object hostname = "";
            try {
                hostname = " (" + InetAddress.getLocalHost().getHostName() + ")";
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            String from = this.context.publisherRepo.getLibraryData().libraries.description + (String)hostname;
            if (this.context.cfg.getMismatchFilename().length() > 0) {
                this.createOutputFiles(this.context.cfg.getMismatchFilename(), true);
                this.mismatchesFile.println("Automated email from: " + from);
                this.mismatchesFile.println("------------------------------------------\n");
                this.mismatchesFileHtml.println("<!DOCTYPE html><html><body style=\"font-family: Arial, Helvetica, sans-serif;font-size: 100%;\">");
                this.mismatchesFileHtml.println("<div><img src='https://www.elsnavigator.com/assets/images/els-logo-64px.png' style=\"vertical-align: middle;\"/>");
                this.mismatchesFileHtml.println("<span style=\"font-family: Arial, Helvetica, sans-serif;font-size: 120%;vertical-align: middle;\">");
                this.mismatchesFileHtml.println("<b>&nbsp;&nbsp;Automated email from: " + from + "</b></span></div>");
                this.mismatchesFileHtml.println("<hr/>");
            }
            if (this.context.cfg.getWhatsNewFilename().length() > 0) {
                this.createOutputFiles(this.context.cfg.getWhatsNewFilename(), false);
                this.whatsNewFile.println("Automated email from: " + from);
                this.whatsNewFile.println("------------------------------------------\n");
                this.whatsNewFileHtml.println("<!DOCTYPE html><html><body style=\"font-family: Arial, Helvetica, sans-serif;font-size: 100%;\">");
                this.whatsNewFileHtml.println("<div><img src='https://www.elsnavigator.com/assets/images/els-logo-64px.png' style=\"vertical-align: middle;\"/>");
                this.whatsNewFileHtml.println("<span style=\"font-family: Arial, Helvetica, sans-serif;font-size: 120%;vertical-align: middle;\">");
                this.whatsNewFileHtml.println("<b>&nbsp;&nbsp;Automated email from: " + from + "</b></span></div>");
                this.whatsNewFileHtml.println("<hr/>");
            }
            if (this.context.hintsHandler != null && this.context.cfg.isTargetsEnabled() && !this.context.cfg.isRemoteOperation() && (this.context.cfg.getPublisherLibrariesFileName().length() > 0 || this.context.cfg.getPublisherCollectionFilename().length() > 0) && this.context.cfg.getSubscriberLibrariesFileName().length() == 0 && this.context.cfg.getSubscriberCollectionFilename().length() == 0) {
                localHints = true;
                result = this.context.hintsHandler.hintsMunge(true, null, null);
            }
            if (this.context.cfg.getExportTextFilename().length() > 0) {
                this.exportText();
            }
            if (this.context.cfg.getExportCollectionFilename().length() > 0) {
                this.exportCollection();
            }
            if (this.context.cfg.isDuplicateCheck() || this.context.cfg.isEmptyDirectoryCheck()) {
                this.duplicatesCheck();
            }
            if (this.context.cfg.isHintTrackingEnabled() && this.context.cfg.isTargetsEnabled() && this.context.cfg.getPublisherFilename().length() > 0 && this.context.cfg.getSubscriberFilename().length() > 0) {
                result = this.context.hintsHandler.hintsMunge(false, this.mismatchesFile, this.mismatchesFileHtml);
            }
            if (!(result.toLowerCase().equals("fault") || this.context.fault || localHints || this.context.cfg.isHintSkipMainProcess())) {
                if (this.context.cfg.isTargetsEnabled() && this.context.cfg.getPublisherFilename().length() > 0 && this.context.cfg.getSubscriberFilename().length() > 0) {
                    this.munge();
                } else if (!(this.context.cfg.isDuplicateCheck() || this.context.cfg.isEmptyDirectoryCheck() || this.context.cfg.isValidation() || this.context.cfg.getPublisherFilename().isEmpty() || this.context.cfg.getSubscriberFilename().isEmpty())) {
                    this.logger.warn(this.context.cfg.gs("Process.something.missing.make.sure"));
                }
            }
        }
        catch (Exception ex) {
            this.fault = true;
            ++this.errorCount;
            this.logger.error(Utils.getStackTrace(ex));
        }
        finally {
            if (this.logger != null) {
                if (!lined) {
                    this.logger.info(this.SHORT, "-------------------------------------------");
                }
                if (this.context.cfg.isHintSkipMainProcess() && !localHints) {
                    this.logger.info(this.context.cfg.gs("Process.skipping.main.process"));
                }
            }
            if (this.context.clientStty != null) {
                try {
                    if (!this.context.cfg.isKeepGoing()) {
                        this.context.clientStty.send("quit", this.context.cfg.gs("Process.sending.quit.command.to.remote.subscriber"));
                    } else {
                        this.context.clientStty.send("bye", this.context.cfg.gs("Process.sending.bye.command.to.remote.subscriber"));
                    }
                    Thread.sleep(1500L);
                }
                catch (Exception exception) {}
            }
            if (this.context.hintsStty != null) {
                try {
                    if (this.context.cfg.isQuitStatusServer()) {
                        this.context.hintsStty.send("quit", this.context.cfg.gs("Process.sending.quit.command.to.remote.hint.status.server"));
                    } else {
                        this.context.hintsStty.send("bye", this.context.cfg.gs("Process.sending.bye.command.to.remote.hint.status.server"));
                    }
                    Thread.sleep(1500L);
                    this.context.hintsStty.disconnect();
                    this.context.hintsStty = null;
                }
                catch (Exception exception) {}
            }
        }
        this.context.fault = this.fault;
        if (!(this.fault || this.context.transfer.getGrandTotalItems() <= 0L && this.context.hintsHandler.getPerformed() <= 0 || this.mismatchesFile == null && this.whatsNewFile == null)) {
            this.sendCompletionEmail();
        }
    }

    private int reportDuplicates(String type, Item item, int duplicates) {
        for (Item dupe : item.getHas()) {
            if (dupe.isReported()) continue;
            if (duplicates == 0 && this.context.cfg.isDuplicateCheck()) {
                this.logger.debug(this.SIMPLE, "+------------------------------------------");
                this.logger.debug(this.SIMPLE, type + this.context.cfg.gs("Process.duplicate.filenames.found"));
            }
            ++duplicates;
            if (this.context.cfg.isDuplicateCheck()) {
                this.logger.debug(this.SIMPLE, "  " + dupe.getFullPath());
            }
            dupe.setReported(true);
        }
        return duplicates;
    }

    private int reportEmpties(String type, Item item, int empties) {
        if (empties == 0 && this.context.cfg.isEmptyDirectoryCheck()) {
            this.logger.debug(this.SIMPLE, "+------------------------------------------");
            this.logger.debug(this.SIMPLE, type + this.context.cfg.gs("Process.empty.directories.found"));
        }
        ++empties;
        if (this.context.cfg.isEmptyDirectoryCheck()) {
            this.logger.debug(this.SIMPLE, "  " + item.getFullPath());
        }
        return empties;
    }

    public void sendCompletionEmail() {
        String toolName = "";
        if (this.context.cfg.getEmailServer().length() > 0) {
            toolName = this.context.cfg.getEmailServer();
        }
        if (toolName == null || toolName.length() == 0) {
            String msg = this.context.cfg.gs(this.context.cfg.gs(this.context.cfg.gs("Process.cannot.send.completion.email")));
            this.logger.warn(msg);
            return;
        }
        Tools emailTools = new Tools();
        try {
            emailTools.loadAllTools(this.context, "Email");
        }
        catch (Exception ex) {
            this.logger.error(Utils.getStackTrace(ex));
            return;
        }
        EmailTool tool = (EmailTool)emailTools.getTool("Email", toolName);
        if (tool != null) {
            int opt;
            if ((this.context.navigator != null || this.context.cfg.isLoggerView()) && this.context.preferences.isAskSendEmail() && (opt = JOptionPane.showConfirmDialog(this.context.mainFrame, this.context.cfg.gs("Process.back.up.completed.successfully.send.emails"), this.context.cfg.getNavigatorName(), 0)) != 0) {
                return;
            }
            EmailHandler emailHandler = new EmailHandler(this.context, null, tool, EmailHandler.Function.SEND);
            emailHandler.start();
            try {
                while (emailHandler.isAlive()) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            String msg = this.context.cfg.gs("Process.email.tool.not.found" + toolName);
            this.logger.error(msg);
            if ((this.context.navigator != null || this.context.cfg.isLoggerView()) && this.context.preferences.isAskSendEmail()) {
                JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
            }
        }
    }

    private void reportIgnored() {
        if (this.context.cfg.isIgnoredReported() && this.ignoredList.size() > 0) {
            this.logger.debug(this.SHORT, "+------------------------------------------");
            this.logger.debug(this.SIMPLE, MessageFormat.format(this.context.cfg.gs("Process.ignored.files.fin"), this.ignoredList.size()));
            for (String s : this.ignoredList) {
                this.logger.debug(this.SIMPLE, "    " + s);
            }
        }
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }
}

