/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui;

import com.corionis.els.Context;
import com.corionis.els.Transfer;
import com.corionis.els.Utils;
import com.corionis.els.gui.About;
import com.corionis.els.gui.Generator;
import com.corionis.els.gui.MainFrame;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.Progress;
import com.corionis.els.gui.Settings;
import com.corionis.els.gui.bookmarks.Bookmark;
import com.corionis.els.gui.bookmarks.Bookmarks;
import com.corionis.els.gui.bookmarks.BookmarksUI;
import com.corionis.els.gui.browser.Browser;
import com.corionis.els.gui.browser.NavTransferHandler;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.gui.hints.HintsUI;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.JobsUI;
import com.corionis.els.gui.libraries.LibrariesUI;
import com.corionis.els.gui.system.FileEditor;
import com.corionis.els.gui.tools.archiver.ArchiverUI;
import com.corionis.els.gui.tools.cleanup.CleanupUI;
import com.corionis.els.gui.tools.duplicateFinder.DuplicateFinderUI;
import com.corionis.els.gui.tools.email.EmailUI;
import com.corionis.els.gui.tools.emptyDirectoryFinder.EmptyDirectoryFinderUI;
import com.corionis.els.gui.tools.junkRemover.JunkRemoverUI;
import com.corionis.els.gui.tools.operations.OperationsUI;
import com.corionis.els.gui.tools.renamer.RenamerUI;
import com.corionis.els.gui.tools.sleep.SleepUI;
import com.corionis.els.gui.util.GuiLogAppender;
import com.corionis.els.hints.Hint;
import com.corionis.els.hints.HintKey;
import com.corionis.els.jobs.Job;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Origins;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import com.corionis.els.sftp.ClientSftp;
import com.corionis.els.stty.ClientStty;
import com.formdev.flatlaf.extras.FlatDesktop;
import com.formdev.flatlaf.util.SystemInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.jcraft.jsch.SftpATTRS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Navigator {
    public ArchiverUI dialogArchiver;
    public CleanupUI dialogCleanup;
    public Bookmarks bookmarks;
    public Context context;
    public DuplicateFinderUI dialogDuplicateFinder;
    public EmailUI dialogEmail;
    public EmptyDirectoryFinderUI dialogEmptyDirectoryFinder;
    public HintsUI dialogHints = null;
    public JobsUI dialogJobs = null;
    public JunkRemoverUI dialogJunkRemover = null;
    public OperationsUI dialogOperations = null;
    public RenamerUI dialogRenamer = null;
    public SleepUI dialogSleep = null;
    public FileEditor fileeditor = null;
    public Job[] jobs;
    public SwingWorker<Void, Void> worker;
    boolean mockMode = false;
    private boolean blockingProcessRunning = false;
    private int bottomSizeBrowser;
    private Settings dialogSettings = null;
    private int lastFindPosition = 0;
    private String lastFindString = "";
    private int lastFindTab = -1;
    private ArrayList<ArrayList<Origin>> originsArray = null;
    private boolean quitRemoteHintStatusServer = false;
    private boolean quitRemoteSubscriber = false;
    private boolean secondaryNavigator = false;
    private String updaterJar = null;
    private boolean updaterProcess = false;
    private boolean workerRunning = false;
    private transient Logger logger = LogManager.getLogger("applog");

    public Navigator(Context context) {
        this.context = context;
        if (this.context.navigator != null) {
            this.secondaryNavigator = true;
        }
        this.context.navigator = this;
    }

    public boolean checkForConflicts(NavTreeUserObject tuo, String action) {
        if (tuo.type == 6) {
            if (this.context.cfg.isHintTrackingEnabled() && this.context.browser.isHintTrackingButtonEnabled() && tuo.node.getMyTree().getName().toLowerCase().contains("collection")) {
                ArrayList<Hint> hints = null;
                String libName = tuo.getParentLibrary().getUserObject().name;
                try {
                    hints = this.context.hintsHandler.checkConflicts(libName, tuo.getItemPath(libName, tuo.getPath()));
                    if (hints != null && hints.size() > 0) {
                        this.logger.info(this.context.cfg.gs("NavTransferHandler.action.cancelled"));
                        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("NavTransferHandler.action.cancelled"));
                        String msg = hints.size() + this.context.cfg.gs("Navigator.hint.s.conflict.with.the.current") + action;
                        JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 2);
                        return true;
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    this.logger.error(message);
                    Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                    JOptionPane.showOptionDialog(this.context.mainFrame, message, this.context.cfg.gs("Z.exception"), -1, 0, null, opts, opts[0]);
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public int checkForHints() {
        int count;
        block6: {
            count = 0;
            if (this.context.cfg.isHintTrackingEnabled() && this.context.hintsHandler != null && this.context.publisherRepo != null) {
                try {
                    HintKey hk = this.context.hintsHandler.findHintKey(this.context.publisherRepo);
                    if (hk != null) {
                        count = this.context.hintsHandler.getCount(hk.system);
                    }
                    if (count > 0) {
                        String text = count + " " + this.context.cfg.gs("Navigator.hints.available");
                        this.logger.info(text);
                        this.context.mainFrame.labelAlertHintsMenu.setToolTipText(text);
                        this.context.mainFrame.labelAlertHintsToolbar.setToolTipText(text);
                        this.context.mainFrame.labelAlertHintsMenu.setVisible(true);
                        this.context.mainFrame.labelAlertHintsToolbar.setVisible(true);
                        break block6;
                    }
                    this.context.mainFrame.labelAlertHintsMenu.setVisible(false);
                    this.context.mainFrame.labelAlertHintsToolbar.setVisible(false);
                }
                catch (Exception e) {
                    this.context.fault = true;
                    this.logger.error(Utils.getStackTrace(e));
                }
            } else {
                this.context.mainFrame.labelAlertHintsMenu.setVisible(false);
                this.context.mainFrame.labelAlertHintsToolbar.setVisible(false);
            }
        }
        return count;
    }

    public void disableComponent(boolean disable, Component component) {
        Component[] components;
        boolean enable = !disable;
        component.setEnabled(enable);
        if (component instanceof Container && (components = ((Container)component).getComponents()) != null && components.length > 0) {
            for (Component comp : components) {
                this.disableComponent(disable, comp);
            }
        }
    }

    public void disableGui(boolean disable) {
        int i;
        boolean enable;
        boolean bl = enable = !disable;
        if (!enable) {
            this.bottomSizeBrowser = this.context.preferences.getBrowserBottomSize();
        }
        this.context.mainFrame.panelBrowserTop.setVisible(enable);
        this.context.mainFrame.menuItemOpenPublisher.setEnabled(enable);
        this.context.mainFrame.menuItemOpenSubscriber.setEnabled(enable);
        this.context.mainFrame.menuItemOpenHintKeys.setEnabled(enable);
        this.context.mainFrame.menuItemOpenHintTracking.setEnabled(enable);
        this.context.mainFrame.menuItemCopy.setEnabled(enable);
        this.context.mainFrame.menuItemCut.setEnabled(enable);
        this.context.mainFrame.menuItemPaste.setEnabled(enable);
        this.context.mainFrame.menuItemDelete.setEnabled(enable);
        this.context.mainFrame.menuItemFind.setEnabled(enable);
        this.context.mainFrame.menuItemFindNext.setEnabled(enable);
        this.context.mainFrame.menuItemNewFolder.setEnabled(enable);
        this.context.mainFrame.menuItemRename.setEnabled(enable);
        this.context.mainFrame.menuItemTouch.setEnabled(enable);
        this.context.mainFrame.menuItemRefresh.setEnabled(enable);
        this.context.mainFrame.radioButtonAutoRefresh.setEnabled(enable);
        this.context.mainFrame.menuItemShowHidden.setEnabled(enable);
        this.context.mainFrame.menuItemWordWrap.setEnabled(enable);
        this.context.mainFrame.menuTbCopy.setEnabled(enable);
        this.context.mainFrame.menuTbCut.setEnabled(enable);
        this.context.mainFrame.menuTbPaste.setEnabled(enable);
        this.context.mainFrame.menuTbDelete.setEnabled(enable);
        this.context.mainFrame.menuTbNewFolder.setEnabled(enable);
        this.context.mainFrame.menuTbRefresh.setEnabled(enable);
        for (i = 0; i < this.context.mainFrame.menuBookmarks.getItemCount(); ++i) {
            if (this.context.mainFrame.menuBookmarks.getItem(i) == null) continue;
            this.context.mainFrame.menuBookmarks.getItem(i).setEnabled(enable);
        }
        for (i = 0; i < this.context.mainFrame.menuTools.getItemCount(); ++i) {
            if (this.context.mainFrame.menuTools.getItem(i) == null) continue;
            this.context.mainFrame.menuTools.getItem(i).setEnabled(enable);
        }
        for (i = 0; i < this.context.mainFrame.menuJobs.getItemCount(); ++i) {
            if (this.context.mainFrame.menuJobs.getItem(i) == null) continue;
            this.context.mainFrame.menuJobs.getItem(i).setEnabled(enable);
        }
        this.context.mainFrame.menuItemExternalTools.setEnabled(false);
        this.context.mainFrame.menuItemPlexGenerator.setEnabled(false);
        this.context.mainFrame.menuItemSplitHorizontal.setEnabled(enable);
        this.context.mainFrame.menuItemSplitVertical.setEnabled(enable);
        if (enable) {
            this.context.preferences.fixBrowserDivider(this.context, this.bottomSizeBrowser);
        }
    }

    public void disconnectSubscriber() {
        this.disconnectSubscriber(true);
        this.context.subscriberRepo = null;
        this.context.cfg.setSubscriberCollectionFilename("");
        this.context.cfg.setSubscriberLibrariesFileName("");
        this.context.cfg.setOperation("-");
    }

    public void disconnectSubscriber(boolean clear) {
        this.context.preferences.setLastSubscriberIsOpen(false);
        this.quitByeRemotes(true, false);
        NavTreeNode root = this.context.browser.setCollectionRoot(null, this.context.mainFrame.treeCollectionTwo, this.context.cfg.gs("Browser.open.a.subscriber"), false);
        root.loadTable();
        root = this.context.browser.setCollectionRoot(null, this.context.mainFrame.treeSystemTwo, this.context.cfg.gs("Browser.open.a.subscriber"), false);
        root.loadTable();
        this.setQuitTerminateVisibility();
    }

    public void enableDisableSystemMenus(FileEditor.EditorTypes type, boolean enable) {
        if (enable) {
            this.context.mainFrame.menuItemHints.setEnabled(true);
            this.context.mainFrame.menuItemAuthKeys.setEnabled(true);
            this.context.mainFrame.menuItemHintKeys.setEnabled(true);
            this.context.mainFrame.menuItemBlacklist.setEnabled(true);
            this.context.mainFrame.menuItemWhitelist.setEnabled(true);
        } else {
            switch (type) {
                case Authentication: {
                    this.context.mainFrame.menuItemHints.setEnabled(false);
                    this.context.mainFrame.menuItemAuthKeys.setEnabled(true);
                    this.context.mainFrame.menuItemHintKeys.setEnabled(false);
                    this.context.mainFrame.menuItemBlacklist.setEnabled(false);
                    this.context.mainFrame.menuItemWhitelist.setEnabled(false);
                    break;
                }
                case Hints: {
                    this.context.mainFrame.menuItemHints.setEnabled(true);
                    this.context.mainFrame.menuItemAuthKeys.setEnabled(false);
                    this.context.mainFrame.menuItemHintKeys.setEnabled(false);
                    this.context.mainFrame.menuItemBlacklist.setEnabled(false);
                    this.context.mainFrame.menuItemWhitelist.setEnabled(false);
                    break;
                }
                case HintKeys: {
                    this.context.mainFrame.menuItemHints.setEnabled(false);
                    this.context.mainFrame.menuItemAuthKeys.setEnabled(false);
                    this.context.mainFrame.menuItemHintKeys.setEnabled(true);
                    this.context.mainFrame.menuItemBlacklist.setEnabled(false);
                    this.context.mainFrame.menuItemWhitelist.setEnabled(false);
                    break;
                }
                case BlackList: {
                    this.context.mainFrame.menuItemHints.setEnabled(false);
                    this.context.mainFrame.menuItemAuthKeys.setEnabled(false);
                    this.context.mainFrame.menuItemHintKeys.setEnabled(false);
                    this.context.mainFrame.menuItemBlacklist.setEnabled(true);
                    this.context.mainFrame.menuItemWhitelist.setEnabled(false);
                    break;
                }
                case WhiteList: {
                    this.context.mainFrame.menuItemHints.setEnabled(false);
                    this.context.mainFrame.menuItemAuthKeys.setEnabled(false);
                    this.context.mainFrame.menuItemHintKeys.setEnabled(false);
                    this.context.mainFrame.menuItemBlacklist.setEnabled(false);
                    this.context.mainFrame.menuItemWhitelist.setEnabled(true);
                }
            }
        }
    }

    public void enableDisableToolMenus(AbstractToolDialog dialog, boolean enable) {
        this.context.mainFrame.menuItemArchiver.setEnabled(enable);
        this.context.mainFrame.menuItemArchiver.setToolTipText(enable ? "" : this.context.cfg.gs("Navigator.a.tool.is.active"));
        this.context.mainFrame.menuItemCleanup.setEnabled(enable);
        this.context.mainFrame.menuItemCleanup.setToolTipText(enable ? "" : this.context.cfg.gs("Navigator.a.tool.is.active"));
        this.context.mainFrame.menuItemJunk.setEnabled(enable);
        this.context.mainFrame.menuItemJunk.setToolTipText(enable ? "" : this.context.cfg.gs("Navigator.a.tool.is.active"));
        this.context.mainFrame.menuItemOperations.setEnabled(enable);
        this.context.mainFrame.menuItemOperations.setToolTipText(enable ? "" : this.context.cfg.gs("Navigator.a.tool.is.active"));
        this.context.mainFrame.menuItemRenamer.setEnabled(enable);
        this.context.mainFrame.menuItemRenamer.setToolTipText(enable ? "" : this.context.cfg.gs("Navigator.a.tool.is.active"));
        this.context.mainFrame.menuItemSleep.setEnabled(enable);
        this.context.mainFrame.menuItemSleep.setToolTipText(enable ? "" : this.context.cfg.gs("Navigator.a.tool.is.active"));
        this.context.mainFrame.menuItemJobsManage.setEnabled(enable);
        this.context.mainFrame.menuItemJobsManage.setToolTipText(enable ? "" : this.context.cfg.gs("Navigator.a.tool.is.active"));
        this.context.mainFrame.menuItemUpdates.setEnabled(enable);
        this.context.mainFrame.menuItemUpdates.setToolTipText(enable ? "" : this.context.cfg.gs("Navigator.a.tool.is.active"));
        if (!enable) {
            if (dialog instanceof ArchiverUI) {
                this.context.mainFrame.menuItemArchiver.setEnabled(true);
                this.context.mainFrame.menuItemArchiver.setToolTipText("");
            } else if (dialog instanceof CleanupUI) {
                this.context.mainFrame.menuItemCleanup.setEnabled(true);
                this.context.mainFrame.menuItemCleanup.setToolTipText("");
            } else if (dialog instanceof JunkRemoverUI) {
                this.context.mainFrame.menuItemJunk.setEnabled(true);
                this.context.mainFrame.menuItemJunk.setToolTipText("");
            } else if (dialog instanceof OperationsUI) {
                this.context.mainFrame.menuItemOperations.setEnabled(true);
                this.context.mainFrame.menuItemOperations.setToolTipText("");
            } else if (dialog instanceof RenamerUI) {
                this.context.mainFrame.menuItemRenamer.setEnabled(true);
                this.context.mainFrame.menuItemRenamer.setToolTipText("");
            } else if (dialog instanceof SleepUI) {
                this.context.mainFrame.menuItemSleep.setEnabled(true);
                this.context.mainFrame.menuItemSleep.setToolTipText("");
            } else if (dialog instanceof JobsUI) {
                this.context.mainFrame.menuItemJobsManage.setEnabled(true);
                this.context.mainFrame.menuItemJobsManage.setToolTipText("");
            }
        }
    }

    public boolean execExternalExe(String commandLine) {
        final Marker SIMPLE = MarkerManager.getMarker("SIMPLE");
        try {
            final Process proc = Runtime.getRuntime().exec(commandLine);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    try {
                        String line;
                        while ((line = input.readLine()) != null) {
                            Navigator.this.logger.info(SIMPLE, line);
                        }
                        input.close();
                    }
                    catch (IOException e) {
                        Navigator.this.logger.error(Navigator.this.context.cfg.gs("Z.exception") + e.getMessage());
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e), Navigator.this.context.cfg.getNavigatorName(), 0);
                    }
                }
            };
            thread.start();
            int result = proc.waitFor();
            thread.join();
            if (result == 0) {
                return true;
            }
            this.logger.error(this.context.cfg.gs("Z.process.failed") + result);
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.process.failed") + result, this.context.cfg.getNavigatorName(), 0);
        }
        catch (Exception e) {
            this.logger.error(this.context.cfg.gs("Z.process.failed") + Utils.getStackTrace(e));
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.process.failed") + Utils.getStackTrace(e), this.context.cfg.getNavigatorName(), 0);
        }
        return false;
    }

    private int findMenuItemIndex(JMenu menu, JMenuItem item) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            Component comp = menu.getMenuComponent(i);
            if (!(comp instanceof JMenuItem) || item != (JMenuItem)comp) continue;
            return i;
        }
        return -1;
    }

    private boolean initialize() {
        this.context.cfg.setNavigator(true);
        this.context.cfg.loadLocale(this.context.preferences.getLocale());
        if (this.context.cfg.getPublisherCollectionFilename().length() > 0) {
            this.context.preferences.setLastPublisherIsWorkstation(false);
            this.context.preferences.setLastPublisherOpenFile(this.context.cfg.getPublisherCollectionFilename());
            this.context.preferences.setLastPublisherOpenPath(Utils.getLeftPath(this.context.cfg.getPublisherCollectionFilename(), Utils.getSeparatorFromPath(this.context.cfg.getPublisherCollectionFilename())));
        } else if (this.context.cfg.getPublisherLibrariesFileName().length() > 0) {
            this.context.preferences.setLastPublisherIsWorkstation(true);
            this.context.preferences.setLastPublisherOpenFile(this.context.cfg.getPublisherLibrariesFileName());
            this.context.preferences.setLastPublisherOpenPath(Utils.getLeftPath(this.context.cfg.getPublisherLibrariesFileName(), Utils.getSeparatorFromPath(this.context.cfg.getPublisherLibrariesFileName())));
        }
        if (!this.context.preferences.getLastPublisherOpenFile().isEmpty() && this.context.preferences.getLastPublisherOpenPath().equals(this.context.preferences.getLastPublisherOpenFile())) {
            this.context.preferences.setLastPublisherOpenPath("");
        }
        if (this.context.cfg.getSubscriberCollectionFilename().length() > 0) {
            this.context.preferences.setLastSubscriberIsRemote(this.context.cfg.isRemoteSubscriber());
            this.context.preferences.setLastOverrideSubscriber(this.context.cfg.getOverrideSubscriberHost());
            this.context.preferences.setLastSubscriberOpenFile(this.context.cfg.getSubscriberCollectionFilename());
            this.context.preferences.setLastSubscriberOpenPath(Utils.getLeftPath(this.context.cfg.getSubscriberCollectionFilename(), Utils.getSeparatorFromPath(this.context.cfg.getSubscriberCollectionFilename())));
        } else if (this.context.cfg.getSubscriberLibrariesFileName().length() > 0) {
            this.context.preferences.setLastSubscriberIsRemote(this.context.cfg.isRemoteSubscriber());
            this.context.preferences.setLastOverrideSubscriber(this.context.cfg.getOverrideSubscriberHost());
            this.context.preferences.setLastSubscriberOpenFile(this.context.cfg.getSubscriberLibrariesFileName());
            this.context.preferences.setLastSubscriberOpenPath(Utils.getLeftPath(this.context.cfg.getSubscriberLibrariesFileName(), Utils.getSeparatorFromPath(this.context.cfg.getSubscriberLibrariesFileName())));
        }
        if (!this.context.preferences.getLastSubscriberOpenFile().isEmpty() && this.context.preferences.getLastSubscriberOpenPath().equals(this.context.preferences.getLastSubscriberOpenFile())) {
            this.context.preferences.setLastSubscriberOpenPath("");
        }
        if (this.context.cfg.isHintTrackingEnabled()) {
            this.context.preferences.setLastHintTrackingIsRemote(this.context.cfg.getHintsDaemonFilename().length() > 0);
            this.context.preferences.setLastOverrideHintHost(this.context.cfg.isOverrideHintsHost());
            this.context.preferences.setLastHintTrackingOpenFile(this.context.cfg.getHintHandlerFilename());
            this.context.preferences.setLastHintTrackingOpenPath(Utils.getLeftPath(this.context.cfg.getHintHandlerFilename(), Utils.getSeparatorFromPath(this.context.cfg.getHintHandlerFilename())));
            if (this.context.preferences.getLastHintKeysOpenPath().equals(this.context.preferences.getLastHintKeysOpenFile())) {
                this.context.preferences.setLastHintTrackingOpenPath("");
            }
        } else if (this.context.cfg.getHintHandlerFilename().length() > 0) {
            this.context.preferences.setLastOverrideHintHost(this.context.cfg.isOverrideHintsHost());
            if (!this.context.preferences.getLastHintKeysOpenFile().isEmpty() && this.context.preferences.getLastHintTrackingOpenPath().equals(this.context.preferences.getLastHintTrackingOpenFile())) {
                this.context.preferences.setLastHintTrackingOpenPath("");
            }
        }
        if (!this.isLogger()) {
            this.context.transfer = new Transfer(this.context);
            try {
                this.context.transfer.initialize();
                if (this.context.cfg.getHintKeysFile() != null && this.context.cfg.getHintKeysFile().length() > 0) {
                    this.context.preferences.setLastHintKeysOpenFile(this.context.cfg.getHintKeysFile());
                    this.context.preferences.setLastHintKeysOpenPath(FilenameUtils.getFullPathNoEndSeparator(this.context.cfg.getHintKeysFile()));
                }
            }
            catch (Exception e) {
                this.logger.error(Utils.getStackTrace(e));
                this.context.fault = true;
                return false;
            }
        }
        if (this.context.previousContext != null && this.context.previousContext.navigator != null) {
            this.context.main.secondaryNavigator = true;
        }
        this.context.mainFrame = new MainFrame(this.context);
        if (!this.context.fault) {
            if (Utils.isOsMac() && SystemInfo.isMacFullWindowContentSupported) {
                this.context.mainFrame.getRootPane().putClientProperty("apple.awt.fullscreenable", true);
            }
            this.initializeMainMenu();
            this.context.browser = new Browser(this.context);
            this.context.libraries = new LibrariesUI(this.context);
            this.context.cfg.setNoBackFill(true);
            this.context.cfg.setPreserveDates(this.context.preferences.isPreserveFileTimes());
            this.setQuitTerminateVisibility();
            if (!this.context.cfg.isLoggerView()) {
                this.bookmarks = new Bookmarks(this.context);
                this.loadBookmarksMenu();
                this.loadJobsMenu();
            }
        }
        return !this.context.fault;
    }

    private void initializeMainMenu() {
        AbstractAction openPublisherAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block9: {
                    File file;
                    File last;
                    boolean isWorkstation;
                    block12: {
                        block11: {
                            block10: {
                                File lf;
                                JFileChooser fc = new JFileChooser();
                                fc.setFileFilter(new FileFilter(){

                                    @Override
                                    public boolean accept(File file) {
                                        if (file.isDirectory()) {
                                            return true;
                                        }
                                        return file.getName().toLowerCase().endsWith(".json");
                                    }

                                    @Override
                                    public String getDescription() {
                                        return Navigator.this.context.cfg.gs("Navigator.menu.Open.publisher.files");
                                    }
                                });
                                fc.setDialogTitle(Navigator.this.context.cfg.gs("Navigator.menu.Open.publisher"));
                                fc.setFileHidingEnabled(false);
                                File ld = null;
                                if (!(Navigator.this.context.preferences.getLastPublisherOpenPath().length() <= 0 || (ld = new File(Navigator.this.context.preferences.getLastPublisherOpenPath())).exists() && ld.isDirectory())) {
                                    ld = null;
                                }
                                if (!(ld != null || (ld = new File(Navigator.this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + "libraries")).exists() && ld.isDirectory())) {
                                    ld = new File(Navigator.this.context.cfg.getWorkingDirectory());
                                }
                                if (ld.exists() && ld.isDirectory()) {
                                    fc.setCurrentDirectory(ld);
                                }
                                if (Navigator.this.context.preferences.getLastPublisherOpenFile().length() > 0 && (lf = new File(Navigator.this.context.preferences.getLastPublisherOpenFile())).exists()) {
                                    fc.setSelectedFile(lf);
                                }
                                JPanel jp = new JPanel();
                                GridBagLayout layout = new GridBagLayout();
                                jp.setLayout(layout);
                                jp.setBackground(UIManager.getColor("TextField.background"));
                                jp.setBorder(Navigator.this.context.mainFrame.scrollPaneTableCollectionOne.getBorder());
                                JLabel lab = new JLabel(Navigator.this.context.cfg.gs("Navigator.menu.Open.publisher.system.type"));
                                Font font = lab.getFont();
                                Font boldFont = new Font(font.getFontName(), 1, font.getSize());
                                lab.setFont(boldFont);
                                JRadioButton rbCollection = new JRadioButton(Navigator.this.context.cfg.gs("Navigator.menu.Open.publisher.collection.radio"));
                                rbCollection.setToolTipText(Navigator.this.context.cfg.gs("Navigator.menu.Open.publisher.collection.radio.tooltip"));
                                rbCollection.setSelected(!Navigator.this.context.preferences.isLastPublisherIsWorkstation());
                                JRadioButton rbWorkstation = new JRadioButton(Navigator.this.context.cfg.gs("Navigator.menu.Open.publisher.workstation.radio"));
                                rbWorkstation.setToolTipText(Navigator.this.context.cfg.gs("Navigator.menu.Open.publisher.workstation.radio.tooltip"));
                                rbWorkstation.setSelected(Navigator.this.context.preferences.isLastPublisherIsWorkstation());
                                ButtonGroup group = new ButtonGroup();
                                group.add(rbCollection);
                                group.add(rbWorkstation);
                                GridBagConstraints gbc = new GridBagConstraints();
                                gbc.insets = new Insets(0, 8, 4, 8);
                                gbc.gridx = 0;
                                gbc.gridy = 0;
                                gbc.anchor = 17;
                                layout.setConstraints(lab, gbc);
                                gbc.gridy = 1;
                                layout.setConstraints(rbCollection, gbc);
                                gbc.insets = new Insets(0, 8, 0, 8);
                                gbc.gridy = 2;
                                layout.setConstraints(rbWorkstation, gbc);
                                jp.add(lab);
                                jp.add(rbCollection);
                                jp.add(rbWorkstation);
                                fc.setAccessory(jp);
                                int selection = fc.showOpenDialog(Navigator.this.context.mainFrame);
                                if (selection != 0) break block9;
                                isWorkstation = rbWorkstation.isSelected();
                                last = fc.getCurrentDirectory();
                                file = fc.getSelectedFile();
                                if (file.exists()) break block10;
                                JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.open.error.file.not.found") + file.getName(), Navigator.this.context.cfg.getNavigatorName(), 0);
                                break block9;
                            }
                            if (!file.isDirectory()) break block11;
                            JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.open.error.select.a.file.only"), Navigator.this.context.cfg.getNavigatorName(), 0);
                            break block9;
                        }
                        if (!Navigator.this.context.cfg.isRemoteSubscriber() && (!Navigator.this.context.cfg.isHintTrackingEnabled() || !Navigator.this.context.cfg.isRemoteStatusServer())) break block12;
                        int r = JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.remote.connections.must.be.closed"), Navigator.this.context.cfg.getNavigatorName(), 0);
                        if (r != 0) break block9;
                        Navigator.this.disconnectSubscriber();
                        Navigator.this.quitByeRemotes(false, true);
                        Navigator.this.context.hintsHandler = null;
                        Navigator.this.context.hintKeys = null;
                        Navigator.this.context.cfg.setHintKeysFile("");
                        Navigator.this.context.hintsRepo = null;
                        Navigator.this.context.cfg.setHintTrackerFilename("");
                        Navigator.this.context.cfg.setHintsDaemonFilename("");
                        Navigator.this.context.preferences.setLastHintKeysIsOpen(false);
                        Navigator.this.context.browser.setupHintTrackingButton();
                    }
                    try {
                        Navigator.this.context.preferences.setLastPublisherOpenFile(file.getPath());
                        Navigator.this.context.preferences.setLastPublisherOpenPath(last.getPath());
                        Navigator.this.context.preferences.setLastPublisherIsWorkstation(isWorkstation);
                        Navigator.this.context.preferences.setLastPublisherIsOpen(true);
                        if (isWorkstation) {
                            Navigator.this.context.cfg.setPublisherCollectionFilename("");
                            Navigator.this.context.cfg.setPublisherLibrariesFileName(file.getPath());
                        } else {
                            Navigator.this.context.cfg.setPublisherCollectionFilename(file.getPath());
                            Navigator.this.context.cfg.setPublisherLibrariesFileName("");
                        }
                        Navigator.this.context.mainFrame.tabbedPaneMain.setSelectedIndex(0);
                        Navigator.this.context.publisherRepo = Navigator.this.context.main.readRepo(Navigator.this.context, 1, true);
                        Navigator.this.context.browser.loadCollectionTree(Navigator.this.context.mainFrame.treeCollectionOne, Navigator.this.context.publisherRepo, false);
                        Navigator.this.context.browser.loadSystemTree(Navigator.this.context.mainFrame.treeSystemOne, Navigator.this.context.publisherRepo, false);
                        Navigator.this.setQuitTerminateVisibility();
                        Navigator.this.context.libraries.loadConfigurations();
                        Navigator.this.checkForHints();
                        if (Navigator.this.dialogHints != null && Navigator.this.dialogHints.isVisible()) {
                            Navigator.this.dialogHints.refresh();
                        }
                    }
                    catch (Exception e) {
                        Navigator.this.logger.error(Utils.getStackTrace(e));
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.publisher.error.opening.publisher.library") + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                        Navigator.this.context.fault = false;
                    }
                }
            }
        };
        this.context.mainFrame.menuItemOpenPublisher.addActionListener(openPublisherAction);
        AbstractAction openSubscriberAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int selection;
                File lf;
                final JFileChooser fc = new JFileChooser();
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        return file.getName().toLowerCase().endsWith(".json");
                    }

                    @Override
                    public String getDescription() {
                        return Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber.files");
                    }
                });
                fc.setDialogTitle(Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber"));
                fc.setFileHidingEnabled(false);
                File ld = null;
                if (!(Navigator.this.context.preferences.getLastSubscriberOpenPath().length() <= 0 || (ld = new File(Navigator.this.context.preferences.getLastSubscriberOpenPath())).exists() && ld.isDirectory())) {
                    ld = null;
                }
                if (!(ld != null || (ld = new File(Navigator.this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + "libraries")).exists() && ld.isDirectory())) {
                    ld = new File(Navigator.this.context.cfg.getWorkingDirectory());
                }
                if (ld.exists() && ld.isDirectory()) {
                    fc.setCurrentDirectory(ld);
                }
                if (Navigator.this.context.preferences.getLastSubscriberOpenFile().length() > 0 && (lf = new File(Navigator.this.context.preferences.getLastSubscriberOpenFile())).exists()) {
                    fc.setSelectedFile(lf);
                }
                JPanel jp = new JPanel();
                GridBagLayout gb = new GridBagLayout();
                jp.setLayout(gb);
                jp.setBackground(UIManager.getColor("TextField.background"));
                jp.setBorder(Navigator.this.context.mainFrame.scrollPaneTableCollectionOne.getBorder());
                JLabel cbLabel = new JLabel(Navigator.this.context.cfg.gs("Navigator.labelRemote.text"));
                Font font = cbLabel.getFont();
                Font boldFont = new Font(font.getFontName(), 1, font.getSize());
                cbLabel.setFont(boldFont);
                final JCheckBox cbIsRemote = new JCheckBox();
                cbIsRemote.setHorizontalTextPosition(2);
                cbIsRemote.setToolTipText(Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber.connection.checkbox.tooltip"));
                cbIsRemote.setSelected(Navigator.this.context.preferences.isLastSubscriberIsRemote());
                final JRadioButton hostButton = new JRadioButton(Navigator.this.context.cfg.gs("Navigator.labelHostInternet.text"));
                hostButton.setSelected(Navigator.this.context.preferences.getLastOverrideSubscriber().isEmpty());
                final JLabel hostLabel = new JLabel();
                final JRadioButton listenButton = new JRadioButton(Navigator.this.context.cfg.gs("Navigator.labelListenLan.text"));
                listenButton.setSelected(Navigator.this.context.preferences.getLastOverrideSubscriber().equals("true"));
                final JLabel listenLabel = new JLabel();
                boolean custom = !Navigator.this.context.preferences.getLastOverrideSubscriber().isEmpty() && !Navigator.this.context.preferences.getLastOverrideSubscriber().equals("true");
                final JRadioButton customButton = new JRadioButton(Navigator.this.context.cfg.gs("Navigator.labelCustom.text"));
                customButton.setSelected(custom);
                ButtonGroup group = new ButtonGroup();
                group.add(hostButton);
                group.add(listenButton);
                group.add(customButton);
                final JTextField customAddress = new JTextField();
                if (custom) {
                    customAddress.setText(Navigator.this.context.preferences.getLastOverrideSubscriber());
                } else {
                    customAddress.setText("");
                }
                customAddress.setEnabled(customButton.isSelected());
                cbIsRemote.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (cbIsRemote.isSelected()) {
                            hostButton.setEnabled(true);
                            hostLabel.setEnabled(true);
                            listenButton.setEnabled(true);
                            listenLabel.setEnabled(true);
                            customButton.setEnabled(true);
                            customAddress.setEnabled(customButton.isSelected());
                        } else {
                            hostButton.setEnabled(false);
                            hostLabel.setEnabled(false);
                            listenButton.setEnabled(false);
                            listenLabel.setEnabled(false);
                            customButton.setEnabled(false);
                            customAddress.setEnabled(false);
                        }
                    }
                });
                if (cbIsRemote.isSelected()) {
                    hostButton.setEnabled(true);
                    hostLabel.setEnabled(true);
                    listenButton.setEnabled(true);
                    listenLabel.setEnabled(true);
                    customButton.setEnabled(true);
                    customAddress.setEnabled(customButton.isSelected());
                } else {
                    hostButton.setEnabled(false);
                    hostLabel.setEnabled(false);
                    listenButton.setEnabled(false);
                    listenLabel.setEnabled(false);
                    customButton.setEnabled(false);
                    customAddress.setEnabled(false);
                }
                hostButton.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (hostButton.isSelected()) {
                            customAddress.setText("");
                            customAddress.setEnabled(false);
                        }
                    }
                });
                listenButton.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (listenButton.isSelected()) {
                            customAddress.setText("");
                            customAddress.setEnabled(false);
                        }
                    }
                });
                customButton.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (customButton.isSelected()) {
                            if (customAddress.getText().isEmpty() && !Navigator.this.context.preferences.getLastOverrideSubscriber().trim().equals("true")) {
                                customAddress.setText(Navigator.this.context.preferences.getLastOverrideSubscriber());
                            }
                            customAddress.setEnabled(true);
                        }
                    }
                });
                jp.add((Component)cbLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
                jp.add((Component)cbIsRemote, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
                jp.add((Component)hostButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 12, 4, 4), 0, 0));
                jp.add((Component)hostLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
                jp.add((Component)listenButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 12, 4, 4), 0, 0));
                jp.add((Component)listenLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
                jp.add((Component)customButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 12, 4, 4), 0, 0));
                jp.add((Component)customAddress, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 4, 4), 0, 0));
                fc.setAccessory(jp);
                fc.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        File selected = fc.getSelectedFile();
                        Navigator.this.logger.debug(propertyChangeEvent.getPropertyName() + " :: " + String.valueOf(selected));
                        if (Navigator.this.setFileChooserHostListen(fc, hostLabel, listenLabel)) {
                            cbIsRemote.setEnabled(true);
                        } else {
                            cbIsRemote.setEnabled(false);
                        }
                        if (cbIsRemote.isSelected()) {
                            hostButton.setEnabled(true);
                            hostLabel.setEnabled(true);
                            listenButton.setEnabled(true);
                            listenLabel.setEnabled(true);
                            customButton.setEnabled(true);
                            customAddress.setEnabled(true);
                        } else {
                            hostButton.setEnabled(false);
                            hostLabel.setEnabled(false);
                            listenButton.setEnabled(false);
                            listenLabel.setEnabled(false);
                            customButton.setEnabled(false);
                            customAddress.setEnabled(false);
                        }
                    }
                });
                Navigator.this.setFileChooserHostListen(fc, hostLabel, listenLabel);
                while ((selection = fc.showOpenDialog(Navigator.this.context.mainFrame)) == 0) {
                    if (cbIsRemote.isSelected() && Navigator.this.context.publisherRepo == null) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.a.publisher.library.required"), Navigator.this.context.cfg.getNavigatorName(), 1);
                        return;
                    }
                    File last = fc.getCurrentDirectory();
                    File file = fc.getSelectedFile();
                    if (!file.exists()) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.open.error.file.not.found") + file.getName(), Navigator.this.context.cfg.getNavigatorName(), 0);
                        continue;
                    }
                    if (file.isDirectory()) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.open.error.select.a.file.only"), Navigator.this.context.cfg.getNavigatorName(), 0);
                        continue;
                    }
                    Navigator.this.context.preferences.setLastSubscriberOpenFile(file.getPath());
                    Navigator.this.context.preferences.setLastSubscriberOpenPath(last.getPath());
                    Navigator.this.context.preferences.setLastSubscriberIsRemote(cbIsRemote.isSelected());
                    Navigator.this.context.preferences.setLastSubscriberIsOpen(true);
                    boolean closeRemote = Navigator.this.context.cfg.isRemoteSubscriber();
                    try {
                        Navigator.this.context.cfg.setSubscriberLibrariesFileName(file.getPath());
                        Navigator.this.context.cfg.setSubscriberCollectionFilename("");
                        Navigator.this.context.mainFrame.tabbedPaneMain.setSelectedIndex(0);
                        if (cbIsRemote.isSelected()) {
                            Navigator.this.context.cfg.setOperation("P");
                        } else {
                            Navigator.this.context.cfg.setOperation("-");
                        }
                        Navigator.this.context.subscriberRepo = Navigator.this.context.main.readRepo(Navigator.this.context, 2, !Navigator.this.context.preferences.isLastSubscriberIsRemote());
                    }
                    catch (Exception e) {
                        Navigator.this.logger.error(Utils.getStackTrace(e));
                        Navigator.this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber.error.opening.subscriber.library") + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                        Navigator.this.context.fault = false;
                        return;
                    }
                    if (cbIsRemote.isSelected()) {
                        if (hostButton.isSelected()) {
                            Navigator.this.context.cfg.setOverrideSubscriberHost("");
                            Navigator.this.context.preferences.setLastOverrideSubscriber("");
                        } else if (listenButton.isSelected()) {
                            Navigator.this.context.cfg.setOverrideSubscriberHost("true");
                            Navigator.this.context.preferences.setLastOverrideSubscriber("true");
                        } else {
                            String host = Utils.parseHost(customAddress.getText());
                            String port = Utils.parsePort(customAddress.getText());
                            int p = -1;
                            if (!port.isEmpty()) {
                                p = Integer.parseInt(port);
                            }
                            if (!host.isEmpty() && p > 0 && p <= 65535) {
                                Navigator.this.context.cfg.setOverrideSubscriberHost(customAddress.getText());
                                Navigator.this.context.preferences.setLastOverrideSubscriber(customAddress.getText());
                            } else {
                                JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.valid.port") + file.getName(), Navigator.this.context.cfg.getNavigatorName(), 0);
                                continue;
                            }
                        }
                    }
                    if (closeRemote) {
                        int r = JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber.close.current.remote.connection"), Navigator.this.context.cfg.getNavigatorName(), 0);
                        if (r == 1 || r == 2) {
                            return;
                        }
                        Navigator.this.disconnectSubscriber(false);
                        Navigator.this.context.preferences.setLastSubscriberIsOpen(true);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (Navigator.this.context.preferences.isLastSubscriberIsRemote()) {
                        Navigator.this.context.mainFrame.labelStatusMiddle.setText(MessageFormat.format(Navigator.this.context.cfg.gs("Transfer.requesting.subscriber.library"), Navigator.this.context.subscriberRepo.getLibraryData().libraries.description));
                        Navigator.this.context.mainFrame.repaint();
                        Navigator.this.context.mainFrame.labelStatusMiddle.repaint();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Navigator.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                                Navigator.this.context.mainFrame.repaint();
                                Navigator.this.context.mainFrame.labelStatusMiddle.repaint();
                                if (Navigator.this.context.preferences.isLastSubscriberIsRemote()) {
                                    Navigator.this.context.clientSftp = new ClientSftp(Navigator.this.context, Navigator.this.context.publisherRepo, Navigator.this.context.subscriberRepo, true);
                                    if (!Navigator.this.context.clientSftp.startClient("transfer")) {
                                        Navigator.this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                                        Navigator.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                                        Navigator.this.disconnectSubscriber();
                                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber.subscriber.sftp.failed.to.connect"), Navigator.this.context.cfg.getNavigatorName(), 0);
                                        Navigator.this.context.fault = false;
                                        return;
                                    }
                                    Navigator.this.context.clientSftpMetadata = new ClientSftp(Navigator.this.context, Navigator.this.context.publisherRepo, Navigator.this.context.subscriberRepo, true);
                                    if (!Navigator.this.context.clientSftpMetadata.startClient("metadata")) {
                                        Navigator.this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                                        Navigator.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                                        Navigator.this.disconnectSubscriber();
                                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber.subscriber.sftp.failed.to.connect"), Navigator.this.context.cfg.getNavigatorName(), 0);
                                        Navigator.this.context.fault = false;
                                        return;
                                    }
                                    Navigator.this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                                    Navigator.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                                    Navigator.this.context.clientStty = new ClientStty(Navigator.this.context, false, true, false);
                                    if (!Navigator.this.context.clientStty.connect(Navigator.this.context.publisherRepo, Navigator.this.context.subscriberRepo)) {
                                        Navigator.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                                        Navigator.this.disconnectSubscriber();
                                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber.remote.subscriber.failed.to.connect"), Navigator.this.context.cfg.getNavigatorName(), 0);
                                        Navigator.this.context.cfg.setOperation("-");
                                        Navigator.this.context.fault = false;
                                        return;
                                    }
                                    Navigator.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                                    if (Navigator.this.context.clientStty.checkBannerCommands()) {
                                        Navigator.this.logger.info(Navigator.this.context.cfg.gs("Transfer.received.subscriber.commands") + (Navigator.this.context.cfg.isRequestCollection() ? "RequestCollection " : "") + (Navigator.this.context.cfg.isRequestTargets() ? "RequestTargets" : ""));
                                    }
                                    String directory = Navigator.this.context.clientStty.getWorkingDirectoryRemote();
                                    Navigator.this.context.cfg.setWorkingDirectorySubscriber(directory);
                                    Navigator.this.context.transfer.requestLibrary();
                                } else {
                                    Navigator.this.context.cfg.setWorkingDirectorySubscriber(Navigator.this.context.cfg.getWorkingDirectory());
                                }
                                Navigator.this.setQuitTerminateVisibility();
                                Navigator.this.context.libraries.loadConfigurations();
                                Navigator.this.context.browser.loadCollectionTree(Navigator.this.context.mainFrame.treeCollectionTwo, Navigator.this.context.subscriberRepo, Navigator.this.context.preferences.isLastSubscriberIsRemote());
                                Navigator.this.context.browser.loadSystemTree(Navigator.this.context.mainFrame.treeSystemTwo, Navigator.this.context.subscriberRepo, Navigator.this.context.preferences.isLastSubscriberIsRemote());
                                Navigator.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                                Navigator.this.checkForHints();
                                if (Navigator.this.dialogHints != null && Navigator.this.dialogHints.isVisible()) {
                                    Navigator.this.dialogHints.refresh();
                                }
                            }
                            catch (Exception e) {
                                Navigator.this.logger.error(Utils.getStackTrace(e));
                                Navigator.this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                                Navigator.this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                                Navigator.this.disconnectSubscriber();
                                JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.subscriber.error.opening.subscriber.library") + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                                Navigator.this.context.fault = false;
                            }
                        }
                    });
                    break;
                }
            }
        };
        this.context.mainFrame.menuItemOpenSubscriber.addActionListener(openSubscriberAction);
        if (this.context.subscriberRepo != null) {
            this.context.preferences.setLastSubscriberIsRemote(this.context.cfg.isRemoteOperation());
        }
        AbstractAction openHintKeysAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block10: {
                    int selection;
                    File lf;
                    JFileChooser fc = new JFileChooser();
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            return file.getName().toLowerCase().endsWith(".keys");
                        }

                        @Override
                        public String getDescription() {
                            return Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.keys.files");
                        }
                    });
                    fc.setDialogTitle(Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.keys"));
                    fc.setFileHidingEnabled(false);
                    File ld = null;
                    if (!(Navigator.this.context.preferences.getLastHintKeysOpenPath().length() <= 0 || (ld = new File(Navigator.this.context.preferences.getLastHintKeysOpenPath())).exists() && ld.isDirectory())) {
                        ld = null;
                    }
                    if (!(ld != null || (ld = new File(Navigator.this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + "system")).exists() && ld.isDirectory())) {
                        ld = new File(Navigator.this.context.cfg.getWorkingDirectory());
                    }
                    if (ld.exists() && ld.isDirectory()) {
                        fc.setCurrentDirectory(ld);
                    }
                    if (Navigator.this.context.preferences.getLastHintKeysOpenFile().length() > 0 && (lf = new File(Navigator.this.context.preferences.getLastHintKeysOpenFile())).exists()) {
                        fc.setSelectedFile(lf);
                    }
                    if ((selection = fc.showOpenDialog(Navigator.this.context.mainFrame)) != 0) break block10;
                    File last = fc.getCurrentDirectory();
                    File file = fc.getSelectedFile();
                    if (!file.exists()) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.open.error.file.not.found") + file.getName(), Navigator.this.context.cfg.getNavigatorName(), 0);
                    } else if (file.isDirectory()) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.open.error.select.a.file.only"), Navigator.this.context.cfg.getNavigatorName(), 0);
                    } else {
                        try {
                            Navigator.this.context.preferences.setLastHintKeysOpenFile(file.getPath());
                            Navigator.this.context.preferences.setLastHintKeysOpenPath(last.getPath());
                            Navigator.this.context.preferences.setLastHintKeysIsOpen(true);
                            Navigator.this.context.cfg.setHintKeysFile(file.getPath());
                            Navigator.this.context.main.connectHints(Navigator.this.context.publisherRepo);
                        }
                        catch (Exception e) {
                            Navigator.this.logger.error(Utils.getStackTrace(e));
                            JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.keys.error.opening.hint.keys") + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                            Navigator.this.context.fault = false;
                        }
                    }
                }
            }
        };
        this.context.mainFrame.menuItemOpenHintKeys.addActionListener(openHintKeysAction);
        AbstractAction openHintTrackingAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block21: {
                    File lf;
                    if (Navigator.this.context.cfg.getHintKeysFile() == null || Navigator.this.context.cfg.getHintKeysFile().length() == 0) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.tracking.please.open.hints.keys.first"), Navigator.this.context.cfg.getNavigatorName(), 1);
                        return;
                    }
                    final JFileChooser fc = new JFileChooser();
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            return file.getName().toLowerCase().endsWith(".json");
                        }

                        @Override
                        public String getDescription() {
                            return Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.tracking.files");
                        }
                    });
                    fc.setDialogTitle(Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.tracking"));
                    fc.setFileHidingEnabled(false);
                    File ld = null;
                    if (!(Navigator.this.context.preferences.getLastHintTrackingOpenPath().length() <= 0 || (ld = new File(Navigator.this.context.preferences.getLastHintTrackingOpenPath())).exists() && ld.isDirectory())) {
                        ld = null;
                    }
                    if (!(ld != null || (ld = new File(Navigator.this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + "libraries")).exists() && ld.isDirectory())) {
                        ld = new File(Navigator.this.context.cfg.getWorkingDirectory());
                    }
                    if (ld.exists() && ld.isDirectory()) {
                        fc.setCurrentDirectory(ld);
                    }
                    if (Navigator.this.context.preferences.getLastHintTrackingOpenFile().length() > 0 && (lf = new File(Navigator.this.context.preferences.getLastHintTrackingOpenFile())).exists()) {
                        fc.setSelectedFile(lf);
                    }
                    JPanel jp = new JPanel();
                    GridBagLayout gb = new GridBagLayout();
                    jp.setLayout(gb);
                    jp.setBackground(UIManager.getColor("TextField.background"));
                    jp.setBorder(Navigator.this.context.mainFrame.scrollPaneTableCollectionOne.getBorder());
                    JLabel cbLabel = new JLabel(Navigator.this.context.cfg.gs("Navigator.labelRemote.text"));
                    Font font = cbLabel.getFont();
                    Font boldFont = new Font(font.getFontName(), 1, font.getSize());
                    cbLabel.setFont(boldFont);
                    final JCheckBox cbIsRemote = new JCheckBox();
                    cbIsRemote.setHorizontalTextPosition(2);
                    cbIsRemote.setToolTipText(Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.tracking.checkbox.tooltip"));
                    cbIsRemote.setSelected(Navigator.this.context.preferences.isLastHintTrackingIsRemote());
                    final JRadioButton hostButton = new JRadioButton(Navigator.this.context.cfg.gs("Navigator.labelHostInternet.text"));
                    hostButton.setSelected(!Navigator.this.context.preferences.isLastOverrideHintHost());
                    final JLabel hostLabel = new JLabel();
                    final JRadioButton listenButton = new JRadioButton(Navigator.this.context.cfg.gs("Navigator.labelListenLan.text"));
                    listenButton.setSelected(Navigator.this.context.preferences.isLastOverrideHintHost());
                    final JLabel listenLabel = new JLabel();
                    ButtonGroup group = new ButtonGroup();
                    group.add(hostButton);
                    group.add(listenButton);
                    cbIsRemote.addActionListener(new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (cbIsRemote.isSelected()) {
                                hostButton.setEnabled(true);
                                hostLabel.setEnabled(true);
                                listenButton.setEnabled(true);
                                listenLabel.setEnabled(true);
                            } else {
                                hostButton.setEnabled(false);
                                hostLabel.setEnabled(false);
                                listenButton.setEnabled(false);
                                listenLabel.setEnabled(false);
                            }
                        }
                    });
                    if (cbIsRemote.isSelected()) {
                        hostButton.setEnabled(true);
                        hostLabel.setEnabled(true);
                        listenButton.setEnabled(true);
                        listenLabel.setEnabled(true);
                    } else {
                        hostButton.setEnabled(false);
                        hostLabel.setEnabled(false);
                        listenButton.setEnabled(false);
                        listenLabel.setEnabled(false);
                    }
                    jp.add((Component)cbLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
                    jp.add((Component)cbIsRemote, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
                    jp.add((Component)hostButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 12, 4, 4), 0, 0));
                    jp.add((Component)hostLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
                    jp.add((Component)listenButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 12, 4, 4), 0, 0));
                    jp.add((Component)listenLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
                    fc.setAccessory(jp);
                    fc.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            File selected = fc.getSelectedFile();
                            Navigator.this.logger.info(propertyChangeEvent.getPropertyName() + " :: " + String.valueOf(selected));
                            if (Navigator.this.setFileChooserHostListen(fc, hostLabel, listenLabel)) {
                                cbIsRemote.setEnabled(true);
                            } else {
                                cbIsRemote.setEnabled(false);
                            }
                            if (cbIsRemote.isSelected()) {
                                hostButton.setEnabled(true);
                                hostLabel.setEnabled(true);
                                listenButton.setEnabled(true);
                                listenLabel.setEnabled(true);
                            } else {
                                hostButton.setEnabled(false);
                                hostLabel.setEnabled(false);
                                listenButton.setEnabled(false);
                                listenLabel.setEnabled(false);
                            }
                        }
                    });
                    Navigator.this.setFileChooserHostListen(fc, hostLabel, listenLabel);
                    int selection = fc.showOpenDialog(Navigator.this.context.mainFrame);
                    if (selection != 0) break block21;
                    if (cbIsRemote.isSelected() && Navigator.this.context.publisherRepo == null) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.a.publisher.library.required"), Navigator.this.context.cfg.getNavigatorName(), 1);
                        return;
                    }
                    File last = fc.getCurrentDirectory();
                    File file = fc.getSelectedFile();
                    if (!file.exists()) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.open.error.file.not.found") + file.getName(), Navigator.this.context.cfg.getNavigatorName(), 0);
                    } else if (file.isDirectory()) {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.open.error.select.a.file.only"), Navigator.this.context.cfg.getNavigatorName(), 0);
                    } else {
                        try {
                            String filename;
                            Navigator.this.context.preferences.setLastHintTrackingOpenFile(file.getPath());
                            Navigator.this.context.preferences.setLastHintTrackingOpenPath(last.getPath());
                            Navigator.this.context.preferences.setLastHintTrackingIsRemote(cbIsRemote.isSelected());
                            Navigator.this.context.preferences.setLastHintTrackingIsOpen(true);
                            if (Navigator.this.context.preferences.isLastHintTrackingIsRemote()) {
                                Navigator.this.context.cfg.setHintsDaemonFilename(file.getPath());
                                Navigator.this.context.cfg.setHintTrackerFilename("");
                                filename = Navigator.this.context.cfg.getHintsDaemonFilename();
                            } else {
                                Navigator.this.context.cfg.setHintsDaemonFilename("");
                                Navigator.this.context.cfg.setHintTrackerFilename(file.getPath());
                                filename = Navigator.this.context.cfg.getHintTrackerFilename();
                            }
                            Navigator.this.context.cfg.setOverrideHintsHost(listenButton.isSelected());
                            Navigator.this.context.preferences.setLastOverrideHintHost(listenButton.isSelected());
                            try {
                                Navigator.this.context.hintsRepo = new Repository(Navigator.this.context, 3);
                                Navigator.this.context.hintsRepo.read(filename, Navigator.this.context.cfg.gs("Libraries.hint.server"), false);
                            }
                            catch (Exception e) {
                                Navigator.this.logger.error(e.getMessage() + " : " + Utils.getStackTrace(e));
                                Navigator.this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
                                JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.error.opening.hint.library") + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                                Navigator.this.context.fault = false;
                                return;
                            }
                            if (Navigator.this.context.cfg.isHintTrackingEnabled() && Navigator.this.context.cfg.isRemoteStatusServer()) {
                                int r = JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Open.hint.tracking.close.current.status.server"), Navigator.this.context.cfg.getNavigatorName(), 0);
                                if (r == 1 || r == 2) {
                                    return;
                                }
                                Navigator.this.quitByeRemotes(false, true);
                            }
                            Navigator.this.context.main.connectHints(Navigator.this.context.publisherRepo);
                            Navigator.this.context.browser.setupHintTrackingButton();
                            Navigator.this.setQuitTerminateVisibility();
                            Navigator.this.context.libraries.loadConfigurations();
                            Navigator.this.checkForHints();
                            if (Navigator.this.dialogHints != null && Navigator.this.dialogHints.isVisible()) {
                                Navigator.this.dialogHints.refresh();
                            }
                        }
                        catch (Exception e) {
                            Navigator.this.logger.error(Utils.getStackTrace(e));
                            JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                        }
                    }
                }
            }
        };
        this.context.mainFrame.menuItemOpenHintTracking.addActionListener(openHintTrackingAction);
        this.context.mainFrame.menuItemClose.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                if (Navigator.this.context.publisherRepo != null && Navigator.this.context.publisherRepo.isInitialized()) {
                    Navigator.this.context.mainFrame.menuItemClosePublisher.setVisible(true);
                    if (Navigator.this.context.cfg.isRemoteActive()) {
                        Navigator.this.context.mainFrame.menuItemClosePublisher.setEnabled(false);
                        Navigator.this.context.mainFrame.menuItemClosePublisher.setToolTipText(Navigator.this.context.cfg.gs("Navigator.menu.Open.a.publisher.library.required"));
                    } else {
                        Navigator.this.context.mainFrame.menuItemClosePublisher.setEnabled(true);
                        Navigator.this.context.mainFrame.menuItemClosePublisher.setToolTipText(Navigator.this.context.cfg.gs(""));
                    }
                } else {
                    Navigator.this.context.mainFrame.menuItemClosePublisher.setVisible(false);
                }
                if (Navigator.this.context.subscriberRepo != null && Navigator.this.context.cfg.getSubscriberFilename().length() > 0) {
                    Navigator.this.context.mainFrame.menuItemCloseSubscriber.setVisible(true);
                } else {
                    Navigator.this.context.mainFrame.menuItemCloseSubscriber.setVisible(false);
                }
                if (Navigator.this.context.hintKeys != null && Navigator.this.context.cfg.getHintKeysFile().length() > 0) {
                    Navigator.this.context.mainFrame.menuItemCloseHintKeys.setVisible(true);
                } else {
                    Navigator.this.context.mainFrame.menuItemCloseHintKeys.setVisible(false);
                }
                if (Navigator.this.context.hintsRepo != null && Navigator.this.context.cfg.getHintHandlerFilename().length() > 0) {
                    if (Navigator.this.context.cfg.isRemoteStatusServer()) {
                        Navigator.this.context.mainFrame.menuItemCloseHintTracking.setText(Navigator.this.context.cfg.gs("Z.hint.server") + " ...");
                    } else {
                        Navigator.this.context.mainFrame.menuItemCloseHintTracking.setText(Navigator.this.context.cfg.gs("Z.hint.tracker") + " ...");
                    }
                    Navigator.this.context.mainFrame.menuItemCloseHintTracking.setVisible(true);
                } else {
                    Navigator.this.context.mainFrame.menuItemCloseHintTracking.setVisible(false);
                }
            }
        });
        this.context.mainFrame.menuItemClosePublisher.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int r = JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Z.are.you.sure.you.want.to.close") + Navigator.this.context.cfg.gs("Z.publisher"), Navigator.this.context.cfg.getNavigatorName(), 0);
                if (r == 0) {
                    NavTreeNode root = Navigator.this.context.browser.setCollectionRoot(null, Navigator.this.context.mainFrame.treeCollectionOne, Navigator.this.context.cfg.gs("Browser.open.a.publisher"), false);
                    root.loadTable();
                    root = Navigator.this.context.browser.setCollectionRoot(null, Navigator.this.context.mainFrame.treeSystemOne, Navigator.this.context.cfg.gs("Browser.open.a.publisher"), false);
                    root.loadTable();
                    Navigator.this.context.publisherRepo = null;
                    Navigator.this.context.cfg.setPublisherCollectionFilename("");
                    Navigator.this.context.cfg.setPublisherLibrariesFileName("");
                    Navigator.this.context.preferences.setLastPublisherIsOpen(false);
                    Navigator.this.setQuitTerminateVisibility();
                    Navigator.this.context.libraries.loadConfigurations();
                    Navigator.this.checkForHints();
                    if (Navigator.this.dialogHints != null && Navigator.this.dialogHints.isVisible()) {
                        Navigator.this.dialogHints.refresh();
                    }
                }
            }
        });
        this.context.mainFrame.menuItemCloseSubscriber.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int r = JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Z.are.you.sure.you.want.to.close") + Navigator.this.context.cfg.gs("Z.subscriber"), Navigator.this.context.cfg.getNavigatorName(), 0);
                if (r == 0) {
                    Navigator.this.disconnectSubscriber();
                    Navigator.this.context.libraries.loadConfigurations();
                    Navigator.this.checkForHints();
                    if (Navigator.this.dialogHints != null && Navigator.this.dialogHints.isVisible()) {
                        Navigator.this.dialogHints.refresh();
                    }
                }
            }
        });
        this.context.mainFrame.menuItemCloseHintKeys.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int r = Navigator.this.context.hintsRepo != null && Navigator.this.context.hintsRepo.isInitialized() ? JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Z.are.you.sure.you.want.to.quit.and.close") + Navigator.this.context.cfg.gs("Z.hint.key"), Navigator.this.context.cfg.getNavigatorName(), 0) : JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Z.are.you.sure.you.want.to.close") + Navigator.this.context.cfg.gs("Z.hint.key"), Navigator.this.context.cfg.getNavigatorName(), 0);
                if (r == 0) {
                    Navigator.this.quitByeRemotes(false, true);
                    Navigator.this.context.hintsHandler = null;
                    Navigator.this.context.hintKeys = null;
                    Navigator.this.context.cfg.setHintKeysFile("");
                    Navigator.this.context.preferences.setLastHintKeysIsOpen(false);
                    Navigator.this.context.hintsRepo = null;
                    Navigator.this.context.cfg.setHintTrackerFilename("");
                    Navigator.this.context.cfg.setHintsDaemonFilename("");
                    Navigator.this.context.preferences.setLastHintTrackingIsOpen(false);
                    Navigator.this.context.browser.setupHintTrackingButton();
                    Navigator.this.context.libraries.loadConfigurations();
                    Navigator.this.checkForHints();
                    if (Navigator.this.dialogHints != null && Navigator.this.dialogHints.isVisible()) {
                        Navigator.this.dialogHints.refresh();
                    }
                }
            }
        });
        this.context.mainFrame.menuItemCloseHintTracking.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int r = JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Z.are.you.sure.you.want.to.close") + (Navigator.this.context.cfg.isRemoteStatusServer() ? Navigator.this.context.cfg.gs("Z.hint.server") : Navigator.this.context.cfg.gs("Z.hint.tracker")) + "?", Navigator.this.context.cfg.getNavigatorName(), 0);
                if (r == 0) {
                    Navigator.this.quitByeRemotes(false, true);
                    Navigator.this.context.hintsRepo = null;
                    Navigator.this.context.cfg.setHintTrackerFilename("");
                    Navigator.this.context.cfg.setHintsDaemonFilename("");
                    Navigator.this.context.preferences.setLastHintTrackingIsOpen(false);
                    Navigator.this.context.browser.setupHintTrackingButton();
                    Navigator.this.setQuitTerminateVisibility();
                    Navigator.this.checkForHints();
                    if (Navigator.this.dialogHints != null && Navigator.this.dialogHints.isVisible()) {
                        Navigator.this.dialogHints.refresh();
                    }
                }
            }
        });
        AbstractAction generateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Generator generator = new Generator(Navigator.this.context, true);
                generator.showDialog(null, null, "ELS Navigator");
            }
        };
        this.context.mainFrame.menuItemGenerate.addActionListener(generateAction);
        AbstractAction saveLayoutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Navigator.this.context.preferences.write(Navigator.this.context);
                    Navigator.this.context.mainFrame.labelStatusMiddle.setText(Navigator.this.context.cfg.gs("Navigator.preferences.saved"));
                }
                catch (Exception e) {
                    Navigator.this.logger.error(Utils.getStackTrace(e));
                    JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Save.layout.error.saving.layout") + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                }
            }
        };
        this.context.mainFrame.menuItemSaveLayout.addActionListener(saveLayoutAction);
        this.context.mainFrame.menuItemQuitTerminate.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.verifyClose()) {
                    int r;
                    if (Navigator.this.context.clientStty != null) {
                        r = JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.QuitTerminate.stop.subscriber"), Navigator.this.context.cfg.getNavigatorName(), 0);
                        Navigator.this.quitRemoteSubscriber = r != 1 && r != 2;
                    }
                    if (Navigator.this.context.hintsStty != null) {
                        r = JOptionPane.showConfirmDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.QuitTerminate.stop.hint.status.server"), Navigator.this.context.cfg.getNavigatorName(), 0);
                        Navigator.this.quitRemoteHintStatusServer = r != 1 && r != 2;
                    }
                    Navigator.this.stop();
                }
            }
        });
        if (Utils.isOsMac()) {
            FlatDesktop.setQuitHandler(response -> {
                boolean canQuit = this.context.mainFrame.verifyClose();
                if (canQuit) {
                    this.context.navigator.stop();
                } else {
                    response.cancelQuit();
                }
            });
            this.context.mainFrame.menuItemFileQuit.setVisible(false);
        } else {
            this.context.mainFrame.menuItemFileQuit.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Navigator.this.context.mainFrame.verifyClose()) {
                        Navigator.this.context.navigator.stop();
                    }
                }
            });
            if (!this.context.cfg.isRemoteOperation()) {
                for (Component comp : this.context.mainFrame.menuFile.getComponents()) {
                    if (!(comp instanceof JSeparator) || !((JSeparator)comp).getName().equalsIgnoreCase("separatorQuit")) continue;
                    ((JSeparator)comp).setVisible(false);
                }
            }
        }
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0 && Navigator.this.context.browser.lastComponent != null) {
                    ActionEvent ev = new ActionEvent(Navigator.this.context.browser.lastComponent, 1001, "copy");
                    Navigator.this.context.browser.lastComponent.requestFocus();
                    Navigator.this.context.browser.lastComponent.getActionMap().get(ev.getActionCommand()).actionPerformed(ev);
                }
            }
        };
        this.context.mainFrame.menuItemCopy.addActionListener(copyAction);
        this.context.mainFrame.popupMenuItemCopy.addActionListener(copyAction);
        this.context.mainFrame.menuTbCopy.addActionListener(copyAction);
        AbstractAction cutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0 && Navigator.this.context.browser.lastComponent != null) {
                    ActionEvent ev = new ActionEvent(Navigator.this.context.browser.lastComponent, 1001, "cut");
                    Navigator.this.context.browser.lastComponent.requestFocus();
                    Navigator.this.context.browser.lastComponent.getActionMap().get(ev.getActionCommand()).actionPerformed(ev);
                }
            }
        };
        this.context.mainFrame.menuItemCut.addActionListener(cutAction);
        this.context.mainFrame.popupMenuItemCut.addActionListener(cutAction);
        this.context.mainFrame.menuTbCut.addActionListener(cutAction);
        AbstractAction pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0 && Navigator.this.context.browser.lastComponent != null) {
                    ActionEvent ev = new ActionEvent(Navigator.this.context.browser.lastComponent, 1001, "paste");
                    Navigator.this.context.browser.lastComponent.requestFocus();
                    Navigator.this.context.browser.lastComponent.getActionMap().get(ev.getActionCommand()).actionPerformed(ev);
                }
            }
        };
        this.context.mainFrame.menuItemPaste.addActionListener(pasteAction);
        this.context.mainFrame.popupMenuItemPaste.addActionListener(pasteAction);
        this.context.mainFrame.menuTbPaste.addActionListener(pasteAction);
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0) {
                    JComponent object = Navigator.this.context.browser.lastComponent;
                    if (object instanceof JTree) {
                        JTree sourceTree = (JTree)object;
                        Navigator.this.context.browser.deleteSelected(sourceTree);
                    } else if (object instanceof JTable) {
                        JTable sourceTable = (JTable)object;
                        Navigator.this.context.browser.deleteSelected(sourceTable);
                    }
                }
            }
        };
        this.context.mainFrame.menuItemDelete.addActionListener(deleteAction);
        this.context.mainFrame.popupMenuItemDelete.addActionListener(deleteAction);
        this.context.mainFrame.menuTbDelete.addActionListener(deleteAction);
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0) {
                    String name;
                    Navigator.this.lastFindTab = Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex();
                    if (Navigator.this.lastFindTab == 0) {
                        name = Navigator.this.context.cfg.gs("Navigator.splitPane.Browser.tab.title");
                    } else if (Navigator.this.lastFindTab == 1) {
                        name = "";
                    } else {
                        Navigator.this.lastFindTab = -1;
                        return;
                    }
                    if (Navigator.this.context.mainFrame.textAreaLog.getSelectedText() != null && Navigator.this.context.mainFrame.textAreaLog.getSelectedText().length() > 0) {
                        Navigator.this.lastFindString = Navigator.this.context.mainFrame.textAreaLog.getSelectedText();
                    }
                    Object obj = JOptionPane.showInputDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.popupMenuItemFind.title"), name, 3, null, null, Navigator.this.lastFindString);
                    Navigator.this.lastFindString = (String)obj;
                    if (Navigator.this.lastFindString != null && Navigator.this.lastFindString.length() > 0) {
                        String content = Navigator.this.context.mainFrame.textAreaLog.getText().toLowerCase();
                        Navigator.this.lastFindPosition = content.indexOf(Navigator.this.lastFindString.toLowerCase(), 0);
                        if (Navigator.this.lastFindPosition > 0) {
                            if (Navigator.this.lastFindTab == 0) {
                                Navigator.this.context.mainFrame.tabbedPaneMain.setSelectedIndex(0);
                                Navigator.this.context.mainFrame.textAreaLog.requestFocus();
                                Navigator.this.context.mainFrame.textAreaLog.setSelectionStart(Navigator.this.lastFindPosition);
                                Navigator.this.context.mainFrame.textAreaLog.setSelectionEnd(Navigator.this.lastFindPosition + Navigator.this.lastFindString.length());
                            }
                            Navigator.this.lastFindPosition += Navigator.this.lastFindString.length();
                        } else {
                            Navigator.this.context.mainFrame.labelStatusMiddle.setText(Navigator.this.context.cfg.gs("Navigator.value.not.found"));
                        }
                    }
                }
            }
        };
        this.context.mainFrame.menuItemFind.addActionListener(findAction);
        this.context.mainFrame.popupMenuItemFind.addActionListener(findAction);
        AbstractAction findNextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0) {
                    if (Navigator.this.lastFindTab < 0 || Navigator.this.lastFindString == null || Navigator.this.lastFindString.length() == 0) {
                        return;
                    }
                    String content = Navigator.this.context.mainFrame.textAreaLog.getText().toLowerCase();
                    if (content != null && content.length() > 0) {
                        Navigator.this.lastFindPosition = content.indexOf(Navigator.this.lastFindString.toLowerCase(), Navigator.this.lastFindPosition);
                        if (Navigator.this.lastFindPosition > 0) {
                            if (Navigator.this.lastFindTab == 0) {
                                Navigator.this.context.mainFrame.tabbedPaneMain.setSelectedIndex(0);
                                Navigator.this.context.mainFrame.textAreaLog.requestFocus();
                                try {
                                    Rectangle rect = Navigator.this.context.mainFrame.textAreaLog.modelToView(Navigator.this.lastFindPosition);
                                    Navigator.this.context.mainFrame.textAreaLog.scrollRectToVisible(rect);
                                }
                                catch (Exception e) {
                                    System.out.println("bad scroll position");
                                }
                                Navigator.this.context.mainFrame.textAreaLog.setSelectionStart(Navigator.this.lastFindPosition);
                                Navigator.this.context.mainFrame.textAreaLog.setSelectionEnd(Navigator.this.lastFindPosition + Navigator.this.lastFindString.length());
                            }
                            Navigator.this.lastFindPosition += Navigator.this.lastFindString.length();
                        }
                    }
                }
            }
        };
        this.context.mainFrame.menuItemFindNext.addActionListener(findNextAction);
        this.context.mainFrame.popupMenuItemFindNext.addActionListener(findNextAction);
        AbstractAction newFolderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0) {
                    boolean tooMany = false;
                    JTree tree = null;
                    NavTreeUserObject tuo = null;
                    JComponent object = Navigator.this.context.browser.lastComponent;
                    if (object instanceof JTree) {
                        tree = (JTree)object;
                    } else if (object instanceof JTable) {
                        tree = Navigator.this.context.browser.navTransferHandler.getTargetTree((JTable)object);
                    }
                    assert (tree != null);
                    TreePath[] paths = tree.getSelectionPaths();
                    if (paths.length == 1) {
                        NavTreeNode ntn = (NavTreeNode)paths[0].getLastPathComponent();
                        tuo = ntn.getUserObject();
                    } else {
                        if (paths.length == 0) {
                            return;
                        }
                        tooMany = true;
                    }
                    if (!tooMany) {
                        Object path = Navigator.this.selectLibrarySource(tuo);
                        if (path == null || ((String)path).length() < 1) {
                            JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.New.folder.cannot.create.new.folder.in.current.location"), Navigator.this.context.cfg.getNavigatorName(), 2);
                            return;
                        }
                        if (((String)path).equals("_cancelled_")) {
                            return;
                        }
                        boolean error = false;
                        String reply = "";
                        if (((String)path).length() > 0) {
                            path = Utils.getFullPathLocal((String)path);
                            reply = JOptionPane.showInputDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.New.folder.for") + (String)path + ": ", Navigator.this.context.cfg.getNavigatorName(), 3);
                            if (reply != null && reply.length() > 0) {
                                NavTreeUserObject createdTuo = null;
                                try {
                                    path = (String)path + Utils.getSeparatorFromPath((String)path) + reply;
                                    String msg = Navigator.this.context.cfg.gs("Navigator.menu.New.folder.creating") + (String)(tuo.isRemote ? Navigator.this.context.cfg.gs("Z.remote.lowercase") + " " : "") + Navigator.this.context.cfg.gs("Navigator.menu.New.folder.directory") + ": " + (String)path;
                                    Navigator.this.logger.info(msg);
                                    if (Navigator.this.context.transfer.makeDirs((String)(tuo.isRemote ? (String)path + Utils.getSeparatorFromPath((String)path) + "dummyfile.els" : path), true, tuo.isRemote)) {
                                        NavTreeNode createdNode = new NavTreeNode(Navigator.this.context, tuo.node.getMyRepo(), tree);
                                        if (tuo.isRemote) {
                                            Thread.sleep(1000L);
                                            SftpATTRS attrs = Navigator.this.context.clientSftp.stat((String)path);
                                            createdTuo = new NavTreeUserObject(createdNode, Utils.getRightPath((String)path, null), (String)path, attrs.getSize(), attrs.getMTime(), true);
                                        } else {
                                            createdTuo = new NavTreeUserObject(createdNode, Utils.getRightPath((String)path, null), (String)path, new File((String)path));
                                        }
                                        createdNode.setNavTreeUserObject(createdTuo);
                                        createdNode.setAllowsChildren(true);
                                        createdNode.setVisible(true);
                                        tuo.node.add(createdNode);
                                    } else {
                                        error = true;
                                        Navigator.this.logger.error(Navigator.this.context.cfg.gs("Navigator.menu.New.folder.directory.not.created.check.permissions"));
                                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.New.folder.directory.not.created.check.permissions"), Navigator.this.context.cfg.getNavigatorName(), 2);
                                    }
                                }
                                catch (Exception e) {
                                    Navigator.this.logger.error(Utils.getStackTrace(e));
                                    JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.New.folder.error.creating") + (String)(tuo.isRemote ? Navigator.this.context.cfg.gs("Z.remote.lowercase") + " " : "") + Navigator.this.context.cfg.gs("Navigator.menu.New.folder.directory") + ": " + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                                    error = true;
                                }
                                if (!error) {
                                    Navigator.this.context.browser.refreshByObject(tree);
                                    if (object instanceof JTree) {
                                        tuo.node.selectMe();
                                    } else {
                                        int row;
                                        tuo.node.loadTable();
                                        if (createdTuo != null && (row = Navigator.this.context.browser.findRowIndex((JTable)object, createdTuo)) > -1) {
                                            ((JTable)object).setRowSelectionInterval(row, row);
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.New.folder.please.select.a.single.destination.for.a.new.folder"), Navigator.this.context.cfg.getNavigatorName(), 0);
                    }
                }
            }
        };
        this.context.mainFrame.menuItemNewFolder.addActionListener(newFolderAction);
        this.context.mainFrame.popupMenuItemNewFolder.addActionListener(newFolderAction);
        this.context.mainFrame.menuTbNewFolder.addActionListener(newFolderAction);
        AbstractAction renameAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0) {
                    int[] rows = new int[]{0};
                    boolean tooMany = false;
                    JTree tree = null;
                    NavTreeUserObject tuo = null;
                    JComponent object = Navigator.this.context.browser.lastComponent;
                    if (object instanceof JTree) {
                        tree = (JTree)object;
                        TreePath[] paths = tree.getSelectionPaths();
                        if (paths.length == 1) {
                            NavTreeNode ntn = (NavTreeNode)paths[0].getLastPathComponent();
                            tuo = ntn.getUserObject();
                        } else {
                            if (paths.length == 0) {
                                return;
                            }
                            tooMany = true;
                        }
                    } else if (object instanceof JTable) {
                        tree = Navigator.this.context.browser.navTransferHandler.getTargetTree((JTable)object);
                        rows = ((JTable)object).getSelectedRows();
                        if (rows.length == 1) {
                            tuo = (NavTreeUserObject)((JTable)object).getValueAt(rows[0], 1);
                        } else {
                            if (rows.length == 0) {
                                return;
                            }
                            tooMany = true;
                        }
                    }
                    if (!tooMany) {
                        Object obj;
                        String name = "";
                        String path = "";
                        if (tuo.type != 6) {
                            JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Rename.cannot.rename.current.location"), Navigator.this.context.cfg.getNavigatorName(), 2);
                            return;
                        }
                        name = tuo.name;
                        path = tuo.path;
                        if (Navigator.this.context.navigator.checkForConflicts(tuo, Navigator.this.context.cfg.gs("HintsUI.action.rename"))) {
                            return;
                        }
                        String reply = name;
                        if (path.length() > 0 && (reply = (String)(obj = JOptionPane.showInputDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Rename") + name + " " + Navigator.this.context.cfg.gs("Navigator.menu.Rename.to"), Navigator.this.context.cfg.getNavigatorName(), 3, null, null, reply))) != null && reply.length() > 0) {
                            try {
                                Object to = Utils.getLeftPath(path, null);
                                to = (String)to + Utils.getSeparatorFromPath(path) + reply;
                                Navigator.this.context.transfer.rename(path, (String)to, tuo.isRemote);
                                NavTreeUserObject orig = (NavTreeUserObject)tuo.clone();
                                orig.node = tuo.node;
                                tuo.path = to;
                                tuo.name = reply;
                                if (tuo.file != null) {
                                    tuo.file = new File((String)to);
                                }
                                try {
                                    ((NavTransferHandler)tree.getTransferHandler()).exportHint("mv", orig, tuo);
                                }
                                catch (Exception e) {
                                    Navigator.this.logger.error(Utils.getStackTrace(e));
                                    JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.error.writing.hint") + "  " + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                                }
                                Navigator.this.context.browser.refreshByObject(tree);
                                if (object instanceof JTree) {
                                    tuo.node.selectMe();
                                } else {
                                    ((JTable)object).setRowSelectionInterval(rows[0], rows[0]);
                                    int row = Navigator.this.context.browser.findRowIndex((JTable)object, tuo);
                                    if (row > -1) {
                                        ((JTable)object).scrollRectToVisible(new Rectangle(((JTable)object).getCellRect(row, 0, true)));
                                    }
                                }
                            }
                            catch (Exception e) {
                                Navigator.this.logger.error(Utils.getStackTrace(e));
                                JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Rename.error.renaming") + (String)(tuo.isRemote ? Navigator.this.context.cfg.gs("Z.remote.lowercase") + " " : "") + name + ": " + e.getMessage(), Navigator.this.context.cfg.getNavigatorName(), 0);
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.menu.Rename.please.select.a.single.item.to.be.renamed"), Navigator.this.context.cfg.getNavigatorName(), 0);
                    }
                }
            }
        };
        this.context.mainFrame.menuItemRename.addActionListener(renameAction);
        this.context.mainFrame.popupMenuItemRename.addActionListener(renameAction);
        AbstractAction touchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComponent object = Navigator.this.context.browser.lastComponent;
                if (object instanceof JTree) {
                    JTree sourceTree = (JTree)object;
                    Navigator.this.context.browser.touchSelected(sourceTree);
                } else if (object instanceof JTable) {
                    JTable sourceTable = (JTable)object;
                    Navigator.this.context.browser.touchSelected(sourceTable);
                }
            }
        };
        this.context.mainFrame.menuItemTouch.addActionListener(touchAction);
        this.context.mainFrame.popupMenuItemTouch.addActionListener(touchAction);
        this.context.mainFrame.menuItemProgress.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.progress == null) {
                    ActionListener cancel = new ActionListener(this){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    };
                    Navigator.this.context.progress = new Progress(Navigator.this.context, Navigator.this.context.mainFrame, cancel, false);
                }
                Navigator.this.context.progress.view();
                Navigator.this.context.progress.requestFocus();
                Navigator.this.context.progress.toFront();
            }
        });
        AbstractAction refreshAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0) {
                    Navigator.this.context.browser.rescanByTreeOrTable(Navigator.this.context.browser.lastComponent);
                }
            }
        };
        this.context.mainFrame.menuItemRefresh.addActionListener(refreshAction);
        this.context.mainFrame.popupMenuItemRefresh.addActionListener(refreshAction);
        this.context.mainFrame.menuTbRefresh.addActionListener(refreshAction);
        this.context.mainFrame.radioButtonAutoRefresh.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.preferences.setAutoRefresh(!Navigator.this.context.preferences.isAutoRefresh());
                if (Navigator.this.context.preferences.isAutoRefresh()) {
                    Navigator.this.context.mainFrame.radioButtonAutoRefresh.setSelected(true);
                } else {
                    Navigator.this.context.mainFrame.radioButtonAutoRefresh.setSelected(false);
                }
            }
        });
        if (this.context.preferences.isAutoRefresh()) {
            this.context.mainFrame.radioButtonAutoRefresh.setSelected(true);
        } else {
            this.context.mainFrame.radioButtonAutoRefresh.setSelected(false);
        }
        this.context.mainFrame.menuItemShowHidden.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0) {
                    Navigator.this.context.browser.toggleShowHiddenFiles();
                }
            }
        });
        if (this.context.preferences.isHideHiddenFiles()) {
            this.context.mainFrame.menuItemShowHidden.setSelected(false);
        } else {
            this.context.mainFrame.menuItemShowHidden.setSelected(true);
        }
        this.context.mainFrame.menuItemShowNavigation.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.preferences.setShowNavigation(Navigator.this.context.mainFrame.menuItemShowNavigation.isSelected());
                if (Navigator.this.context.mainFrame.menuItemShowNavigation.isSelected()) {
                    Navigator.this.context.preferences.setShowNavigation(true);
                    Navigator.this.context.mainFrame.panelLocationAndButtons.setVisible(true);
                } else {
                    Navigator.this.context.preferences.setShowNavigation(false);
                    Navigator.this.context.mainFrame.panelLocationAndButtons.setVisible(false);
                }
            }
        });
        if (this.context.preferences.isShowNavigation()) {
            this.context.mainFrame.menuItemShowNavigation.setSelected(true);
        } else {
            this.context.mainFrame.menuItemShowNavigation.setSelected(false);
        }
        this.context.mainFrame.menuItemShowToolbar.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.preferences.setShowToolbar(Navigator.this.context.mainFrame.menuItemShowToolbar.isSelected());
                if (Navigator.this.context.mainFrame.menuItemShowToolbar.isSelected()) {
                    Navigator.this.context.preferences.setShowToolbar(true);
                    Navigator.this.context.mainFrame.panelAlertsMenu.setVisible(false);
                    Navigator.this.context.mainFrame.panelToolbar.setVisible(true);
                } else {
                    Navigator.this.context.preferences.setShowToolbar(false);
                    Navigator.this.context.mainFrame.panelAlertsMenu.setVisible(true);
                    Navigator.this.context.mainFrame.panelToolbar.setVisible(false);
                }
            }
        });
        if (this.context.preferences.isShowToolbar()) {
            this.context.mainFrame.menuItemShowToolbar.setSelected(true);
        } else {
            this.context.mainFrame.menuItemShowToolbar.setSelected(false);
        }
        AbstractAction wordWrapAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.context.mainFrame.tabbedPaneMain.getSelectedIndex() == 0) {
                    boolean selected = false;
                    if (actionEvent.getSource() == Navigator.this.context.mainFrame.menuItemWordWrap) {
                        selected = Navigator.this.context.mainFrame.menuItemWordWrap.isSelected();
                    }
                    if (actionEvent.getSource() == Navigator.this.context.mainFrame.popupCheckBoxMenuItemWordWrap) {
                        selected = Navigator.this.context.mainFrame.popupCheckBoxMenuItemWordWrap.isSelected();
                    }
                    Navigator.this.context.mainFrame.menuItemWordWrap.setSelected(selected);
                    Navigator.this.context.mainFrame.popupCheckBoxMenuItemWordWrap.setSelected(selected);
                    Navigator.this.context.mainFrame.textAreaLog.setLineWrap(Navigator.this.context.mainFrame.menuItemWordWrap.isSelected());
                }
            }
        };
        this.context.mainFrame.menuItemWordWrap.setSelected(true);
        this.context.mainFrame.popupCheckBoxMenuItemWordWrap.setSelected(true);
        this.context.mainFrame.menuItemWordWrap.addActionListener(wordWrapAction);
        this.context.mainFrame.popupCheckBoxMenuItemWordWrap.addActionListener(wordWrapAction);
        this.context.mainFrame.menuItemAddBookmark.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComponent object = Navigator.this.context.browser.lastComponent;
                if (object instanceof JTree) {
                    JTree sourceTree = (JTree)object;
                    Navigator.this.context.browser.bookmarkSelected(sourceTree);
                } else if (object instanceof JTable) {
                    JTable sourceTable = (JTable)object;
                    Navigator.this.context.browser.bookmarkSelected(sourceTable);
                }
            }
        });
        this.context.mainFrame.menuItemBookmarksDelete.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new BookmarksUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
            }
        });
        this.context.mainFrame.menuItemDuplicates.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogDuplicateFinder == null || !Navigator.this.dialogDuplicateFinder.isShowing()) {
                    Navigator.this.dialogDuplicateFinder = new DuplicateFinderUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogDuplicateFinder.setVisible(true);
                } else {
                    Navigator.this.dialogDuplicateFinder.toFront();
                    Navigator.this.dialogDuplicateFinder.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemEmptyFinder.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogEmptyDirectoryFinder == null || !Navigator.this.dialogEmptyDirectoryFinder.isShowing()) {
                    Navigator.this.dialogEmptyDirectoryFinder = new EmptyDirectoryFinderUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogEmptyDirectoryFinder.setVisible(true);
                } else {
                    Navigator.this.dialogEmptyDirectoryFinder.toFront();
                    Navigator.this.dialogEmptyDirectoryFinder.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemArchiver.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogArchiver == null || !Navigator.this.dialogArchiver.isShowing()) {
                    Navigator.this.dialogArchiver = new ArchiverUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogArchiver.setVisible(true);
                } else {
                    Navigator.this.dialogArchiver.toFront();
                    Navigator.this.dialogArchiver.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemCleanup.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogCleanup == null || !Navigator.this.dialogCleanup.isShowing()) {
                    Navigator.this.dialogCleanup = new CleanupUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogCleanup.setVisible(true);
                } else {
                    Navigator.this.dialogCleanup.toFront();
                    Navigator.this.dialogCleanup.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemJunk.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogJunkRemover == null || !Navigator.this.dialogJunkRemover.isShowing()) {
                    Navigator.this.dialogJunkRemover = new JunkRemoverUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogJunkRemover.setVisible(true);
                } else {
                    Navigator.this.dialogJunkRemover.toFront();
                    Navigator.this.dialogJunkRemover.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemOperations.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogOperations == null || !Navigator.this.dialogOperations.isShowing()) {
                    Navigator.this.dialogOperations = new OperationsUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogOperations.setVisible(true);
                } else {
                    Navigator.this.dialogOperations.toFront();
                    Navigator.this.dialogOperations.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemRenamer.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogRenamer == null || !Navigator.this.dialogRenamer.isShowing()) {
                    Navigator.this.dialogRenamer = new RenamerUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogRenamer.setVisible(true);
                } else {
                    Navigator.this.dialogRenamer.toFront();
                    Navigator.this.dialogRenamer.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemSleep.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogSleep == null || !Navigator.this.dialogSleep.isShowing()) {
                    Navigator.this.dialogSleep = new SleepUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogSleep.setVisible(true);
                } else {
                    Navigator.this.dialogSleep.toFront();
                    Navigator.this.dialogSleep.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemJobsManage.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogJobs == null || !Navigator.this.dialogJobs.isShowing()) {
                    Navigator.this.dialogJobs = new JobsUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogJobs.setVisible(true);
                } else {
                    Navigator.this.dialogJobs.setVisible(true);
                    Navigator.this.dialogJobs.toFront();
                    Navigator.this.dialogJobs.requestFocus();
                }
            }
        });
        this.context.mainFrame.menuItemHints.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.enableDisableSystemMenus(FileEditor.EditorTypes.Hints, false);
                if (Navigator.this.dialogHints != null && Navigator.this.dialogHints.isShowing()) {
                    Navigator.this.dialogHints.toFront();
                } else {
                    Navigator.this.dialogHints = new HintsUI(Navigator.this.context);
                }
            }
        });
        this.context.mainFrame.menuItemAuthKeys.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.fileeditor != null && Navigator.this.fileeditor.isShowing()) {
                    Navigator.this.fileeditor.requestFocus();
                } else {
                    Navigator.this.fileeditor = new FileEditor(Navigator.this.context, FileEditor.EditorTypes.Authentication);
                }
            }
        });
        this.context.mainFrame.menuItemHintKeys.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.fileeditor != null && Navigator.this.fileeditor.isShowing()) {
                    Navigator.this.fileeditor.requestFocus();
                } else {
                    Navigator.this.fileeditor = new FileEditor(Navigator.this.context, FileEditor.EditorTypes.HintKeys);
                }
            }
        });
        this.context.mainFrame.menuItemBlacklist.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.fileeditor != null && Navigator.this.fileeditor.isShowing()) {
                    Navigator.this.fileeditor.requestFocus();
                } else {
                    Navigator.this.fileeditor = new FileEditor(Navigator.this.context, FileEditor.EditorTypes.BlackList);
                }
            }
        });
        this.context.mainFrame.menuItemWhitelist.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.fileeditor != null && Navigator.this.fileeditor.isShowing()) {
                    Navigator.this.fileeditor.requestFocus();
                } else {
                    Navigator.this.fileeditor = new FileEditor(Navigator.this.context, FileEditor.EditorTypes.WhiteList);
                }
            }
        });
        this.context.mainFrame.menuItemEmail.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Navigator.this.dialogEmail == null || !Navigator.this.dialogEmail.isShowing()) {
                    Navigator.this.dialogEmail = new EmailUI((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    Navigator.this.dialogEmail.setVisible(true);
                } else {
                    Navigator.this.dialogEmail.toFront();
                    Navigator.this.dialogEmail.requestFocus();
                }
            }
        });
        if (Utils.isOsMac()) {
            FlatDesktop.setPreferencesHandler(() -> {
                if (this.dialogSettings == null || !this.dialogSettings.isShowing()) {
                    this.dialogSettings = new Settings((Window)this.context.mainFrame, this.context);
                    this.dialogSettings.setVisible(true);
                } else {
                    this.dialogSettings.toFront();
                    this.dialogSettings.requestFocus();
                }
            });
            for (Component comp : this.context.mainFrame.menuSystem.getComponents()) {
                if (!(comp instanceof JSeparator) || !((JSeparator)comp).getName().equalsIgnoreCase("separatorSettings")) continue;
                ((JSeparator)comp).setVisible(false);
            }
            this.context.mainFrame.menuItemSettings.setVisible(false);
        } else {
            this.context.mainFrame.menuItemSettings.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Navigator.this.dialogSettings == null || !Navigator.this.dialogSettings.isShowing()) {
                        Navigator.this.dialogSettings = new Settings((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                        Navigator.this.dialogSettings.setVisible(true);
                    } else {
                        Navigator.this.dialogSettings.toFront();
                        Navigator.this.dialogSettings.requestFocus();
                    }
                }
            });
        }
        this.context.mainFrame.menuItemMaximize.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.mainFrame.setExtendedState(Navigator.this.context.mainFrame.getExtendedState() | 6);
            }
        });
        this.context.mainFrame.menuItemMinimize.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.mainFrame.setState(1);
            }
        });
        this.context.mainFrame.menuItemRestore.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.mainFrame.setExtendedState(0);
            }
        });
        this.context.mainFrame.menuItemSplitHorizontal.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.mainFrame.tabbedPaneBrowserOne.setVisible(true);
                Navigator.this.context.mainFrame.tabbedPaneBrowserTwo.setVisible(true);
                int size = Navigator.this.context.mainFrame.splitPaneTwoBrowsers.getHeight();
                Navigator.this.context.mainFrame.splitPaneTwoBrowsers.setOrientation(0);
                Navigator.this.context.mainFrame.splitPaneTwoBrowsers.setDividerLocation(size / 2);
            }
        });
        this.context.mainFrame.menuItemSplitVertical.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.mainFrame.tabbedPaneBrowserOne.setVisible(true);
                Navigator.this.context.mainFrame.tabbedPaneBrowserTwo.setVisible(true);
                int size = Navigator.this.context.mainFrame.splitPaneTwoBrowsers.getWidth();
                Navigator.this.context.mainFrame.splitPaneTwoBrowsers.setOrientation(1);
                Navigator.this.context.mainFrame.splitPaneTwoBrowsers.setDividerLocation(size / 2);
            }
        });
        this.context.mainFrame.menuItemControls.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavHelp dialog = new NavHelp(Navigator.this.context.mainFrame, Navigator.this.context.mainFrame, Navigator.this.context, Navigator.this.context.cfg.gs("Navigator.controls.help.title"), "controls_" + Navigator.this.context.preferences.getLocale() + ".html", false);
                if (!dialog.fault) {
                    dialog.buttonFocus();
                }
            }
        });
        this.context.mainFrame.menuItemGettingStarted.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavHelp dialog = new NavHelp(Navigator.this.context.mainFrame, Navigator.this.context.mainFrame, Navigator.this.context, Navigator.this.context.cfg.gs("Navigator.getting.started"), "gettingstarted_" + Navigator.this.context.preferences.getLocale() + ".html", false);
                if (!dialog.fault) {
                    dialog.buttonFocus();
                }
            }
        });
        this.context.mainFrame.menuItemWebSite.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URI uri = new URI("https://www.elsnavigator.com/");
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.error.launching.browser"), Navigator.this.context.cfg.getNavigatorName(), 0);
                }
            }
        });
        this.context.mainFrame.menuItemDiscussions.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URI uri = new URI("https://github.com/Corionis/ELS/discussions");
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.error.launching.browser"), Navigator.this.context.cfg.getNavigatorName(), 0);
                }
            }
        });
        this.context.mainFrame.menuItemDocumentation.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URI uri = new URI("https://github.com/Corionis/ELS/wiki");
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.error.launching.browser"), Navigator.this.context.cfg.getNavigatorName(), 0);
                }
            }
        });
        this.context.mainFrame.menuItemGitHubProject.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URI uri = new URI("https://github.com/Corionis/ELS");
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.error.launching.browser"), Navigator.this.context.cfg.getNavigatorName(), 0);
                }
            }
        });
        this.context.mainFrame.menuItemIssue.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URI uri = new URI("https://github.com/Corionis/ELS/issues");
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Navigator.this.context.mainFrame, Navigator.this.context.cfg.gs("Navigator.error.launching.browser"), Navigator.this.context.cfg.getNavigatorName(), 0);
                }
            }
        });
        this.context.mainFrame.menuItemChangelist.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavHelp dialog = new NavHelp(Navigator.this.context.mainFrame, Navigator.this.context.mainFrame, Navigator.this.context, Navigator.this.context.cfg.gs("Navigator.changes.help.title"), "changes_" + Navigator.this.context.preferences.getLocale() + ".html", false);
                if (!dialog.fault) {
                    dialog.buttonFocus();
                }
            }
        });
        this.context.mainFrame.menuItemReleaseNotes.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavHelp helpDialog = new NavHelp(Navigator.this.context.mainFrame, Navigator.this.context.mainFrame, Navigator.this.context, Navigator.this.context.cfg.gs("Navigator.release.notes"), "releasenotes_" + Navigator.this.context.preferences.getLocale() + ".html", false);
                if (!helpDialog.fault) {
                    helpDialog.buttonFocus();
                }
            }
        });
        this.context.mainFrame.menuItemUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.main.checkForUpdates(false);
            }
        });
        if (Utils.isOsMac()) {
            FlatDesktop.setAboutHandler(() -> {
                About about = new About((Window)this.context.mainFrame, this.context);
                about.setVisible(true);
            });
            this.context.mainFrame.menuItemAbout.setVisible(false);
        } else {
            this.context.mainFrame.menuItemAbout.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    About about = new About((Window)Navigator.this.context.mainFrame, Navigator.this.context);
                    about.setVisible(true);
                }
            });
        }
        this.context.mainFrame.popupMenuItemBottom.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar vertical = Navigator.this.context.mainFrame.scrollPaneLog.getVerticalScrollBar();
                vertical.setValue(vertical.getMaximum());
            }
        });
        this.context.mainFrame.popupMenuItemClear.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Navigator.this.context.mainFrame.textAreaLog.setText("");
            }
        });
        this.context.mainFrame.popupMenuItemTop.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar vertical = Navigator.this.context.mainFrame.scrollPaneLog.getVerticalScrollBar();
                vertical.setValue(0);
            }
        });
        MouseAdapter mad = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Navigator.this.context.mainFrame.menuItemHints.doClick();
            }
        };
        this.context.mainFrame.labelAlertHintsMenu.addMouseListener(mad);
        this.context.mainFrame.labelAlertHintsToolbar.addMouseListener(mad);
        mad = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Navigator.this.context.main.checkForUpdates(false);
            }
        };
        this.context.mainFrame.labelAlertUpdateMenu.addMouseListener(mad);
        this.context.mainFrame.labelAlertUpdateToolbar.addMouseListener(mad);
    }

    public boolean isBlockingProcessRunning() {
        return this.blockingProcessRunning;
    }

    public boolean isLogger() {
        return this.context.cfg.isLoggerView();
    }

    public boolean isUpdaterProcess() {
        return this.updaterProcess;
    }

    public boolean isWorkerRunning() {
        return this.workerRunning;
    }

    public void loadBookmarksMenu() {
        int i;
        JMenu menu = this.context.mainFrame.menuBookmarks;
        int count = menu.getItemCount();
        if (count > 3) {
            for (i = count - 1; i > 2; --i) {
                menu.remove(i);
            }
        }
        this.readBookmarks();
        count = this.bookmarks.size();
        if (count > 0) {
            this.bookmarks.sort();
            for (i = 0; i < count; ++i) {
                JMenuItem item = new JMenuItem(this.bookmarks.get((int)i).name);
                item.setHorizontalAlignment(10);
                item.setHorizontalTextPosition(11);
                item.setMargin(new Insets(2, 18, 2, 2));
                item.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Bookmark bm;
                        JMenuItem selected = (JMenuItem)actionEvent.getSource();
                        String name = selected.getText();
                        int index = Navigator.this.findMenuItemIndex(Navigator.this.context.mainFrame.menuBookmarks, selected) - 3;
                        if (index >= 0 && index < Navigator.this.bookmarks.size() && (bm = Navigator.this.bookmarks.get(index)) != null) {
                            Navigator.this.context.browser.bookmarkGoto(bm);
                        }
                    }
                });
                menu.add(item);
            }
        }
    }

    public void loadJobsMenu() {
        File[] files;
        Job tmpJob;
        File jobsDir;
        int OffsetCount = 2;
        JMenu menu = this.context.mainFrame.menuJobs;
        int count = menu.getItemCount();
        if (count > 2) {
            for (int i = count - 1; i > 1; --i) {
                menu.remove(i);
            }
        }
        if ((jobsDir = new File((tmpJob = new Job(this.context, "temp")).getDirectoryPath())).exists() && (files = FileSystemView.getFileSystemView().getFiles(jobsDir, true)).length > 0) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new Job(Navigator.this.context, "");
                }
            }
            builder.registerTypeAdapter((Type)((Object)Job.class), new ObjInstanceCreator());
            int index = 0;
            this.jobs = new Job[files.length];
            for (File entry : files) {
                if (entry.isDirectory()) continue;
                try {
                    Job job;
                    String json = new String(Files.readAllBytes(Paths.get(entry.getPath(), new String[0])));
                    if (json == null || (job = builder.create().fromJson(json, Job.class)) == null) continue;
                    this.jobs[index++] = job;
                }
                catch (Exception e) {
                    String msg = this.context.cfg.gs("Z.exception") + entry.getName() + ", " + Utils.getStackTrace(e);
                    this.logger.error(msg);
                    JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.getNavigatorName(), 0);
                }
            }
            Arrays.sort(this.jobs);
            for (int i = 0; i < this.jobs.length; ++i) {
                JMenuItem item = new JMenuItem(this.jobs[i].getConfigName());
                item.setHorizontalAlignment(10);
                item.setHorizontalTextPosition(11);
                item.setMargin(new Insets(2, 18, 2, 2));
                item.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JMenuItem selected = (JMenuItem)actionEvent.getSource();
                        int index = Navigator.this.findMenuItemIndex(Navigator.this.context.mainFrame.menuJobs, selected) - 2;
                        if (index >= 0) {
                            Job job = Navigator.this.jobs[index];
                            Navigator.this.processJob(job);
                        }
                    }
                });
                menu.add(item);
            }
        }
    }

    private void processJob(final Job job) {
        String status = job.validate(this.context.cfg, true);
        if (status.length() == 0) {
            String message = MessageFormat.format(this.context.cfg.gs("JobsUI.run.as.defined"), job.getConfigName());
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(0, 4, 8));
            final JCheckBox checkbox = new JCheckBox(this.context.cfg.gs("Navigator.dryrun") + "        ");
            checkbox.setToolTipText(this.context.cfg.gs("Navigator.dryrun.tooltip"));
            checkbox.setSelected(this.context.preferences.isDefaultDryrun());
            final JButton generateButton = new JButton(this.context.cfg.gs("JobsUI.buttonGenerate.text"));
            generateButton.setToolTipText(this.context.cfg.gs("JobsUI.buttonGenerate.toolTipText"));
            generateButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Generator generator = new Generator(Navigator.this.context, false);
                    generator.setDryRunPreset(checkbox.isSelected() ? 1 : 0);
                    Window w = SwingUtilities.getWindowAncestor(generateButton);
                    if (w != null) {
                        w.setVisible(false);
                    }
                    generator.showDialog(null, job, job.getConfigName());
                }
            });
            panel.add(checkbox);
            panel.add(generateButton);
            Object[] params = new Object[]{message, panel};
            int reply = JOptionPane.showConfirmDialog(this.context.mainFrame, params, this.context.cfg.getNavigatorName(), 2);
            final boolean isDryRun = checkbox.isSelected();
            if (reply == 0) {
                block8: {
                    try {
                        this.originsArray = Origins.makeAllOrigins(this.context, this.context.mainFrame);
                    }
                    catch (Exception e) {
                        if (e.getMessage().equals("HANDLED_INTERNALLY")) break block8;
                        String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                        if (this.context.navigator != null) {
                            this.logger.error(msg);
                            JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.gs("JobsUI.title"), 0);
                        }
                        this.logger.error(msg);
                    }
                }
                this.worker = job.process(this.context, this.context.mainFrame, this.context.cfg.getNavigatorName(), job, isDryRun);
                if (this.worker != null) {
                    this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                    this.disableComponent(false, this.context.mainFrame.getContentPane());
                    this.context.mainFrame.tabbedPaneMain.setSelectedIndex(0);
                    this.context.mainFrame.menuItemFileQuit.setEnabled(true);
                    this.setBlockingProcessRunning(true);
                    this.setWorkerRunning(true);
                    this.disableGui(true);
                    this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            if (e.getPropertyName().equals("state") && e.getNewValue() == SwingWorker.StateValue.DONE) {
                                Navigator.this.processTerminated(job, isDryRun);
                            }
                        }
                    });
                    this.worker.execute();
                    JScrollBar vertical = this.context.mainFrame.scrollPaneLog.getVerticalScrollBar();
                    vertical.setValue(vertical.getMaximum());
                } else {
                    this.processTerminated(job, isDryRun);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.context.mainFrame, status, this.context.cfg.getNavigatorName(), 2);
        }
    }

    private void processLoggerJob() {
        try {
            Job tmpJob = new Job(this.context, this.context.cfg.getJobName());
            final Job job = tmpJob.load(this.context.cfg.getJobName());
            if (job == null) {
                this.logger.error(this.context.cfg.gs("Navigator.job") + this.context.cfg.getJobName() + this.context.cfg.gs("Navigator.could.not.be.loaded"));
            } else {
                this.worker = job.process(this.context, this.context.mainFrame, this.context.cfg.getNavigatorName(), job, this.context.cfg.isDryRun());
                if (this.worker != null) {
                    this.setBlockingProcessRunning(true);
                    this.setWorkerRunning(true);
                    this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                    this.disableComponent(false, this.context.mainFrame.getContentPane());
                    this.disableGui(true);
                    this.context.mainFrame.labelAlertHintsMenu.setVisible(false);
                    this.context.mainFrame.labelAlertUpdateMenu.setVisible(false);
                    this.context.mainFrame.tabbedPaneMain.setTitleAt(0, job.getConfigName());
                    this.context.mainFrame.tabbedPaneMain.remove(1);
                    this.context.mainFrame.tabbedPaneMain.repaint();
                    this.context.mainFrame.tabbedPaneNavigatorBottom.setEnabledAt(1, false);
                    this.context.mainFrame.tabbedPaneNavigatorBottom.remove(1);
                    this.context.mainFrame.tabbedPaneNavigatorBottom.repaint();
                    this.context.mainFrame.menuFile.removeAll();
                    this.context.mainFrame.menuFile.add(this.context.mainFrame.menuItemFileQuit);
                    this.context.mainFrame.menuItemFileQuit.setEnabled(true);
                    this.context.mainFrame.menuEdit.removeAll();
                    this.context.mainFrame.menuEdit.add(this.context.mainFrame.menuItemFind);
                    this.context.mainFrame.menuItemFind.setEnabled(true);
                    this.context.mainFrame.menuEdit.add(this.context.mainFrame.menuItemFindNext);
                    this.context.mainFrame.menuItemFindNext.setEnabled(true);
                    this.context.mainFrame.menuView.removeAll();
                    this.context.mainFrame.menuView.add(this.context.mainFrame.menuItemWordWrap);
                    this.context.mainFrame.menuItemWordWrap.setEnabled(true);
                    this.context.mainFrame.menuBookmarks.setVisible(false);
                    this.context.mainFrame.menuTools.setVisible(false);
                    this.context.mainFrame.menuJobs.setVisible(false);
                    this.context.mainFrame.menuSystem.setVisible(false);
                    this.context.mainFrame.menuWindows.setVisible(false);
                    this.context.mainFrame.menuItemUpdates.setVisible(false);
                    this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            if (e.getPropertyName().equals("state") && e.getNewValue() == SwingWorker.StateValue.DONE) {
                                Navigator.this.processTerminated(job, Navigator.this.context.cfg.isDryRun());
                            }
                        }
                    });
                    this.worker.execute();
                    JScrollBar vertical = this.context.mainFrame.scrollPaneLog.getVerticalScrollBar();
                    vertical.setValue(vertical.getMaximum());
                } else {
                    this.processTerminated(job, this.context.cfg.isDryRun());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
        }
    }

    private void processTerminated(Job job, boolean isDryRun) {
        try {
            this.context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            if (!isDryRun && !this.isLogger()) {
                if (job.usesPublisher() && this.context.publisherRepo != null) {
                    if (this.context.progress != null) {
                        this.context.progress.update(this.context.cfg.gs("Navigator.scanning.publisher"));
                    }
                    this.context.browser.deepScanCollectionTree(this.context.mainFrame.treeCollectionOne, this.context.publisherRepo, false, false);
                    this.context.browser.deepScanSystemTree(this.context.mainFrame.treeSystemOne, this.context.publisherRepo, false, false);
                }
                if (job.usesSubscriber() && this.context.subscriberRepo != null) {
                    if (this.context.progress != null) {
                        this.context.progress.update(this.context.cfg.gs("Navigator.scanning.subscriber"));
                    }
                    this.context.browser.deepScanCollectionTree(this.context.mainFrame.treeCollectionTwo, this.context.subscriberRepo, this.context.cfg.isRemoteOperation(), false);
                    this.context.browser.deepScanSystemTree(this.context.mainFrame.treeSystemTwo, this.context.subscriberRepo, this.context.cfg.isRemoteOperation(), false);
                }
            }
            if (this.context.progress != null) {
                this.context.progress.done();
                this.context.progress.dispose();
                this.context.progress = null;
            }
            this.setBlockingProcessRunning(false);
            if (this.originsArray != null && this.originsArray.size() == 8) {
                Origins.setAllOrigins(this.context, this.context.mainFrame, this.originsArray);
            }
            if (!this.isLogger()) {
                this.disableGui(false);
                this.reconnectRemote(this.context, this.context.publisherRepo, this.context.subscriberRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (job.isRequestStop()) {
            this.logger.info(job.getConfigName() + this.context.cfg.gs("Z.cancelled"));
            this.context.mainFrame.labelStatusMiddle.setText(job.getConfigName() + this.context.cfg.gs("Z.cancelled"));
            this.setWorkerRunning(false);
        } else if (!this.context.main.isListening()) {
            String msg = MessageFormat.format(this.context.cfg.gs(this.context.fault ? "Job.failed.job" : "Job.completed.job"), job.getConfigName() + (this.context.cfg.isDryRun() ? this.context.cfg.gs("Z.dry.run") : ""));
            this.logger.info(msg);
            this.context.mainFrame.labelStatusMiddle.setText(msg);
            this.context.main.stopVerbiage();
            this.setWorkerRunning(false);
        }
    }

    public void quitByeRemotes(boolean elsListener, boolean hintStatusServer) {
        boolean closure = false;
        if (elsListener && this.context.clientStty != null) {
            try {
                closure = true;
                if (this.context.clientSftp != null) {
                    this.context.clientSftp.stopClient();
                }
                if (this.context.clientSftpMetadata != null) {
                    this.context.clientSftpMetadata.stopClient();
                }
                if (this.context.clientStty != null && this.context.clientStty.isConnected() && !this.context.timeout) {
                    this.logger.info(this.context.cfg.gs("Main.disconnecting.stty"));
                    if (this.context.fault) {
                        String resp;
                        try {
                            resp = this.context.clientStty.roundTrip("fault", "Sending fault to remote", 1000);
                        }
                        catch (Exception e) {
                            resp = null;
                        }
                    } else if (this.quitRemoteSubscriber) {
                        this.context.clientStty.send("quit", "Sending quit command to remote subscriber");
                    } else {
                        this.context.clientStty.send("bye", "Sending bye command to remote subscriber");
                    }
                    this.context.clientStty.disconnect();
                }
                this.context.clientStty = null;
                this.context.clientSftp = null;
            }
            catch (Exception e) {
                this.context.clientStty = null;
                this.logger.error(Utils.getStackTrace(e));
            }
        }
        if (hintStatusServer && this.context.cfg.isRemoteStatusServer()) {
            try {
                closure = true;
                this.logger.info(this.context.cfg.gs("Main.disconnecting.status.server"));
                if (this.quitRemoteHintStatusServer) {
                    this.context.hintsStty.send("quit", "Sending quit command to remote Hint Status Server");
                } else {
                    this.context.hintsStty.send("bye", "Sending bye command to remote Hint Status Server");
                }
                this.context.hintsStty.disconnect();
                this.context.hintsStty = null;
            }
            catch (Exception e) {
                this.logger.error(Utils.getStackTrace(e));
            }
        }
        if (closure && elsListener && hintStatusServer) {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readBookmarks() {
        try {
            Gson gson = new Gson();
            String json = new String(Files.readAllBytes(Paths.get(this.bookmarks.getFullPath(), new String[0])));
            this.bookmarks = (Bookmarks)gson.fromJson(json, this.bookmarks.getClass());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean reconnectRemote(Context context, Repository publisherRepo, Repository subscriberRepo) throws Exception {
        if (context.cfg.isRemoteOperation() && subscriberRepo != null && context.clientStty != null && context.clientStty.getTheirKey().equals(subscriberRepo.getLibraryData().libraries.key) && context.clientStty.isConnected()) {
            return true;
        }
        if (context.cfg.isRemoteSubscriber()) {
            try {
                context.clientStty.send("bye", "");
                context.clientSftp.stopClient();
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        context.main.connectHints(context.publisherRepo);
        if (context.cfg.isRemoteOperation()) {
            context.clientStty = new ClientStty(context, false, true, false);
            if (!context.clientStty.connect(publisherRepo, subscriberRepo)) {
                context.cfg.setOperation("-");
                if (context.navigator != null) {
                    JOptionPane.showMessageDialog(context.mainFrame, context.cfg.gs("Navigator.menu.Open.subscriber.remote.subscriber.failed.to.connect"), context.cfg.getNavigatorName(), 0);
                }
                return false;
            }
            if (context.clientStty.checkBannerCommands()) {
                this.logger.info(context.cfg.gs("Transfer.received.subscriber.commands") + (context.cfg.isRequestCollection() ? "RequestCollection " : "") + (context.cfg.isRequestTargets() ? "RequestTargets" : ""));
            }
            String directory = context.clientStty.getWorkingDirectoryRemote();
            context.cfg.setWorkingDirectorySubscriber(directory);
            context.clientSftp = new ClientSftp(context, publisherRepo, subscriberRepo, true);
            if (!context.clientSftp.startClient("transfer")) {
                context.cfg.setOperation("-");
                if (context.navigator != null) {
                    JOptionPane.showMessageDialog(context.mainFrame, context.cfg.gs("Navigator.menu.Open.subscriber.subscriber.sftp.failed.to.connect"), context.cfg.getNavigatorName(), 0);
                }
                return false;
            }
            context.clientSftpMetadata = new ClientSftp(context, context.publisherRepo, context.subscriberRepo, true);
            if (!context.clientSftpMetadata.startClient("metadata")) {
                if (context.navigator != null) {
                    JOptionPane.showMessageDialog(context.mainFrame, context.cfg.gs("Navigator.menu.Open.subscriber.subscriber.sftp.failed.to.connect"), context.cfg.getNavigatorName(), 0);
                }
                return false;
            }
        } else {
            context.cfg.setWorkingDirectorySubscriber(context.cfg.getWorkingDirectory());
        }
        return true;
    }

    public String reduceCollectionPath(NavTreeUserObject tuo) {
        String path = null;
        Repository repo = null;
        if (tuo.node.getMyTree().getName().contains("Collection") && (repo = tuo.getRepo()) != null) {
            String tuoPath;
            String string = tuoPath = repo.getLibraryData().libraries.case_sensitive != false ? tuo.path : tuo.path.toLowerCase();
            if (tuoPath.length() == 0) {
                path = "";
            } else {
                tuoPath = Utils.pipe(tuoPath);
                for (Library lib : repo.getLibraryData().libraries.bibliography) {
                    String[] stringArray = lib.sources;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String source;
                        String sourcePath = source = stringArray[i];
                        if (!Utils.isRelativePath(tuoPath)) {
                            if (repo.getPurpose() == 1) {
                                sourcePath = Utils.getFullPathLocal(sourcePath);
                            } else if (repo.getPurpose() == 2) {
                                sourcePath = this.context.cfg.getFullPathSubscriber(sourcePath);
                            }
                            if (sourcePath.matches("^\\\\[a-zA-Z]:.*") || sourcePath.matches("^/[a-zA-Z]:.*")) {
                                sourcePath = sourcePath.substring(1);
                            }
                        }
                        sourcePath = repo.getLibraryData().libraries.case_sensitive != false ? sourcePath : sourcePath.toLowerCase();
                        if (!tuoPath.startsWith(sourcePath = Utils.pipe(sourcePath))) continue;
                        path = tuo.path.substring(sourcePath.length() + 1);
                        break;
                    }
                    if (path != null) break;
                }
            }
        }
        if (path == null) {
            path = tuo.path;
        } else if (repo != null) {
            path = Utils.unpipe(path, repo.getSeparator());
        }
        return path;
    }

    public int run() throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Navigator.this.context.cfg.getOriginalCommandline().contains("-y")) {
                    Navigator.this.context.preferences.setPreserveFileTimes(Navigator.this.context.cfg.isPreserveDates());
                } else {
                    Navigator.this.context.preferences.setPreserveFileTimes(Navigator.this.context.preferences.isPreserveFileTimes());
                }
                if (Navigator.this.context.cfg.getOriginalCommandline().contains("-z")) {
                    Navigator.this.context.cfg.setLongScale(Navigator.this.context.cfg.isBinaryScale());
                } else {
                    Navigator.this.context.cfg.setLongScale(Navigator.this.context.preferences.isBinaryScale());
                }
                if (Navigator.this.initialize()) {
                    Navigator.this.logger.trace(Navigator.this.context.cfg.gs("Navigator.initialized"));
                    Navigator.this.context.preferences.fixApplication(Navigator.this.context);
                    for (ActionListener listener : Navigator.this.context.mainFrame.buttonHintTracking.getActionListeners()) {
                        listener.actionPerformed(new ActionEvent(Navigator.this.context.mainFrame.buttonHintTracking, 1001, null));
                    }
                    String os = Utils.getOS();
                    Navigator.this.logger.debug(Navigator.this.context.cfg.gs("Navigator.detected.local.system.as") + os);
                    if (!Navigator.this.isLogger()) {
                        if (Navigator.this.context.main.checkForUpdates(true)) {
                            Navigator.this.logger.info(Navigator.this.context.cfg.gs("Navigator.update.available"));
                            Navigator.this.context.mainFrame.labelStatusMiddle.setText(Navigator.this.context.cfg.gs("Navigator.update.available"));
                            Navigator.this.context.mainFrame.labelAlertUpdateMenu.setVisible(true);
                            Navigator.this.context.mainFrame.labelAlertUpdateToolbar.setVisible(true);
                        } else {
                            Navigator.this.logger.info(Navigator.this.context.cfg.gs("Navigator.installed.up.to.date"));
                            Navigator.this.context.mainFrame.labelStatusMiddle.setText(Navigator.this.context.cfg.gs("Navigator.installed.up.to.date"));
                            Navigator.this.context.mainFrame.labelAlertUpdateMenu.setVisible(false);
                            Navigator.this.context.mainFrame.labelAlertUpdateToolbar.setVisible(false);
                        }
                        Navigator.this.checkForHints();
                    }
                    if (Navigator.this.context.preferences.isShowNavigation() && !Navigator.this.isLogger()) {
                        Navigator.this.context.mainFrame.panelLocationAndButtons.setVisible(true);
                    } else {
                        Navigator.this.context.mainFrame.panelLocationAndButtons.setVisible(false);
                    }
                    if (Navigator.this.context.preferences.isShowToolbar() && !Navigator.this.isLogger()) {
                        Navigator.this.context.mainFrame.panelAlertsMenu.setVisible(false);
                        Navigator.this.context.mainFrame.panelToolbar.setVisible(true);
                    } else {
                        Navigator.this.context.mainFrame.panelAlertsMenu.setVisible(true);
                        Navigator.this.context.mainFrame.panelToolbar.setVisible(false);
                    }
                    Navigator.this.context.mainFrame.setVisible(true);
                    Navigator.this.context.preferences.fixBrowserDivider(Navigator.this.context, -1);
                    Navigator.this.context.mainFrame.treeCollectionOne.requestFocus();
                    if (Navigator.this.context.cfg.isLoggerView()) {
                        Navigator.this.context.navigator.processLoggerJob();
                    }
                } else {
                    Navigator.this.context.mainFrame = null;
                    Navigator.this.context.fault = true;
                    Navigator.this.stop();
                }
            }
        });
        return 0;
    }

    private String selectLibrarySource(NavTreeUserObject tuo) {
        String path = "";
        if (tuo.type == 6) {
            path = tuo.path;
        } else if (tuo.type == 5) {
            if (tuo.sources.length == 1) {
                path = tuo.sources[0];
            } else {
                try {
                    String message = MessageFormat.format(this.context.cfg.gs("Navigator.menu.New.folder.select.library.source"), tuo.sources.length, tuo.name);
                    JList sources = new JList();
                    DefaultListModel<CallSite> listModel = new DefaultListModel<CallSite>();
                    sources.setModel(listModel);
                    sources.setSelectionMode(0);
                    for (String src : tuo.sources) {
                        long space = this.context.transfer.getFreespace(src, tuo.isRemote);
                        String line = src + "  " + Utils.formatLong(space, false, this.context.cfg.getLongScale()) + this.context.cfg.gs("Navigator.newFolder.free");
                        listModel.addElement((CallSite)((Object)line));
                    }
                    sources.setSelectedIndex(0);
                    JScrollPane pane = new JScrollPane();
                    pane.setViewportView(sources);
                    sources.requestFocus();
                    Object[] params = new Object[]{message, pane};
                    int opt = JOptionPane.showConfirmDialog(this.context.mainFrame, params, this.context.cfg.getNavigatorName(), 2);
                    if (opt == 0) {
                        int index = sources.getSelectedIndex();
                        path = tuo.sources[index];
                    } else {
                        path = "_cancelled_";
                    }
                }
                catch (Exception e) {
                    this.logger.error(this.context.cfg.gs("Z.exception") + e.getMessage());
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.exception") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                }
            }
        }
        return path;
    }

    public void setBlockingProcessRunning(boolean blockingProcessRunning) {
        this.blockingProcessRunning = blockingProcessRunning;
    }

    private boolean setFileChooserHostListen(JFileChooser fc, JLabel hostField, JLabel listenField) {
        String host = "";
        String listen = "";
        try {
            Repository repo = new Repository(this.context, 2);
            repo.read(fc.getSelectedFile().getPath(), "Subscriber", true);
            host = repo.getLibraryData().libraries.host;
            listen = repo.getLibraryData().libraries.listen;
        }
        catch (Exception e) {
            hostField.setText("");
            listenField.setText("");
            return false;
        }
        hostField.setText(host);
        listenField.setText(listen);
        return true;
    }

    private void setQuitTerminateVisibility() {
        if (this.context.cfg.isRemoteActive()) {
            this.context.mainFrame.menuItemQuitTerminate.setVisible(true);
        } else {
            this.context.mainFrame.menuItemQuitTerminate.setVisible(false);
        }
    }

    public void setUpdaterProcess(String updaterJar) {
        this.updaterJar = updaterJar;
        this.updaterProcess = true;
    }

    public void setWorkerRunning(boolean sense) {
        this.workerRunning = sense;
    }

    public void stop() {
        if (this.context.cfg.isRemoteActive()) {
            this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Navigator.disconnecting"));
            Graphics gfx = this.context.mainFrame.labelStatusMiddle.getGraphics();
            if (gfx != null) {
                this.context.mainFrame.labelStatusMiddle.update(gfx);
            }
            this.context.mainFrame.labelStatusMiddle.repaint();
            Timer time = new Timer(1500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Navigator.this.stopNavigator();
                }
            });
            time.start();
        } else {
            this.stopNavigator();
        }
    }

    private void stopNavigator() {
        this.quitByeRemotes(true, true);
        if (this.dialogEmail != null && this.dialogEmail.getEmailHandler() != null && this.dialogEmail.getEmailHandler().isWorkerRunning()) {
            this.dialogEmail.getEmailHandler().interrupt();
        }
        if (this.context.mainFrame != null) {
            if (!this.context.main.secondaryNavigator && !this.isLogger()) {
                try {
                    this.context.libraries.savePreferences();
                    this.context.preferences.write(this.context);
                }
                catch (Exception e) {
                    this.logger.error(Utils.getStackTrace(e));
                    JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.exception") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
                }
            }
            this.context.mainFrame.setVisible(false);
            this.context.mainFrame.dispose();
        }
        if (!this.context.main.secondaryNavigator) {
            boolean success = true;
            if (this.isUpdaterProcess()) {
                success = this.context.main.execUpdater(this.updaterJar, true);
            }
            if (success) {
                if (!this.context.cfg.isLoggerView()) {
                    this.context.main.shutdown();
                }
                System.exit(0);
            }
        } else {
            GuiLogAppender guiLogAppender = this.context.guiLogAppender;
        }
    }
}

