/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.Preferences;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.Tools;
import com.formdev.flatlaf.FlatLaf;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Settings
extends JDialog {
    private transient Logger logger = LogManager.getLogger("applog");
    private Context context;
    private NavHelp helpDialog;
    private int laf;
    private Settings thisDialog;
    private ArrayList<AbstractTool> emailToolList = new ArrayList();
    private JPanel settingsDialogPane;
    private JPanel settingsContentPanel;
    private JTabbedPane settingsTabbedPane;
    private JPanel generalPanel;
    private JLabel showDefaultDryrunLabel;
    private JCheckBox defaultDryrunCheckBox;
    private JLabel labelDefaultEmailServer;
    private JComboBox comboBoxEmailServer;
    private JLabel generateLongOptionsLabel;
    private JCheckBox generateLongOptionsCheckBox;
    private JLabel preserveFileTimestampsLabel;
    private JCheckBox preserveFileTimestampsCheckBox;
    private JLabel showGettingStarted;
    private JCheckBox showGettingStartedCheckBox;
    private JLabel useLastPubSubLabel;
    private JCheckBox uselastPubSubCheckBox;
    private JLabel macosLauncherLabel;
    private JCheckBox macosLauncherCheckBox;
    private JPanel apperancePanel;
    private JLabel lookFeelLabel;
    private JComboBox<String> lookFeelComboBox;
    private JLabel localeLabel;
    private JComboBox<String> localeComboBox;
    private JPanel vSpacer1;
    private JLabel accentColorButtonLabel;
    private JButton defaultAccentButton;
    private JTextField textFieldAccentColor;
    private JButton buttonChooseColor;
    private JLabel dateFormatLabel;
    private JButton dateInfoButton;
    private JTextField dateFormatTextField;
    private JLabel scaleLabel;
    private JCheckBox scaleCheckBox;
    private JLabel labelRounded;
    private JCheckBox roundedCheckBox;
    private JLabel showMnemonicsLabel;
    private JCheckBox showMnemonicsCheckBox;
    private JLabel showArrowseLabel;
    private JCheckBox showArrowsCheckBox;
    private JPanel behaviorPanel;
    private JLabel askSendEmailLabel;
    private JCheckBox askSendEmailCheckBox;
    private JLabel showCcpConfirmationLabel;
    private JCheckBox showCcpConfirmationCheckBox;
    private JLabel showDeleteConfirmationLabel;
    private JCheckBox showDeleteConfirmationCheckBox;
    private JLabel showDndConfirmationLabel;
    private JCheckBox showDndConfirmationCheckBox;
    private JLabel showTouchConfirmationLabel;
    private JCheckBox showTouchConfirmationCheckBox;
    private JPanel browserPanel;
    private JLabel hideFilesInTreeLabel;
    private JCheckBox hideFilesInTreeCheckBox;
    private JLabel sortCaseSensitiveLabel;
    private JCheckBox sortCaseSensitiveCheckBox;
    private JLabel sortFoldersBeforeFilesLabel;
    private JCheckBox sortFoldersBeforeFilesCheckBox;
    private JLabel sortReverseLabel;
    private JCheckBox sortReverseCheckBox;
    private JLabel tabPlacementlabel;
    private JComboBox<String> tabPlacementComboBox;
    private JLabel tooltipLargeTableLabel;
    private JCheckBox tooltipLargeTableCheckBox;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public Settings(final Window owner, final Context context) {
        super(owner);
        this.context = context;
        this.initComponents();
        this.thisDialog = this;
        this.cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                context.preferences.setLookAndFeel(Settings.this.laf);
                Settings.this.textFieldAccentColor.setText(context.preferences.getAccentColor());
                Settings.this.scaleCheckBox.setSelected(!context.preferences.isBinaryScale());
                Settings.this.roundedCheckBox.setSelected(context.preferences.isRoundedEdges());
                Settings.this.showArrowsCheckBox.setSelected(context.preferences.isShowArrows());
                Settings.this.showMnemonicsCheckBox.setSelected(context.preferences.isShowMnemonics());
                Settings.this.updateLookAndFeel(null);
                Settings.this.refreshLookAndFeel(context.preferences.getLookAndFeel());
                if (Settings.this.helpDialog != null && Settings.this.helpDialog.isVisible()) {
                    Settings.this.helpDialog.setVisible(false);
                }
                Settings.this.setVisible(false);
            }
        });
        this.okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Settings.this.setPreferences()) {
                    try {
                        context.preferences.write(context);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(context.mainFrame, context.cfg.gs("Z.exception") + e.getMessage(), context.cfg.gs("Settings.this.title"), 0);
                    }
                    Settings.this.refreshLookAndFeel(context.preferences.getLookAndFeel());
                    if (Settings.this.helpDialog != null && Settings.this.helpDialog.isVisible()) {
                        Settings.this.helpDialog.setVisible(false);
                    }
                    Settings.this.setVisible(false);
                }
            }
        });
        this.okButton.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' && keyEvent.getSource() == Settings.this.okButton) {
                    Settings.this.okButton.doClick();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.dateInfoButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Settings.this.helpDialog = new NavHelp(owner, Settings.this.thisDialog, context, context.cfg.gs("Settings.date.format.help.title"), "formats_" + context.preferences.getLocale() + ".html", false);
                if (!Settings.this.helpDialog.fault) {
                    Settings.this.helpDialog.buttonFocus();
                }
            }
        });
        this.lookFeelComboBox.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox combobox = (JComboBox)actionEvent.getSource();
                int index = combobox.getSelectedIndex();
                if (Utils.getOS().equals("Linux") && index == 0) {
                    index = 4;
                    combobox.setSelectedIndex(index);
                }
                Settings.this.refreshLookAndFeel(index);
            }
        });
        this.tabPlacementComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                    context.mainFrame.setBrowserTabs(Settings.this.tabPlacementComboBox.getSelectedIndex());
                    context.browser.refreshAll();
                }
            }
        });
        Tools tools = new Tools();
        try {
            this.emailToolList = tools.loadAllTools(context, "Email");
            if (this.emailToolList.isEmpty()) {
                this.labelDefaultEmailServer.setEnabled(false);
                this.comboBoxEmailServer.setEnabled(false);
            } else {
                this.comboBoxEmailServer.addItem("None");
                for (AbstractTool tool : this.emailToolList) {
                    this.comboBoxEmailServer.addItem(tool.getConfigName());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
            this.labelDefaultEmailServer.setEnabled(false);
            this.comboBoxEmailServer.setEnabled(false);
        }
        this.laf = context.preferences.getLookAndFeel();
        this.setDialog();
    }

    private void chooseColor(ActionEvent e) {
        Color color = new Color(Integer.parseInt(this.textFieldAccentColor.getText(), 16));
        color = JColorChooser.showDialog(this.context.mainFrame, this.context.cfg.gs("Settings.select.accent.color"), color);
        if (color != null) {
            this.textFieldAccentColor.setText(Utils.formatHex(color.getRed(), 2) + Utils.formatHex(color.getGreen(), 2) + Utils.formatHex(color.getBlue(), 2));
            this.setAccentColor();
        }
    }

    private void defaultAccentColor(ActionEvent e) {
        Preferences cfr_ignored_0 = this.context.preferences;
        this.textFieldAccentColor.setText("2675BF");
        this.setAccentColor();
    }

    private void updateLookAndFeel(ActionEvent ae) {
        try {
            this.setAccentColor();
            if (this.roundedCheckBox.isSelected()) {
                UIManager.put("Button.arc", 500);
                UIManager.put("Component.arc", 500);
                UIManager.put("ProgressBar.arc", 500);
                UIManager.put("TextComponent.arc", 500);
            } else {
                UIManager.put("Button.arc", 5);
                UIManager.put("Component.arc", 5);
                UIManager.put("ProgressBar.arc", 5);
                UIManager.put("TextComponent.arc", 5);
            }
            UIManager.put("ScrollBar.showButtons", this.showArrowsCheckBox.isSelected());
            UIManager.put("Component.hideMnemonics", !this.showMnemonicsCheckBox.isSelected());
            Class<?> lafClass = UIManager.getLookAndFeel().getClass();
            FlatLaf.setup((LookAndFeel)lafClass.newInstance());
            FlatLaf.updateUI();
            this.context.mainFrame.panelToolbar.setBackground(this.context.mainFrame.menuToolbar.getBackground());
        }
        catch (Exception ex) {
            this.logger.error(Utils.getStackTrace(ex));
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.exception") + ex.getMessage(), this.context.cfg.gs("Settings.this.title"), 0);
        }
    }

    private void refreshLookAndFeel(int index) {
        try {
            this.context.preferences.setLookAndFeel(index);
            Configuration cfr_ignored_0 = this.context.cfg;
            this.context.preferences.initLookAndFeel("ELS", false);
            for (Frame frame : Frame.getFrames()) {
                Settings.updateLAFRecursively(frame);
            }
            this.context.mainFrame.panelToolbar.setBackground(this.context.mainFrame.menuToolbar.getBackground());
            this.context.mainFrame.setBrowserTabs(-1);
            this.context.browser.refreshAll();
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
            JOptionPane.showMessageDialog(this.settingsDialogPane, this.context.cfg.gs("Settings.error.changing.look.n.feel") + e.getMessage(), this.context.cfg.getNavigatorName(), 0);
        }
    }

    private void setAccentColor() {
        try {
            FlatLaf.setGlobalExtraDefaults(Collections.singletonMap("@accentColor", "#" + this.textFieldAccentColor.getText()));
            Class<?> lafClass = UIManager.getLookAndFeel().getClass();
            FlatLaf.setup((LookAndFeel)lafClass.newInstance());
            FlatLaf.updateUI();
        }
        catch (Exception ex) {
            this.logger.error(Utils.getStackTrace(ex));
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Z.exception") + ex.getMessage(), this.context.cfg.gs("Settings.this.title"), 0);
        }
    }

    private void setDialog() {
        this.defaultDryrunCheckBox.setSelected(this.context.preferences.isDefaultDryrun());
        if (this.context.preferences.getDefaultEmailServer().length() > 0) {
            this.comboBoxEmailServer.setSelectedItem(this.context.preferences.getDefaultEmailServer());
        }
        this.generateLongOptionsCheckBox.setSelected(this.context.preferences.isGenerateLongOptions());
        this.preserveFileTimestampsCheckBox.setSelected(this.context.preferences.isPreserveFileTimes());
        this.showGettingStartedCheckBox.setSelected(this.context.preferences.isShowGettingStarted());
        this.macosLauncherCheckBox.setSelected(this.context.preferences.isMacosLauncher());
        this.lookFeelComboBox.setAutoscrolls(true);
        this.lookFeelComboBox.setSelectedIndex(this.context.preferences.getLookAndFeel());
        ComboBoxModel<String> model = this.localeComboBox.getModel();
        this.localeComboBox.setAutoscrolls(true);
        if (Configuration.availableLocales.length > 0) {
            this.localeComboBox.removeAllItems();
            for (String loc : Configuration.availableLocales) {
                this.localeComboBox.addItem(loc);
            }
        }
        for (int i = 0; i < model.getSize(); ++i) {
            String loc = (String)model.getElementAt(i);
            if (!loc.equals(this.context.preferences.getLocale())) continue;
            this.localeComboBox.setSelectedIndex(i);
            break;
        }
        this.dateFormatTextField.setText(this.context.preferences.getDateFormat());
        if (this.context.preferences.getAccentColor() == null || this.context.preferences.getAccentColor().length() < 1) {
            Preferences cfr_ignored_0 = this.context.preferences;
            this.context.preferences.setAccentColor("2675BF");
        }
        this.textFieldAccentColor.setText(this.context.preferences.getAccentColor());
        this.scaleCheckBox.setSelected(!this.context.preferences.isBinaryScale());
        this.roundedCheckBox.setSelected(this.context.preferences.isRoundedEdges());
        this.showArrowsCheckBox.setSelected(this.context.preferences.isShowArrows());
        this.showMnemonicsCheckBox.setSelected(this.context.preferences.isShowMnemonics());
        this.askSendEmailCheckBox.setSelected(this.context.preferences.isAskSendEmail());
        this.showDeleteConfirmationCheckBox.setSelected(this.context.preferences.isShowDeleteConfirmation());
        this.showCcpConfirmationCheckBox.setSelected(this.context.preferences.isShowCcpConfirmation());
        this.showDndConfirmationCheckBox.setSelected(this.context.preferences.isShowDnDConfirmation());
        this.showTouchConfirmationCheckBox.setSelected(this.context.preferences.isShowTouchConfirmation());
        this.hideFilesInTreeCheckBox.setSelected(this.context.preferences.isHideFilesInTree());
        this.sortCaseSensitiveCheckBox.setSelected(this.context.preferences.isSortCaseInsensitive());
        this.sortFoldersBeforeFilesCheckBox.setSelected(this.context.preferences.isSortFoldersBeforeFiles());
        this.sortReverseCheckBox.setSelected(this.context.preferences.isSortReverse());
        this.tabPlacementComboBox.removeAllItems();
        model = this.tabPlacementComboBox.getModel();
        this.tabPlacementComboBox.addItem(this.context.cfg.gs("Settings.tabPlacement.top"));
        this.tabPlacementComboBox.addItem(this.context.cfg.gs("Settings.tabPlacement.left"));
        this.tabPlacementComboBox.addItem(this.context.cfg.gs("Settings.tabPlacement.bottom"));
        this.tabPlacementComboBox.addItem(this.context.cfg.gs("Settings.tabPlacement.right"));
        this.tabPlacementComboBox.setSelectedIndex(this.context.preferences.getTabPlacementIndex());
        this.tooltipLargeTableCheckBox.setSelected(this.context.preferences.isTooltipsLargeTables());
        this.uselastPubSubCheckBox.setSelected(this.context.preferences.isUseLastPublisherSubscriber());
        if (!Utils.isOsMac()) {
            this.macosLauncherLabel.setVisible(false);
            this.macosLauncherCheckBox.setVisible(false);
        }
    }

    private boolean setPreferences() {
        try {
            new SimpleDateFormat(this.dateFormatTextField.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Settings.date.format.not.valid"), this.context.cfg.getNavigatorName(), 0);
            this.settingsTabbedPane.setSelectedIndex(1);
            this.dateFormatTextField.requestFocus();
            this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Settings.date.format.not.valid"));
            return false;
        }
        this.context.preferences.setDefaultDryrun(this.defaultDryrunCheckBox.isSelected());
        String sel = this.comboBoxEmailServer.getSelectedItem().toString();
        if (sel.equalsIgnoreCase("None")) {
            sel = "";
        }
        this.context.preferences.setDefaultEmailServer(sel);
        this.context.preferences.setPreserveFileTimes(this.preserveFileTimestampsCheckBox.isSelected());
        this.context.preferences.setGenerateLongOptions(this.generateLongOptionsCheckBox.isSelected());
        this.context.preferences.setPreserveFileTimes(this.preserveFileTimestampsCheckBox.isSelected());
        this.context.preferences.setShowGettingStarted(this.showGettingStartedCheckBox.isSelected());
        this.context.preferences.setMacosLauncher(this.macosLauncherCheckBox.isSelected());
        this.context.preferences.setLookAndFeel(this.lookFeelComboBox.getSelectedIndex());
        this.context.preferences.setLocale((String)this.localeComboBox.getSelectedItem());
        this.context.preferences.setDateFormat(this.dateFormatTextField.getText());
        if (this.textFieldAccentColor.getText().length() == 0) {
            Preferences cfr_ignored_0 = this.context.preferences;
            this.context.preferences.setAccentColor("2675BF");
            FlatLaf.setGlobalExtraDefaults(Collections.singletonMap("@accentColor", "#" + this.context.preferences.getAccentColor()));
            Class<?> lafClass = UIManager.getLookAndFeel().getClass();
            try {
                FlatLaf.setup((LookAndFeel)lafClass.newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
            FlatLaf.updateUI();
        } else {
            this.context.preferences.setAccentColor(this.textFieldAccentColor.getText());
        }
        this.context.preferences.setBinaryScale(!this.scaleCheckBox.isSelected());
        this.context.cfg.setLongScale(this.context.preferences.isBinaryScale());
        this.context.preferences.setRoundedEdges(this.roundedCheckBox.isSelected());
        this.context.preferences.setShowArrows(this.showArrowsCheckBox.isSelected());
        this.context.preferences.setShowMnemonics(this.showMnemonicsCheckBox.isSelected());
        this.context.preferences.setAskSendEmail(this.askSendEmailCheckBox.isSelected());
        this.context.preferences.setShowCcpConfirmation(this.showCcpConfirmationCheckBox.isSelected());
        this.context.preferences.setShowDeleteConfirmation(this.showDeleteConfirmationCheckBox.isSelected());
        this.context.preferences.setShowDnDConfirmation(this.showDndConfirmationCheckBox.isSelected());
        this.context.preferences.setShowTouchConfirmation(this.showTouchConfirmationCheckBox.isSelected());
        this.context.preferences.setHideFilesInTree(this.hideFilesInTreeCheckBox.isSelected());
        this.context.preferences.setSortCaseInsensitive(this.sortCaseSensitiveCheckBox.isSelected());
        this.context.preferences.setSortFoldersBeforeFiles(this.sortFoldersBeforeFilesCheckBox.isSelected());
        this.context.preferences.setSortReverse(this.sortReverseCheckBox.isSelected());
        this.context.preferences.setTabPlacement(this.tabPlacementComboBox.getSelectedIndex());
        this.context.preferences.setTooltipsLargeTables(this.tooltipLargeTableCheckBox.isSelected());
        this.context.preferences.setUseLastPublisherSubscriber(this.uselastPubSubCheckBox.isSelected());
        this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
        return true;
    }

    private void thisWindowClosed(WindowEvent e) {
        if (this.helpDialog != null && this.helpDialog.isVisible()) {
            this.helpDialog.setVisible(false);
        }
    }

    private void thisWindowClosing(WindowEvent e) {
        if (this.helpDialog != null && this.helpDialog.isVisible()) {
            this.helpDialog.setVisible(false);
        }
    }

    public static void updateLAFRecursively(Window window) {
        for (Window childWindow : window.getOwnedWindows()) {
            Settings.updateLAFRecursively(childWindow);
        }
        SwingUtilities.updateComponentTreeUI(window);
    }

    private void initComponents() {
        this.settingsDialogPane = new JPanel();
        this.settingsContentPanel = new JPanel();
        this.settingsTabbedPane = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.showDefaultDryrunLabel = new JLabel();
        this.defaultDryrunCheckBox = new JCheckBox();
        this.labelDefaultEmailServer = new JLabel();
        this.comboBoxEmailServer = new JComboBox();
        this.generateLongOptionsLabel = new JLabel();
        this.generateLongOptionsCheckBox = new JCheckBox();
        this.preserveFileTimestampsLabel = new JLabel();
        this.preserveFileTimestampsCheckBox = new JCheckBox();
        this.showGettingStarted = new JLabel();
        this.showGettingStartedCheckBox = new JCheckBox();
        this.useLastPubSubLabel = new JLabel();
        this.uselastPubSubCheckBox = new JCheckBox();
        this.macosLauncherLabel = new JLabel();
        this.macosLauncherCheckBox = new JCheckBox();
        this.apperancePanel = new JPanel();
        this.lookFeelLabel = new JLabel();
        this.lookFeelComboBox = new JComboBox();
        this.localeLabel = new JLabel();
        this.localeComboBox = new JComboBox();
        this.vSpacer1 = new JPanel(null);
        this.accentColorButtonLabel = new JLabel();
        this.defaultAccentButton = new JButton();
        this.textFieldAccentColor = new JTextField();
        this.buttonChooseColor = new JButton();
        this.dateFormatLabel = new JLabel();
        this.dateInfoButton = new JButton();
        this.dateFormatTextField = new JTextField();
        this.scaleLabel = new JLabel();
        this.scaleCheckBox = new JCheckBox();
        this.labelRounded = new JLabel();
        this.roundedCheckBox = new JCheckBox();
        this.showMnemonicsLabel = new JLabel();
        this.showMnemonicsCheckBox = new JCheckBox();
        this.showArrowseLabel = new JLabel();
        this.showArrowsCheckBox = new JCheckBox();
        this.behaviorPanel = new JPanel();
        this.askSendEmailLabel = new JLabel();
        this.askSendEmailCheckBox = new JCheckBox();
        this.showCcpConfirmationLabel = new JLabel();
        this.showCcpConfirmationCheckBox = new JCheckBox();
        this.showDeleteConfirmationLabel = new JLabel();
        this.showDeleteConfirmationCheckBox = new JCheckBox();
        this.showDndConfirmationLabel = new JLabel();
        this.showDndConfirmationCheckBox = new JCheckBox();
        this.showTouchConfirmationLabel = new JLabel();
        this.showTouchConfirmationCheckBox = new JCheckBox();
        this.browserPanel = new JPanel();
        this.hideFilesInTreeLabel = new JLabel();
        this.hideFilesInTreeCheckBox = new JCheckBox();
        this.sortCaseSensitiveLabel = new JLabel();
        this.sortCaseSensitiveCheckBox = new JCheckBox();
        this.sortFoldersBeforeFilesLabel = new JLabel();
        this.sortFoldersBeforeFilesCheckBox = new JCheckBox();
        this.sortReverseLabel = new JLabel();
        this.sortReverseCheckBox = new JCheckBox();
        this.tabPlacementlabel = new JLabel();
        this.tabPlacementComboBox = new JComboBox();
        this.tooltipLargeTableLabel = new JLabel();
        this.tooltipLargeTableCheckBox = new JCheckBox();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(this.context.cfg.gs("Settings.this.title"));
        this.setMinimumSize(new Dimension(100, 50));
        this.setName("settingsDialog");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Settings.this.thisWindowClosed(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.this.thisWindowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.settingsDialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.settingsDialogPane.setLayout(new BorderLayout());
        this.settingsContentPanel.setLayout(new BoxLayout(this.settingsContentPanel, 0));
        this.settingsTabbedPane.setTabPlacement(2);
        this.generalPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.generalPanel.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.generalPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.generalPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.generalPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.showDefaultDryrunLabel.setText(this.context.cfg.gs("Settings.default.dry.runLabel.text"));
        this.generalPanel.add((Component)this.showDefaultDryrunLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 8, 20, 5), 0, 0));
        this.defaultDryrunCheckBox.setToolTipText(this.context.cfg.gs("Settings.defaultDryrunCheckBox.toolTipText"));
        this.generalPanel.add((Component)this.defaultDryrunCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 0, 20, 0), 0, 0));
        this.labelDefaultEmailServer.setText(this.context.cfg.gs("Settings.labelDefaultEmailServer.text"));
        this.generalPanel.add((Component)this.labelDefaultEmailServer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.comboBoxEmailServer.setMaximumRowCount(32);
        this.comboBoxEmailServer.setPreferredSize(new Dimension(240, 34));
        this.comboBoxEmailServer.setAutoscrolls(true);
        this.comboBoxEmailServer.setToolTipText(this.context.cfg.gs("Settings.comboBoxEmailServer.toolTipText"));
        this.generalPanel.add((Component)this.comboBoxEmailServer, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.generateLongOptionsLabel.setText(this.context.cfg.gs("Settings.generateLongOptionsLabel.text"));
        this.generalPanel.add((Component)this.generateLongOptionsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.generateLongOptionsCheckBox.setToolTipText(this.context.cfg.gs("Settings.generateLongOptionsCheckBox.toolTipText"));
        this.generalPanel.add((Component)this.generateLongOptionsCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.preserveFileTimestampsLabel.setText(this.context.cfg.gs("Settings.preserveFileTimestampsLabel.text"));
        this.generalPanel.add((Component)this.preserveFileTimestampsLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 50), 0, 0));
        this.preserveFileTimestampsCheckBox.setToolTipText(this.context.cfg.gs("Settings.preserveFileTimestampsCheckBox.toolTipText"));
        this.generalPanel.add((Component)this.preserveFileTimestampsCheckBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.showGettingStarted.setText(this.context.cfg.gs("Settings.showGettingStarted.text"));
        this.generalPanel.add((Component)this.showGettingStarted, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.showGettingStartedCheckBox.setToolTipText("Uncheck to not show Getting Started at Navigator start");
        this.generalPanel.add((Component)this.showGettingStartedCheckBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.useLastPubSubLabel.setText(this.context.cfg.gs("Settings.useLastPubSubLabel.text"));
        this.generalPanel.add((Component)this.useLastPubSubLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 24), 0, 0));
        this.uselastPubSubCheckBox.setToolTipText(this.context.cfg.gs("Settings.uselastPubSubCheckBox.toolTipText"));
        this.generalPanel.add((Component)this.uselastPubSubCheckBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.macosLauncherLabel.setText(this.context.cfg.gs("Settings.macosLauncherLabel.text"));
        this.generalPanel.add((Component)this.macosLauncherLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.macosLauncherCheckBox.setToolTipText("Uncheck to use ELS-Navigator.sh script internally and for shortcuts");
        this.generalPanel.add((Component)this.macosLauncherCheckBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.settingsTabbedPane.addTab(this.context.cfg.gs("Settings.generalPanel.tab.title"), this.generalPanel);
        this.settingsTabbedPane.setMnemonicAt(0, this.context.cfg.gs("Settings.generalPanel.tab.mnemonic").charAt(0));
        this.apperancePanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.apperancePanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.apperancePanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.apperancePanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.apperancePanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.lookFeelLabel.setText(this.context.cfg.gs("Settings.lookFeelLabel.text"));
        this.apperancePanel.add((Component)this.lookFeelLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(8, 8, 20, 5), 0, 0));
        this.lookFeelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System (Windows)", "Flat light", "Flat dark", "IntelliJ light", "IntelliJ dark", "macOS light", "macOS dark"}));
        this.lookFeelComboBox.setName("lafCombo");
        this.apperancePanel.add(this.lookFeelComboBox, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(-6, 0, 14, 0), 0, 0));
        this.localeLabel.setText(this.context.cfg.gs("Settings.localeLabel.text"));
        this.apperancePanel.add((Component)this.localeLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.localeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"en_US"}));
        this.localeComboBox.setName("localeCombo");
        this.localeComboBox.setToolTipText("Select language");
        this.apperancePanel.add(this.localeComboBox, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(-6, 0, 14, 0), 0, 0));
        this.vSpacer1.setMaximumSize(new Dimension(Short.MAX_VALUE, 26));
        this.vSpacer1.setMinimumSize(new Dimension(12, 26));
        this.vSpacer1.setPreferredSize(new Dimension(10, 26));
        this.apperancePanel.add((Component)this.vSpacer1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 5), 0, 0));
        this.accentColorButtonLabel.setText(this.context.cfg.gs("Settings.accentColorLabel.text"));
        this.apperancePanel.add((Component)this.accentColorButtonLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.defaultAccentButton.setText(this.context.cfg.gs("Settings.defaultAccentButton.text"));
        this.defaultAccentButton.setToolTipText(this.context.cfg.gs("Settings.defaultAccentButton.toolTipText"));
        this.defaultAccentButton.addActionListener(e -> this.defaultAccentColor(e));
        this.apperancePanel.add((Component)this.defaultAccentButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(-6, 0, 14, 5), 0, 0));
        this.textFieldAccentColor.setToolTipText(this.context.cfg.gs("Settings.textField.HintButtonColor.toolTipText"));
        this.apperancePanel.add((Component)this.textFieldAccentColor, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(-6, 0, 14, 5), 0, 0));
        this.buttonChooseColor.setText(this.context.cfg.gs("Settings.button.ChooseColor.text"));
        this.buttonChooseColor.setToolTipText(this.context.cfg.gs("Settings.button.ChooseColor.toolTipText"));
        this.buttonChooseColor.addActionListener(e -> this.chooseColor(e));
        this.apperancePanel.add((Component)this.buttonChooseColor, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(-6, 0, 14, 0), 0, 0));
        this.dateFormatLabel.setText(this.context.cfg.gs("Settings.dateFormatLabel.text"));
        this.apperancePanel.add((Component)this.dateFormatLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 41), 0, 0));
        this.dateInfoButton.setText(this.context.cfg.gs("Settings.button.dateInfo.text"));
        this.dateInfoButton.setToolTipText(this.context.cfg.gs("Settings.button.dateInfo.text.tooltip"));
        this.apperancePanel.add((Component)this.dateInfoButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(-6, 0, 14, 5), 0, 0));
        this.dateFormatTextField.setText("yyyy-MM-dd hh:mm:ss aa");
        this.apperancePanel.add((Component)this.dateFormatTextField, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(-6, 0, 14, 0), 0, 0));
        this.scaleLabel.setText(this.context.cfg.gs("Settings.scaleLabel.text"));
        this.apperancePanel.add((Component)this.scaleLabel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.scaleCheckBox.setToolTipText(this.context.cfg.gs("Settings.scaleCheckBox.toolTipText"));
        this.apperancePanel.add((Component)this.scaleCheckBox, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.labelRounded.setText(this.context.cfg.gs("Settings.labelRounded.text"));
        this.labelRounded.setToolTipText(this.context.cfg.gs("Settings.labelRounded.toolTipText"));
        this.apperancePanel.add((Component)this.labelRounded, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.roundedCheckBox.setToolTipText(this.context.cfg.gs("Settings.roundedCheckBox.toolTipText"));
        this.roundedCheckBox.addActionListener(e -> this.updateLookAndFeel(e));
        this.apperancePanel.add((Component)this.roundedCheckBox, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 5), 0, 0));
        this.showMnemonicsLabel.setText(this.context.cfg.gs("Settings.showMnemonicsLabel.text"));
        this.apperancePanel.add((Component)this.showMnemonicsLabel, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.showMnemonicsCheckBox.setToolTipText(this.context.cfg.gs("Settings.showMnemonicsCheckBox.toolTipText"));
        this.showMnemonicsCheckBox.addActionListener(e -> this.updateLookAndFeel(e));
        this.apperancePanel.add((Component)this.showMnemonicsCheckBox, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 5), 0, 0));
        this.showArrowseLabel.setText(this.context.cfg.gs("Settings.show.Arrows.Label.text"));
        this.apperancePanel.add((Component)this.showArrowseLabel, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 0, 5), 0, 0));
        this.showArrowsCheckBox.setToolTipText(this.context.cfg.gs("Settings.showArrowsCheckBox.toolTipText"));
        this.showArrowsCheckBox.addActionListener(e -> this.updateLookAndFeel(e));
        this.apperancePanel.add((Component)this.showArrowsCheckBox, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.settingsTabbedPane.addTab(this.context.cfg.gs("Settings.appearance.tab.title"), this.apperancePanel);
        this.settingsTabbedPane.setMnemonicAt(1, this.context.cfg.gs("Settings.appearancePanel.tab.mnemonic").charAt(0));
        this.behaviorPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.behaviorPanel.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.behaviorPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.behaviorPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.behaviorPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.askSendEmailLabel.setText(this.context.cfg.gs("Settings.askSendEmailLabel.text"));
        this.behaviorPanel.add((Component)this.askSendEmailLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 8, 20, 39), 0, 0));
        this.askSendEmailCheckBox.setToolTipText(this.context.cfg.gs("Settings.askSendEmailCheckbox"));
        this.behaviorPanel.add((Component)this.askSendEmailCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 0, 20, 0), 0, 0));
        this.showCcpConfirmationLabel.setText(this.context.cfg.gs("Settings.showCcpConfirmationLabel.text"));
        this.behaviorPanel.add((Component)this.showCcpConfirmationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.behaviorPanel.add((Component)this.showCcpConfirmationCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.showDeleteConfirmationLabel.setText(this.context.cfg.gs("Settings.showDeleteConfirmationLabel.text"));
        this.behaviorPanel.add((Component)this.showDeleteConfirmationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.behaviorPanel.add((Component)this.showDeleteConfirmationCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.showDndConfirmationLabel.setText(this.context.cfg.gs("Settings.showDndConfirmationLabel.text"));
        this.behaviorPanel.add((Component)this.showDndConfirmationLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.behaviorPanel.add((Component)this.showDndConfirmationCheckBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.showTouchConfirmationLabel.setText(this.context.cfg.gs("Settings.showTouchConfirmationLabel.text"));
        this.behaviorPanel.add((Component)this.showTouchConfirmationLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.behaviorPanel.add((Component)this.showTouchConfirmationCheckBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.settingsTabbedPane.addTab(this.context.cfg.gs("Settings.behaviorPanel.tab.title"), this.behaviorPanel);
        this.settingsTabbedPane.setMnemonicAt(2, this.context.cfg.gs("Settings.behaviorPanel.tab.mnemonic").charAt(0));
        this.browserPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.browserPanel.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.browserPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.browserPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.browserPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.hideFilesInTreeLabel.setText(this.context.cfg.gs("Settings.hideFilesInTreeLabel.text"));
        this.browserPanel.add((Component)this.hideFilesInTreeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 8, 20, 5), 0, 0));
        this.browserPanel.add((Component)this.hideFilesInTreeCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 0, 20, 0), 0, 0));
        this.sortCaseSensitiveLabel.setText(this.context.cfg.gs("Settings.sortCaseSensitiveLabel.text"));
        this.browserPanel.add((Component)this.sortCaseSensitiveLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.browserPanel.add((Component)this.sortCaseSensitiveCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.sortFoldersBeforeFilesLabel.setText(this.context.cfg.gs("Settings.sortFoldersBeforeFilesLabel.text"));
        this.browserPanel.add((Component)this.sortFoldersBeforeFilesLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 57), 0, 0));
        this.browserPanel.add((Component)this.sortFoldersBeforeFilesCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.sortReverseLabel.setText(this.context.cfg.gs("Settings.sortReverseLabel.text"));
        this.browserPanel.add((Component)this.sortReverseLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.browserPanel.add((Component)this.sortReverseCheckBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.tabPlacementlabel.setText(this.context.cfg.gs("Settings.tabPlacementLabel.text"));
        this.browserPanel.add((Component)this.tabPlacementlabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.tabPlacementComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Top", "Bottom", "Left", "Right"}));
        this.tabPlacementComboBox.setPreferredSize(new Dimension(100, 30));
        this.tabPlacementComboBox.setName("tabPlacementCombo");
        this.browserPanel.add(this.tabPlacementComboBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 14, 0), 0, 0));
        this.tooltipLargeTableLabel.setText(this.context.cfg.gs("Settings.tooltipLargeTableLabel.text"));
        this.browserPanel.add((Component)this.tooltipLargeTableLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 20, 5), 0, 0));
        this.tooltipLargeTableCheckBox.setToolTipText(this.context.cfg.gs("Settings.tooltipLargeTableCheckBox.toolTipText"));
        this.browserPanel.add((Component)this.tooltipLargeTableCheckBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        this.settingsTabbedPane.addTab(this.context.cfg.gs("Settings.browserPanel.tab.title"), this.browserPanel);
        this.settingsTabbedPane.setMnemonicAt(3, this.context.cfg.gs("Settings.browserPanel.tab.mnemonic_2").charAt(0));
        this.settingsContentPanel.add(this.settingsTabbedPane);
        this.settingsDialogPane.add((Component)this.settingsContentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText(this.context.cfg.gs("Z.save"));
        this.okButton.setToolTipText(this.context.cfg.gs("Z.save.toolTip.text"));
        this.okButton.setMnemonic(this.context.cfg.gs("Settings.okButton.mnemonic").charAt(0));
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText(this.context.cfg.gs("Z.cancel"));
        this.cancelButton.setToolTipText(this.context.cfg.gs("Z.cancel.changes.toolTipText"));
        this.cancelButton.setMnemonic(this.context.cfg.gs("Settings.cancelButton.mnemonic_2").charAt(0));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.settingsDialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.settingsDialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

