/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.bookmarks;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.bookmarks.Bookmark;
import com.corionis.els.gui.bookmarks.Bookmarks;
import javax.swing.table.DefaultTableModel;

public class BookmarksTableModel
extends DefaultTableModel {
    Context context;
    Bookmarks bookmarks;

    private BookmarksTableModel() {
    }

    public BookmarksTableModel(Context context, Bookmarks bookmarks) {
        this.context = context;
        this.bookmarks = bookmarks;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = this.context.cfg.gs("BookmarksUI.header.tab");
                break;
            }
            case 1: {
                name = this.context.cfg.gs("BookmarksUI.header.name");
                break;
            }
            case 2: {
                name = this.context.cfg.gs("BookmarksUI.header.path");
            }
        }
        return name;
    }

    @Override
    public int getRowCount() {
        return this.bookmarks == null ? 0 : this.bookmarks.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Bookmark bm = null;
        if (row < this.bookmarks.size()) {
            bm = this.bookmarks.get(row);
            switch (column) {
                case 0: {
                    switch (bm.panel) {
                        case "treeCollectionOne": 
                        case "tableCollectionOne": {
                            return "   1";
                        }
                        case "treeSystemOne": 
                        case "tableSystemOne": {
                            return "   2";
                        }
                        case "treeCollectionTwo": 
                        case "tableCollectionTwo": {
                            return "   3";
                        }
                        case "treeSystemTwo": 
                        case "tableSystemTwo": {
                            return "   4";
                        }
                    }
                    break;
                }
                case 1: {
                    return bm.name;
                }
                case 2: {
                    return Utils.concatStringArray(bm.pathElements, "/");
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        if (column == 1) {
            Bookmark bm = this.bookmarks.get(row);
            bm.name = (String)object;
        }
    }
}

