/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.browser;

import com.corionis.els.Context;
import com.corionis.els.gui.browser.DateColumn;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.gui.hints.HintDate;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class BrowserTableCellRenderer
extends DefaultTableCellRenderer {
    private Context context;
    private JTable table;

    public BrowserTableCellRenderer(Context context, JTable table) {
        this.context = context;
        this.table = table;
    }

    private String getTip(int row, int column) {
        String tip = null;
        String value = null;
        if (row >= 0 && row < this.table.getModel().getRowCount() && column >= 0 && column < this.table.getModel().getColumnCount()) {
            row = this.table.getRowSorter().convertRowIndexToModel(row);
            Object object = this.table.getModel().getValueAt(row, column);
            if (object != null) {
                if (object instanceof ImageIcon) {
                    tip = ((ImageIcon)object).getDescription();
                } else {
                    if (object instanceof String) {
                        value = (String)object;
                    } else if (object instanceof HintDate) {
                        value = ((HintDate)object).toString();
                    } else if (object instanceof DateColumn) {
                        value = ((DateColumn)object).toString();
                    } else if (object instanceof NavTreeUserObject) {
                        value = ((NavTreeUserObject)object).name;
                    }
                    if (value != null) {
                        int columnWidth;
                        int textWidth = this.context.preferences.isTooltipsLargeTables() ? 32768 : 0;
                        Component component = this.table.getComponentAt(row, column);
                        if (component != null) {
                            FontMetrics metrics = component.getFontMetrics(component.getFont());
                            textWidth = SwingUtilities.computeStringWidth(metrics, value);
                        }
                        if ((columnWidth = this.table.getColumnModel().getColumn(column).getWidth()) < (textWidth += 10)) {
                            tip = value;
                        }
                    }
                }
            }
        }
        return tip;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column > 0 && column <= 8) {
            String tip = this.getTip(row, column);
            ((JLabel)rendererComponent).setToolTipText(tip);
        }
        return rendererComponent;
    }
}

