/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.browser;

import com.corionis.els.Context;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.gui.browser.NavTreeUserObject;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class NavTreeCellRenderer
extends DefaultTreeCellRenderer {
    Context context;

    public NavTreeCellRenderer(Context context) {
        this.context = context;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (tree.isEnabled() && value instanceof NavTreeNode) {
            NavTreeNode node = (NavTreeNode)value;
            if (node.getUserObject() instanceof NavTreeUserObject) {
                NavTreeUserObject tuo = node.getUserObject();
                switch (tuo.type) {
                    case 0: {
                        this.setIcon(UIManager.getIcon("FileView.floppyDriveIcon"));
                        break;
                    }
                    case 1: {
                        this.setIcon(UIManager.getIcon("FileChooser.homeFolderIcon"));
                        this.setToolTipText((tuo.isRemote ? this.context.cfg.gs("Z.remote.uppercase") : this.context.cfg.gs("NavTreeNode.local")) + (!tuo.isSubscriber() && this.context.preferences.isLastPublisherIsWorkstation() ? this.context.cfg.gs("Navigator.workstation") : this.context.cfg.gs("NavTreeNode.collection")) + ", " + tuo.node.getChildCount() + this.context.cfg.gs("Navigator.libraries"));
                        break;
                    }
                    case 2: {
                        this.setIcon(UIManager.getIcon("FileView.computerIcon"));
                        this.setToolTipText(tuo.isRemote ? this.context.cfg.gs("Z.remote.uppercase") : this.context.cfg.gs("NavTreeNode.local"));
                        break;
                    }
                    case 3: {
                        this.setIcon(UIManager.getIcon("FileView.hardDriveIcon"));
                        this.setToolTipText(tuo.path);
                        break;
                    }
                    case 4: {
                        this.setIcon(UIManager.getIcon("FileChooser.homeFolderIcon"));
                        this.setToolTipText(tuo.path);
                        break;
                    }
                    case 5: {
                        this.setIcon(UIManager.getIcon("FileView.directoryIcon"));
                        this.setToolTipText(this.context.cfg.gs("NavTreeNode.library") + ", " + tuo.sources.length + (tuo.sources.length == 1 ? this.context.cfg.gs("NavTreeNode.source") : this.context.cfg.gs("NavTreeNode.sources")));
                        break;
                    }
                    case 6: {
                        this.setToolTipText(tuo.path);
                        if (tuo.isDir) {
                            this.setIcon(UIManager.getIcon("FileView.directoryIcon"));
                            break;
                        }
                        this.setIcon(UIManager.getIcon("FileView.fileIcon"));
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        this.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
                        break;
                    }
                }
            } else {
                this.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
            }
        } else {
            this.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        }
        return this;
    }
}

