/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.hints;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.browser.BrowserTableCellRenderer;
import com.corionis.els.gui.hints.HintsTableModel;
import com.corionis.els.hints.Hint;
import com.corionis.els.hints.HintKey;
import com.corionis.els.hints.HintStatus;
import com.corionis.els.hints.Hints;
import com.corionis.els.repository.Repositories;
import com.corionis.els.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HintsUI
extends JDialog {
    private boolean allSelected = false;
    private Context context;
    private boolean changesMade = false;
    private NavHelp helpDialog;
    ArrayList<Hint> hints = null;
    private String hintPublisherName = "-";
    private String hintSubscriberName = "-";
    private Logger logger = LogManager.getLogger("applog");
    private HintsTableModel model;
    private int pendingPublisher = 0;
    private int pendingSubscriber = 0;
    private ArrayList<Hint> pendingPublisherHints;
    private ArrayList<Hint> pendingSubscriberHints;
    private String publisherDisplayName = "";
    private String subscriberDisplayName = "";
    private Repositories repositories = null;
    public JPanel dialogPane;
    public JPanel contentPanel;
    public JPanel panelTop;
    public JPanel panelTopButtons;
    public JButton buttonDelete;
    public JPanel hSpace42;
    public JButton buttonRun;
    public JPanel panelHelp;
    public JLabel labelHelp;
    public JScrollPane scrollPaneHints;
    public JTable tableHints;
    public JPanel panelOptionsButtons;
    public JButton buttonAll;
    public JPanel panelBottom;
    public JLabel labelStatus;
    public JPanel buttonBar;
    public JButton okButton;
    public JButton cancelButton;

    public HintsUI(Context context) {
        super(context.mainFrame);
        this.context = context;
        boolean fault = false;
        try {
            this.repositories = this.getRepositories();
            if (context.datastore != null) {
                context.datastore.reload();
            } else {
                this.hints = new ArrayList();
            }
            if (context.hintsHandler == null) {
                context.hintsHandler = new Hints(context, null);
            }
            this.hints = context.hintsHandler.getAll();
        }
        catch (Exception e) {
            fault = true;
            String msg = context.cfg.gs("Z.exception") + e.getMessage();
            this.logger.error(msg);
            JOptionPane.showMessageDialog(context.mainFrame, msg, context.cfg.gs("HintsUI.this.title"), 0);
        }
        if (!fault) {
            this.initComponents();
            this.model = (HintsTableModel)this.tableHints.getModel();
            Icon icon = this.labelHelp.getIcon();
            Image image = Utils.iconToImage(icon);
            Image scaled = image.getScaledInstance(30, 30, 4);
            ImageIcon replacement = new ImageIcon(scaled);
            this.labelHelp.setIcon(replacement);
            if (context.preferences.getHintsXpos() != -1 && Utils.isOnScreen(context.preferences.getHintsXpos(), context.preferences.getHintsYpos())) {
                this.setLocation(context.preferences.getHintsXpos(), context.preferences.getHintsYpos());
                Dimension dim = new Dimension(context.preferences.getHintsWidth(), context.preferences.getHintsHeight());
                this.setSize(dim);
            } else {
                this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
            }
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    super.componentResized(e);
                    Dimension d = HintsUI.this.labelStatus.getSize();
                    HintsUI.this.labelStatus.setPreferredSize(d);
                }
            });
            Dimension d = this.labelStatus.getSize();
            this.labelStatus.setPreferredSize(d);
            AbstractAction escListener = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HintsUI.this.cancelButton.doClick();
                }
            };
            this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
            if (this.model != null && this.hints != null) {
                for (Hint hint : this.hints) {
                    hint.selected = false;
                }
                this.model.fireTableDataChanged();
            }
            if (context.cfg.isHintTrackingEnabled()) {
                this.refresh();
            } else {
                this.labelStatus.setText(context.cfg.gs("HintsUI.hint.tracker.server.not.enabled"));
            }
            this.setButtons();
            context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
            this.setWidths();
            this.setVisible(true);
            this.requestFocus();
        }
    }

    private void actionAllClicked(ActionEvent e) {
        if (this.model != null && this.hints != null) {
            this.allSelected = !this.allSelected;
            for (Hint hint : this.hints) {
                hint.selected = this.allSelected;
            }
            this.model.fireTableDataChanged();
        }
        int count = this.setButtons();
        this.labelStatus.setText(count + this.context.cfg.gs("HintsUI.hints.selected"));
    }

    private void actionDeleteClicked(ActionEvent e) {
        int count = 0;
        if (this.model != null && this.hints != null) {
            for (Hint hint : this.hints) {
                if (!hint.selected) continue;
                ++count;
            }
            if (count > 0) {
                this.labelStatus.setText(count + this.context.cfg.gs("HintsUI.hints.selected"));
                int r = JOptionPane.showConfirmDialog(this, MessageFormat.format(this.context.cfg.gs("HintsUI.are.you.sure.you.want.to.delete"), count), this.context.cfg.gs("HintsUI.this.title"), 0);
                if (r == 0) {
                    for (int i = this.hints.size() - 1; i >= 0; --i) {
                        if (!this.hints.get((int)i).selected) continue;
                        this.hints.remove(i);
                        this.changesMade = true;
                    }
                    this.model.fireTableDataChanged();
                    this.checkNotificationDisplay();
                }
            }
        }
        this.labelStatus.setText("");
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.changesMade) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply != 0) {
                return;
            }
        }
        this.context.navigator.checkForHints();
        this.context.navigator.enableDisableSystemMenus(null, true);
        this.setVisible(false);
    }

    private void actionOkClicked(ActionEvent e) {
        if (this.changesMade) {
            try {
                this.context.hintsHandler.save(this.hints);
            }
            catch (Exception e1) {
                String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e1);
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("HintsUI.this.title"), 0);
            }
        }
        this.savePreferences();
        this.context.navigator.enableDisableSystemMenus(null, true);
        this.setVisible(false);
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("HintsUI.help"), "hints_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionRunClicked(ActionEvent e) {
        Repository repo;
        JTree currentTree = null;
        String displayName = "";
        boolean isPublisher = false;
        String name = "";
        this.labelStatus.setText("");
        JComponent object = this.context.browser.lastComponent;
        if (object instanceof JTree) {
            JTree sourceTree = (JTree)object;
            name = sourceTree.getName();
        } else if (object instanceof JTable) {
            JTable sourceTable = (JTable)object;
            name = sourceTable.getName();
        }
        if (name.toLowerCase().contains("system")) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
            JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.select.collection.for.run"), this.getTitle(), -1, 2, null, opts, opts[0]);
            return;
        }
        if (name.toLowerCase().endsWith("one")) {
            isPublisher = true;
            repo = this.context.publisherRepo;
            currentTree = this.context.mainFrame.treeCollectionOne;
            which = this.context.cfg.gs("Z.publisher");
            if (this.context.publisherRepo != null) {
                displayName = this.context.publisherRepo.getLibraryData().libraries.description;
            }
        } else {
            repo = this.context.subscriberRepo;
            currentTree = this.context.mainFrame.treeCollectionTwo;
            which = this.context.cfg.gs("Z.subscriber");
            if (this.context.subscriberRepo != null) {
                displayName = this.context.subscriberRepo.getLibraryData().libraries.description;
            }
        }
        if (this.context.hintKeys.findKey(repo.getLibraryData().libraries.key) == null) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
            JOptionPane.showOptionDialog(this, MessageFormat.format(this.context.cfg.gs("HintsUI.current.key.was.not.found.in.hint.keys"), displayName), this.getTitle(), -1, 2, null, opts, opts[0]);
            return;
        }
        if (displayName.length() < 1) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
            JOptionPane.showOptionDialog(this, this.context.cfg.gs("HintsUI.select.open"), this.getTitle(), -1, 2, null, opts, opts[0]);
            return;
        }
        if (isPublisher && this.context.preferences.isLastPublisherIsWorkstation()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
            JOptionPane.showOptionDialog(this, this.context.cfg.gs("HintsUI.not.workstation"), this.getTitle(), -1, 2, null, opts, opts[0]);
            return;
        }
        ArrayList<Hint> pendingFor = this.getSelectedFor(isPublisher ? this.hintPublisherName : this.hintSubscriberName);
        if (pendingFor == null || pendingFor.size() < 1) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
            JOptionPane.showOptionDialog(this, MessageFormat.format(this.context.cfg.gs("HintsUI.no.selected.hints.pending.for"), displayName), this.getTitle(), -1, 2, null, opts, opts[0]);
            return;
        }
        int reply = JOptionPane.showConfirmDialog(this, MessageFormat.format(this.context.cfg.gs("HintsUI.run.tool.on.collection"), displayName), this.context.cfg.gs("HintsUI.this.title"), 0);
        if (reply == 0) {
            try {
                String result = this.context.hintsHandler.hintsMunge(pendingFor, isPublisher, this.model, null, null);
                if (!result.toLowerCase().equals("false")) {
                    if (this.context.preferences.isAutoRefresh()) {
                        this.context.browser.rescanByTreeOrTable(currentTree);
                    }
                    this.logger.info(this.context.cfg.gs("HintsUI.hints.run.complete") + result);
                }
                this.refresh();
            }
            catch (Exception e1) {
                String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e1);
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("HintsUI.this.title"), 0);
            }
        }
    }

    private void checkNotificationDisplay() {
        block6: {
            int count = 0;
            if (this.context.cfg.isHintTrackingEnabled() && this.context.hintsHandler != null) {
                try {
                    HintKey hk = this.context.hintsHandler.findHintKey(this.context.publisherRepo);
                    if (hk != null) {
                        count = this.getHintCount(hk.system);
                    }
                    if (count > 0) {
                        String text = count + " " + this.context.cfg.gs("Navigator.hints.available");
                        this.logger.info(text);
                        this.context.mainFrame.labelAlertHintsMenu.setToolTipText(text);
                        this.context.mainFrame.labelAlertHintsToolbar.setToolTipText(text);
                        this.context.mainFrame.labelAlertHintsMenu.setVisible(true);
                        this.context.mainFrame.labelAlertHintsToolbar.setVisible(true);
                        break block6;
                    }
                    this.context.mainFrame.labelAlertHintsMenu.setVisible(false);
                    this.context.mainFrame.labelAlertHintsToolbar.setVisible(false);
                }
                catch (Exception e) {
                    this.context.fault = true;
                    this.logger.error(Utils.getStackTrace(e));
                }
            } else {
                this.context.mainFrame.labelAlertHintsMenu.setVisible(false);
                this.context.mainFrame.labelAlertHintsToolbar.setVisible(false);
            }
        }
    }

    private int getHintCount(String system) {
        int count = 0;
        if (this.hints != null && this.hints.size() > 0) {
            for (int i = 0; i < this.hints.size(); ++i) {
                HintStatus hs = this.hints.get(i).findStatus(system);
                if (hs != null && !hs.status.toLowerCase().equals("done")) {
                    ++count;
                    continue;
                }
                if (hs != null) continue;
                ++count;
            }
        }
        return count;
    }

    private Repositories getRepositories() {
        Repositories repositories = null;
        try {
            repositories = new Repositories();
            repositories.loadList(this.context);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("HintsUI.this.title"), 0);
        }
        return repositories;
    }

    private ArrayList<Hint> getSelectedFor(String hintSystemName) {
        ArrayList<Hint> results = new ArrayList<Hint>();
        if (this.model != null && this.hints != null) {
            for (Hint hint : this.hints) {
                if (!hint.selected || hint.isFor(hintSystemName) < -1) continue;
                results.add(hint);
            }
            if (results.size() > 0) {
                Collections.sort(results);
            }
        }
        return results;
    }

    public void refresh() {
        try {
            this.repositories = this.getRepositories();
            if (this.context.cfg.isHintTrackingEnabled()) {
                this.hints = this.context.hintsHandler.getAll();
                BrowserTableCellRenderer btcr = new BrowserTableCellRenderer(this.context, this.tableHints);
                for (int i = 1; i < 9; ++i) {
                    this.tableHints.getColumnModel().getColumn(i).setCellRenderer(btcr);
                }
                btcr = (BrowserTableCellRenderer)this.tableHints.getColumnModel().getColumn(4).getCellRenderer();
                btcr.setHorizontalAlignment(0);
                this.tableHints.getColumnModel().getColumn(4).setCellRenderer(btcr);
                this.model.fireTableDataChanged();
                this.pendingPublisher = 0;
                this.pendingSubscriber = 0;
                if (this.context.publisherRepo != null) {
                    this.publisherDisplayName = this.context.publisherRepo.getLibraryData().libraries.description;
                    HintKey hk = this.context.hintKeys.findKey(this.context.publisherRepo.getLibraryData().libraries.key);
                    if (hk != null) {
                        this.hintPublisherName = hk.system;
                        this.pendingPublisherHints = this.context.hintsHandler.getFor(this.hintPublisherName);
                        if (this.pendingPublisherHints != null) {
                            this.pendingPublisher = this.pendingPublisherHints.size();
                        }
                    } else {
                        this.hintPublisherName = this.context.preferences.isLastPublisherIsWorkstation() ? this.publisherDisplayName + "*" : MessageFormat.format(this.context.cfg.gs("HintsUI.not.in.hint.keys"), this.context.publisherRepo.getLibraryData().libraries.description);
                    }
                } else {
                    this.publisherDisplayName = this.context.cfg.gs("HintsUI.not.loaded");
                }
                if (this.context.subscriberRepo != null) {
                    HintKey hk = this.context.hintKeys.findKey(this.context.subscriberRepo.getLibraryData().libraries.key);
                    if (hk != null) {
                        this.hintSubscriberName = hk.system;
                        this.subscriberDisplayName = this.context.subscriberRepo.getLibraryData().libraries.description;
                        this.pendingSubscriberHints = this.context.hintsHandler.getFor(this.hintSubscriberName);
                        if (this.pendingSubscriberHints != null) {
                            this.pendingSubscriber = this.pendingSubscriberHints.size();
                        }
                    } else {
                        this.subscriberDisplayName = MessageFormat.format(this.context.cfg.gs("HintsUI.not.in.hint.keys"), this.context.subscriberRepo.getLibraryData().libraries.description);
                    }
                } else {
                    this.subscriberDisplayName = this.context.cfg.gs("HintsUI.not.loaded");
                }
                this.model.fireTableDataChanged();
                this.refreshStatus();
            } else {
                this.labelStatus.setText(this.context.cfg.gs("HintsUI.hint.tracker.server.not.enabled"));
            }
            this.setWidths();
            this.context.navigator.checkForHints();
            this.setButtons();
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.context.cfg.gs("HintsUI.this.title"), 0);
        }
    }

    private void refreshStatus() {
        int count = 0;
        if (this.model != null && this.hints != null && this.hints.size() > 0) {
            count = this.hints.size();
        }
        String msg = MessageFormat.format(this.context.cfg.gs("HintsUI.hints.for"), count, this.context.hintKeys.size(), this.pendingPublisher, this.publisherDisplayName, this.pendingSubscriber, this.subscriberDisplayName);
        this.labelStatus.setText(msg);
    }

    private void savePreferences() {
        this.context.preferences.setHintsHeight(this.getHeight());
        this.context.preferences.setHintsWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setHintsXpos(location.x);
        this.context.preferences.setHintsYpos(location.y);
        if (this.context.cfg.isHintTrackingEnabled()) {
            this.context.preferences.setHintsSystemWidth(this.tableHints.getColumnModel().getColumn(1).getWidth());
            this.context.preferences.setHintsByWidth(this.tableHints.getColumnModel().getColumn(2).getWidth());
            this.context.preferences.setHintsDateWidth(this.tableHints.getColumnModel().getColumn(3).getWidth());
            this.context.preferences.setHintsActionWidth(this.tableHints.getColumnModel().getColumn(4).getWidth());
            this.context.preferences.setHintsFromLibWidth(this.tableHints.getColumnModel().getColumn(5).getWidth());
            this.context.preferences.setHintsFromItemWidth(this.tableHints.getColumnModel().getColumn(6).getWidth());
            this.context.preferences.setHintsToLibWidth(this.tableHints.getColumnModel().getColumn(7).getWidth());
            this.context.preferences.setHintsToItemWidth(this.tableHints.getColumnModel().getColumn(8).getWidth());
            this.context.preferences.setHintsStatusWidth(this.tableHints.getColumnModel().getColumn(9).getWidth());
        }
    }

    public int setButtons() {
        int count = 0;
        if (this.model != null && this.hints != null && this.hints.size() > 0) {
            for (Hint hint : this.hints) {
                if (!hint.selected) continue;
                ++count;
            }
        }
        boolean enable = count > 0;
        this.buttonDelete.setEnabled(enable);
        this.buttonRun.setEnabled(enable);
        return count;
    }

    private void setWidths() {
        this.tableHints.getColumnModel().getColumn(0).setPreferredWidth(22);
        this.tableHints.getColumnModel().getColumn(0).setWidth(22);
        this.tableHints.getColumnModel().getColumn(0).setMaxWidth(22);
        this.tableHints.getColumnModel().getColumn(0).setMinWidth(22);
        this.tableHints.getColumnModel().getColumn(0).setResizable(false);
        this.tableHints.getColumnModel().getColumn(1).setPreferredWidth(this.context.preferences.getHintsSystemWidth());
        this.tableHints.getColumnModel().getColumn(1).setWidth(this.context.preferences.getHintsSystemWidth());
        this.tableHints.getColumnModel().getColumn(2).setPreferredWidth(this.context.preferences.getHintsByWidth());
        this.tableHints.getColumnModel().getColumn(2).setWidth(this.context.preferences.getHintsByWidth());
        this.tableHints.getColumnModel().getColumn(3).setPreferredWidth(this.context.preferences.getHintsDateWidth());
        this.tableHints.getColumnModel().getColumn(3).setWidth(this.context.preferences.getHintsDateWidth());
        this.tableHints.getColumnModel().getColumn(4).setPreferredWidth(this.context.preferences.getHintsActionWidth());
        this.tableHints.getColumnModel().getColumn(4).setWidth(this.context.preferences.getHintsActionWidth());
        this.tableHints.getColumnModel().getColumn(5).setPreferredWidth(this.context.preferences.getHintsFromLibWidth());
        this.tableHints.getColumnModel().getColumn(5).setWidth(this.context.preferences.getHintsFromLibWidth());
        this.tableHints.getColumnModel().getColumn(6).setPreferredWidth(this.context.preferences.getHintsFromItemWidth());
        this.tableHints.getColumnModel().getColumn(6).setWidth(this.context.preferences.getHintsFromItemWidth());
        this.tableHints.getColumnModel().getColumn(7).setPreferredWidth(this.context.preferences.getHintsToLibWidth());
        this.tableHints.getColumnModel().getColumn(7).setWidth(this.context.preferences.getHintsToLibWidth());
        this.tableHints.getColumnModel().getColumn(8).setPreferredWidth(this.context.preferences.getHintsToItemWidth());
        this.tableHints.getColumnModel().getColumn(8).setWidth(this.context.preferences.getHintsToItemWidth());
        if (this.context.cfg.isHintTrackingEnabled()) {
            for (int i = 0; i < this.context.hintKeys.size(); ++i) {
                this.tableHints.getColumnModel().getColumn(i + 9).setPreferredWidth(this.context.preferences.getHintsStatusWidth());
                this.tableHints.getColumnModel().getColumn(i + 9).setWidth(this.context.preferences.getHintsStatusWidth());
            }
        }
    }

    private void windowClosing(WindowEvent e) {
        this.context.navigator.enableDisableSystemMenus(null, true);
        this.cancelButton.doClick();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.buttonDelete = new JButton();
        this.hSpace42 = new JPanel(null);
        this.buttonRun = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.scrollPaneHints = new JScrollPane();
        this.tableHints = new JTable();
        this.panelOptionsButtons = new JPanel();
        this.buttonAll = new JButton();
        this.panelBottom = new JPanel();
        this.labelStatus = new JLabel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.tableHints.setModel(new HintsTableModel(this.context, this.repositories, this));
        this.setDefaultCloseOperation(0);
        this.setTitle(this.context.cfg.gs("HintsUI.this.title"));
        this.setMinimumSize(new Dimension(150, 126));
        this.setName("dialogEmptyDirectoryUI");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HintsUI.this.windowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(600, 550));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setPreferredSize(new Dimension(570, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonDelete.setText(this.context.cfg.gs("HintsUI.buttonDelete.text"));
        this.buttonDelete.setMnemonic('D');
        this.buttonDelete.setToolTipText(this.context.cfg.gs("HintsUI.buttonDelete.toolTipText"));
        this.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopButtons.add(this.buttonDelete);
        this.hSpace42.setMinimumSize(new Dimension(22, 6));
        this.hSpace42.setPreferredSize(new Dimension(22, 6));
        this.panelTopButtons.add(this.hSpace42);
        this.buttonRun.setText(this.context.cfg.gs("Z.run.ellipsis"));
        this.buttonRun.setMnemonic(this.context.cfg.gs("HintsUI.buttonRun.mnemonic").charAt(0));
        this.buttonRun.setToolTipText(this.context.cfg.gs("HintsUI.buttonRun.toolTipText"));
        this.buttonRun.addActionListener(e -> this.actionRunClicked(e));
        this.panelTopButtons.add(this.buttonRun);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("HintsUI.labelHelp.toolTipText"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HintsUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "Center");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.tableHints.setFillsViewportHeight(true);
        this.tableHints.setSelectionMode(0);
        this.tableHints.setAutoResizeMode(1);
        this.tableHints.setShowHorizontalLines(false);
        this.tableHints.setShowVerticalLines(false);
        this.tableHints.setAutoCreateRowSorter(true);
        this.scrollPaneHints.setViewportView(this.tableHints);
        this.contentPanel.add((Component)this.scrollPaneHints, "Center");
        this.panelOptionsButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAll.setText(this.context.cfg.gs("HintsUI.buttonAll.text"));
        this.buttonAll.setFont(this.buttonAll.getFont().deriveFont((float)this.buttonAll.getFont().getSize() - 2.0f));
        this.buttonAll.setPreferredSize(new Dimension(78, 24));
        this.buttonAll.setMinimumSize(new Dimension(78, 24));
        this.buttonAll.setMaximumSize(new Dimension(78, 24));
        this.buttonAll.setMnemonic(this.context.cfg.gs("HintsUI.buttonAll.mnemonic").charAt(0));
        this.buttonAll.setToolTipText(this.context.cfg.gs("HintsUI.buttonAll.toolTipText"));
        this.buttonAll.setMargin(new Insets(0, -10, 0, -10));
        this.buttonAll.addActionListener(e -> this.actionAllClicked(e));
        this.panelOptionsButtons.add(this.buttonAll);
        this.contentPanel.add((Component)this.panelOptionsButtons, "South");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.panelBottom.setLayout(new BorderLayout());
        this.labelStatus.setMaximumSize(new Dimension(32768, 0));
        this.panelBottom.add((Component)this.labelStatus, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText(this.context.cfg.gs("Z.ok"));
        this.okButton.setToolTipText(this.context.cfg.gs("Z.save.toolTip.text"));
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(e -> this.actionOkClicked(e));
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText(this.context.cfg.gs("Z.cancel"));
        this.cancelButton.setToolTipText(this.context.cfg.gs("Z.cancel.changes.toolTipText"));
        this.cancelButton.setMnemonic('L');
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelBottom.add((Component)this.buttonBar, "After");
        this.dialogPane.add((Component)this.panelBottom, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

