/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.email;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.ConfigModel;
import com.corionis.els.gui.util.NumberFilter;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.email.EmailHandler;
import com.corionis.els.tools.email.EmailTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.PlainDocument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmailUI
extends AbstractToolDialog {
    private ConfigModel configModel;
    private Context context;
    private EmailTool currentTool = null;
    private EmailHandler emailHandler = null;
    private NavHelp helpDialog;
    private boolean hidePassword = true;
    private boolean inUpdateOnChange = false;
    private boolean loading = false;
    private Logger logger = LogManager.getLogger("applog");
    private NumberFilter numberFilter;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panelTop;
    private JPanel panelTopButtons;
    private JButton buttonNew;
    private JButton buttonCopy;
    private JButton buttonDelete;
    private JPanel panelHelp;
    private JLabel labelHelp;
    private JSplitPane splitPaneContent;
    private JScrollPane scrollPaneConfig;
    private JTable configItems;
    private JPanel panelOptions;
    private JScrollPane scrollPaneOptions;
    private JPanel panelServer;
    private JLabel labelPanelTitle;
    private JLabel labelProfile;
    private JComboBox<String> comboBoxProfile;
    private JLabel labelServerName;
    private JTextField textFieldServerName;
    private JLabel labelUsername;
    private JTextField textFieldUsername;
    private JLabel labelPassword;
    private JPanel panelPassword;
    private JButton buttonPassword;
    private JPasswordField passwordField;
    private JLabel labelPort;
    private JTextField textFieldPort;
    private JLabel labelSecurity;
    private JComboBox<String> comboBoxSecurity;
    private JLabel labelAuthMethod;
    private JComboBox<String> comboBoxAuthMethod;
    private JPanel panelOptionsButtons;
    public JButton buttonAuth;
    public JButton buttonTest;
    private JPanel buttonBar;
    public JLabel labelStatus;
    private JButton saveButton;
    private JButton cancelButton;

    public EmailUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.initComponents();
        Icon icon = this.labelHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelHelp.setIcon(replacement);
        if (context.preferences.getToolsEmailXpos() != -1 && Utils.isOnScreen(context.preferences.getToolsEmailXpos(), context.preferences.getToolsEmailYpos())) {
            this.setLocation(context.preferences.getToolsEmailXpos(), context.preferences.getToolsEmailYpos());
            Dimension dim = new Dimension(context.preferences.getToolsEmailWidth(), context.preferences.getToolsEmailHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        this.splitPaneContent.setDividerLocation(context.preferences.getToolsEmailDividerLocation());
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EmailUI.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.numberFilter = new NumberFilter();
        PlainDocument pd = (PlainDocument)this.textFieldPort.getDocument();
        pd.setDocumentFilter(this.numberFilter);
        this.configModel = new ConfigModel(context, this);
        this.configModel.setColumnCount(1);
        this.configItems.setModel(this.configModel);
        this.configItems.getTableHeader().setUI(null);
        this.configItems.setTableHeader(null);
        this.scrollPaneConfig.setColumnHeaderView(null);
        ListSelectionModel lsm = this.configItems.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel sm = (ListSelectionModel)listSelectionEvent.getSource();
                    int index = sm.getMinSelectionIndex();
                    EmailUI.this.loadEmail(index);
                }
            }
        });
        this.loadConfigurations();
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void actionAuthClicked(ActionEvent event) {
        if (this.emailHandler != null && this.emailHandler.isWorkerRunning()) {
            this.interruptEmailHandler();
            this.emailHandler = null;
            return;
        }
        this.emailHandler = null;
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            this.currentTool = (EmailTool)this.configModel.getValueAt(index, 0);
            this.labelStatus.setText(" ");
            this.updateControls(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.buttonAuth.setText(this.context.cfg.gs("EmailUI.button.cancel"));
            this.buttonAuth.setToolTipText(this.context.cfg.gs("EmailUI.buttonAuth.toolTipCancel"));
            this.buttonAuth.setEnabled(true);
            this.buttonAuth.setCursor(Cursor.getPredefinedCursor(0));
            this.emailHandler = new EmailHandler(this.context, this, this.currentTool, EmailHandler.Function.AUTH);
            this.emailHandler.start();
        }
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.checkForChanges()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.cleanUp();
                this.cancelChanges();
                this.setVisible(false);
            }
        } else {
            this.cleanUp();
            this.setVisible(false);
        }
    }

    private void actionCopyClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            EmailTool orig = (EmailTool)this.configModel.getValueAt(index, 0);
            String rename = orig.getConfigName() + this.context.cfg.gs("Z.copy");
            if (this.configModel.find(rename, null) == null) {
                EmailTool et = orig.clone();
                et.setConfigName(rename);
                et.setDataHasChanged();
                this.configModel.addRow(new Object[]{et});
                this.currentTool = (EmailTool)this.configModel.getValueAt(this.configModel.getRowCount() - 1, 0);
                this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
                this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + rename, this.context.cfg.gs("Email.title"), 2);
            }
        }
    }

    private void actionDeleteClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            this.currentTool = (EmailTool)this.configModel.getValueAt(index, 0);
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.are.you.sure.you.want.to.delete.configuration") + this.currentTool.getConfigName(), this.context.cfg.gs("Z.delete.configuration"), 0);
            if (reply == 0) {
                int answer = this.configModel.checkJobConflicts(this.currentTool.getConfigName(), null, this.currentTool.getInternalName(), false);
                if (answer >= 0) {
                    File file = new File(this.currentTool.getFullPath());
                    if (file.exists()) {
                        this.deletedTools.add(this.currentTool);
                    }
                    this.configModel.removeRow(index);
                    index = this.configModel.getRowCount() - 1;
                    this.configModel.fireTableDataChanged();
                    if (index >= 0) {
                        this.currentTool = (EmailTool)this.configModel.getValueAt(index, 0);
                        this.configItems.changeSelection(index, 0, false, false);
                    } else {
                        this.currentTool = null;
                    }
                    this.loadEmail(index);
                }
                this.configItems.requestFocus();
            }
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("EmailUI.help"), "email_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionNewClicked(ActionEvent e) {
        if (this.configModel.find(this.context.cfg.gs("Z.untitled"), null) == null) {
            EmailTool emt = new EmailTool(this.context);
            emt.setConfigName(this.context.cfg.gs("Z.untitled"));
            emt.setDataHasChanged();
            this.configModel.addRow(new Object[]{emt});
            this.loadEmail(this.configModel.getRowCount() - 1);
            this.updateControls();
            this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
            this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
            this.configItems.getEditorComponent().requestFocus();
            ((JTextField)this.configItems.getEditorComponent()).selectAll();
        } else {
            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.context.cfg.gs("Email.title"), 2);
        }
    }

    private void actionPasswordClicked(ActionEvent e) {
        if (this.hidePassword) {
            this.passwordField.setEchoChar('\u0000');
            this.hidePassword = false;
        } else {
            this.passwordField.setEchoChar('\u25cf');
            this.hidePassword = true;
        }
    }

    private void actionSaveClicked(ActionEvent e) {
        this.cleanUp();
        this.saveConfigurations();
        this.savePreferences();
        this.setVisible(false);
    }

    private void actionTestClicked(ActionEvent event) {
        if (this.emailHandler != null && this.emailHandler.isWorkerRunning()) {
            this.interruptEmailHandler();
            this.emailHandler = null;
            return;
        }
        this.emailHandler = null;
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            this.currentTool = (EmailTool)this.configModel.getValueAt(index, 0);
            this.labelStatus.setText(" ");
            this.updateControls(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.buttonTest.setText(this.context.cfg.gs("EmailUI.button.cancel"));
            this.buttonTest.setToolTipText(this.context.cfg.gs("EmailUI.buttonAuth.toolTipCancel"));
            this.buttonTest.setEnabled(true);
            this.buttonTest.setCursor(Cursor.getPredefinedCursor(0));
            this.emailHandler = new EmailHandler(this.context, this, this.currentTool, EmailHandler.Function.TEST);
            this.emailHandler.start();
        }
    }

    public void cancelChanges() {
        if (this.deletedTools.size() > 0) {
            this.deletedTools = new ArrayList();
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            ((EmailTool)this.configModel.getValueAt(i, 0)).setDataHasChanged(false);
        }
        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.changes.cancelled"));
    }

    public boolean checkForChanges() {
        if (!this.deletedTools.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            if (!((EmailTool)this.configModel.getValueAt(i, 0)).isDataChanged()) continue;
            return true;
        }
        return false;
    }

    private void cleanUp() {
        if (this.emailHandler != null) {
            if (this.emailHandler.isWorkerRunning()) {
                this.emailHandler.interrupt();
            }
            this.emailHandler = null;
        }
    }

    private void configItemsMouseClicked(MouseEvent e) {
        JTable src = (JTable)e.getSource();
        if (e.getClickCount() == 1) {
            int index = src.getSelectedRow();
            this.loadEmail(index);
        }
    }

    @Override
    public JTable getConfigItems() {
        return this.configItems;
    }

    public void genericAction(ActionEvent e) {
        this.updateOnChange(e.getSource());
    }

    public void genericTextFieldFocusLost(FocusEvent e) {
        this.updateOnChange(e.getSource());
    }

    public EmailTool getCurrentTool() {
        return this.currentTool;
    }

    public EmailHandler getEmailHandler() {
        return this.emailHandler;
    }

    private void interruptEmailHandler() {
        this.emailHandler.interrupt();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.updateControls();
        this.buttonAuth.setText(this.context.cfg.gs("EmailUI.buttonAuth.text"));
        this.buttonAuth.setToolTipText(this.context.cfg.gs("EmailUI.buttonAuth.toolTipText"));
        this.labelStatus.setText(this.context.cfg.gs("EmailUI.authentication.cancel"));
    }

    private void loadConfigurations() {
        ArrayList<AbstractTool> toolList = null;
        try {
            toolList = this.context.tools.loadAllTools(this.context, "Email");
            for (AbstractTool tool : toolList) {
                EmailTool jrt = (EmailTool)tool;
                this.configModel.addRow(new Object[]{jrt});
            }
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogEmail, msg, this.context.cfg.gs("Email.title"), 0);
            }
            this.logger.error(msg);
        }
        this.configModel.setToolList(toolList);
        this.configModel.loadJobsConfigurations(this, null);
        if (this.configModel.getRowCount() == 0) {
            this.loadEmail(-1);
        } else {
            this.loadEmail(0);
            this.configItems.requestFocus();
            this.configItems.setRowSelectionInterval(0, 0);
        }
    }

    private void loadEmail(int index) {
        this.loading = true;
        if (index >= 0 && index < this.configModel.getRowCount()) {
            this.currentTool = (EmailTool)this.configModel.getValueAt(index, 0);
            this.textFieldServerName.setText(this.currentTool.getServer());
            this.textFieldUsername.setText(this.currentTool.getUsername());
            this.textFieldPort.setText(this.currentTool.getPort());
            this.comboBoxProfile.setSelectedItem(this.currentTool.getProfile());
            this.comboBoxSecurity.setSelectedItem(this.currentTool.getSecurity());
            this.comboBoxAuthMethod.setSelectedItem(this.currentTool.getAuthMethod());
            if (this.currentTool.getPassword().length() > 0) {
                this.passwordField.setText(this.currentTool.getPassword());
                this.hidePassword = false;
            } else {
                this.passwordField.setText("");
                this.hidePassword = true;
            }
            this.buttonPassword.doClick();
            this.updateControls();
        } else {
            this.currentTool = null;
            this.textFieldServerName.setText("");
            this.textFieldUsername.setText("");
            this.passwordField.setText("");
            this.textFieldPort.setText("");
            this.comboBoxProfile.setSelectedIndex(0);
            this.comboBoxSecurity.setSelectedIndex(0);
            this.comboBoxAuthMethod.setSelectedIndex(0);
            this.updateControls();
            this.hidePassword = true;
            this.buttonPassword.doClick();
        }
        this.loading = false;
    }

    private void saveConfigurations() {
        EmailTool tool = null;
        try {
            int i;
            for (i = 0; i < this.deletedTools.size(); ++i) {
                tool = (EmailTool)this.deletedTools.get(i);
                File file = new File(tool.getFullPath());
                if (!file.exists()) continue;
                file.delete();
            }
            this.deletedTools = new ArrayList();
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                tool = (EmailTool)this.configModel.getValueAt(i, 0);
                this.updateOnChange(this.comboBoxProfile);
                this.updateOnChange(this.comboBoxSecurity);
                this.updateOnChange(this.comboBoxAuthMethod);
                if (tool.isDataChanged()) {
                    tool.write();
                }
                tool.setDataHasChanged(false);
            }
            this.configModel.saveJobsConfigurations(null);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogEmail, msg, this.context.cfg.gs("Email.title"), 0);
            }
            this.logger.error(msg);
        }
    }

    private void savePreferences() {
        this.context.preferences.setToolsEmailHeight(this.getHeight());
        this.context.preferences.setToolsEmailWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setToolsEmailXpos(location.x);
        this.context.preferences.setToolsEmailYpos(location.y);
        this.context.preferences.setToolsEmailDividerLocation(this.splitPaneContent.getDividerLocation());
    }

    private void updateOnChange(Object source) {
        if (this.inUpdateOnChange || this.loading) {
            return;
        }
        this.inUpdateOnChange = true;
        String name = null;
        if (source != null && this.currentTool != null && !this.loading) {
            String current = "";
            String value = "";
            if (source instanceof JPasswordField) {
                JPasswordField pf = (JPasswordField)source;
                current = this.currentTool.getPassword();
                char[] chars = pf.getPassword();
                value = new String(chars);
                if (value.isEmpty()) {
                    value = "";
                }
                this.currentTool.setPassword(value);
            } else if (source instanceof JTextField) {
                JTextField tf = (JTextField)source;
                name = tf.getName();
                switch (name.toLowerCase()) {
                    case "server": {
                        current = this.currentTool.getServer();
                        value = tf.getText();
                        this.currentTool.setServer(value);
                        break;
                    }
                    case "username": {
                        current = this.currentTool.getUsername();
                        value = tf.getText();
                        this.currentTool.setUsername(value);
                        break;
                    }
                    case "port": {
                        current = this.currentTool.getPort();
                        value = tf.getText();
                        this.currentTool.setPort(value);
                    }
                }
            } else if (source instanceof JComboBox) {
                JComboBox combo = (JComboBox)source;
                name = combo.getName();
                switch (name.toLowerCase()) {
                    case "profile": {
                        current = this.currentTool.getProfile();
                        value = this.comboBoxProfile.getSelectedItem().toString();
                        this.currentTool.setProfile(value);
                        break;
                    }
                    case "security": {
                        current = this.currentTool.getSecurity();
                        value = this.comboBoxSecurity.getSelectedItem().toString();
                        this.currentTool.setSecurity(value);
                        break;
                    }
                    case "authmethod": {
                        current = this.currentTool.getAuthMethod();
                        value = this.comboBoxAuthMethod.getSelectedItem().toString();
                        this.currentTool.setAuthMethod(value);
                        if (this.currentTool.getAuthMethod().equalsIgnoreCase("oauth2")) {
                            this.buttonAuth.setEnabled(true);
                            break;
                        }
                        this.buttonAuth.setEnabled(false);
                    }
                }
            }
            if (!current.equals(value)) {
                this.currentTool.setDataHasChanged();
            }
        }
        this.inUpdateOnChange = false;
    }

    public void updateControls() {
        this.buttonNew.setEnabled(true);
        if (this.configModel.getRowCount() > 0) {
            this.buttonCopy.setEnabled(true);
            this.buttonDelete.setEnabled(true);
            if (this.currentTool != null) {
                if (this.currentTool.getAuthMethod().equalsIgnoreCase("oauth2")) {
                    SimpleDateFormat dateFormatter = new SimpleDateFormat(this.context.preferences.getDateFormat());
                    String stamp = dateFormatter.format(this.currentTool.getAccessExpires());
                    this.logger.info(this.currentTool.getUsername() + " access expires: " + stamp);
                    stamp = dateFormatter.format(this.currentTool.getRefreshExpires());
                    this.logger.info(this.currentTool.getUsername() + " refresh expires: " + stamp);
                    if (!this.currentTool.isExpired(this.currentTool.getAccessExpires()) && !this.currentTool.isExpired(this.currentTool.getRefreshExpires())) {
                        this.buttonAuth.setEnabled(false);
                        this.buttonTest.setEnabled(true);
                    } else if (this.currentTool.isExpired(this.currentTool.getAccessExpires()) && this.currentTool.isExpired(this.currentTool.getRefreshExpires())) {
                        this.buttonAuth.setEnabled(true);
                        this.buttonTest.setEnabled(false);
                        this.labelStatus.setText(this.context.cfg.gs("EmailUI.authentication.expired"));
                    } else {
                        this.labelStatus.setText("<html><body>&nbsp;</body></html>");
                        this.buttonAuth.setEnabled(false);
                        this.buttonTest.setEnabled(true);
                    }
                } else {
                    this.labelStatus.setText("<html><body>&nbsp;</body></html>");
                    this.buttonAuth.setEnabled(false);
                    this.buttonTest.setEnabled(true);
                }
                if (this.context.publisherRepo == null || this.context.publisherRepo.getLibraryData().libraries.email == null || this.context.publisherRepo.getLibraryData().libraries.email.length() == 0) {
                    this.buttonTest.setEnabled(false);
                    this.buttonTest.setToolTipText(this.context.cfg.gs("EmailUI.buttonTest.toolTipText.disabled"));
                } else {
                    this.buttonTest.setToolTipText(this.context.cfg.gs("EmailUI.buttonTest.toolTipText") + " " + this.context.publisherRepo.getLibraryData().libraries.email);
                }
            } else {
                this.buttonAuth.setEnabled(false);
                this.buttonTest.setEnabled(false);
                this.buttonTest.setToolTipText(this.context.cfg.gs("EmailUI.buttonTest.toolTipText") + " " + this.context.publisherRepo.getLibraryData().libraries.email);
            }
        } else {
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonAuth.setEnabled(false);
            this.buttonTest.setEnabled(false);
        }
        this.saveButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    private void updateControls(boolean enable) {
        this.buttonNew.setEnabled(enable);
        this.buttonCopy.setEnabled(enable);
        this.buttonDelete.setEnabled(enable);
        if (this.currentTool != null && this.currentTool.getAuthMethod().equalsIgnoreCase("oauth2")) {
            this.buttonAuth.setEnabled(enable);
        } else {
            this.buttonAuth.setEnabled(false);
        }
        this.buttonTest.setEnabled(enable);
        this.saveButton.setEnabled(enable);
        this.cancelButton.setEnabled(enable);
    }

    private void windowClosing(WindowEvent e) {
        this.cancelButton.doClick();
    }

    private void windowHidden(ComponentEvent e) {
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.buttonNew = new JButton();
        this.buttonCopy = new JButton();
        this.buttonDelete = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.splitPaneContent = new JSplitPane();
        this.scrollPaneConfig = new JScrollPane();
        this.configItems = new JTable();
        this.panelOptions = new JPanel();
        this.scrollPaneOptions = new JScrollPane();
        this.panelServer = new JPanel();
        this.labelPanelTitle = new JLabel();
        this.labelProfile = new JLabel();
        this.comboBoxProfile = new JComboBox();
        this.labelServerName = new JLabel();
        this.textFieldServerName = new JTextField();
        this.labelUsername = new JLabel();
        this.textFieldUsername = new JTextField();
        this.labelPassword = new JLabel();
        this.panelPassword = new JPanel();
        this.buttonPassword = new JButton();
        this.passwordField = new JPasswordField();
        this.labelPort = new JLabel();
        this.textFieldPort = new JTextField();
        this.labelSecurity = new JLabel();
        this.comboBoxSecurity = new JComboBox();
        this.labelAuthMethod = new JLabel();
        this.comboBoxAuthMethod = new JComboBox();
        this.panelOptionsButtons = new JPanel();
        this.buttonAuth = new JButton();
        this.buttonTest = new JButton();
        this.buttonBar = new JPanel();
        this.labelStatus = new JLabel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.context.cfg.gs("EmailUI.title"));
        this.setName("emailUI");
        this.setMinimumSize(new Dimension(150, 126));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EmailUI.this.windowClosing(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                EmailUI.this.windowHidden(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(595, 525));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setPreferredSize(new Dimension(570, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonNew.setText(this.context.cfg.gs("EmailUI.buttonNew.text"));
        this.buttonNew.setMnemonic(this.context.cfg.gs("EmailUI.buttonNew.mnemonic").charAt(0));
        this.buttonNew.setToolTipText(this.context.cfg.gs("EmailUI.buttonNew.toolTipText"));
        this.buttonNew.addActionListener(e -> this.actionNewClicked(e));
        this.panelTopButtons.add(this.buttonNew);
        this.buttonCopy.setText(this.context.cfg.gs("EmailUI.buttonCopy.text"));
        this.buttonCopy.setMnemonic(this.context.cfg.gs("EmailUI.buttonCopy.mnemonic").charAt(0));
        this.buttonCopy.setToolTipText(this.context.cfg.gs("EmailUI.buttonCopy.toolTipText"));
        this.buttonCopy.addActionListener(e -> this.actionCopyClicked(e));
        this.panelTopButtons.add(this.buttonCopy);
        this.buttonDelete.setText(this.context.cfg.gs("EmailUI.buttonDelete.text"));
        this.buttonDelete.setMnemonic(this.context.cfg.gs("EmailUI.buttonDelete.mnemonic").charAt(0));
        this.buttonDelete.setToolTipText(this.context.cfg.gs("EmailUI.buttonDelete.toolTipText"));
        this.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopButtons.add(this.buttonDelete);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("EmailUI.labelHelp.toolTipText"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EmailUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "East");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.splitPaneContent.setDividerLocation(142);
        this.splitPaneContent.setLastDividerLocation(142);
        this.splitPaneContent.setMinimumSize(new Dimension(140, 80));
        this.scrollPaneConfig.setMinimumSize(new Dimension(140, 16));
        this.scrollPaneConfig.setPreferredSize(new Dimension(142, 146));
        this.configItems.setSelectionMode(0);
        this.configItems.setShowVerticalLines(false);
        this.configItems.setFillsViewportHeight(true);
        this.configItems.setShowHorizontalLines(false);
        this.configItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EmailUI.this.configItemsMouseClicked(e);
            }
        });
        this.scrollPaneConfig.setViewportView(this.configItems);
        this.splitPaneContent.setLeftComponent(this.scrollPaneConfig);
        this.panelOptions.setMinimumSize(new Dimension(0, 78));
        this.panelOptions.setLayout(new BorderLayout());
        this.panelServer.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelServer.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.panelServer.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.labelPanelTitle.setText(this.context.cfg.gs("EmailUI.labelPanelTitle.text"));
        this.labelPanelTitle.setFont(this.labelPanelTitle.getFont().deriveFont(this.labelPanelTitle.getFont().getStyle() | 1, (float)this.labelPanelTitle.getFont().getSize() + 1.0f));
        this.panelServer.add((Component)this.labelPanelTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(4, 0, 6, 0), 0, 0));
        this.labelProfile.setText(this.context.cfg.gs("EmailUI.labelProfile.text"));
        this.panelServer.add((Component)this.labelProfile, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.comboBoxProfile.setName("profile");
        this.comboBoxProfile.setModel(new DefaultComboBoxModel<String>(new String[]{"Apple", "GMail", "Outlook", "SMTP", "Zoho"}));
        this.comboBoxProfile.setToolTipText(this.context.cfg.gs("EmailUI.comboBox.Profile.toolTipText"));
        this.comboBoxProfile.addActionListener(e -> this.genericAction(e));
        this.panelServer.add(this.comboBoxProfile, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.labelServerName.setText(this.context.cfg.gs("EmailUI.labelServerName.text"));
        this.panelServer.add((Component)this.labelServerName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldServerName.setMinimumSize(new Dimension(240, 34));
        this.textFieldServerName.setName("server");
        this.textFieldServerName.setPreferredSize(new Dimension(240, 34));
        this.textFieldServerName.addActionListener(e -> this.genericAction(e));
        this.textFieldServerName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EmailUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelServer.add((Component)this.textFieldServerName, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 0), 0, 0));
        this.labelUsername.setText(this.context.cfg.gs("EmailUI.labelUsername.text"));
        this.panelServer.add((Component)this.labelUsername, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldUsername.setName("username");
        this.textFieldUsername.addActionListener(e -> this.genericAction(e));
        this.textFieldUsername.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EmailUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelServer.add((Component)this.textFieldUsername, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 0), 0, 0));
        this.labelPassword.setText(this.context.cfg.gs("EmailUI.labelPassword.text"));
        this.panelServer.add((Component)this.labelPassword, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.panelPassword.setLayout(new BorderLayout());
        this.buttonPassword.setIcon(new ImageIcon(this.getClass().getResource("/password.png")));
        this.buttonPassword.setToolTipText(this.context.cfg.gs("EmailUI.buttonPassword.toolTipText"));
        this.buttonPassword.setPreferredSize(new Dimension(28, 28));
        this.buttonPassword.setMinimumSize(new Dimension(28, 28));
        this.buttonPassword.setMaximumSize(new Dimension(28, 28));
        this.buttonPassword.setOpaque(false);
        this.buttonPassword.addActionListener(e -> this.actionPasswordClicked(e));
        this.panelPassword.add((Component)this.buttonPassword, "East");
        this.passwordField.setName("password");
        this.passwordField.addActionListener(e -> this.genericAction(e));
        this.passwordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EmailUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelPassword.add((Component)this.passwordField, "Center");
        this.panelServer.add((Component)this.panelPassword, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 0), 0, 0));
        this.labelPort.setText(this.context.cfg.gs("EmailUI.labelPort.text"));
        this.panelServer.add((Component)this.labelPort, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldPort.setName("port");
        this.textFieldPort.setPreferredSize(new Dimension(64, 34));
        this.textFieldPort.setMaximumSize(new Dimension(64, Integer.MAX_VALUE));
        this.textFieldPort.addActionListener(e -> this.genericAction(e));
        this.textFieldPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EmailUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelServer.add((Component)this.textFieldPort, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.labelSecurity.setText(this.context.cfg.gs("EmailUI.labelSecurity.text"));
        this.panelServer.add((Component)this.labelSecurity, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.comboBoxSecurity.setModel(new DefaultComboBoxModel<String>(new String[]{"STARTTLS", "SSL/TLS", "None"}));
        this.comboBoxSecurity.setName("security");
        this.comboBoxSecurity.addActionListener(e -> this.genericAction(e));
        this.panelServer.add(this.comboBoxSecurity, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.labelAuthMethod.setText(this.context.cfg.gs("EmailUI.labelAuthMethod.text"));
        this.panelServer.add((Component)this.labelAuthMethod, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 8), 0, 0));
        this.comboBoxAuthMethod.setModel(new DefaultComboBoxModel<String>(new String[]{"Plain", "Login", "OAuth2"}));
        this.comboBoxAuthMethod.setName("authmethod");
        this.comboBoxAuthMethod.addActionListener(e -> this.genericAction(e));
        this.panelServer.add(this.comboBoxAuthMethod, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 4, 0), 0, 0));
        this.scrollPaneOptions.setViewportView(this.panelServer);
        this.panelOptions.add((Component)this.scrollPaneOptions, "Center");
        this.panelOptionsButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAuth.setText(this.context.cfg.gs("EmailUI.buttonAuth.text"));
        this.buttonAuth.setFont(this.buttonAuth.getFont().deriveFont((float)this.buttonAuth.getFont().getSize() - 2.0f));
        this.buttonAuth.setPreferredSize(new Dimension(110, 24));
        this.buttonAuth.setMinimumSize(new Dimension(110, 24));
        this.buttonAuth.setMaximumSize(new Dimension(110, 24));
        this.buttonAuth.setMnemonic('A');
        this.buttonAuth.setToolTipText(this.context.cfg.gs("EmailUI.buttonAuth.toolTipText"));
        this.buttonAuth.setMargin(new Insets(0, -10, 0, -10));
        this.buttonAuth.addActionListener(e -> this.actionAuthClicked(e));
        this.panelOptionsButtons.add(this.buttonAuth);
        this.buttonTest.setText(this.context.cfg.gs("EmailUI.buttonTest.text"));
        this.buttonTest.setFont(this.buttonTest.getFont().deriveFont((float)this.buttonTest.getFont().getSize() - 2.0f));
        this.buttonTest.setPreferredSize(new Dimension(78, 24));
        this.buttonTest.setMinimumSize(new Dimension(78, 24));
        this.buttonTest.setMaximumSize(new Dimension(78, 24));
        this.buttonTest.setMnemonic('T');
        this.buttonTest.setToolTipText(this.context.cfg.gs("EmailUI.buttonTest.toolTipText"));
        this.buttonTest.setMargin(new Insets(0, -10, 0, -10));
        this.buttonTest.addActionListener(e -> this.actionTestClicked(e));
        this.panelOptionsButtons.add(this.buttonTest);
        this.panelOptions.add((Component)this.panelOptionsButtons, "South");
        this.splitPaneContent.setRightComponent(this.panelOptions);
        this.contentPanel.add((Component)this.splitPaneContent, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.buttonBar.add((Component)this.labelStatus, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.saveButton.setText(this.context.cfg.gs("EmailUI.saveButton.text"));
        this.saveButton.setToolTipText(this.context.cfg.gs("EmailUI.saveButton.toolTipText"));
        this.saveButton.setMnemonic('S');
        this.saveButton.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText(this.context.cfg.gs("EmailUI.cancelButton.text"));
        this.cancelButton.setToolTipText(this.context.cfg.gs("EmailUI.cancelButton.toolTipText"));
        this.cancelButton.setMnemonic('L');
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

