/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.emptyDirectoryFinder;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.tools.emptyDirectoryFinder.EmptiesTableModel;
import com.corionis.els.repository.Item;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmptyDirectoryFinderUI
extends JDialog {
    private boolean allSelected = false;
    private Context context;
    private ArrayList<Empty> empties;
    private boolean isPublisher = false;
    private Logger logger = LogManager.getLogger("applog");
    private NavHelp helpDialog;
    private boolean requestStop = false;
    private final EmptyDirectoryFinderUI thisDialog = this;
    private JTree sourceTree = null;
    private boolean workerRunning = false;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panelTop;
    private JPanel panelTopButtons;
    private JButton buttonRun;
    private JPanel hSpacerBeforeRun;
    private JButton buttonDelete;
    private JPanel panelHelp;
    private JLabel labelHelp;
    private JScrollPane scrollPaneEmpties;
    private JTable tableEmpties;
    private JPanel panelOptionsButtons;
    private JButton buttonAll;
    private JPanel panelBottom;
    private JLabel labelStatus;
    private JPanel buttonBar;
    private JButton closeButton;

    private EmptyDirectoryFinderUI() {
    }

    public EmptyDirectoryFinderUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.initComponents();
        Icon icon = this.labelHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelHelp.setIcon(replacement);
        if (context.preferences.getToolsEmptyDirectoryFinderXpos() != -1 && Utils.isOnScreen(context.preferences.getToolsEmptyDirectoryFinderXpos(), context.preferences.getToolsEmptyDirectoryFinderYpos())) {
            this.setLocation(context.preferences.getToolsEmptyDirectoryFinderXpos(), context.preferences.getToolsEmptyDirectoryFinderYpos());
            Dimension dim = new Dimension(context.preferences.getToolsEmptyDirectoryFinderWidth(), context.preferences.getToolsEmptyDirectoryFinderHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EmptyDirectoryFinderUI.this.closeButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.adjustEmptiesTable();
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
        this.buttonDelete.setEnabled(false);
        this.buttonAll.setEnabled(false);
    }

    private void actionAllClicked(ActionEvent e) {
        if (this.empties.size() > 0) {
            this.allSelected = !this.allSelected;
            for (int i = 0; i < this.empties.size(); ++i) {
                this.empties.get((int)i).isSelected = this.allSelected;
            }
            EmptiesTableModel etm = (EmptiesTableModel)this.tableEmpties.getModel();
            etm.fireTableDataChanged();
        }
    }

    private void actionCloseClicked(ActionEvent e) {
        if (this.workerRunning) {
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.stop.run.after.scan"), "Z.cancel.run", 0);
            if (reply == 0) {
                this.requestStop = true;
                this.logger.info(this.context.cfg.gs("Z.run.cancelled"));
            } else {
                return;
            }
        }
        this.savePreferences();
        this.setVisible(false);
    }

    private void actionDeleteClicked(ActionEvent e) {
        int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("EmptyDirectoryFinder.delete.the.selected.empties"), this.getTitle(), 0);
        if (reply == 0) {
            Empty empty;
            int i;
            EmptiesTableModel etm = (EmptiesTableModel)this.tableEmpties.getModel();
            int deletes = 0;
            for (i = 0; i < this.empties.size(); ++i) {
                empty = this.empties.get(i);
                if (!empty.isSelected || this.context.transfer == null) continue;
                try {
                    String path = Utils.makeLinuxPath(empty.path);
                    this.logger.info(this.context.cfg.gs("EmptyDirectoryFinder.removing") + path);
                    this.context.transfer.remove(path, !this.isPublisher && this.context.cfg.isRemoteOperation());
                }
                catch (Exception ex) {
                    empty.isSelected = false;
                    String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(ex);
                    this.logger.error(msg, (Object)true);
                    JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
                }
                ++deletes;
            }
            for (i = this.empties.size() - 1; i >= 0; --i) {
                empty = this.empties.get(i);
                if (!empty.isSelected) continue;
                this.empties.remove(i);
            }
            etm.fireTableDataChanged();
            this.labelStatus.setText(this.context.cfg.gs("Z.deleted") + deletes);
            if (this.sourceTree != null) {
                this.context.browser.rescanByTreeOrTable(this.sourceTree);
            }
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("EmptyDirectoryFinder.help"), "emptydirectoryfinder_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionNoneClicked(ActionEvent e) {
        if (this.empties.size() > 0) {
            for (int i = 0; i < this.empties.size(); ++i) {
                this.empties.get((int)i).isSelected = false;
            }
            EmptiesTableModel etm = (EmptiesTableModel)this.tableEmpties.getModel();
            etm.fireTableDataChanged();
        }
    }

    private void actionRunClicked(ActionEvent e) {
        String which;
        String name = "";
        JComponent object = this.context.browser.lastComponent;
        if (object instanceof JTree) {
            JTree sourceTree = (JTree)object;
            name = sourceTree.getName();
        } else if (object instanceof JTable) {
            JTable sourceTable = (JTable)object;
            name = sourceTable.getName();
        }
        if (name.toLowerCase().contains("system")) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
            JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.select.collection.for.run"), this.getTitle(), -1, 2, null, opts, opts[0]);
            return;
        }
        if (name.toLowerCase().endsWith("one")) {
            this.isPublisher = true;
            which = this.context.cfg.gs("Z.publisher");
            this.sourceTree = this.context.mainFrame.treeCollectionOne;
        } else {
            this.isPublisher = false;
            which = this.context.cfg.gs("Z.subscriber");
            this.sourceTree = this.context.mainFrame.treeCollectionTwo;
        }
        int reply = JOptionPane.showConfirmDialog(this, MessageFormat.format(this.context.cfg.gs("EmptyDirectoryFinder.run.tool.on.collection"), which), this.getTitle(), 0);
        if (reply == 0) {
            this.process();
        }
    }

    private void adjustEmptiesTable() {
        this.empties = new ArrayList();
        this.tableEmpties.setModel(new EmptiesTableModel(this.context, this.empties));
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        TableColumn column = this.tableEmpties.getColumnModel().getColumn(0);
        column.setResizable(false);
        column.setWidth(32);
        column.setPreferredWidth(32);
        column.setMaxWidth(32);
        column.setMinWidth(32);
        column = this.tableEmpties.getColumnModel().getColumn(1);
        cellRenderer.setHorizontalAlignment(2);
        column.setMinWidth(32);
        column.setCellRenderer(cellRenderer);
        column.setResizable(true);
    }

    private void process() {
        try {
            Repository repo;
            Repository repository = repo = this.isPublisher ? this.context.publisherRepo : this.context.subscriberRepo;
            if (repo != null) {
                this.buttonDelete.setEnabled(false);
                this.buttonRun.setEnabled(false);
                this.buttonAll.setEnabled(false);
                this.empties = new ArrayList();
                final EmptiesTableModel etm = (EmptiesTableModel)this.tableEmpties.getModel();
                etm.setEmpties(this.empties);
                etm.fireTableDataChanged();
                this.logger.info(this.context.cfg.gs("EmptyDirectoryFinder.running"));
                this.setCursor(Cursor.getPredefinedCursor(3));
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                    int emptyCount = 0;
                    int totalDirectories = 0;
                    int totalItems = 0;

                    @Override
                    protected Void doInBackground() throws Exception {
                        EmptyDirectoryFinderUI.this.workerRunning = true;
                        if (EmptyDirectoryFinderUI.this.isPublisher) {
                            EmptyDirectoryFinderUI.this.labelStatus.setText(EmptyDirectoryFinderUI.this.context.cfg.gs("Z.scanning"));
                            repo.scan();
                        } else if (EmptyDirectoryFinderUI.this.context.cfg.isRemoteOperation()) {
                            Object[] opts;
                            if (!EmptyDirectoryFinderUI.this.context.clientStty.isConnected()) {
                                opts = new Object[]{EmptyDirectoryFinderUI.this.context.cfg.gs("Z.ok")};
                                JOptionPane.showOptionDialog(EmptyDirectoryFinderUI.this.thisDialog, EmptyDirectoryFinderUI.this.context.cfg.gs("Browser.connection.lost"), EmptyDirectoryFinderUI.this.thisDialog.getTitle(), -1, 2, null, opts, opts[0]);
                            }
                            if (EmptyDirectoryFinderUI.this.context.transfer != null) {
                                EmptyDirectoryFinderUI.this.labelStatus.setText(EmptyDirectoryFinderUI.this.context.cfg.gs("Z.requesting.collection.data.from.remote"));
                                EmptyDirectoryFinderUI.this.context.transfer.requestCollection();
                            } else {
                                opts = new Object[]{EmptyDirectoryFinderUI.this.context.cfg.gs("Z.ok")};
                                JOptionPane.showOptionDialog(EmptyDirectoryFinderUI.this.thisDialog, EmptyDirectoryFinderUI.this.context.cfg.gs("Transfer.could.not.retrieve.remote.collection.file"), EmptyDirectoryFinderUI.this.thisDialog.getTitle(), -1, 2, null, opts, opts[0]);
                            }
                        } else {
                            EmptyDirectoryFinderUI.this.labelStatus.setText(EmptyDirectoryFinderUI.this.context.cfg.gs("Z.scanning"));
                            repo.scan();
                        }
                        Repository repo2 = EmptyDirectoryFinderUI.this.isPublisher ? EmptyDirectoryFinderUI.this.context.publisherRepo : EmptyDirectoryFinderUI.this.context.subscriberRepo;
                        for (Library lib : repo2.getLibraryData().libraries.bibliography) {
                            if (EmptyDirectoryFinderUI.this.requestStop) break;
                            String msg = EmptyDirectoryFinderUI.this.context.cfg.gs("DuplicateFinder.analyzing.library") + "'" + lib.name + "'";
                            EmptyDirectoryFinderUI.this.labelStatus.setText(msg);
                            for (Item item : lib.items) {
                                if (item.isDirectory()) {
                                    ++this.totalDirectories;
                                    if (item.getSize() != 0L) continue;
                                    ++this.emptyCount;
                                    Empty empty = new Empty(EmptyDirectoryFinderUI.this, item.getFullPath());
                                    EmptyDirectoryFinderUI.this.empties.add(empty);
                                    continue;
                                }
                                ++this.totalItems;
                            }
                        }
                        EmptyDirectoryFinderUI.this.labelStatus.setText("  " + MessageFormat.format(EmptyDirectoryFinderUI.this.context.cfg.gs("EmptyDirectoryFinder.empty.items.directories"), this.emptyCount, this.totalItems, this.totalDirectories));
                        etm.fireTableDataChanged();
                        EmptyDirectoryFinderUI.this.context.mainFrame.labelStatusMiddle.setText(this.emptyCount + EmptyDirectoryFinderUI.this.context.cfg.gs("EmptyDirectoryFinder.empty.directories"));
                        if (this.emptyCount > 0) {
                            EmptyDirectoryFinderUI.this.buttonDelete.setEnabled(true);
                            EmptyDirectoryFinderUI.this.buttonAll.setEnabled(true);
                        }
                        return null;
                    }
                };
                if (worker != null) {
                    worker.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            if (e.getPropertyName().equals("state") && e.getNewValue() == SwingWorker.StateValue.DONE) {
                                EmptyDirectoryFinderUI.this.workerRunning = false;
                                EmptyDirectoryFinderUI.this.buttonRun.setEnabled(true);
                                EmptiesTableModel etm = (EmptiesTableModel)EmptyDirectoryFinderUI.this.tableEmpties.getModel();
                                etm.setEmpties(EmptyDirectoryFinderUI.this.empties);
                                etm.fireTableDataChanged();
                                EmptyDirectoryFinderUI.this.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                    });
                }
                worker.execute();
            } else {
                Object[] opts = new Object[]{this.context.cfg.gs("Z.ok")};
                JOptionPane.showOptionDialog(this, this.context.cfg.gs("EmptyDirectoryFinder.collection.not.loaded"), this.getTitle(), -1, 2, null, opts, opts[0]);
            }
        }
        catch (Exception ex) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(ex);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
        }
    }

    private void savePreferences() {
        this.context.preferences.setToolsEmptyDirectoryFinderHeight(this.getHeight());
        this.context.preferences.setToolsEmptyDirectoryFinderWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setToolsEmptyDirectoryFinderXpos(location.x);
        this.context.preferences.setToolsEmptyDirectoryFinderYpos(location.y);
    }

    private void windowClosing(WindowEvent e) {
        this.closeButton.doClick();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.buttonRun = new JButton();
        this.hSpacerBeforeRun = new JPanel(null);
        this.buttonDelete = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.scrollPaneEmpties = new JScrollPane();
        this.tableEmpties = new JTable();
        this.panelOptionsButtons = new JPanel();
        this.buttonAll = new JButton();
        this.panelBottom = new JPanel();
        this.labelStatus = new JLabel();
        this.buttonBar = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.context.cfg.gs("EmptyDirectoryFinder.this.title"));
        this.setMinimumSize(new Dimension(150, 126));
        this.setName("dialogEmptyDirectoryUI");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EmptyDirectoryFinderUI.this.windowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setPreferredSize(new Dimension(570, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonRun.setText(this.context.cfg.gs("Z.run.ellipsis"));
        this.buttonRun.setMnemonic(this.context.cfg.gs("EmptyDirectoryFinder.buttonRun.mnemonic").charAt(0));
        this.buttonRun.setToolTipText(this.context.cfg.gs("EmptyDirectoryFinder.buttonRun.toolTipText"));
        this.buttonRun.addActionListener(e -> this.actionRunClicked(e));
        this.panelTopButtons.add(this.buttonRun);
        this.hSpacerBeforeRun.setMinimumSize(new Dimension(22, 6));
        this.hSpacerBeforeRun.setPreferredSize(new Dimension(22, 6));
        this.panelTopButtons.add(this.hSpacerBeforeRun);
        this.buttonDelete.setText(this.context.cfg.gs("EmptyDirectoryFinder.buttonDelete.text"));
        this.buttonDelete.setMnemonic(this.context.cfg.gs("EmptyDirectoryFinder.buttonDelete.mnemonic_2").charAt(0));
        this.buttonDelete.setToolTipText(this.context.cfg.gs("EmptyDirectoryFinder.buttonDelete.toolTipText"));
        this.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopButtons.add(this.buttonDelete);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("EmptyDirectoryFinder.help"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EmptyDirectoryFinderUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "Center");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.tableEmpties.setFillsViewportHeight(true);
        this.tableEmpties.setSelectionMode(0);
        this.tableEmpties.setAutoResizeMode(4);
        this.scrollPaneEmpties.setViewportView(this.tableEmpties);
        this.contentPanel.add((Component)this.scrollPaneEmpties, "Center");
        this.panelOptionsButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonAll.setText(this.context.cfg.gs("EmptyDirectoryFinder.buttonAll.text"));
        this.buttonAll.setFont(this.buttonAll.getFont().deriveFont((float)this.buttonAll.getFont().getSize() - 2.0f));
        this.buttonAll.setPreferredSize(new Dimension(78, 24));
        this.buttonAll.setMinimumSize(new Dimension(78, 24));
        this.buttonAll.setMaximumSize(new Dimension(78, 24));
        this.buttonAll.setMnemonic(this.context.cfg.gs("EmptyDirectoryFinder.buttonAll.mnemonic").charAt(0));
        this.buttonAll.setToolTipText(this.context.cfg.gs("EmptyDirectoryFinder.buttonAll.toolTipText"));
        this.buttonAll.setMargin(new Insets(0, -10, 0, -10));
        this.buttonAll.addActionListener(e -> this.actionAllClicked(e));
        this.panelOptionsButtons.add(this.buttonAll);
        this.contentPanel.add((Component)this.panelOptionsButtons, "South");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.panelBottom.setLayout(new BorderLayout());
        this.panelBottom.add((Component)this.labelStatus, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.closeButton.setText(this.context.cfg.gs("EmptyDirectoryFinder.closeButton.text"));
        this.closeButton.setToolTipText(this.context.cfg.gs("EmptyDirectoryFinder.closeButton.toolTipText"));
        this.closeButton.setMnemonic(this.context.cfg.gs("EmptyDirectoryFinder.closeButton.mnemonic").charAt(0));
        this.closeButton.addActionListener(e -> this.actionCloseClicked(e));
        this.buttonBar.add((Component)this.closeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelBottom.add((Component)this.buttonBar, "After");
        this.dialogPane.add((Component)this.panelBottom, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public class Empty {
        boolean isSelected = false;
        String path = "";

        public Empty(EmptyDirectoryFinderUI this$0, String path) {
            this.path = path;
        }
    }
}

