/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.junkRemover;

import com.corionis.els.Context;
import com.corionis.els.tools.junkremover.JunkRemoverTool;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class JunkTableModel
extends DefaultTableModel {
    private Context context;
    private JunkRemoverTool tool;

    public JunkTableModel(Context context) {
        this.context = context;
    }

    public int find(String pattern) {
        for (int i = 0; i < this.tool.getJunkList().size(); ++i) {
            String wc = this.tool.getJunkList().get((int)i).wildcard;
            if ((wc != null || pattern.length() != 0) && !wc.equals(pattern)) continue;
            return i;
        }
        return -1;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return JTextField.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.context.cfg.gs("JunkRemover.junk.pattern");
            }
            case 1: {
                return this.context.cfg.gs("JunkRemover.case");
            }
        }
        return this.context.cfg.gs("NavTreeNode.unknown");
    }

    @Override
    public int getRowCount() {
        if (this.tool != null) {
            return this.tool.getJunkList().size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.tool != null) {
            if (column == 0) {
                return this.tool.getJunkList().get((int)row).wildcard;
            }
            if (column == 1) {
                return this.tool.getJunkList().get((int)row).caseSensitive;
            }
        }
        return null;
    }

    public JunkRemoverTool getTool() {
        return this.tool;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void removeRow(int index) {
        if (this.tool != null) {
            this.tool.getJunkList().remove(index);
            this.tool.setDataHasChanged();
        }
    }

    public void setTool(JunkRemoverTool junkRemoverTool) {
        this.tool = junkRemoverTool;
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        if (this.tool != null) {
            JunkRemoverTool.JunkItem ji = this.tool.getJunkList().get(row);
            if (column == 0) {
                ji.wildcard = ((JTextField)object).getText();
                this.tool.setDataHasChanged();
            }
            if (column == 1) {
                ji.caseSensitive = (Boolean)object;
                this.tool.setDataHasChanged();
            }
        }
    }
}

