/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.operations;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.ConfigModel;
import com.corionis.els.gui.jobs.Conflict;
import com.corionis.els.gui.util.DisableJListSelectionModel;
import com.corionis.els.jobs.Job;
import com.corionis.els.jobs.Task;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.operations.OperationsTool;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OperationsUI
extends AbstractToolDialog {
    private JComboBox comboBoxMode;
    private JTable configItems;
    private Context context;
    private ConfigModel configModel;
    private int currentConfigIndex = -1;
    private OperationsTool currentTool;
    private String displayName;
    private boolean inUpdateOnChange = false;
    private boolean pickerAnyFile = false;
    private boolean pickerKeys = false;
    private boolean pickerFileMustExist = false;
    private File lastFile;
    private JList<String> libJList = null;
    private NavHelp helpDialog;
    private boolean loading = false;
    private Logger logger = LogManager.getLogger("applog");
    private Mode[] modes;
    private SwingWorker<Void, Void> worker;
    private OperationsTool workerOperation = null;
    public JPanel dialogPane;
    public JPanel contentPanel;
    public JPanel panelOperationButtons;
    public JPanel panelTopOperationButtons;
    public JButton buttonNewOperation;
    public JButton buttonCopyOperation;
    public JButton buttonDeleteOperation;
    public JPanel panelOperationHelp;
    public JLabel labelOperationHelp;
    public JSplitPane splitPaneOperationContent;
    public JScrollPane scrollPaneOperationConfig;
    public JTable operationConfigItems;
    public JPanel panelOperationOptions;
    public JPanel panelOperationControls;
    public JPanel topOperationOptions;
    public JPanel vSpacer0;
    public JPanel panelOperationMode;
    public JPanel hSpacer3;
    public JLabel labelOperationMode;
    public JScrollPane scrollPaneOperationCards;
    public JPanel panelOperationCards;
    public JPanel panelCardGettingStarted;
    public JLabel labelOperationGettingStarted;
    public JPanel panelCardPublisher;
    public JPanel hSpacer4;
    public JPanel vSpacer3;
    public JPanel hSpacer5;
    public JLabel labelOperationNavigatorCheckbox;
    public JCheckBox checkBoxOperationNavigator;
    public JPanel vSpacer33;
    public JPanel panelOperationIncludeExcludeBox;
    public JScrollPane scrollPaneOperationIncludeExclude;
    public JList<String> listOperationIncludeExclude;
    public JPanel panelOperationIncludeExcludeButtons;
    public JButton buttonOperationAddIncludeExclude;
    public JButton buttonOperationRemoveIncludeExclude;
    public JLabel labelOperationIncludeExclude;
    public JPanel vSpacer4;
    public JLabel labelOperationTargets;
    public JTextField textFieldOperationTargets;
    public JButton buttonOperationTargetsFilePick;
    public JPanel vSpacer5;
    public JLabel labelOperationsMismatches;
    public JTextField textFieldOperationMismatches;
    public JButton buttonOperationMismatchesFilePick;
    public JPanel vSpacer6;
    public JComboBox<String> comboBoxOperationWhatsNew;
    public JTextField textFieldOperationWhatsNew;
    public JButton buttonOperationWhatsNewFilePick;
    public JPanel vSpacer7;
    public JLabel labelOperationDecimalScale;
    public JCheckBox checkBoxOperationDecimalScale;
    public JLabel labelOperationExportText;
    public JTextField textFieldOperationExportText;
    public JButton buttonOperationExportTextFilePick;
    public JPanel vSpacer9;
    public JLabel labelOperationNoBackfill;
    public JCheckBox checkBoxOperationNoBackFill;
    public JLabel labelOperationExportItems;
    public JTextField textFieldOperationExportItems;
    public JButton buttonOperationExportItemsFilePick;
    public JPanel vSpacer10;
    public JLabel labelOperationOverwrite;
    public JCheckBox checkBoxOperationOverwrite;
    public JPanel vSpacer11;
    public JLabel labelOperationPreservedDates;
    public JCheckBox checkBoxOperationPreserveDates;
    public JComboBox<String> comboBoxOperationHintKeys;
    public JTextField textFieldOperationHintKeys;
    public JButton buttonOperationHintKeysFilePick;
    public JPanel vSpacer19;
    public JLabel labelOperationValidate;
    public JCheckBox checkBoxOperationValidate;
    public JLabel labelOperationKeepGoing;
    public JCheckBox checkBoxOperationKeepGoing;
    public JPanel vSpacer18;
    public JLabel labelOperationQuitStatusServer;
    public JCheckBox checkBoxOperationQuitStatus;
    public JPanel vSpacer17;
    public JLabel labelOperationDuplicates;
    public JCheckBox checkBoxOperationDuplicates;
    public JPanel vSpacer16;
    public JLabel labelOperationCrossCheck;
    public JCheckBox checkBoxOperationCrossCheck;
    public JPanel vSpacer15;
    public JLabel labelOperationEmptyDirectories;
    public JCheckBox checkBoxOperationEmptyDirectories;
    public JPanel vSpacer14;
    public JLabel labelOperationIgnored;
    public JCheckBox checkBoxOperationIgnored;
    public JPanel panelCardListener;
    public JPanel hSpacer6;
    public JPanel vSpacer40;
    public JPanel hSpacer7;
    public JLabel labelOperationTargets2;
    public JTextField textFieldOperationTargets2;
    public JButton buttonOperationTargetsFilePick2;
    public JPanel vSpacer32;
    public JPanel panelOperationExcludeBox;
    public JScrollPane scrollPaneOperationExclude;
    public JList<String> listOperationExclude;
    public JPanel panelOperationExcludeButtons;
    public JButton buttonOperationAddExclude;
    public JButton buttonOperationRemoveExclude;
    public JLabel labelOperationExclude;
    public JPanel vSpacer8;
    public JLabel labelOperationAuthorize;
    public JPasswordField passwordFieldOperationsAuthorize;
    public JPanel vSpacer12;
    public JLabel labelOperationAuthKeys;
    public JTextField textFieldOperationAuthKeys;
    public JButton buttonOperationAuthKeysFilePick;
    public JPanel vSpacer20;
    public JLabel labelOperationBlacklist;
    public JTextField textFieldOperationBlacklist;
    public JButton buttonOperationBlacklistFilePick;
    public JPanel vSpacer21;
    public JLabel labelOperationDecimalScale2;
    public JCheckBox checkBoxOperationDecimalScale2;
    public JLabel labelOperationIpWhitelist;
    public JTextField textFieldOperationIpWhitelist;
    public JButton buttonOperationIpWhitelistFilePick;
    public JPanel vSpacer22;
    public JLabel labelOperationOverwrite2;
    public JCheckBox checkBoxOperationOverwrite2;
    public JPanel vSpacer23;
    public JLabel labelOperationPreservedDates2;
    public JCheckBox checkBoxOperationPreserveDates2;
    public JLabel labelOperationHintKeys;
    public JTextField textFieldOperationHintKeys2;
    public JButton buttonOperationHintKeysFilePick2;
    public JPanel vSpacer24;
    public JLabel labelOperationKeepGoing2;
    public JCheckBox checkBoxOperationKeepGoing2;
    public JPanel vSpacer26;
    public JPanel panelCardHintServer;
    public JPanel vSpacer41;
    public JLabel labelOperationHintKeys2;
    public JTextField textFieldOperationHintKeys3;
    public JButton buttonOperationHintKeysFilePick3;
    public JPanel vSpacer34;
    public JLabel label1;
    public JTextField textFieldOperationAuthKeys3;
    public JButton buttonOperationAuthKeysFilePick3;
    public JPanel vSpacer44;
    public JLabel labelOperationKeepGoing3;
    public JCheckBox checkBoxOperationKeepGoing3;
    public JPanel vSpacer36;
    public JPanel vSpacer39;
    public JLabel labelOperationBlacklist3;
    public JTextField textFieldOperationBlacklist3;
    public JButton buttonOperationBlacklistFilePick3;
    public JPanel vSpacer37;
    public JLabel labelOperationIpWhitelist3;
    public JTextField textFieldOperationIpWhitelist3;
    public JButton buttonOperationIpWhitelistFilePick3;
    public JPanel vSpacer38;
    public JPanel panelCardTerminal;
    public JLabel labelOperationsTerminal;
    public JPanel panelCardQuit;
    public JLabel labelOperationsQuitter;
    public JPanel panelCardQuitHints;
    public JLabel labelOperationsQuitHints;
    public JPanel buttonBar;
    public JButton buttonOperationSave;
    public JButton buttonOperationCancel;

    public OperationsUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.displayName = context.cfg.gs("Operations.displayName");
        this.initComponents();
        this.initialize();
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.checkForChanges()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.cancelChanges();
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void actionCopyClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            OperationsTool original = (OperationsTool)this.configModel.getValueAt(index, 0);
            String rename = original.getConfigName() + this.context.cfg.gs("Z.copy");
            if (this.configModel.find(rename, null) == null) {
                OperationsTool copy = original.clone();
                copy.setConfigName(rename);
                copy.setDataHasChanged();
                this.configModel.addRow(new Object[]{copy});
                this.currentConfigIndex = this.configModel.getRowCount() - 1;
                this.loadOptions(this.currentConfigIndex);
                this.configItems.editCellAt(this.currentConfigIndex, 0);
                this.configItems.changeSelection(this.currentConfigIndex, this.currentConfigIndex, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + rename, this.displayName, 2);
            }
        }
    }

    private void actionDeleteClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            OperationsTool tool = (OperationsTool)this.configModel.getValueAt(index, 0);
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.are.you.sure.you.want.to.delete.configuration") + tool.getConfigName(), this.context.cfg.gs("Z.delete.configuration"), 0);
            if (reply == 0) {
                int answer = this.configModel.checkJobConflicts(tool.getConfigName(), null, tool.getInternalName(), false);
                if (answer >= 0) {
                    File file = new File(tool.getFullPath());
                    if (file.exists()) {
                        this.deletedTools.add(tool);
                        this.currentTool.setDataHasChanged();
                    }
                    this.configModel.removeRow(index);
                    if (index > this.configModel.getRowCount() - 1) {
                        index = this.configModel.getRowCount() - 1;
                    }
                    this.currentConfigIndex = index;
                    this.configModel.fireTableDataChanged();
                    if (this.configModel.getRowCount() > 0) {
                        this.configItems.changeSelection(index, 0, false, false);
                        this.loadOptions(index);
                    } else {
                        ((CardLayout)this.panelOperationCards.getLayout()).show(this.panelOperationCards, "gettingStarted");
                        this.labelOperationMode.setText("");
                        this.buttonCopyOperation.setEnabled(false);
                        this.buttonDeleteOperation.setEnabled(false);
                        this.buttonOperationSave.setEnabled(false);
                        this.currentConfigIndex = 0;
                    }
                }
                this.configItems.requestFocus();
            }
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("OperationsUI.help"), "operations_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionNewClicked(ActionEvent e) {
        if (this.configModel.find(this.context.cfg.gs("Z.untitled"), null) == null) {
            String message = this.context.cfg.gs("OperationsUI.mode.select.type");
            String line = this.context.cfg.gs("OperationsUI.mode.select.use.publish.for.navigator");
            Object[] params = new Object[]{message, line, this.comboBoxMode};
            this.comboBoxMode.setSelectedIndex(0);
            int opt = JOptionPane.showConfirmDialog(this, params, this.displayName, 2);
            if (opt == 0) {
                this.currentTool = new OperationsTool(this.context);
                Mode mode = this.modes[this.comboBoxMode.getSelectedIndex()];
                this.currentTool.setConfigName(this.context.cfg.gs("Z.untitled"));
                this.currentTool.setOperation(mode.operation);
                this.currentTool.setCard(mode.card);
                this.currentTool.setDataHasChanged();
                this.initNewCard();
                this.buttonCopyOperation.setEnabled(true);
                this.buttonDeleteOperation.setEnabled(true);
                this.buttonOperationSave.setEnabled(true);
                this.configModel.addRow(new Object[]{this.currentTool});
                this.currentConfigIndex = this.configModel.getRowCount() - 1;
                this.loadOptions(this.currentConfigIndex);
                this.configItems.editCellAt(this.currentConfigIndex, 0);
                this.configItems.changeSelection(this.currentConfigIndex, this.currentConfigIndex, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                this.configItems.requestFocus();
            }
        } else {
            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.displayName, 2);
        }
    }

    public void actionOperationAddRowClicked(ActionEvent e) {
        if (this.currentTool != null && e.getSource().getClass().equals(JButton.class)) {
            JButton button = (JButton)e.getSource();
            this.libraryPicker(button);
        }
    }

    public void actionOperationRemoveRowClicked(ActionEvent e) {
        if (this.currentTool != null && e.getSource().getClass().equals(JButton.class)) {
            int cardVar = 0;
            JButton button = (JButton)e.getSource();
            if (button.getName().toLowerCase().equals("removeincexc")) {
                cardVar = 1;
            } else if (button.getName().toLowerCase().equals("removeexc")) {
                cardVar = 2;
            }
            int[] indices = new int[]{};
            if (cardVar == 1 && this.listOperationIncludeExclude.getModel().getSize() > 0) {
                indices = this.listOperationIncludeExclude.getSelectedIndices();
            } else if (cardVar == 2 && this.listOperationExclude.getModel().getSize() > 0) {
                indices = this.listOperationExclude.getSelectedIndices();
            }
            if (indices.length > 0) {
                if (cardVar == 1) {
                    this.listOperationIncludeExclude.requestFocus();
                } else if (cardVar == 2) {
                    this.listOperationExclude.requestFocus();
                }
                int count = indices.length;
                int reply = JOptionPane.showConfirmDialog(this, MessageFormat.format(this.context.cfg.gs("OperationsUI.are.you.sure.you.want.delete.entries"), count), this.displayName, 0);
                if (reply == 0) {
                    List<String> selections = this.listOperationIncludeExclude.getSelectedValuesList();
                    Arrays.sort(indices);
                    boolean changed = false;
                    if (cardVar == 1 && this.libraryRemover(1, true, indices)) {
                        changed = true;
                    }
                    if (this.libraryRemover(2, false, indices)) {
                        changed = true;
                    }
                    if (changed) {
                        this.currentTool.setDataHasChanged();
                        if (cardVar == 1) {
                            this.loadIncludeExcludeList();
                        } else if (cardVar == 2) {
                            this.loadExcludeList();
                        }
                    }
                }
            }
        }
    }

    private void actionSaveClicked(ActionEvent e) {
        if (this.saveConfigurations()) {
            this.savePreferences();
            this.setVisible(false);
        }
    }

    private void cancelChanges() {
        if (this.deletedTools.size() > 0) {
            this.deletedTools = new ArrayList();
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            ((OperationsTool)this.configModel.getValueAt(i, 0)).setDataHasChanged(false);
        }
        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.changes.cancelled"));
    }

    public boolean checkForChanges() {
        if (!this.deletedTools.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            if (!((OperationsTool)this.configModel.getValueAt(i, 0)).isDataChanged()) continue;
            return true;
        }
        return false;
    }

    public int checkHintKeysConflicts() {
        int answer = 0;
        JList conflictJList = new JList();
        try {
            int count = 0;
            ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
            ConfigModel jobsConfigModel = this.configModel.getJobsConfigModel();
            for (int i = 0; i < jobsConfigModel.getRowCount(); ++i) {
                Job job = (Job)jobsConfigModel.getValueAt(i, 0);
                for (int j = 0; j < job.getTasks().size(); ++j) {
                    Task task = job.getTasks().get(j);
                    if (!task.getConfigName().equals(this.currentTool.getConfigName()) || task.getHintsKey().isEmpty()) continue;
                    Conflict conflict = new Conflict();
                    conflict.job = job;
                    conflict.newName = null;
                    conflict.taskNumber = j;
                    conflicts.add(conflict);
                    ++count;
                }
            }
            if (count > 0) {
                answer = -1;
                ArrayList<String> conflictNames = new ArrayList<String>();
                for (Conflict conflict : conflicts) {
                    conflictNames.add(conflict.toString(this.context));
                }
                Collections.sort(conflictNames);
                DefaultListModel<String> dialogList = new DefaultListModel<String>();
                for (String name : conflictNames) {
                    dialogList.addElement(name);
                }
                conflictJList.setModel(dialogList);
                conflictJList.setSelectionModel(new DisableJListSelectionModel());
                String message = MessageFormat.format(this.context.cfg.gs("Jobs.references.for.found.in.jobs"), this.currentTool.getConfigName());
                JScrollPane pane = new JScrollPane();
                pane.setViewportView(conflictJList);
                String question = this.context.cfg.gs("OperationsUI.clear.hints");
                Object[] params = new Object[]{message, pane, question};
                int opt = JOptionPane.showConfirmDialog(this, params, this.getTitle(), 2);
                if (opt == 0) {
                    answer = 1;
                    for (Conflict conflict : conflicts) {
                        Job job = (Job)conflict.job;
                        Task task = job.getTasks().get(conflict.taskNumber);
                        task.setContext(this.context);
                        task.setHintsRemote(false);
                        task.setHintsOverrideHost(false);
                        task.setHintsKey("");
                        task.setHintsPath("");
                        job.setDataHasChanged();
                    }
                }
            }
        }
        catch (Exception e) {
            answer = -1;
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
        }
        return answer;
    }

    private void filePicker(final JButton button) {
        int selection;
        JFileChooser fc = new JFileChooser();
        fc.setFileHidingEnabled(false);
        fc.setDialogTitle(button.getToolTipText());
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (OperationsUI.this.pickerKeys) {
                    return file.getName().toLowerCase().endsWith(".keys");
                }
                if (!OperationsUI.this.pickerAnyFile) {
                    return file.getName().toLowerCase().endsWith(".json");
                }
                return true;
            }

            @Override
            public String getDescription() {
                String desc = "";
                OperationsUI.this.pickerKeys = false;
                switch (button.getName().toLowerCase()) {
                    case "authkeys": 
                    case "authkeys3": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.auth.keys.file");
                        OperationsUI.this.pickerAnyFile = false;
                        OperationsUI.this.pickerFileMustExist = true;
                        OperationsUI.this.pickerKeys = true;
                        break;
                    }
                    case "blacklist": 
                    case "blacklist3": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.blacklist.file");
                        OperationsUI.this.pickerAnyFile = true;
                        OperationsUI.this.pickerFileMustExist = true;
                        break;
                    }
                    case "ipwhitelist": 
                    case "ipwhitelist3": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.whitelist.file");
                        OperationsUI.this.pickerAnyFile = true;
                        OperationsUI.this.pickerFileMustExist = true;
                        break;
                    }
                    case "targets": 
                    case "targets2": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.targets.file.json");
                        OperationsUI.this.pickerAnyFile = false;
                        OperationsUI.this.pickerFileMustExist = true;
                        break;
                    }
                    case "mismatches": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.mismatches.file");
                        OperationsUI.this.pickerAnyFile = true;
                        OperationsUI.this.pickerFileMustExist = false;
                        break;
                    }
                    case "whatsnew": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.what.s.new.file");
                        OperationsUI.this.pickerAnyFile = true;
                        OperationsUI.this.pickerFileMustExist = false;
                        break;
                    }
                    case "exporttext": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.export.text.file");
                        OperationsUI.this.pickerAnyFile = true;
                        OperationsUI.this.pickerFileMustExist = false;
                        break;
                    }
                    case "exportitems": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.export.items.file");
                        OperationsUI.this.pickerAnyFile = true;
                        OperationsUI.this.pickerFileMustExist = false;
                        break;
                    }
                    case "hintkeys": 
                    case "hintkeys2": 
                    case "hintkeys3": {
                        desc = OperationsUI.this.context.cfg.gs("OperationsUI.els.hint.keys.file");
                        OperationsUI.this.pickerAnyFile = true;
                        OperationsUI.this.pickerFileMustExist = true;
                        OperationsUI.this.pickerKeys = true;
                    }
                }
                return desc;
            }
        });
        String fileName = "";
        switch (button.getName().toLowerCase()) {
            case "authkeys": {
                fileName = this.textFieldOperationAuthKeys.getText();
                break;
            }
            case "authkeys3": {
                fileName = this.textFieldOperationAuthKeys3.getText();
                break;
            }
            case "blacklist": {
                fileName = this.textFieldOperationBlacklist.getText();
                break;
            }
            case "blacklist3": {
                fileName = this.textFieldOperationBlacklist3.getText();
                break;
            }
            case "ipwhitelist": {
                fileName = this.textFieldOperationIpWhitelist.getText();
                break;
            }
            case "ipwhitelist3": {
                fileName = this.textFieldOperationIpWhitelist3.getText();
                break;
            }
            case "targets": {
                fileName = this.textFieldOperationTargets.getText();
                break;
            }
            case "targets2": {
                fileName = this.textFieldOperationTargets2.getText();
                break;
            }
            case "mismatches": {
                fileName = this.textFieldOperationMismatches.getText();
                break;
            }
            case "whatsnew": {
                fileName = this.textFieldOperationWhatsNew.getText();
                break;
            }
            case "exporttext": {
                fileName = this.textFieldOperationExportText.getText();
                break;
            }
            case "exportitems": {
                fileName = this.textFieldOperationExportItems.getText();
                break;
            }
            case "hintkeys": {
                fileName = this.textFieldOperationHintKeys.getText();
                break;
            }
            case "hintkeys2": {
                fileName = this.textFieldOperationHintKeys2.getText();
                break;
            }
            case "hintkeys3": {
                fileName = this.textFieldOperationHintKeys3.getText();
            }
        }
        if (fileName.length() > 0) {
            File dir = new File(this.filePickerDirectory(fileName));
            try {
                fc.setCurrentDirectory(dir.getCanonicalFile());
            }
            catch (IOException e) {
                fc.setCurrentDirectory(dir);
            }
            File file = new File(fileName);
            fc.setSelectedFile(file);
        } else if (this.lastFile != null) {
            fc.setCurrentDirectory(this.lastFile);
        } else {
            fc.setCurrentDirectory(new File(this.context.cfg.getWorkingDirectory()));
        }
        fc.setDialogType(this.pickerFileMustExist ? 0 : 1);
        while ((selection = fc.showOpenDialog(this)) == 0) {
            this.lastFile = fc.getCurrentDirectory();
            File file = fc.getSelectedFile();
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Navigator.open.error.select.a.file.only"), this.context.cfg.getNavigatorName(), 0);
                continue;
            }
            if (this.pickerFileMustExist && !file.exists()) {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Navigator.open.error.file.not.found") + file.getName(), this.displayName, 0);
                continue;
            }
            if (this.pickerFileMustExist && !file.canWrite()) {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Navigator.open.error.file.not.writable") + file.getName(), this.displayName, 0);
                continue;
            }
            String path = "";
            path = !file.getPath().equals(this.context.cfg.getWorkingDirectory()) && file.getPath().startsWith(this.context.cfg.getWorkingDirectory()) ? file.getPath().substring(this.context.cfg.getWorkingDirectory().length() + 1) : file.getPath();
            switch (button.getName().toLowerCase()) {
                case "authkeys": {
                    this.textFieldOperationAuthKeys.setText(path);
                    this.textFieldOperationAuthKeys.postActionEvent();
                    break;
                }
                case "authkeys3": {
                    this.textFieldOperationAuthKeys3.setText(path);
                    this.textFieldOperationAuthKeys3.postActionEvent();
                    break;
                }
                case "blacklist": {
                    this.textFieldOperationBlacklist.setText(path);
                    this.textFieldOperationBlacklist.postActionEvent();
                    break;
                }
                case "blacklist3": {
                    this.textFieldOperationBlacklist3.setText(path);
                    this.textFieldOperationBlacklist3.postActionEvent();
                    break;
                }
                case "ipwhitelist": {
                    this.textFieldOperationIpWhitelist.setText(path);
                    this.textFieldOperationIpWhitelist.postActionEvent();
                    break;
                }
                case "ipwhitelist3": {
                    this.textFieldOperationIpWhitelist3.setText(path);
                    this.textFieldOperationIpWhitelist3.postActionEvent();
                    break;
                }
                case "targets": {
                    this.textFieldOperationTargets.setText(path);
                    this.textFieldOperationTargets.postActionEvent();
                    break;
                }
                case "targets2": {
                    this.textFieldOperationTargets2.setText(path);
                    this.textFieldOperationTargets2.postActionEvent();
                    break;
                }
                case "mismatches": {
                    this.textFieldOperationMismatches.setText(path);
                    this.textFieldOperationMismatches.postActionEvent();
                    break;
                }
                case "whatsnew": {
                    this.textFieldOperationWhatsNew.setText(path);
                    this.textFieldOperationWhatsNew.postActionEvent();
                    break;
                }
                case "exporttext": {
                    this.textFieldOperationExportText.setText(path);
                    this.textFieldOperationExportText.postActionEvent();
                    break;
                }
                case "exportitems": {
                    this.textFieldOperationExportItems.setText(path);
                    this.textFieldOperationExportItems.postActionEvent();
                    break;
                }
                case "hintkeys": {
                    this.textFieldOperationHintKeys.setText(path);
                    this.textFieldOperationHintKeys.postActionEvent();
                    break;
                }
                case "hintkeys2": {
                    this.textFieldOperationHintKeys2.setText(path);
                    this.textFieldOperationHintKeys2.postActionEvent();
                    break;
                }
                case "hintkeys3": {
                    this.textFieldOperationHintKeys3.setText(path);
                    this.textFieldOperationHintKeys3.postActionEvent();
                }
            }
            break;
        }
    }

    private String filePickerDirectory(String path) {
        if (Utils.isRelativePath((String)path)) {
            path = this.context.cfg.getWorkingDirectory() + System.getProperty("file.separator") + (String)path;
        }
        return Utils.getLeftPath((String)path, Utils.getSeparatorFromPath((String)path));
    }

    public void genericAction(ActionEvent e) {
        if (e.getSource().getClass().equals(JButton.class)) {
            JButton button = (JButton)e.getSource();
            if (button.getActionCommand().toLowerCase().endsWith("filepick")) {
                this.filePicker(button);
            } else {
                this.updateOnChange(e.getSource());
            }
        } else {
            this.updateOnChange(e.getSource());
        }
    }

    public void genericTextFieldFocusLost(FocusEvent e) {
        if (!(e.getOppositeComponent() instanceof JTable)) {
            this.updateOnChange(e.getSource());
        }
    }

    @Override
    public JTable getConfigItems() {
        return this.configItems;
    }

    private int getModeOperationIndex() {
        int index = -1;
        for (int i = 0; i < this.modes.length; ++i) {
            if (this.modes[i].operation != this.currentTool.getOperation() || this.modes[i].card != this.currentTool.getCard()) continue;
            index = i;
            break;
        }
        return index;
    }

    public void initialize() {
        this.configItems = this.operationConfigItems;
        Icon icon = this.labelOperationHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelOperationHelp.setIcon(replacement);
        if (this.context.preferences.getToolsOperationsXpos() != -1 && Utils.isOnScreen(this.context.preferences.getToolsOperationsXpos(), this.context.preferences.getToolsOperationsYpos())) {
            this.setLocation(this.context.preferences.getToolsOperationsXpos(), this.context.preferences.getToolsOperationsYpos());
            Dimension dim = new Dimension(this.context.preferences.getToolsOperationsWidth(), this.context.preferences.getToolsOperationsHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(this.context.mainFrame, this));
        }
        this.splitPaneOperationContent.setDividerLocation(this.context.preferences.getToolOperationsDividerConfigLocation());
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OperationsUI.this.buttonOperationCancel.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.configModel = new ConfigModel(this.context, this);
        this.configModel.setColumnCount(1);
        this.configItems.setModel(this.configModel);
        this.configItems.getTableHeader().setUI(null);
        this.configItems.setTableHeader(null);
        this.scrollPaneOperationConfig.setColumnHeaderView(null);
        ListSelectionModel lsm = this.configItems.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel sm;
                int index;
                if (!listSelectionEvent.getValueIsAdjusting() && (index = (sm = (ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex()) != OperationsUI.this.currentConfigIndex && OperationsUI.this.currentConfigIndex >= 0) {
                    OperationsUI.this.currentConfigIndex = index;
                    OperationsUI.this.loadOptions(OperationsUI.this.currentConfigIndex);
                }
            }
        });
        this.configItems.setTableHeader(null);
        this.modes = new Mode[8];
        this.modes[0] = new Mode(this, this.context.cfg.gs("OperationsUI.mode.localPublish"), OperationsTool.Cards.Publisher, OperationsTool.Operations.PublisherOperation);
        this.modes[1] = new Mode(this, this.context.cfg.gs("OperationsUI.mode.subscriberListener"), OperationsTool.Cards.Listener, OperationsTool.Operations.SubscriberListener);
        this.modes[2] = new Mode(this, this.context.cfg.gs("OperationsUI.mode.hintServer"), OperationsTool.Cards.HintServer, OperationsTool.Operations.StatusServer);
        this.modes[3] = new Mode(this, this.context.cfg.gs("OperationsUI.mode.publisherTerminal"), OperationsTool.Cards.Terminal, OperationsTool.Operations.PublisherManual);
        this.modes[4] = new Mode(this, this.context.cfg.gs("OperationsUI.mode.publisherListener"), OperationsTool.Cards.Listener, OperationsTool.Operations.PublisherListener);
        this.modes[5] = new Mode(this, this.context.cfg.gs("OperationsUI.mode.subscriberTerminal"), OperationsTool.Cards.Terminal, OperationsTool.Operations.SubscriberTerminal);
        this.modes[6] = new Mode(this, this.context.cfg.gs("OperationsUI.mode.hintForceQuit"), OperationsTool.Cards.StatusQuit, OperationsTool.Operations.StatusServerQuit);
        this.modes[7] = new Mode(this, this.context.cfg.gs("OperationsUI.mode.subscriberForceQuit"), OperationsTool.Cards.SubscriberQuit, OperationsTool.Operations.SubscriberListenerQuit);
        this.comboBoxMode = new JComboBox();
        this.comboBoxMode.setModel(new DefaultComboBoxModel<Mode>(new Mode[0]));
        this.comboBoxMode.removeAllItems();
        for (Mode m : this.modes) {
            this.comboBoxMode.addItem(m);
        }
        this.initializeComboBoxes();
        this.loadConfigurations();
        this.context.navigator.enableDisableToolMenus(this, false);
        this.context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void initializeComboBoxes() {
        this.comboBoxOperationWhatsNew.removeAllItems();
        this.comboBoxOperationWhatsNew.addItem(this.context.cfg.gs("OperationsUI.comboBoxOperationWhatsNew.0.whatsNew"));
        this.comboBoxOperationWhatsNew.addItem(this.context.cfg.gs("OperationsUI.comboBoxOperationWhatsNew.1.whatsNewAll"));
        this.comboBoxOperationHintKeys.removeAllItems();
        this.comboBoxOperationHintKeys.addItem(this.context.cfg.gs("OperationsUI.comboBoxOperationHintKeys.0.keys"));
        this.comboBoxOperationHintKeys.addItem(this.context.cfg.gs("OperationsUI.comboBoxOperationHintKeys.1.keysOnly"));
    }

    private void libraryLoader(int which) {
        Repository repo;
        if (this.libJList == null) {
            this.libJList = new JList();
        }
        if ((repo = which == 0 ? this.context.publisherRepo : this.context.subscriberRepo) != null) {
            Library[] biblio = repo.getLibraryData().libraries.bibliography;
            ArrayList<String> libraries = new ArrayList<String>();
            for (int i = 0; i < biblio.length; ++i) {
                libraries.add(biblio[i].name);
            }
            Collections.sort(libraries);
            DefaultListModel<String> dialogList = new DefaultListModel<String>();
            for (String name : libraries) {
                dialogList.addElement(name);
            }
            this.libJList.setModel(dialogList);
            this.libJList.setSelectionMode(2);
            this.libJList.setSelectedIndex(0);
        }
    }

    private void initNewCard() {
        this.loading = true;
        switch (this.currentTool.getOperation()) {
            case PublisherOperation: 
            case SubscriberListener: {
                this.currentTool.setOptKeys(this.context.cfg.getHintKeysFile());
                if (this.context.cfg.getHintTrackerFilename().length() > 0) {
                    this.comboBoxOperationHintKeys.setSelectedIndex(0);
                }
                if (this.context.cfg.getHintsDaemonFilename().length() <= 0) break;
                this.comboBoxOperationHintKeys.setSelectedIndex(1);
                break;
            }
            case StatusServer: {
                this.currentTool.setOptKeys(this.context.cfg.getHintKeysFile());
                break;
            }
            case PublisherManual: {
                break;
            }
            case PublisherListener: {
                break;
            }
            case SubscriberTerminal: {
                break;
            }
            case StatusServerQuit: {
                break;
            }
        }
        this.currentTool.setDataHasChanged();
        this.updateState();
        this.loading = false;
    }

    private void libraryPicker(JButton button) {
        try {
            JCheckBox checkBox = new JCheckBox(this.context.cfg.gs("OperationsUI.include.selections"));
            checkBox.setToolTipText(this.context.cfg.gs("OperationsUI.uncheck.to.exclude.selections"));
            checkBox.setSelected(true);
            if (button.getName().toLowerCase().equals("addexc")) {
                checkBox.setSelected(false);
            }
            final JComboBox<String> combo = new JComboBox<String>();
            combo.addItem(this.context.cfg.gs("OperationsUI.publisher.libraries"));
            combo.addItem(this.context.cfg.gs("OperationsUI.subscriber.libraries"));
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String cmd = actionEvent.getActionCommand();
                    if (cmd.equals("comboBoxChanged")) {
                        int selected = combo.getSelectedIndex();
                        OperationsUI.this.libraryLoader(selected);
                    }
                }
            });
            this.libraryLoader(0);
            JScrollPane pane = new JScrollPane();
            pane.setViewportView(this.libJList);
            this.libJList.requestFocus();
            Object[] params1 = new Object[]{this.context.cfg.gs("OperationsUI.select.included.excluded.libraries"), combo, checkBox, pane};
            Object[] params2 = new Object[]{this.context.cfg.gs("OperationsUI.select.excluded.libraries"), combo, pane};
            int opt = 0;
            if (button.getName().toLowerCase().equals("addincexc")) {
                opt = JOptionPane.showConfirmDialog(this, params1, this.displayName, 2);
            } else if (button.getName().toLowerCase().equals("addexc")) {
                opt = JOptionPane.showConfirmDialog(this, params2, this.displayName, 2);
            }
            if (opt == 0) {
                List<String> selections = this.libJList.getSelectedValuesList();
                String[] libs = checkBox.isSelected() ? this.currentTool.getOptLibrary() : this.currentTool.getOptExclude();
                String[] allLibs = null;
                if (this.currentTool.getOptLibrary() != null && this.currentTool.getOptExclude() == null) {
                    allLibs = this.currentTool.getOptLibrary();
                } else if (this.currentTool.getOptLibrary() == null && this.currentTool.getOptExclude() != null) {
                    allLibs = this.currentTool.getOptExclude();
                } else if (this.currentTool.getOptLibrary() != null && this.currentTool.getOptExclude() != null) {
                    allLibs = ArrayUtils.addAll(this.currentTool.getOptLibrary(), this.currentTool.getOptExclude());
                }
                int start = 0;
                if (libs == null) {
                    libs = new String[selections.size()];
                } else {
                    start = libs.length;
                    String[] newLibs = new String[start + selections.size()];
                    System.arraycopy(libs, 0, newLibs, 0, start);
                    libs = newLibs;
                }
                boolean changed = false;
                for (String name : selections) {
                    if (allLibs != null) {
                        boolean duplicate = false;
                        for (int i = 0; i < allLibs.length; ++i) {
                            if (!name.equals(allLibs[i])) continue;
                            duplicate = true;
                            break;
                        }
                        if (duplicate) {
                            JOptionPane.showMessageDialog(this, name + this.context.cfg.gs("OperationsUI.is.a.duplicate"), this.displayName, 2);
                            continue;
                        }
                    }
                    libs[start++] = name;
                    changed = true;
                }
                if (changed) {
                    if (checkBox.isSelected()) {
                        this.currentTool.setOptLibrary(libs);
                    } else {
                        this.currentTool.setOptExclude(libs);
                    }
                    this.currentTool.setDataHasChanged();
                    if (button.getName().toLowerCase().equals("addincexc")) {
                        this.loadIncludeExcludeList();
                    } else if (button.getName().toLowerCase().equals("addexc")) {
                        this.loadExcludeList();
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + Utils.getStackTrace(e);
            this.logger.error(msg);
            JOptionPane.showMessageDialog(this, msg, this.displayName, 0);
        }
    }

    private boolean libraryRemover(int cardVar, boolean includes, int[] indices) {
        boolean changed = false;
        List<String> selections = cardVar == 1 ? this.listOperationIncludeExclude.getSelectedValuesList() : this.listOperationExclude.getSelectedValuesList();
        for (int i = indices.length - 1; i >= 0; --i) {
            String[] newLibs;
            String[] libs;
            String dn = selections.get(i);
            if (dn.startsWith(this.context.cfg.gs("OperationsUI.include")) && !includes || dn.startsWith(this.context.cfg.gs("OperationsUI.exclude")) && includes) continue;
            String cn = "";
            cn = includes ? dn.substring(this.context.cfg.gs("OperationsUI.include").length()) : dn.substring(this.context.cfg.gs("OperationsUI.exclude").length());
            int removed = 0;
            String[] stringArray = libs = includes ? this.currentTool.getOptLibrary() : this.currentTool.getOptExclude();
            if (libs != null) {
                for (int j = 0; j < libs.length; ++j) {
                    if (!libs[j].equals(cn)) continue;
                    libs[j] = null;
                    ++removed;
                }
            }
            if (removed > 0) {
                changed = true;
                int j = libs.length - removed;
                if (j > 0) {
                    newLibs = new String[j];
                    j = 0;
                    for (int k = 0; k < libs.length; ++k) {
                        if (libs[k] == null) continue;
                        newLibs[j++] = libs[k];
                    }
                } else {
                    newLibs = null;
                }
            } else {
                newLibs = libs;
            }
            if (includes) {
                this.currentTool.setOptLibrary(newLibs);
                continue;
            }
            this.currentTool.setOptExclude(newLibs);
        }
        return changed;
    }

    private void loadConfigurations() {
        ArrayList<AbstractTool> toolList = null;
        try {
            toolList = this.context.tools.loadAllTools(this.context, "Operations");
            for (AbstractTool tool : toolList) {
                OperationsTool operation = (OperationsTool)tool;
                this.configModel.addRow(new Object[]{operation});
            }
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this, msg, this.displayName, 0);
            }
            this.logger.error(msg);
        }
        this.configModel.setToolList(toolList);
        this.configModel.loadJobsConfigurations(this, null);
        if (this.configModel.getRowCount() == 0) {
            this.buttonCopyOperation.setEnabled(false);
            this.buttonDeleteOperation.setEnabled(false);
            this.buttonOperationSave.setEnabled(false);
        } else {
            this.loadOptions(0);
            this.configItems.requestFocus();
            this.configItems.setRowSelectionInterval(0, 0);
        }
        this.currentConfigIndex = 0;
    }

    private void loadExcludeList() {
        ArrayList<CallSite> exc = new ArrayList<CallSite>();
        if (this.currentTool.getOptExclude() != null) {
            for (int i = 0; i < this.currentTool.getOptExclude().length; ++i) {
                exc.add((CallSite)((Object)(this.context.cfg.gs("OperationsUI.exclude") + this.currentTool.getOptExclude()[i])));
            }
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        if (exc.size() > 0) {
            Collections.sort(exc);
            for (String string : exc) {
                model.addElement(string);
            }
        }
        this.listOperationExclude.setModel(model);
        this.scrollPaneOperationExclude.setViewportView(this.listOperationExclude);
        this.listOperationExclude.setSelectionInterval(0, 0);
    }

    private void loadIncludeExcludeList() {
        int i;
        ArrayList<CallSite> incExc = new ArrayList<CallSite>();
        if (this.currentTool.getOptExclude() != null) {
            for (i = 0; i < this.currentTool.getOptExclude().length; ++i) {
                incExc.add((CallSite)((Object)(this.context.cfg.gs("OperationsUI.exclude") + this.currentTool.getOptExclude()[i])));
            }
        }
        if (this.currentTool.getOptLibrary() != null) {
            for (i = 0; i < this.currentTool.getOptLibrary().length; ++i) {
                incExc.add((CallSite)((Object)(this.context.cfg.gs("OperationsUI.include") + this.currentTool.getOptLibrary()[i])));
            }
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        if (incExc.size() > 0) {
            Collections.sort(incExc);
            for (String string : incExc) {
                model.addElement(string);
            }
        } else {
            this.listOperationIncludeExclude.removeAll();
            model.removeAllElements();
            model.clear();
        }
        this.listOperationIncludeExclude.setModel(model);
        this.scrollPaneOperationIncludeExclude.setViewportView(this.listOperationIncludeExclude);
        this.listOperationIncludeExclude.setSelectionInterval(0, 0);
    }

    private void loadOptions(int index) {
        this.currentTool = null;
        if (index >= 0 && index < this.configModel.getRowCount()) {
            this.currentTool = (OperationsTool)this.configModel.getValueAt(index, 0);
            this.currentConfigIndex = index;
        }
        if (index >= 0 && index < this.configModel.getRowCount() && this.currentTool != null) {
            this.loading = true;
            int cardVar = 1;
            ((CardLayout)this.panelOperationCards.getLayout()).show(this.panelOperationCards, this.currentTool.getCard().name().toLowerCase());
            int moi = this.getModeOperationIndex();
            if (moi < 0) {
                moi = 0;
            }
            this.labelOperationMode.setText(this.modes[moi].description);
            switch (this.currentTool.getOperation()) {
                case PublisherOperation: {
                    this.loadOptionsPublisher();
                    break;
                }
                case SubscriberListener: {
                    this.loadOptionsListener();
                    cardVar = 2;
                    break;
                }
                case StatusServer: {
                    this.loadOptionsHintServer();
                    break;
                }
                case PublisherManual: {
                    break;
                }
                case PublisherListener: {
                    this.loadOptionsListener();
                    cardVar = 2;
                    break;
                }
                case SubscriberTerminal: {
                    break;
                }
                case StatusServerQuit: {
                    this.loadOptionsHintsQuit();
                    break;
                }
            }
            this.updateTextFieldToolTips(cardVar);
            this.updateState();
            this.loading = false;
        }
    }

    private void loadOptionsHintServer() {
        if (this.currentTool.getOptKeys().length() > 0) {
            this.textFieldOperationHintKeys3.setText(this.currentTool.getOptKeys());
        } else {
            this.textFieldOperationHintKeys3.setText("");
        }
        this.textFieldOperationAuthKeys3.setText(this.currentTool.getOptAuthKeys());
        this.checkBoxOperationKeepGoing3.setSelected(this.currentTool.isOptListenerKeepGoing());
        this.textFieldOperationBlacklist3.setText(this.currentTool.getOptBlacklist());
        this.textFieldOperationIpWhitelist3.setText(this.currentTool.getOptIpWhitelist());
    }

    private void loadOptionsHintsQuit() {
    }

    private void loadOptionsListener() {
        if (this.currentTool.getOptTargets().length() > 0) {
            this.textFieldOperationTargets2.setText(this.currentTool.getOptTargets());
        } else {
            this.textFieldOperationTargets2.setText("");
        }
        if (this.currentTool.getOptAuthorize() != null && this.currentTool.getOptAuthorize().length > 0) {
            this.passwordFieldOperationsAuthorize.setText(new String(this.currentTool.getOptAuthorize()));
        } else {
            this.passwordFieldOperationsAuthorize.setText("");
        }
        this.passwordFieldOperationsAuthorize.setEchoChar('\u0000');
        this.textFieldOperationAuthKeys.setText(this.currentTool.getOptAuthKeys());
        this.textFieldOperationBlacklist.setText(this.currentTool.getOptBlacklist());
        this.textFieldOperationIpWhitelist.setText(this.currentTool.getOptIpWhitelist());
        if (this.currentTool.getOptKeys().length() > 0) {
            this.textFieldOperationHintKeys2.setText(this.currentTool.getOptKeys());
        } else {
            this.textFieldOperationHintKeys2.setText("");
        }
        this.checkBoxOperationKeepGoing2.setSelected(this.currentTool.isOptListenerKeepGoing());
        this.loadExcludeList();
        this.checkBoxOperationOverwrite2.setSelected(this.currentTool.isOptOverwrite());
        this.checkBoxOperationPreserveDates2.setSelected(this.currentTool.isOptPreserveDates());
        this.checkBoxOperationDecimalScale2.setSelected(this.currentTool.isOptDecimalScale());
    }

    private void loadOptionsPublisher() {
        this.checkBoxOperationNavigator.setSelected(this.currentTool.isOptNavigator());
        if (this.currentTool.getOptTargets().length() > 0) {
            this.textFieldOperationTargets.setText(this.currentTool.getOptTargets());
        } else {
            this.textFieldOperationTargets.setText("");
        }
        this.textFieldOperationMismatches.setText(this.currentTool.getOptMismatches());
        if (this.currentTool.getOptWhatsNew().length() > 0) {
            this.comboBoxOperationWhatsNew.setSelectedIndex(0);
            this.textFieldOperationWhatsNew.setText(this.currentTool.getOptWhatsNew());
        } else if (this.currentTool.getOptWhatsNewAll().length() > 0) {
            this.comboBoxOperationWhatsNew.setSelectedIndex(1);
            this.textFieldOperationWhatsNew.setText(this.currentTool.getOptWhatsNewAll());
        } else {
            this.comboBoxOperationWhatsNew.setSelectedIndex(0);
            this.textFieldOperationWhatsNew.setText("");
        }
        this.textFieldOperationExportText.setText(this.currentTool.getOptExportText());
        this.textFieldOperationExportItems.setText(this.currentTool.getOptExportItems());
        if (this.currentTool.getOptKeys().length() > 0) {
            this.comboBoxOperationHintKeys.setSelectedIndex(0);
            this.textFieldOperationHintKeys.setText(this.currentTool.getOptKeys());
        } else if (this.currentTool.getOptKeysOnly().length() > 0) {
            this.comboBoxOperationHintKeys.setSelectedIndex(1);
            this.textFieldOperationHintKeys.setText(this.currentTool.getOptKeysOnly());
        } else {
            this.comboBoxOperationHintKeys.setSelectedIndex(0);
            this.textFieldOperationHintKeys.setText("");
        }
        this.checkBoxOperationQuitStatus.setSelected(this.currentTool.isOptQuitStatus());
        this.checkBoxOperationKeepGoing.setSelected(this.currentTool.isOptListenerKeepGoing());
        this.loadIncludeExcludeList();
        this.checkBoxOperationOverwrite.setSelected(this.currentTool.isOptOverwrite());
        this.checkBoxOperationPreserveDates.setSelected(this.currentTool.isOptPreserveDates());
        this.checkBoxOperationDecimalScale.setSelected(this.currentTool.isOptDecimalScale());
        this.checkBoxOperationNoBackFill.setSelected(this.currentTool.isOptNoBackFill());
        this.checkBoxOperationValidate.setSelected(this.currentTool.isOptValidate());
        this.checkBoxOperationDuplicates.setSelected(this.currentTool.isOptDuplicates());
        this.checkBoxOperationCrossCheck.setSelected(this.currentTool.isOptCrossCheck());
        this.checkBoxOperationEmptyDirectories.setSelected(this.currentTool.isOptEmptyDirectories());
        this.checkBoxOperationIgnored.setSelected(this.currentTool.isOptIgnored());
    }

    private boolean saveConfigurations() {
        OperationsTool tool = null;
        try {
            int i;
            for (i = 0; i < this.deletedTools.size(); ++i) {
                tool = (OperationsTool)this.deletedTools.get(i);
                File file = new File(tool.getFullPath());
                if (!file.exists()) continue;
                file.delete();
            }
            this.deletedTools = new ArrayList();
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                tool = (OperationsTool)this.configModel.getValueAt(i, 0);
                if (!tool.isDataChanged() || this.validateTool(tool)) continue;
                return false;
            }
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                tool = (OperationsTool)this.configModel.getValueAt(i, 0);
                if (tool.isDataChanged()) {
                    this.validateTool(tool);
                    tool.write();
                }
                tool.setDataHasChanged(false);
            }
            this.configModel.saveJobsConfigurations(null);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this, msg, this.displayName, 0);
            }
            this.logger.error(msg);
        }
        return true;
    }

    public void savePreferences() {
        this.context.preferences.setToolsOperationsHeight(this.getHeight());
        this.context.preferences.setToolsOperationsWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setToolsOperationsXpos(location.x);
        this.context.preferences.setToolsOperationsYpos(location.y);
        this.context.preferences.setToolOperationsDividerConfigLocation(this.splitPaneOperationContent.getDividerLocation());
    }

    private void updateOnChange(Object source) {
        if (this.inUpdateOnChange) {
            return;
        }
        this.inUpdateOnChange = true;
        int cardVar = 1;
        String name = null;
        int selection = -1;
        if (source != null && this.currentTool != null && !this.loading) {
            if (source instanceof JTextField) {
                String current = null;
                boolean isPwd = false;
                JTextField tf = (JTextField)source;
                name = tf.getName();
                switch (name.toLowerCase()) {
                    case "authkeys3": {
                        current = this.currentTool.getOptAuthKeys();
                        this.currentTool.setOptAuthKeys(tf.getText());
                        break;
                    }
                    case "authkeys": {
                        current = this.currentTool.getOptAuthKeys();
                        this.currentTool.setOptAuthKeys(tf.getText());
                        break;
                    }
                    case "blacklist3": 
                    case "blacklist": {
                        current = this.currentTool.getOptBlacklist();
                        this.currentTool.setOptBlacklist(tf.getText());
                        break;
                    }
                    case "exportitems": {
                        current = this.currentTool.getOptExportItems();
                        this.currentTool.setOptExportItems(tf.getText());
                        break;
                    }
                    case "exporttext": {
                        current = this.currentTool.getOptExportText();
                        this.currentTool.setOptExportText(tf.getText());
                        break;
                    }
                    case "hintkeys2": {
                        cardVar = 2;
                    }
                    case "hintkeys": {
                        int n = selection = cardVar == 2 ? 0 : this.comboBoxOperationHintKeys.getSelectedIndex();
                        if (selection == 0) {
                            current = this.currentTool.getOptKeys();
                            if (!current.isEmpty() && tf.getText().isEmpty() && this.checkHintKeysConflicts() < 0) {
                                this.inUpdateOnChange = false;
                                return;
                            }
                            this.currentTool.setOptKeys(tf.getText());
                            break;
                        }
                        if (selection != 1) break;
                        current = this.currentTool.getOptKeysOnly();
                        if (!current.isEmpty() && tf.getText().isEmpty() && this.checkHintKeysConflicts() < 0) {
                            this.inUpdateOnChange = false;
                            return;
                        }
                        this.currentTool.setOptKeysOnly(tf.getText());
                        break;
                    }
                    case "hintkeys3": {
                        current = this.currentTool.getOptKeys();
                        this.currentTool.setOptKeys(tf.getText());
                        break;
                    }
                    case "ipwhitelist3": 
                    case "ipwhitelist": {
                        current = this.currentTool.getOptIpWhitelist();
                        this.currentTool.setOptIpWhitelist(tf.getText());
                        break;
                    }
                    case "mismatches": {
                        current = this.currentTool.getOptMismatches();
                        this.currentTool.setOptMismatches(tf.getText());
                        break;
                    }
                    case "targets2": 
                    case "targets": {
                        current = this.currentTool.getOptTargets();
                        this.currentTool.setOptTargets(tf.getText());
                        break;
                    }
                    case "whatsnew": {
                        if (this.comboBoxOperationWhatsNew.getSelectedIndex() == 0) {
                            current = this.currentTool.getOptWhatsNew();
                            this.currentTool.setOptWhatsNew(tf.getText());
                            break;
                        }
                        if (this.comboBoxOperationWhatsNew.getSelectedIndex() != 1) break;
                        current = this.currentTool.getOptWhatsNewAll();
                        this.currentTool.setOptWhatsNewAll(tf.getText());
                        break;
                    }
                    case "authpassword": {
                        isPwd = true;
                        JPasswordField pf = (JPasswordField)source;
                        char[] pw = this.currentTool.getOptAuthorize();
                        this.currentTool.setOptAuthorize(pf.getPassword());
                        if (pw == null || pw.equals(pf.getPassword())) break;
                        this.currentTool.setDataHasChanged();
                        this.updateState();
                    }
                }
                if (!isPwd && !current.equals(tf.getText())) {
                    this.currentTool.setDataHasChanged();
                    this.updateState();
                }
            } else if (source instanceof JCheckBox) {
                boolean state = false;
                JCheckBox cb = (JCheckBox)source;
                name = cb.getName();
                switch (name.toLowerCase()) {
                    case "decimalscale2": 
                    case "decimalscale": {
                        state = this.currentTool.isOptDecimalScale();
                        this.currentTool.setOptDecimalScale(cb.isSelected());
                        break;
                    }
                    case "duplicates": {
                        state = this.currentTool.isOptDuplicates();
                        this.currentTool.setOptDuplicates(cb.isSelected());
                        break;
                    }
                    case "crosscheck": {
                        state = this.currentTool.isOptCrossCheck();
                        this.currentTool.setOptCrossCheck(cb.isSelected());
                        break;
                    }
                    case "emptydirectories": {
                        state = this.currentTool.isOptEmptyDirectories();
                        this.currentTool.setOptEmptyDirectories(cb.isSelected());
                        break;
                    }
                    case "ignored": {
                        state = this.currentTool.isOptIgnored();
                        this.currentTool.setOptIgnored(cb.isSelected());
                        break;
                    }
                    case "keepgoing": 
                    case "keepgoing2": 
                    case "keepgoing3": {
                        state = this.currentTool.isOptListenerKeepGoing();
                        this.currentTool.setOptListenerKeepGoing(cb.isSelected());
                        break;
                    }
                    case "navigator": {
                        state = this.currentTool.isOptNavigator();
                        this.currentTool.setOptNavigator(cb.isSelected());
                        break;
                    }
                    case "nobackfill": {
                        state = this.currentTool.isOptNoBackFill();
                        this.currentTool.setOptNoBackFill(cb.isSelected());
                        break;
                    }
                    case "overwrite2": 
                    case "overwrite": {
                        state = this.currentTool.isOptOverwrite();
                        this.currentTool.setOptOverwrite(cb.isSelected());
                        break;
                    }
                    case "preservedates2": 
                    case "preservedates": {
                        state = this.currentTool.isOptPreserveDates();
                        this.currentTool.setOptPreserveDates(cb.isSelected());
                        break;
                    }
                    case "quitstatusserver": {
                        state = this.currentTool.isOptQuitStatus();
                        this.currentTool.setOptQuitStatus(cb.isSelected());
                        break;
                    }
                    case "validate": {
                        state = this.currentTool.isOptValidate();
                        this.currentTool.setOptValidate(cb.isSelected());
                    }
                }
                if (state != cb.isSelected()) {
                    this.currentTool.setDataHasChanged();
                    this.updateState();
                }
            } else if (source instanceof JComboBox) {
                JComboBox combo = (JComboBox)source;
                name = combo.getName();
                int current = -1;
                int index = combo.getSelectedIndex();
                String value = "";
                switch (name.toLowerCase()) {
                    case "keys2": {
                        cardVar = 2;
                    }
                    case "keys": {
                        if (this.currentTool.getOptKeys().length() > 0) {
                            current = 0;
                        } else if (this.currentTool.getOptKeysOnly().length() > 0) {
                            current = 1;
                        }
                        if (index == 0) {
                            value = cardVar == 2 ? this.textFieldOperationHintKeys2.getText() : this.textFieldOperationHintKeys.getText();
                            this.currentTool.setOptKeys(value);
                            this.currentTool.setOptKeysOnly("");
                            break;
                        }
                        if (index != 1) break;
                        value = cardVar == 2 ? this.textFieldOperationHintKeys2.getText() : this.textFieldOperationHintKeys.getText();
                        this.currentTool.setOptKeysOnly(value);
                        this.currentTool.setOptKeys("");
                        break;
                    }
                    case "whatsnew": {
                        if (this.currentTool.getOptWhatsNew().length() > 0) {
                            current = 0;
                        } else if (this.currentTool.getOptWhatsNewAll().length() > 0) {
                            current = 1;
                        }
                        if (index == 0) {
                            this.currentTool.setOptWhatsNew(this.textFieldOperationWhatsNew.getText());
                            this.currentTool.setOptWhatsNewAll("");
                            break;
                        }
                        if (index != 1) break;
                        this.currentTool.setOptWhatsNewAll(this.textFieldOperationWhatsNew.getText());
                        this.currentTool.setOptWhatsNew("");
                    }
                }
                if (index != current) {
                    this.currentTool.setDataHasChanged();
                    this.updateState();
                }
            }
        }
        if (this.currentTool != null) {
            this.updateTextFieldToolTips(cardVar);
        }
        this.inUpdateOnChange = false;
    }

    private void updateTextFieldToolTips(int carVar) {
        String current;
        int selected = 0;
        if (carVar == 1) {
            current = this.currentTool.getOptExportItems();
            this.textFieldOperationExportItems.setToolTipText(current);
            current = this.currentTool.getOptExportText();
            this.textFieldOperationExportText.setToolTipText(current);
            current = this.currentTool.getOptMismatches();
            this.textFieldOperationMismatches.setToolTipText(current);
            current = "";
            if (this.comboBoxOperationWhatsNew.getSelectedIndex() == 0) {
                current = this.currentTool.getOptWhatsNew();
            } else if (this.comboBoxOperationWhatsNew.getSelectedIndex() == 1) {
                current = this.currentTool.getOptWhatsNewAll();
            }
            this.textFieldOperationWhatsNew.setToolTipText(current);
        }
        if (carVar == 2) {
            current = this.currentTool.getOptAuthKeys();
            this.textFieldOperationAuthKeys.setToolTipText(current);
            current = this.currentTool.getOptBlacklist();
            this.textFieldOperationBlacklist.setToolTipText(current);
            current = this.currentTool.getOptIpWhitelist();
            this.textFieldOperationIpWhitelist.setToolTipText(current);
        }
        current = this.currentTool.getOptTargets();
        if (carVar == 1) {
            this.textFieldOperationTargets.setToolTipText(current);
        } else {
            this.textFieldOperationTargets2.setToolTipText(current);
        }
        current = "";
        selected = carVar == 1 ? this.comboBoxOperationHintKeys.getSelectedIndex() : 0;
        if (selected == 0) {
            current = this.currentTool.getOptKeys();
        } else if (selected == 1) {
            current = this.currentTool.getOptKeysOnly();
        }
        if (carVar == 1) {
            this.textFieldOperationHintKeys.setToolTipText(current);
        } else {
            this.textFieldOperationHintKeys2.setToolTipText(current);
        }
        current = "";
    }

    private void updateState() {
        if (this.currentTool.getCard() == OperationsTool.Cards.Publisher) {
            if (this.currentTool.isOptDuplicates()) {
                this.labelOperationCrossCheck.setEnabled(true);
                this.checkBoxOperationCrossCheck.setEnabled(true);
            } else {
                this.labelOperationCrossCheck.setEnabled(false);
                this.checkBoxOperationCrossCheck.setEnabled(false);
            }
        }
    }

    private boolean validateTool(OperationsTool tool) {
        if (tool.getCard().equals((Object)OperationsTool.Cards.HintServer)) {
            if (tool.getOptKeys().isEmpty()) {
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("OperationsUI.hint.status.server.requires.hint.keys") + tool.getConfigName());
                this.textFieldOperationHintKeys3.requestFocus();
                return false;
            }
            if (tool.getOptAuthKeys().isEmpty()) {
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("OperationsUI.hint.status.server.requires.authentication.keys") + tool.getConfigName());
                this.textFieldOperationAuthKeys3.requestFocus();
                return false;
            }
        }
        return true;
    }

    private void windowClosing(WindowEvent e) {
        this.buttonOperationCancel.doClick();
    }

    private void windowHidden(ComponentEvent e) {
        this.context.navigator.enableDisableToolMenus(this, true);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelOperationButtons = new JPanel();
        this.panelTopOperationButtons = new JPanel();
        this.buttonNewOperation = new JButton();
        this.buttonCopyOperation = new JButton();
        this.buttonDeleteOperation = new JButton();
        this.panelOperationHelp = new JPanel();
        this.labelOperationHelp = new JLabel();
        this.splitPaneOperationContent = new JSplitPane();
        this.scrollPaneOperationConfig = new JScrollPane();
        this.operationConfigItems = new JTable();
        this.panelOperationOptions = new JPanel();
        this.panelOperationControls = new JPanel();
        this.topOperationOptions = new JPanel();
        this.vSpacer0 = new JPanel(null);
        this.panelOperationMode = new JPanel();
        this.hSpacer3 = new JPanel(null);
        this.labelOperationMode = new JLabel();
        this.scrollPaneOperationCards = new JScrollPane();
        this.panelOperationCards = new JPanel();
        this.panelCardGettingStarted = new JPanel();
        this.labelOperationGettingStarted = new JLabel();
        this.panelCardPublisher = new JPanel();
        this.hSpacer4 = new JPanel(null);
        this.vSpacer3 = new JPanel(null);
        this.hSpacer5 = new JPanel(null);
        this.labelOperationNavigatorCheckbox = new JLabel();
        this.checkBoxOperationNavigator = new JCheckBox();
        this.vSpacer33 = new JPanel(null);
        this.panelOperationIncludeExcludeBox = new JPanel();
        this.scrollPaneOperationIncludeExclude = new JScrollPane();
        this.listOperationIncludeExclude = new JList();
        this.panelOperationIncludeExcludeButtons = new JPanel();
        this.buttonOperationAddIncludeExclude = new JButton();
        this.buttonOperationRemoveIncludeExclude = new JButton();
        this.labelOperationIncludeExclude = new JLabel();
        this.vSpacer4 = new JPanel(null);
        this.labelOperationTargets = new JLabel();
        this.textFieldOperationTargets = new JTextField();
        this.buttonOperationTargetsFilePick = new JButton();
        this.vSpacer5 = new JPanel(null);
        this.labelOperationsMismatches = new JLabel();
        this.textFieldOperationMismatches = new JTextField();
        this.buttonOperationMismatchesFilePick = new JButton();
        this.vSpacer6 = new JPanel(null);
        this.comboBoxOperationWhatsNew = new JComboBox();
        this.textFieldOperationWhatsNew = new JTextField();
        this.buttonOperationWhatsNewFilePick = new JButton();
        this.vSpacer7 = new JPanel(null);
        this.labelOperationDecimalScale = new JLabel();
        this.checkBoxOperationDecimalScale = new JCheckBox();
        this.labelOperationExportText = new JLabel();
        this.textFieldOperationExportText = new JTextField();
        this.buttonOperationExportTextFilePick = new JButton();
        this.vSpacer9 = new JPanel(null);
        this.labelOperationNoBackfill = new JLabel();
        this.checkBoxOperationNoBackFill = new JCheckBox();
        this.labelOperationExportItems = new JLabel();
        this.textFieldOperationExportItems = new JTextField();
        this.buttonOperationExportItemsFilePick = new JButton();
        this.vSpacer10 = new JPanel(null);
        this.labelOperationOverwrite = new JLabel();
        this.checkBoxOperationOverwrite = new JCheckBox();
        this.vSpacer11 = new JPanel(null);
        this.labelOperationPreservedDates = new JLabel();
        this.checkBoxOperationPreserveDates = new JCheckBox();
        this.comboBoxOperationHintKeys = new JComboBox();
        this.textFieldOperationHintKeys = new JTextField();
        this.buttonOperationHintKeysFilePick = new JButton();
        this.vSpacer19 = new JPanel(null);
        this.labelOperationValidate = new JLabel();
        this.checkBoxOperationValidate = new JCheckBox();
        this.labelOperationKeepGoing = new JLabel();
        this.checkBoxOperationKeepGoing = new JCheckBox();
        this.vSpacer18 = new JPanel(null);
        this.labelOperationQuitStatusServer = new JLabel();
        this.checkBoxOperationQuitStatus = new JCheckBox();
        this.vSpacer17 = new JPanel(null);
        this.labelOperationDuplicates = new JLabel();
        this.checkBoxOperationDuplicates = new JCheckBox();
        this.vSpacer16 = new JPanel(null);
        this.labelOperationCrossCheck = new JLabel();
        this.checkBoxOperationCrossCheck = new JCheckBox();
        this.vSpacer15 = new JPanel(null);
        this.labelOperationEmptyDirectories = new JLabel();
        this.checkBoxOperationEmptyDirectories = new JCheckBox();
        this.vSpacer14 = new JPanel(null);
        this.labelOperationIgnored = new JLabel();
        this.checkBoxOperationIgnored = new JCheckBox();
        this.panelCardListener = new JPanel();
        this.hSpacer6 = new JPanel(null);
        this.vSpacer40 = new JPanel(null);
        this.hSpacer7 = new JPanel(null);
        this.labelOperationTargets2 = new JLabel();
        this.textFieldOperationTargets2 = new JTextField();
        this.buttonOperationTargetsFilePick2 = new JButton();
        this.vSpacer32 = new JPanel(null);
        this.panelOperationExcludeBox = new JPanel();
        this.scrollPaneOperationExclude = new JScrollPane();
        this.listOperationExclude = new JList();
        this.panelOperationExcludeButtons = new JPanel();
        this.buttonOperationAddExclude = new JButton();
        this.buttonOperationRemoveExclude = new JButton();
        this.labelOperationExclude = new JLabel();
        this.vSpacer8 = new JPanel(null);
        this.labelOperationAuthorize = new JLabel();
        this.passwordFieldOperationsAuthorize = new JPasswordField();
        this.vSpacer12 = new JPanel(null);
        this.labelOperationAuthKeys = new JLabel();
        this.textFieldOperationAuthKeys = new JTextField();
        this.buttonOperationAuthKeysFilePick = new JButton();
        this.vSpacer20 = new JPanel(null);
        this.labelOperationBlacklist = new JLabel();
        this.textFieldOperationBlacklist = new JTextField();
        this.buttonOperationBlacklistFilePick = new JButton();
        this.vSpacer21 = new JPanel(null);
        this.labelOperationDecimalScale2 = new JLabel();
        this.checkBoxOperationDecimalScale2 = new JCheckBox();
        this.labelOperationIpWhitelist = new JLabel();
        this.textFieldOperationIpWhitelist = new JTextField();
        this.buttonOperationIpWhitelistFilePick = new JButton();
        this.vSpacer22 = new JPanel(null);
        this.labelOperationOverwrite2 = new JLabel();
        this.checkBoxOperationOverwrite2 = new JCheckBox();
        this.vSpacer23 = new JPanel(null);
        this.labelOperationPreservedDates2 = new JLabel();
        this.checkBoxOperationPreserveDates2 = new JCheckBox();
        this.labelOperationHintKeys = new JLabel();
        this.textFieldOperationHintKeys2 = new JTextField();
        this.buttonOperationHintKeysFilePick2 = new JButton();
        this.vSpacer24 = new JPanel(null);
        this.labelOperationKeepGoing2 = new JLabel();
        this.checkBoxOperationKeepGoing2 = new JCheckBox();
        this.vSpacer26 = new JPanel(null);
        this.panelCardHintServer = new JPanel();
        this.vSpacer41 = new JPanel(null);
        this.labelOperationHintKeys2 = new JLabel();
        this.textFieldOperationHintKeys3 = new JTextField();
        this.buttonOperationHintKeysFilePick3 = new JButton();
        this.vSpacer34 = new JPanel(null);
        this.label1 = new JLabel();
        this.textFieldOperationAuthKeys3 = new JTextField();
        this.buttonOperationAuthKeysFilePick3 = new JButton();
        this.vSpacer44 = new JPanel(null);
        this.labelOperationKeepGoing3 = new JLabel();
        this.checkBoxOperationKeepGoing3 = new JCheckBox();
        this.vSpacer36 = new JPanel(null);
        this.vSpacer39 = new JPanel(null);
        this.labelOperationBlacklist3 = new JLabel();
        this.textFieldOperationBlacklist3 = new JTextField();
        this.buttonOperationBlacklistFilePick3 = new JButton();
        this.vSpacer37 = new JPanel(null);
        this.labelOperationIpWhitelist3 = new JLabel();
        this.textFieldOperationIpWhitelist3 = new JTextField();
        this.buttonOperationIpWhitelistFilePick3 = new JButton();
        this.vSpacer38 = new JPanel(null);
        this.panelCardTerminal = new JPanel();
        this.labelOperationsTerminal = new JLabel();
        this.panelCardQuit = new JPanel();
        this.labelOperationsQuitter = new JLabel();
        this.panelCardQuitHints = new JPanel();
        this.labelOperationsQuitHints = new JLabel();
        this.buttonBar = new JPanel();
        this.buttonOperationSave = new JButton();
        this.buttonOperationCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.context.cfg.gs("Operations.displayName"));
        this.setName("operationsUI");
        this.setMinimumSize(new Dimension(150, 126));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OperationsUI.this.windowClosing(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                OperationsUI.this.windowHidden(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panelOperationButtons.setMinimumSize(new Dimension(0, 0));
        this.panelOperationButtons.setPreferredSize(new Dimension(614, 38));
        this.panelOperationButtons.setLayout(new BorderLayout());
        this.panelTopOperationButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopOperationButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonNewOperation.setText(this.context.cfg.gs("OperationsUI.buttonNewOperation.text"));
        this.buttonNewOperation.setToolTipText(this.context.cfg.gs("OperationsUI.buttonNewOperation.toolTipText"));
        this.buttonNewOperation.setMnemonic(this.context.cfg.gs("OperationsUI.buttonNewOperation.mnemonic").charAt(0));
        this.buttonNewOperation.addActionListener(e -> this.actionNewClicked(e));
        this.panelTopOperationButtons.add(this.buttonNewOperation);
        this.buttonCopyOperation.setText(this.context.cfg.gs("Navigator.buttonCopy.text"));
        this.buttonCopyOperation.setMnemonic(this.context.cfg.gs("OperationsUI.buttonCopyOperation.mnemonic").charAt(0));
        this.buttonCopyOperation.setToolTipText(this.context.cfg.gs("Navigator.buttonCopy.toolTipText"));
        this.buttonCopyOperation.addActionListener(e -> this.actionCopyClicked(e));
        this.panelTopOperationButtons.add(this.buttonCopyOperation);
        this.buttonDeleteOperation.setText(this.context.cfg.gs("Navigator.buttonDelete.text"));
        this.buttonDeleteOperation.setMnemonic(this.context.cfg.gs("OperationsUI.buttonDeleteOperation.mnemonic").charAt(0));
        this.buttonDeleteOperation.setToolTipText(this.context.cfg.gs("Navigator.buttonDelete.toolTipText"));
        this.buttonDeleteOperation.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopOperationButtons.add(this.buttonDeleteOperation);
        this.panelOperationButtons.add((Component)this.panelTopOperationButtons, "West");
        this.panelOperationHelp.setPreferredSize(new Dimension(40, 38));
        this.panelOperationHelp.setMinimumSize(new Dimension(0, 38));
        this.panelOperationHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelOperationHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelOperationHelp.setPreferredSize(new Dimension(32, 30));
        this.labelOperationHelp.setMinimumSize(new Dimension(32, 30));
        this.labelOperationHelp.setMaximumSize(new Dimension(32, 30));
        this.labelOperationHelp.setToolTipText(this.context.cfg.gs("OperationsUI.help"));
        this.labelOperationHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelOperationHelp.setIconTextGap(0);
        this.labelOperationHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OperationsUI.this.actionHelpClicked(e);
            }
        });
        this.panelOperationHelp.add(this.labelOperationHelp);
        this.panelOperationButtons.add((Component)this.panelOperationHelp, "East");
        this.contentPanel.add((Component)this.panelOperationButtons, "North");
        this.splitPaneOperationContent.setDividerLocation(142);
        this.splitPaneOperationContent.setLastDividerLocation(142);
        this.splitPaneOperationContent.setMinimumSize(new Dimension(0, 0));
        this.scrollPaneOperationConfig.setMinimumSize(new Dimension(0, 0));
        this.scrollPaneOperationConfig.setPreferredSize(new Dimension(142, 146));
        this.operationConfigItems.setSelectionMode(0);
        this.operationConfigItems.setShowVerticalLines(false);
        this.operationConfigItems.setFillsViewportHeight(true);
        this.scrollPaneOperationConfig.setViewportView(this.operationConfigItems);
        this.splitPaneOperationContent.setLeftComponent(this.scrollPaneOperationConfig);
        this.panelOperationOptions.setMinimumSize(new Dimension(0, 0));
        this.panelOperationOptions.setLayout(new BorderLayout());
        this.panelOperationControls.setMinimumSize(new Dimension(0, 0));
        this.panelOperationControls.setLayout(new BorderLayout());
        this.topOperationOptions.setMinimumSize(new Dimension(0, 0));
        this.topOperationOptions.setLayout(new BorderLayout());
        this.vSpacer0.setPreferredSize(new Dimension(10, 2));
        this.vSpacer0.setMinimumSize(new Dimension(10, 2));
        this.vSpacer0.setMaximumSize(new Dimension(10, 2));
        this.topOperationOptions.add((Component)this.vSpacer0, "North");
        this.panelOperationMode.setMinimumSize(new Dimension(0, 0));
        this.panelOperationMode.setLayout(new BoxLayout(this.panelOperationMode, 0));
        this.hSpacer3.setPreferredSize(new Dimension(4, 10));
        this.hSpacer3.setMinimumSize(new Dimension(4, 12));
        this.hSpacer3.setMaximumSize(new Dimension(4, Short.MAX_VALUE));
        this.panelOperationMode.add(this.hSpacer3);
        this.labelOperationMode.setMaximumSize(new Dimension(800, 16));
        this.labelOperationMode.setFont(this.labelOperationMode.getFont().deriveFont(this.labelOperationMode.getFont().getStyle() | 1, (float)this.labelOperationMode.getFont().getSize() + 1.0f));
        this.labelOperationMode.setPreferredSize(new Dimension(800, 16));
        this.labelOperationMode.setMinimumSize(new Dimension(110, 16));
        this.panelOperationMode.add(this.labelOperationMode);
        this.topOperationOptions.add((Component)this.panelOperationMode, "West");
        this.panelOperationControls.add((Component)this.topOperationOptions, "North");
        this.panelOperationOptions.add((Component)this.panelOperationControls, "North");
        this.scrollPaneOperationCards.setMinimumSize(new Dimension(0, 0));
        this.panelOperationCards.setMinimumSize(new Dimension(0, 0));
        this.panelOperationCards.setMaximumSize(null);
        this.panelOperationCards.setLayout(new CardLayout());
        this.panelCardGettingStarted.setPreferredSize(new Dimension(824, 500));
        this.panelCardGettingStarted.setMinimumSize(new Dimension(0, 0));
        this.panelCardGettingStarted.setLayout(new BorderLayout());
        this.labelOperationGettingStarted.setText(this.context.cfg.gs("OperationsUI.labelOperationGettingStarted.text"));
        this.labelOperationGettingStarted.setFont(this.labelOperationGettingStarted.getFont().deriveFont(this.labelOperationGettingStarted.getFont().getStyle() | 1));
        this.labelOperationGettingStarted.setHorizontalAlignment(0);
        this.labelOperationGettingStarted.setPreferredSize(new Dimension(630, 470));
        this.panelCardGettingStarted.add((Component)this.labelOperationGettingStarted, "Center");
        this.panelOperationCards.add((Component)this.panelCardGettingStarted, "gettingStarted");
        this.panelCardPublisher.setName("publisher");
        this.panelCardPublisher.setMinimumSize(new Dimension(0, 0));
        this.panelCardPublisher.setPreferredSize(new Dimension(824, 500));
        this.panelCardPublisher.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelCardPublisher.getLayout()).rowHeights = new int[]{0, 0, 28, 34, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.panelCardPublisher.getLayout()).columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
        ((GridBagLayout)this.panelCardPublisher.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.hSpacer4.setMinimumSize(new Dimension(154, 2));
        this.hSpacer4.setPreferredSize(new Dimension(154, 2));
        this.hSpacer4.setMaximumSize(new Dimension(154, 2));
        this.panelCardPublisher.add((Component)this.hSpacer4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer3.setMinimumSize(new Dimension(2, 8));
        this.vSpacer3.setMaximumSize(new Dimension(2, 8));
        this.vSpacer3.setPreferredSize(new Dimension(2, 8));
        this.panelCardPublisher.add((Component)this.vSpacer3, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.hSpacer5.setMinimumSize(new Dimension(154, 2));
        this.hSpacer5.setPreferredSize(new Dimension(154, 2));
        this.hSpacer5.setMaximumSize(new Dimension(154, 2));
        this.panelCardPublisher.add((Component)this.hSpacer5, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationNavigatorCheckbox.setText(this.context.cfg.gs("OperationsUI.labelOperationNavigatorCheckbox.text"));
        this.panelCardPublisher.add((Component)this.labelOperationNavigatorCheckbox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.checkBoxOperationNavigator.setName("navigator");
        this.checkBoxOperationNavigator.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationNavigator.toolTipText"));
        this.checkBoxOperationNavigator.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationNavigator, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer33.setMinimumSize(new Dimension(4, 30));
        this.vSpacer33.setPreferredSize(new Dimension(10, 30));
        this.vSpacer33.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer33, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.panelOperationIncludeExcludeBox.setPreferredSize(new Dimension(240, 120));
        this.panelOperationIncludeExcludeBox.setMinimumSize(new Dimension(240, 120));
        this.panelOperationIncludeExcludeBox.setLayout(new BoxLayout(this.panelOperationIncludeExcludeBox, 1));
        this.scrollPaneOperationIncludeExclude.setPreferredSize(new Dimension(52, 120));
        this.listOperationIncludeExclude.setName("includeexclude");
        this.listOperationIncludeExclude.setVisibleRowCount(5);
        this.listOperationIncludeExclude.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] values = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5", "Item 6"};

            @Override
            public int getSize() {
                return this.values.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.values[i];
            }
        });
        this.listOperationIncludeExclude.setToolTipText(this.context.cfg.gs("OperationsUI.listOperationIncludeExclude.toolTipText"));
        this.listOperationIncludeExclude.setMaximumSize(new Dimension(Short.MAX_VALUE, 120));
        this.scrollPaneOperationIncludeExclude.setViewportView(this.listOperationIncludeExclude);
        this.panelOperationIncludeExcludeBox.add(this.scrollPaneOperationIncludeExclude);
        this.panelOperationIncludeExcludeButtons.setPreferredSize(new Dimension(250, 28));
        this.panelOperationIncludeExcludeButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonOperationAddIncludeExclude.setText(this.context.cfg.gs("OperationsUI.buttonOperationAddIncludeExclude.text"));
        this.buttonOperationAddIncludeExclude.setFont(this.buttonOperationAddIncludeExclude.getFont().deriveFont((float)this.buttonOperationAddIncludeExclude.getFont().getSize() - 2.0f));
        this.buttonOperationAddIncludeExclude.setPreferredSize(new Dimension(78, 24));
        this.buttonOperationAddIncludeExclude.setMinimumSize(new Dimension(78, 24));
        this.buttonOperationAddIncludeExclude.setMaximumSize(new Dimension(78, 24));
        this.buttonOperationAddIncludeExclude.setMnemonic(this.context.cfg.gs("OperationsUI.buttonOperationAddIncludeExclude.mnemonic").charAt(0));
        this.buttonOperationAddIncludeExclude.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationAddIncludeExclude.toolTipText"));
        this.buttonOperationAddIncludeExclude.setName("addincexc");
        this.buttonOperationAddIncludeExclude.addActionListener(e -> this.actionOperationAddRowClicked(e));
        this.panelOperationIncludeExcludeButtons.add(this.buttonOperationAddIncludeExclude);
        this.buttonOperationRemoveIncludeExclude.setText(this.context.cfg.gs("OperationsUI.buttonOperationRemoveIncludeExclude.text"));
        this.buttonOperationRemoveIncludeExclude.setFont(this.buttonOperationRemoveIncludeExclude.getFont().deriveFont((float)this.buttonOperationRemoveIncludeExclude.getFont().getSize() - 2.0f));
        this.buttonOperationRemoveIncludeExclude.setPreferredSize(new Dimension(78, 24));
        this.buttonOperationRemoveIncludeExclude.setMinimumSize(new Dimension(78, 24));
        this.buttonOperationRemoveIncludeExclude.setMaximumSize(new Dimension(78, 24));
        this.buttonOperationRemoveIncludeExclude.setMnemonic(this.context.cfg.gs("OperationsUI.buttonOperationRemoveIncludeExclude.mnemonic").charAt(0));
        this.buttonOperationRemoveIncludeExclude.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationRemoveIncludeExclude.toolTipText"));
        this.buttonOperationRemoveIncludeExclude.setName("removeincexc");
        this.buttonOperationRemoveIncludeExclude.addActionListener(e -> this.actionOperationRemoveRowClicked(e));
        this.panelOperationIncludeExcludeButtons.add(this.buttonOperationRemoveIncludeExclude);
        this.panelOperationIncludeExcludeBox.add(this.panelOperationIncludeExcludeButtons);
        this.panelCardPublisher.add((Component)this.panelOperationIncludeExcludeBox, new GridBagConstraints(5, 1, 1, 4, 0.0, 0.0, 11, 2, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationIncludeExclude.setText(this.context.cfg.gs("OperationsUI.labelOperationIncludeExclude.text"));
        this.panelCardPublisher.add((Component)this.labelOperationIncludeExclude, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer4.setMinimumSize(new Dimension(4, 30));
        this.vSpacer4.setPreferredSize(new Dimension(10, 30));
        this.vSpacer4.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer4, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationTargets.setText(this.context.cfg.gs("OperationsUI.labelOperationTargets.text"));
        this.panelCardPublisher.add((Component)this.labelOperationTargets, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationTargets.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationTargets.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationTargets.setName("targets");
        this.textFieldOperationTargets.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.textFieldOperationTargets.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationTargets.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.textFieldOperationTargets, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationTargetsFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationTargetsFilePick.setFont(this.buttonOperationTargetsFilePick.getFont().deriveFont(this.buttonOperationTargetsFilePick.getFont().getStyle() | 1));
        this.buttonOperationTargetsFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationTargetsFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationTargetsFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationTargetsFilePick.setVerticalTextPosition(1);
        this.buttonOperationTargetsFilePick.setIconTextGap(0);
        this.buttonOperationTargetsFilePick.setHorizontalTextPosition(10);
        this.buttonOperationTargetsFilePick.setActionCommand("targetsFilePick");
        this.buttonOperationTargetsFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationTargetsFilePick.toolTipText"));
        this.buttonOperationTargetsFilePick.setName("targets");
        this.buttonOperationTargetsFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.buttonOperationTargetsFilePick, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer5.setMinimumSize(new Dimension(4, 30));
        this.vSpacer5.setPreferredSize(new Dimension(10, 30));
        this.vSpacer5.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer5, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationsMismatches.setText(this.context.cfg.gs("OperationsUI.labelOperationsMismatches.text"));
        this.panelCardPublisher.add((Component)this.labelOperationsMismatches, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationMismatches.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationMismatches.setName("mismatches");
        this.textFieldOperationMismatches.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.textFieldOperationMismatches.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationMismatches.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationMismatches.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.textFieldOperationMismatches, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationMismatchesFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationMismatchesFilePick.setFont(this.buttonOperationMismatchesFilePick.getFont().deriveFont(this.buttonOperationMismatchesFilePick.getFont().getStyle() | 1));
        this.buttonOperationMismatchesFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationMismatchesFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationMismatchesFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationMismatchesFilePick.setVerticalTextPosition(1);
        this.buttonOperationMismatchesFilePick.setIconTextGap(0);
        this.buttonOperationMismatchesFilePick.setHorizontalTextPosition(10);
        this.buttonOperationMismatchesFilePick.setActionCommand("mismatchesFilePick");
        this.buttonOperationMismatchesFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationMismatchesFilePick.toolTipText"));
        this.buttonOperationMismatchesFilePick.setName("mismatches");
        this.buttonOperationMismatchesFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.buttonOperationMismatchesFilePick, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer6.setMinimumSize(new Dimension(4, 30));
        this.vSpacer6.setPreferredSize(new Dimension(10, 30));
        this.vSpacer6.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer6, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.comboBoxOperationWhatsNew.setPrototypeDisplayValue(this.context.cfg.gs("OperationsUI.comboBoxOperationWhatsNew.prototypeDisplayValue"));
        this.comboBoxOperationWhatsNew.setModel(new DefaultComboBoxModel<String>(new String[]{"What's New:", "What's New, all:"}));
        this.comboBoxOperationWhatsNew.setName("whatsnew");
        this.comboBoxOperationWhatsNew.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add(this.comboBoxOperationWhatsNew, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationWhatsNew.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationWhatsNew.setName("whatsNew");
        this.textFieldOperationWhatsNew.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.textFieldOperationWhatsNew.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationWhatsNew.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationWhatsNew.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.textFieldOperationWhatsNew, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationWhatsNewFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationWhatsNewFilePick.setFont(this.buttonOperationWhatsNewFilePick.getFont().deriveFont(this.buttonOperationWhatsNewFilePick.getFont().getStyle() | 1));
        this.buttonOperationWhatsNewFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationWhatsNewFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationWhatsNewFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationWhatsNewFilePick.setVerticalTextPosition(1);
        this.buttonOperationWhatsNewFilePick.setIconTextGap(0);
        this.buttonOperationWhatsNewFilePick.setHorizontalTextPosition(10);
        this.buttonOperationWhatsNewFilePick.setActionCommand("whatsnewFilePick");
        this.buttonOperationWhatsNewFilePick.setName("whatsnew");
        this.buttonOperationWhatsNewFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationWhatsNewFilePick.toolTipText"));
        this.buttonOperationWhatsNewFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.buttonOperationWhatsNewFilePick, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer7.setMinimumSize(new Dimension(4, 30));
        this.vSpacer7.setPreferredSize(new Dimension(10, 30));
        this.vSpacer7.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer7, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationDecimalScale.setText(this.context.cfg.gs("OperationsUI.labelOperationDecimalScale.text"));
        this.panelCardPublisher.add((Component)this.labelOperationDecimalScale, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationDecimalScale.setName("decimalScale");
        this.checkBoxOperationDecimalScale.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationDecimalScale.toolTipText"));
        this.checkBoxOperationDecimalScale.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationDecimalScale, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationExportText.setText(this.context.cfg.gs("OperationsUI.labelOperationExportText.text"));
        this.panelCardPublisher.add((Component)this.labelOperationExportText, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationExportText.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationExportText.setName("exportText");
        this.textFieldOperationExportText.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.textFieldOperationExportText.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationExportText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationExportText.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.textFieldOperationExportText, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationExportTextFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationExportTextFilePick.setFont(this.buttonOperationExportTextFilePick.getFont().deriveFont(this.buttonOperationExportTextFilePick.getFont().getStyle() | 1));
        this.buttonOperationExportTextFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationExportTextFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationExportTextFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationExportTextFilePick.setVerticalTextPosition(1);
        this.buttonOperationExportTextFilePick.setIconTextGap(0);
        this.buttonOperationExportTextFilePick.setHorizontalTextPosition(10);
        this.buttonOperationExportTextFilePick.setActionCommand("exportTextFilePick");
        this.buttonOperationExportTextFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationExportTextFilePick.toolTipText"));
        this.buttonOperationExportTextFilePick.setName("exporttext");
        this.buttonOperationExportTextFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.buttonOperationExportTextFilePick, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer9.setMinimumSize(new Dimension(4, 30));
        this.vSpacer9.setPreferredSize(new Dimension(10, 30));
        this.vSpacer9.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer9, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationNoBackfill.setText(this.context.cfg.gs("OperationsUI.labelOperationNoBackFill.text"));
        this.panelCardPublisher.add((Component)this.labelOperationNoBackfill, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationNoBackFill.setName("noBackFill");
        this.checkBoxOperationNoBackFill.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationNoBackFill.toolTipText"));
        this.checkBoxOperationNoBackFill.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationNoBackFill, new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationExportItems.setText(this.context.cfg.gs("OperationsUI.labelOperationExportItems.text"));
        this.panelCardPublisher.add((Component)this.labelOperationExportItems, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationExportItems.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationExportItems.setName("exportItems");
        this.textFieldOperationExportItems.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.textFieldOperationExportItems.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationExportItems.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationExportItems.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.textFieldOperationExportItems, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationExportItemsFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationExportItemsFilePick.setFont(this.buttonOperationExportItemsFilePick.getFont().deriveFont(this.buttonOperationExportItemsFilePick.getFont().getStyle() | 1));
        this.buttonOperationExportItemsFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationExportItemsFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationExportItemsFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationExportItemsFilePick.setVerticalTextPosition(1);
        this.buttonOperationExportItemsFilePick.setIconTextGap(0);
        this.buttonOperationExportItemsFilePick.setHorizontalTextPosition(10);
        this.buttonOperationExportItemsFilePick.setActionCommand("exportItemsFilePick");
        this.buttonOperationExportItemsFilePick.setName("exportitems");
        this.buttonOperationExportItemsFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationExportItemsFilePick.toolTipText"));
        this.buttonOperationExportItemsFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.buttonOperationExportItemsFilePick, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer10.setMinimumSize(new Dimension(4, 30));
        this.vSpacer10.setPreferredSize(new Dimension(10, 30));
        this.vSpacer10.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer10, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationOverwrite.setText(this.context.cfg.gs("OperationsUI.labelOperationOverwrite.text"));
        this.panelCardPublisher.add((Component)this.labelOperationOverwrite, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationOverwrite.setName("overwrite");
        this.checkBoxOperationOverwrite.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationOverwrite.toolTipText"));
        this.checkBoxOperationOverwrite.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationOverwrite, new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer11.setMinimumSize(new Dimension(4, 30));
        this.vSpacer11.setPreferredSize(new Dimension(10, 30));
        this.vSpacer11.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer11, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationPreservedDates.setText(this.context.cfg.gs("OperationsUI.labelOperationPreservedDates.text"));
        this.panelCardPublisher.add((Component)this.labelOperationPreservedDates, new GridBagConstraints(4, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationPreserveDates.setName("preserveDates");
        this.checkBoxOperationPreserveDates.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationPreserveDates.toolTipText"));
        this.checkBoxOperationPreserveDates.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationPreserveDates, new GridBagConstraints(5, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.comboBoxOperationHintKeys.setPrototypeDisplayValue(this.context.cfg.gs("OperationsUI.comboBoxOperationHintKeys.prototypeDisplayValue"));
        this.comboBoxOperationHintKeys.setModel(new DefaultComboBoxModel<String>(new String[]{"Hint keys:", "Hint keys, only:"}));
        this.comboBoxOperationHintKeys.setMinimumSize(new Dimension(60, 30));
        this.comboBoxOperationHintKeys.setName("keys");
        this.comboBoxOperationHintKeys.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add(this.comboBoxOperationHintKeys, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationHintKeys.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationHintKeys.setName("hintKeys");
        this.textFieldOperationHintKeys.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.textFieldOperationHintKeys.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationHintKeys.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationHintKeys.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.textFieldOperationHintKeys, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationHintKeysFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationHintKeysFilePick.setFont(this.buttonOperationHintKeysFilePick.getFont().deriveFont(this.buttonOperationHintKeysFilePick.getFont().getStyle() | 1));
        this.buttonOperationHintKeysFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick.setVerticalTextPosition(1);
        this.buttonOperationHintKeysFilePick.setIconTextGap(0);
        this.buttonOperationHintKeysFilePick.setHorizontalTextPosition(10);
        this.buttonOperationHintKeysFilePick.setActionCommand("hintKeysFilePick");
        this.buttonOperationHintKeysFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationHintKeysFilePick.toolTipText"));
        this.buttonOperationHintKeysFilePick.setName("hintkeys");
        this.buttonOperationHintKeysFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.buttonOperationHintKeysFilePick, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer19.setMinimumSize(new Dimension(4, 30));
        this.vSpacer19.setPreferredSize(new Dimension(10, 30));
        this.vSpacer19.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer19, new GridBagConstraints(3, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationValidate.setText(this.context.cfg.gs("OperationsUI.labelOperationValidate.text"));
        this.panelCardPublisher.add((Component)this.labelOperationValidate, new GridBagConstraints(4, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationValidate.setName("validate");
        this.checkBoxOperationValidate.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationValidate.toolTipText"));
        this.checkBoxOperationValidate.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationValidate, new GridBagConstraints(5, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationKeepGoing.setText(this.context.cfg.gs("OperationsUI.labelOperationKeepGoing.text"));
        this.panelCardPublisher.add((Component)this.labelOperationKeepGoing, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.checkBoxOperationKeepGoing.setName("keepgoing");
        this.checkBoxOperationKeepGoing.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationKeepGoing.toolTipText"));
        this.checkBoxOperationKeepGoing.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationKeepGoing, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer18.setMinimumSize(new Dimension(4, 30));
        this.vSpacer18.setPreferredSize(new Dimension(10, 30));
        this.vSpacer18.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer18, new GridBagConstraints(3, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationQuitStatusServer.setText(this.context.cfg.gs("OperationsUI.labelOperationQuitStatusServer.text"));
        this.panelCardPublisher.add((Component)this.labelOperationQuitStatusServer, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.checkBoxOperationQuitStatus.setName("quitstatusserver");
        this.checkBoxOperationQuitStatus.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationQuitStatus.toolTipText"));
        this.checkBoxOperationQuitStatus.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationQuitStatus, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer17.setMinimumSize(new Dimension(4, 30));
        this.vSpacer17.setPreferredSize(new Dimension(10, 30));
        this.vSpacer17.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer17, new GridBagConstraints(3, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationDuplicates.setText(this.context.cfg.gs("OperationsUI.labelOperationDuplicates.text"));
        this.panelCardPublisher.add((Component)this.labelOperationDuplicates, new GridBagConstraints(4, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationDuplicates.setName("duplicates");
        this.checkBoxOperationDuplicates.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationDuplicates.toolTipText"));
        this.checkBoxOperationDuplicates.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationDuplicates, new GridBagConstraints(5, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer16.setMinimumSize(new Dimension(4, 30));
        this.vSpacer16.setPreferredSize(new Dimension(10, 30));
        this.vSpacer16.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer16, new GridBagConstraints(3, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationCrossCheck.setText(this.context.cfg.gs("OperationsUI.labelOperationCrossCheck.text"));
        this.panelCardPublisher.add((Component)this.labelOperationCrossCheck, new GridBagConstraints(4, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 8, 4, 4), 0, 0));
        this.checkBoxOperationCrossCheck.setName("crossCheck");
        this.checkBoxOperationCrossCheck.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationCrossCheck.toolTipText"));
        this.checkBoxOperationCrossCheck.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationCrossCheck, new GridBagConstraints(5, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer15.setMinimumSize(new Dimension(4, 30));
        this.vSpacer15.setPreferredSize(new Dimension(10, 30));
        this.vSpacer15.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer15, new GridBagConstraints(3, 13, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationEmptyDirectories.setText(this.context.cfg.gs("OperationsUI.labelOperationEmptyDirectories.text"));
        this.panelCardPublisher.add((Component)this.labelOperationEmptyDirectories, new GridBagConstraints(4, 13, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationEmptyDirectories.setName("emptyDirectories");
        this.checkBoxOperationEmptyDirectories.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationEmptyDirectories.toolTipText"));
        this.checkBoxOperationEmptyDirectories.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationEmptyDirectories, new GridBagConstraints(5, 13, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer14.setMinimumSize(new Dimension(4, 30));
        this.vSpacer14.setPreferredSize(new Dimension(10, 30));
        this.vSpacer14.setMaximumSize(new Dimension(20, 30));
        this.panelCardPublisher.add((Component)this.vSpacer14, new GridBagConstraints(3, 14, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.labelOperationIgnored.setText(this.context.cfg.gs("OperationsUI.labelOperationIgnored.text"));
        this.panelCardPublisher.add((Component)this.labelOperationIgnored, new GridBagConstraints(4, 14, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.checkBoxOperationIgnored.setName("ignored");
        this.checkBoxOperationIgnored.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationIgnored.toolTipText"));
        this.checkBoxOperationIgnored.addActionListener(e -> this.genericAction(e));
        this.panelCardPublisher.add((Component)this.checkBoxOperationIgnored, new GridBagConstraints(5, 14, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.panelOperationCards.add((Component)this.panelCardPublisher, "publisher");
        this.panelCardListener.setName("listener");
        this.panelCardListener.setPreferredSize(new Dimension(824, 500));
        this.panelCardListener.setMinimumSize(new Dimension(0, 0));
        this.panelCardListener.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelCardListener.getLayout()).rowHeights = new int[]{0, 0, 28, 34, 32, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.panelCardListener.getLayout()).columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
        ((GridBagLayout)this.panelCardListener.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.hSpacer6.setMinimumSize(new Dimension(154, 2));
        this.hSpacer6.setPreferredSize(new Dimension(154, 2));
        this.hSpacer6.setMaximumSize(new Dimension(154, 2));
        this.panelCardListener.add((Component)this.hSpacer6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer40.setPreferredSize(new Dimension(2, 8));
        this.vSpacer40.setMinimumSize(new Dimension(2, 8));
        this.vSpacer40.setMaximumSize(new Dimension(2, 8));
        this.panelCardListener.add((Component)this.vSpacer40, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.hSpacer7.setMinimumSize(new Dimension(154, 2));
        this.hSpacer7.setPreferredSize(new Dimension(154, 2));
        this.hSpacer7.setMaximumSize(new Dimension(154, 2));
        this.panelCardListener.add((Component)this.hSpacer7, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationTargets2.setText(this.context.cfg.gs("OperationsUI.labelOperationTargets2.text"));
        this.panelCardListener.add((Component)this.labelOperationTargets2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationTargets2.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationTargets2.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationTargets2.setName("targets2");
        this.textFieldOperationTargets2.setMargin(new Insets(0, 6, 2, 6));
        this.textFieldOperationTargets2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationTargets2.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.textFieldOperationTargets2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationTargetsFilePick2.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationTargetsFilePick2.setFont(this.buttonOperationTargetsFilePick2.getFont().deriveFont(this.buttonOperationTargetsFilePick2.getFont().getStyle() | 1));
        this.buttonOperationTargetsFilePick2.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationTargetsFilePick2.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationTargetsFilePick2.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationTargetsFilePick2.setVerticalTextPosition(1);
        this.buttonOperationTargetsFilePick2.setIconTextGap(0);
        this.buttonOperationTargetsFilePick2.setHorizontalTextPosition(10);
        this.buttonOperationTargetsFilePick2.setActionCommand("targetsFilePick");
        this.buttonOperationTargetsFilePick2.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationTargetsFilePick2.toolTipText"));
        this.buttonOperationTargetsFilePick2.setName("targets2");
        this.buttonOperationTargetsFilePick2.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.buttonOperationTargetsFilePick2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer32.setMinimumSize(new Dimension(4, 30));
        this.vSpacer32.setPreferredSize(new Dimension(10, 30));
        this.vSpacer32.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer32, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.panelOperationExcludeBox.setPreferredSize(new Dimension(240, 120));
        this.panelOperationExcludeBox.setMinimumSize(new Dimension(240, 120));
        this.panelOperationExcludeBox.setLayout(new BoxLayout(this.panelOperationExcludeBox, 1));
        this.scrollPaneOperationExclude.setPreferredSize(new Dimension(52, 120));
        this.listOperationExclude.setName("exclude");
        this.listOperationExclude.setVisibleRowCount(5);
        this.listOperationExclude.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] values = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5", "Item 6"};

            @Override
            public int getSize() {
                return this.values.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.values[i];
            }
        });
        this.listOperationExclude.setToolTipText(this.context.cfg.gs("OperationsUI.listOperationExclude.toolTipText"));
        this.listOperationExclude.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.scrollPaneOperationExclude.setViewportView(this.listOperationExclude);
        this.panelOperationExcludeBox.add(this.scrollPaneOperationExclude);
        this.panelOperationExcludeButtons.setPreferredSize(new Dimension(250, 28));
        this.panelOperationExcludeButtons.setLayout(new FlowLayout(0, 4, 2));
        this.buttonOperationAddExclude.setText(this.context.cfg.gs("OperationsUI.buttonOperationAddExclude.text"));
        this.buttonOperationAddExclude.setFont(this.buttonOperationAddExclude.getFont().deriveFont((float)this.buttonOperationAddExclude.getFont().getSize() - 2.0f));
        this.buttonOperationAddExclude.setPreferredSize(new Dimension(78, 24));
        this.buttonOperationAddExclude.setMinimumSize(new Dimension(78, 24));
        this.buttonOperationAddExclude.setMaximumSize(new Dimension(78, 24));
        this.buttonOperationAddExclude.setMnemonic(this.context.cfg.gs("OperationsUI.buttonOperationAddExclude.mnemonic").charAt(0));
        this.buttonOperationAddExclude.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationAddExclude.toolTipText"));
        this.buttonOperationAddExclude.setName("addexc");
        this.buttonOperationAddExclude.addActionListener(e -> this.actionOperationAddRowClicked(e));
        this.panelOperationExcludeButtons.add(this.buttonOperationAddExclude);
        this.buttonOperationRemoveExclude.setText(this.context.cfg.gs("OperationsUI.buttonOperationRemoveExclude.text"));
        this.buttonOperationRemoveExclude.setFont(this.buttonOperationRemoveExclude.getFont().deriveFont((float)this.buttonOperationRemoveExclude.getFont().getSize() - 2.0f));
        this.buttonOperationRemoveExclude.setPreferredSize(new Dimension(78, 24));
        this.buttonOperationRemoveExclude.setMinimumSize(new Dimension(78, 24));
        this.buttonOperationRemoveExclude.setMaximumSize(new Dimension(78, 24));
        this.buttonOperationRemoveExclude.setMnemonic(this.context.cfg.gs("OperationsUI.buttonOperationRemoveExclude.mnemonic").charAt(0));
        this.buttonOperationRemoveExclude.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationRemoveExclude.toolTipText"));
        this.buttonOperationRemoveExclude.setName("removeexc");
        this.buttonOperationRemoveExclude.addActionListener(e -> this.actionOperationRemoveRowClicked(e));
        this.panelOperationExcludeButtons.add(this.buttonOperationRemoveExclude);
        this.panelOperationExcludeBox.add(this.panelOperationExcludeButtons);
        this.panelCardListener.add((Component)this.panelOperationExcludeBox, new GridBagConstraints(5, 1, 1, 4, 0.0, 0.0, 11, 2, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationExclude.setText(this.context.cfg.gs("OperationsUI.labelOperationExclude.text"));
        this.panelCardListener.add((Component)this.labelOperationExclude, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer8.setMinimumSize(new Dimension(4, 30));
        this.vSpacer8.setPreferredSize(new Dimension(10, 30));
        this.vSpacer8.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer8, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationAuthorize.setText(this.context.cfg.gs("OperationsUI.labelOperationAuthorize.text"));
        this.panelCardListener.add((Component)this.labelOperationAuthorize, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.passwordFieldOperationsAuthorize.setToolTipText(this.context.cfg.gs("OperationsUI.passwordFieldOperationsAuthorize.toolTipText"));
        this.passwordFieldOperationsAuthorize.setName("authpassword");
        this.passwordFieldOperationsAuthorize.setPreferredSize(new Dimension(240, 30));
        this.passwordFieldOperationsAuthorize.setMinimumSize(new Dimension(240, 30));
        this.passwordFieldOperationsAuthorize.addActionListener(e -> this.genericAction(e));
        this.passwordFieldOperationsAuthorize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.panelCardListener.add((Component)this.passwordFieldOperationsAuthorize, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer12.setMinimumSize(new Dimension(4, 30));
        this.vSpacer12.setPreferredSize(new Dimension(10, 30));
        this.vSpacer12.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer12, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationAuthKeys.setText(this.context.cfg.gs("OperationsUI.labelOperationAuthKeys.text"));
        this.panelCardListener.add((Component)this.labelOperationAuthKeys, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationAuthKeys.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationAuthKeys.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationAuthKeys.setName("authkeys");
        this.textFieldOperationAuthKeys.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationAuthKeys.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.textFieldOperationAuthKeys, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationAuthKeysFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationAuthKeysFilePick.setFont(this.buttonOperationAuthKeysFilePick.getFont().deriveFont(this.buttonOperationAuthKeysFilePick.getFont().getStyle() | 1));
        this.buttonOperationAuthKeysFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationAuthKeysFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationAuthKeysFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationAuthKeysFilePick.setVerticalTextPosition(1);
        this.buttonOperationAuthKeysFilePick.setIconTextGap(0);
        this.buttonOperationAuthKeysFilePick.setHorizontalTextPosition(10);
        this.buttonOperationAuthKeysFilePick.setActionCommand("authKeysFilePick");
        this.buttonOperationAuthKeysFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationAuthKeysFilePick.toolTipText"));
        this.buttonOperationAuthKeysFilePick.setName("authkeys");
        this.buttonOperationAuthKeysFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.buttonOperationAuthKeysFilePick, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer20.setMinimumSize(new Dimension(4, 30));
        this.vSpacer20.setPreferredSize(new Dimension(10, 30));
        this.vSpacer20.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer20, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationBlacklist.setText(this.context.cfg.gs("OperationsUI.labelOperationBlacklist.text"));
        this.panelCardListener.add((Component)this.labelOperationBlacklist, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationBlacklist.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationBlacklist.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationBlacklist.setName("blacklist");
        this.textFieldOperationBlacklist.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationBlacklist.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.textFieldOperationBlacklist, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationBlacklistFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationBlacklistFilePick.setFont(this.buttonOperationBlacklistFilePick.getFont().deriveFont(this.buttonOperationBlacklistFilePick.getFont().getStyle() | 1));
        this.buttonOperationBlacklistFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationBlacklistFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationBlacklistFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationBlacklistFilePick.setVerticalTextPosition(1);
        this.buttonOperationBlacklistFilePick.setIconTextGap(0);
        this.buttonOperationBlacklistFilePick.setHorizontalTextPosition(10);
        this.buttonOperationBlacklistFilePick.setActionCommand("blacklistFilePick");
        this.buttonOperationBlacklistFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationBlacklistFilePick.toolTipText"));
        this.buttonOperationBlacklistFilePick.setName("blacklist");
        this.buttonOperationBlacklistFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.buttonOperationBlacklistFilePick, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer21.setMinimumSize(new Dimension(4, 30));
        this.vSpacer21.setPreferredSize(new Dimension(10, 30));
        this.vSpacer21.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer21, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationDecimalScale2.setText(this.context.cfg.gs("OperationsUI.labelOperationDecimalScale2.text"));
        this.panelCardListener.add((Component)this.labelOperationDecimalScale2, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationDecimalScale2.setName("decimalScale2");
        this.checkBoxOperationDecimalScale2.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationDecimalScale2.toolTipText"));
        this.checkBoxOperationDecimalScale2.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.checkBoxOperationDecimalScale2, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationIpWhitelist.setText(this.context.cfg.gs("OperationsUI.labelOperationIpWhitelist.text"));
        this.panelCardListener.add((Component)this.labelOperationIpWhitelist, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationIpWhitelist.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationIpWhitelist.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationIpWhitelist.setName("ipwhitelist");
        this.textFieldOperationIpWhitelist.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationIpWhitelist.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.textFieldOperationIpWhitelist, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationIpWhitelistFilePick.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationIpWhitelistFilePick.setFont(this.buttonOperationIpWhitelistFilePick.getFont().deriveFont(this.buttonOperationIpWhitelistFilePick.getFont().getStyle() | 1));
        this.buttonOperationIpWhitelistFilePick.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationIpWhitelistFilePick.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationIpWhitelistFilePick.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationIpWhitelistFilePick.setVerticalTextPosition(1);
        this.buttonOperationIpWhitelistFilePick.setIconTextGap(0);
        this.buttonOperationIpWhitelistFilePick.setHorizontalTextPosition(10);
        this.buttonOperationIpWhitelistFilePick.setActionCommand("ipWhitelistFilePick");
        this.buttonOperationIpWhitelistFilePick.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationIpWhitelistFilePick.toolTipText"));
        this.buttonOperationIpWhitelistFilePick.setName("ipwhitelist");
        this.buttonOperationIpWhitelistFilePick.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.buttonOperationIpWhitelistFilePick, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer22.setMinimumSize(new Dimension(4, 30));
        this.vSpacer22.setPreferredSize(new Dimension(10, 30));
        this.vSpacer22.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer22, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationOverwrite2.setText(this.context.cfg.gs("OperationsUI.labelOperationOverwrite2.text"));
        this.panelCardListener.add((Component)this.labelOperationOverwrite2, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationOverwrite2.setName("overwrite2");
        this.checkBoxOperationOverwrite2.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationOverwrite2.toolTipText"));
        this.checkBoxOperationOverwrite2.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.checkBoxOperationOverwrite2, new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer23.setMinimumSize(new Dimension(4, 30));
        this.vSpacer23.setPreferredSize(new Dimension(10, 30));
        this.vSpacer23.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer23, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationPreservedDates2.setText(this.context.cfg.gs("OperationsUI.labelOperationPreservedDates2.text"));
        this.panelCardListener.add((Component)this.labelOperationPreservedDates2, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationPreserveDates2.setName("preserveDates2");
        this.checkBoxOperationPreserveDates2.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationPreserveDates2.toolTipText"));
        this.checkBoxOperationPreserveDates2.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.checkBoxOperationPreserveDates2, new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationHintKeys.setText(this.context.cfg.gs("OperationsUI.labelOperationHintKeys.text"));
        this.labelOperationHintKeys.setName("keys2");
        this.panelCardListener.add((Component)this.labelOperationHintKeys, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.textFieldOperationHintKeys2.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationHintKeys2.setName("hintKeys2");
        this.textFieldOperationHintKeys2.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationHintKeys2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationHintKeys2.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.textFieldOperationHintKeys2, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationHintKeysFilePick2.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationHintKeysFilePick2.setFont(this.buttonOperationHintKeysFilePick2.getFont().deriveFont(this.buttonOperationHintKeysFilePick2.getFont().getStyle() | 1));
        this.buttonOperationHintKeysFilePick2.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick2.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick2.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick2.setVerticalTextPosition(1);
        this.buttonOperationHintKeysFilePick2.setIconTextGap(0);
        this.buttonOperationHintKeysFilePick2.setHorizontalTextPosition(10);
        this.buttonOperationHintKeysFilePick2.setActionCommand("hintKeysFilePick");
        this.buttonOperationHintKeysFilePick2.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationHintKeysFilePick2.toolTipText"));
        this.buttonOperationHintKeysFilePick2.setName("hintkeys2");
        this.buttonOperationHintKeysFilePick2.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.buttonOperationHintKeysFilePick2, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer24.setMinimumSize(new Dimension(4, 30));
        this.vSpacer24.setPreferredSize(new Dimension(10, 30));
        this.vSpacer24.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer24, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationKeepGoing2.setText(this.context.cfg.gs("OperationsUI.labelOperationKeepGoing2.text"));
        this.panelCardListener.add((Component)this.labelOperationKeepGoing2, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 4), 0, 0));
        this.checkBoxOperationKeepGoing2.setName("keepgoing2");
        this.checkBoxOperationKeepGoing2.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationKeepGoing2.toolTipText"));
        this.checkBoxOperationKeepGoing2.addActionListener(e -> this.genericAction(e));
        this.panelCardListener.add((Component)this.checkBoxOperationKeepGoing2, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.vSpacer26.setMinimumSize(new Dimension(4, 30));
        this.vSpacer26.setPreferredSize(new Dimension(10, 30));
        this.vSpacer26.setMaximumSize(new Dimension(20, 30));
        this.panelCardListener.add((Component)this.vSpacer26, new GridBagConstraints(3, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.panelOperationCards.add((Component)this.panelCardListener, "listener");
        this.panelCardHintServer.setName("hintserver");
        this.panelCardHintServer.setPreferredSize(new Dimension(824, 500));
        this.panelCardHintServer.setMinimumSize(new Dimension(0, 0));
        this.panelCardHintServer.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelCardHintServer.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.panelCardHintServer.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.vSpacer41.setMaximumSize(new Dimension(Short.MAX_VALUE, 8));
        this.vSpacer41.setMinimumSize(new Dimension(12, 8));
        this.vSpacer41.setPreferredSize(new Dimension(10, 8));
        this.panelCardHintServer.add((Component)this.vSpacer41, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationHintKeys2.setText(this.context.cfg.gs("OperationsUI.labelOperationHintKeys2.text"));
        this.panelCardHintServer.add((Component)this.labelOperationHintKeys2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldOperationHintKeys3.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationHintKeys3.setName("hintKeys3");
        this.textFieldOperationHintKeys3.setMaximumSize(new Dimension(240, 30));
        this.textFieldOperationHintKeys3.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationHintKeys3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationHintKeys3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.textFieldOperationHintKeys3, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationHintKeysFilePick3.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationHintKeysFilePick3.setFont(this.buttonOperationHintKeysFilePick3.getFont().deriveFont(this.buttonOperationHintKeysFilePick3.getFont().getStyle() | 1));
        this.buttonOperationHintKeysFilePick3.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick3.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick3.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationHintKeysFilePick3.setVerticalTextPosition(1);
        this.buttonOperationHintKeysFilePick3.setIconTextGap(0);
        this.buttonOperationHintKeysFilePick3.setHorizontalTextPosition(10);
        this.buttonOperationHintKeysFilePick3.setActionCommand("hintKeysFilePick");
        this.buttonOperationHintKeysFilePick3.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationHintKeysFilePick3.toolTipText"));
        this.buttonOperationHintKeysFilePick3.setName("hintkeys3");
        this.buttonOperationHintKeysFilePick3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.buttonOperationHintKeysFilePick3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer34.setMinimumSize(new Dimension(10, 30));
        this.vSpacer34.setPreferredSize(new Dimension(20, 30));
        this.vSpacer34.setMaximumSize(new Dimension(20, 30));
        this.panelCardHintServer.add((Component)this.vSpacer34, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.label1.setText(this.context.cfg.gs("OperationsUI.labelOperationAuthKeys.text"));
        this.panelCardHintServer.add((Component)this.label1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldOperationAuthKeys3.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationAuthKeys3.setName("authkeys3");
        this.textFieldOperationAuthKeys3.setMaximumSize(new Dimension(240, 30));
        this.textFieldOperationAuthKeys3.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationAuthKeys3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationAuthKeys3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.textFieldOperationAuthKeys3, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationAuthKeysFilePick3.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationAuthKeysFilePick3.setFont(this.buttonOperationAuthKeysFilePick3.getFont().deriveFont(this.buttonOperationAuthKeysFilePick3.getFont().getStyle() | 1));
        this.buttonOperationAuthKeysFilePick3.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationAuthKeysFilePick3.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationAuthKeysFilePick3.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationAuthKeysFilePick3.setVerticalTextPosition(1);
        this.buttonOperationAuthKeysFilePick3.setIconTextGap(0);
        this.buttonOperationAuthKeysFilePick3.setHorizontalTextPosition(10);
        this.buttonOperationAuthKeysFilePick3.setActionCommand("authKeysFilePick");
        this.buttonOperationAuthKeysFilePick3.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationAuthKeysFilePick.toolTipText"));
        this.buttonOperationAuthKeysFilePick3.setName("authkeys3");
        this.buttonOperationAuthKeysFilePick3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.buttonOperationAuthKeysFilePick3, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer44.setMinimumSize(new Dimension(10, 30));
        this.vSpacer44.setPreferredSize(new Dimension(20, 30));
        this.vSpacer44.setMaximumSize(new Dimension(20, 30));
        this.panelCardHintServer.add((Component)this.vSpacer44, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationKeepGoing3.setText(this.context.cfg.gs("OperationsUI.labelOperationKeepGoing3.text"));
        this.panelCardHintServer.add((Component)this.labelOperationKeepGoing3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.checkBoxOperationKeepGoing3.setName("keepgoing3");
        this.checkBoxOperationKeepGoing3.setToolTipText(this.context.cfg.gs("OperationsUI.checkBoxOperationKeepGoing3.toolTipText"));
        this.checkBoxOperationKeepGoing3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.checkBoxOperationKeepGoing3, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer36.setMinimumSize(new Dimension(10, 30));
        this.vSpacer36.setPreferredSize(new Dimension(20, 30));
        this.vSpacer36.setMaximumSize(new Dimension(20, 30));
        this.panelCardHintServer.add((Component)this.vSpacer36, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer39.setMinimumSize(new Dimension(10, 30));
        this.vSpacer39.setPreferredSize(new Dimension(20, 30));
        this.vSpacer39.setMaximumSize(new Dimension(20, 30));
        this.panelCardHintServer.add((Component)this.vSpacer39, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationBlacklist3.setText(this.context.cfg.gs("OperationsUI.labelOperationBlacklist3.text"));
        this.panelCardHintServer.add((Component)this.labelOperationBlacklist3, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.textFieldOperationBlacklist3.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationBlacklist3.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationBlacklist3.setName("blacklist3");
        this.textFieldOperationBlacklist3.setMaximumSize(new Dimension(240, 30));
        this.textFieldOperationBlacklist3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationBlacklist3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.textFieldOperationBlacklist3, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.buttonOperationBlacklistFilePick3.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationBlacklistFilePick3.setFont(this.buttonOperationBlacklistFilePick3.getFont().deriveFont(this.buttonOperationBlacklistFilePick3.getFont().getStyle() | 1));
        this.buttonOperationBlacklistFilePick3.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationBlacklistFilePick3.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationBlacklistFilePick3.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationBlacklistFilePick3.setVerticalTextPosition(1);
        this.buttonOperationBlacklistFilePick3.setIconTextGap(0);
        this.buttonOperationBlacklistFilePick3.setHorizontalTextPosition(10);
        this.buttonOperationBlacklistFilePick3.setActionCommand("blacklistFilePick");
        this.buttonOperationBlacklistFilePick3.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationBlacklistFilePick3.toolTipText"));
        this.buttonOperationBlacklistFilePick3.setName("blacklist3");
        this.buttonOperationBlacklistFilePick3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.buttonOperationBlacklistFilePick3, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.vSpacer37.setMinimumSize(new Dimension(10, 30));
        this.vSpacer37.setPreferredSize(new Dimension(20, 30));
        this.vSpacer37.setMaximumSize(new Dimension(20, 30));
        this.panelCardHintServer.add((Component)this.vSpacer37, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.labelOperationIpWhitelist3.setText(this.context.cfg.gs("OperationsUI.labelOperationIpWhitelist3.text"));
        this.panelCardHintServer.add((Component)this.labelOperationIpWhitelist3, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.textFieldOperationIpWhitelist3.setPreferredSize(new Dimension(240, 30));
        this.textFieldOperationIpWhitelist3.setMinimumSize(new Dimension(240, 30));
        this.textFieldOperationIpWhitelist3.setName("ipwhitelist3");
        this.textFieldOperationIpWhitelist3.setMaximumSize(new Dimension(240, 30));
        this.textFieldOperationIpWhitelist3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OperationsUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldOperationIpWhitelist3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.textFieldOperationIpWhitelist3, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.buttonOperationIpWhitelistFilePick3.setText(this.context.cfg.gs("Z.ellipsis"));
        this.buttonOperationIpWhitelistFilePick3.setFont(this.buttonOperationIpWhitelistFilePick3.getFont().deriveFont(this.buttonOperationIpWhitelistFilePick3.getFont().getStyle() | 1));
        this.buttonOperationIpWhitelistFilePick3.setMaximumSize(new Dimension(32, 24));
        this.buttonOperationIpWhitelistFilePick3.setMinimumSize(new Dimension(32, 24));
        this.buttonOperationIpWhitelistFilePick3.setPreferredSize(new Dimension(32, 24));
        this.buttonOperationIpWhitelistFilePick3.setVerticalTextPosition(1);
        this.buttonOperationIpWhitelistFilePick3.setIconTextGap(0);
        this.buttonOperationIpWhitelistFilePick3.setHorizontalTextPosition(10);
        this.buttonOperationIpWhitelistFilePick3.setActionCommand("ipWhitelistFilePick");
        this.buttonOperationIpWhitelistFilePick3.setToolTipText(this.context.cfg.gs("OperationsUI.buttonOperationIpWhitelistFilePick3.toolTipText"));
        this.buttonOperationIpWhitelistFilePick3.setName("ipwhitelist3");
        this.buttonOperationIpWhitelistFilePick3.addActionListener(e -> this.genericAction(e));
        this.panelCardHintServer.add((Component)this.buttonOperationIpWhitelistFilePick3, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.vSpacer38.setMinimumSize(new Dimension(10, 30));
        this.vSpacer38.setPreferredSize(new Dimension(20, 30));
        this.vSpacer38.setMaximumSize(new Dimension(20, 30));
        this.panelCardHintServer.add((Component)this.vSpacer38, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.panelOperationCards.add((Component)this.panelCardHintServer, "hintserver");
        this.panelCardTerminal.setName("terminal");
        this.panelCardTerminal.setMinimumSize(new Dimension(0, 0));
        this.panelCardTerminal.setPreferredSize(new Dimension(824, 500));
        this.panelCardTerminal.setLayout(new BorderLayout());
        this.labelOperationsTerminal.setText(this.context.cfg.gs("OperationsUI.labelOperationsTerminal.text"));
        this.labelOperationsTerminal.setHorizontalAlignment(0);
        this.panelCardTerminal.add((Component)this.labelOperationsTerminal, "Center");
        this.panelOperationCards.add((Component)this.panelCardTerminal, "terminal");
        this.panelCardQuit.setName("quit");
        this.panelCardQuit.setMinimumSize(new Dimension(0, 0));
        this.panelCardQuit.setPreferredSize(new Dimension(824, 500));
        this.panelCardQuit.setLayout(new BorderLayout());
        this.labelOperationsQuitter.setText(this.context.cfg.gs("OperationsUI.labelOperationsQuitter.text"));
        this.labelOperationsQuitter.setHorizontalAlignment(0);
        this.panelCardQuit.add((Component)this.labelOperationsQuitter, "Center");
        this.panelOperationCards.add((Component)this.panelCardQuit, "subscriberquit");
        this.panelCardQuitHints.setName("hintserver");
        this.panelCardQuitHints.setPreferredSize(new Dimension(824, 500));
        this.panelCardQuitHints.setMinimumSize(new Dimension(0, 0));
        this.panelCardQuitHints.setLayout(new BorderLayout());
        this.labelOperationsQuitHints.setText(this.context.cfg.gs("OperationsUI.labelOperationsQuitHints.text"));
        this.labelOperationsQuitHints.setHorizontalAlignment(0);
        this.panelCardQuitHints.add((Component)this.labelOperationsQuitHints, "Center");
        this.panelOperationCards.add((Component)this.panelCardQuitHints, "statusquit");
        this.scrollPaneOperationCards.setViewportView(this.panelOperationCards);
        this.panelOperationOptions.add((Component)this.scrollPaneOperationCards, "Center");
        this.splitPaneOperationContent.setRightComponent(this.panelOperationOptions);
        this.contentPanel.add((Component)this.splitPaneOperationContent, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.buttonOperationSave.setText(this.context.cfg.gs("Z.save"));
        this.buttonOperationSave.setToolTipText(this.context.cfg.gs("Z.save.toolTip.text"));
        this.buttonOperationSave.setMnemonic('S');
        this.buttonOperationSave.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.buttonOperationSave, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonOperationCancel.setText(this.context.cfg.gs("Z.cancel"));
        this.buttonOperationCancel.setToolTipText(this.context.cfg.gs("Z.cancel.changes.toolTipText"));
        this.buttonOperationCancel.setMnemonic('L');
        this.buttonOperationCancel.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.buttonOperationCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class Mode {
        String description;
        OperationsTool.Cards card;
        OperationsTool.Operations operation;

        public Mode(OperationsUI operationsUI, String description, OperationsTool.Cards card, OperationsTool.Operations operation) {
            this.description = description;
            this.card = card;
            this.operation = operation;
        }

        public String toString() {
            return this.description;
        }
    }
}

