/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.tools.sleep;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.NavHelp;
import com.corionis.els.gui.jobs.AbstractToolDialog;
import com.corionis.els.gui.jobs.ConfigModel;
import com.corionis.els.gui.util.NumberFilter;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.sleep.SleepTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.PlainDocument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SleepUI
extends AbstractToolDialog {
    private ConfigModel configModel;
    private Context context;
    private SleepTool currentSleepTool = null;
    private Logger logger = LogManager.getLogger("applog");
    private NavHelp helpDialog;
    private NumberFilter numberFilter;
    private SleepTool workerTool = null;
    private boolean workerRunning = false;
    public JPanel dialogPane;
    public JPanel contentPanel;
    public JPanel panelTop;
    public JPanel panelTopButtons;
    public JButton buttonNew;
    public JButton buttonCopy;
    public JButton buttonDelete;
    public JPanel panelHelp;
    public JLabel labelHelp;
    public JSplitPane splitPaneContent;
    public JScrollPane scrollPaneConfig;
    public JTable configItems;
    public JPanel panelOptions;
    public JLabel labelTime;
    public JTextField textFieldTime;
    public JPanel buttonBar;
    public JButton saveButton;
    public JButton cancelButton;

    public SleepUI(Window owner, Context context) {
        super(owner);
        this.context = context;
        this.initComponents();
        Icon icon = this.labelHelp.getIcon();
        Image image = Utils.iconToImage(icon);
        Image scaled = image.getScaledInstance(30, 30, 4);
        ImageIcon replacement = new ImageIcon(scaled);
        this.labelHelp.setIcon(replacement);
        if (context.preferences.getToolsSleepXpos() != -1 && Utils.isOnScreen(context.preferences.getToolsSleepXpos(), context.preferences.getToolsSleepYpos())) {
            this.setLocation(context.preferences.getToolsSleepXpos(), context.preferences.getToolsSleepYpos());
            Dimension dim = new Dimension(context.preferences.getToolsSleepWidth(), context.preferences.getToolsSleepHeight());
            this.setSize(dim);
        } else {
            this.setLocation(Utils.getRelativePosition(context.mainFrame, this));
        }
        this.splitPaneContent.setDividerLocation(context.preferences.getToolsSleepDividerLocation());
        AbstractAction escListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SleepUI.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.configModel = new ConfigModel(context, this);
        this.configModel.setColumnCount(1);
        this.configItems.setModel(this.configModel);
        this.configItems.getTableHeader().setUI(null);
        this.configItems.setTableHeader(null);
        this.scrollPaneConfig.setColumnHeaderView(null);
        ListSelectionModel lsm = this.configItems.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel sm = (ListSelectionModel)listSelectionEvent.getSource();
                    int index = sm.getMinSelectionIndex();
                    SleepUI.this.loadTime(index);
                }
            }
        });
        this.loadConfigurations();
        this.numberFilter = new NumberFilter();
        this.setNumberFilter(this.textFieldTime);
        context.navigator.enableDisableToolMenus(this, false);
        context.mainFrame.labelStatusMiddle.setText("<html><body>&nbsp;</body></html>");
    }

    private void actionCancelClicked(ActionEvent e) {
        if (this.workerRunning && this.workerTool != null) {
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Sleep.stop.running.sleep"), "Z.cancel.run", 0);
            if (reply == 0) {
                this.workerTool.requestStop();
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Sleep.sleep.cancelled"), this.workerTool.getConfigName()));
            }
        } else if (this.checkForChanges()) {
            Object[] opts = new Object[]{this.context.cfg.gs("Z.yes"), this.context.cfg.gs("Z.no")};
            int reply = JOptionPane.showOptionDialog(this, this.context.cfg.gs("Z.cancel.all.changes"), this.getTitle(), 0, 3, null, opts, opts[1]);
            if (reply == 0) {
                this.cancelChanges();
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void actionCopyClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            this.currentSleepTool = (SleepTool)this.configModel.getValueAt(index, 0);
            String rename = this.currentSleepTool.getConfigName() + this.context.cfg.gs("Z.copy");
            if (this.configModel.find(rename, null) == null) {
                SleepTool tool = this.currentSleepTool.clone();
                tool.setConfigName(rename);
                tool.setDataHasChanged();
                this.configModel.addRow(new Object[]{tool});
                this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
                this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
                this.configItems.getEditorComponent().requestFocus();
                ((JTextField)this.configItems.getEditorComponent()).selectAll();
            } else {
                JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + rename, this.context.cfg.gs("Sleep.title"), 2);
            }
        }
    }

    private void actionDeleteClicked(ActionEvent e) {
        int index = this.configItems.getSelectedRow();
        if (index >= 0) {
            if (this.configItems.isEditing()) {
                this.configItems.getCellEditor().stopCellEditing();
            }
            SleepTool tool = (SleepTool)this.configModel.getValueAt(index, 0);
            int reply = JOptionPane.showConfirmDialog(this, this.context.cfg.gs("Z.are.you.sure.you.want.to.delete.configuration") + tool.getConfigName(), this.context.cfg.gs("Z.delete.configuration"), 0);
            if (reply == 0) {
                int answer = this.configModel.checkJobConflicts(tool.getConfigName(), null, tool.getInternalName(), false);
                if (answer >= 0) {
                    File file = new File(tool.getFullPath());
                    if (file.exists()) {
                        this.deletedTools.add(tool);
                        tool.setDataHasChanged(false);
                    }
                    tool.setDataHasChanged();
                    this.configModel.removeRow(index);
                    if (index > this.configModel.getRowCount() - 1) {
                        index = this.configModel.getRowCount() - 1;
                    }
                    this.configModel.fireTableDataChanged();
                    if (index >= 0) {
                        this.configItems.changeSelection(index, 0, false, false);
                        this.loadTime(index);
                    }
                }
                this.configItems.requestFocus();
            }
        }
    }

    private void actionHelpClicked(MouseEvent e) {
        if (this.helpDialog == null) {
            this.helpDialog = new NavHelp(this, this, this.context, this.context.cfg.gs("Sleep.help"), "sleep_" + this.context.preferences.getLocale() + ".html", false);
            if (!this.helpDialog.fault) {
                this.helpDialog.buttonFocus();
            }
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.toFront();
            this.helpDialog.requestFocus();
            this.helpDialog.buttonFocus();
        }
    }

    private void actionNewClicked(ActionEvent e) {
        if (this.configModel.find(this.context.cfg.gs("Z.untitled"), null) == null) {
            SleepTool tool = new SleepTool(this.context);
            tool.setConfigName(this.context.cfg.gs("Z.untitled"));
            tool.setDataHasChanged();
            this.configModel.addRow(new Object[]{tool});
            if (this.configModel.getRowCount() > 0) {
                this.buttonCopy.setEnabled(true);
                this.buttonDelete.setEnabled(true);
            }
            this.configItems.editCellAt(this.configModel.getRowCount() - 1, 0);
            this.configItems.changeSelection(this.configModel.getRowCount() - 1, this.configModel.getRowCount() - 1, false, false);
            this.configItems.getEditorComponent().requestFocus();
            ((JTextField)this.configItems.getEditorComponent()).selectAll();
        } else {
            JOptionPane.showMessageDialog(this, this.context.cfg.gs("Z.please.rename.the.existing") + this.context.cfg.gs("Z.untitled"), this.context.cfg.gs("Sleep.title"), 2);
        }
    }

    private void actionSaveClicked(ActionEvent e) {
        this.saveConfigurations();
        this.savePreferences();
        this.setVisible(false);
    }

    public void cancelChanges() {
        if (this.deletedTools.size() > 0) {
            this.deletedTools = new ArrayList();
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            ((SleepTool)this.configModel.getValueAt(i, 0)).reset();
            ((SleepTool)this.configModel.getValueAt(i, 0)).setDataHasChanged(false);
        }
        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.changes.cancelled"));
    }

    public boolean checkForChanges() {
        if (!this.deletedTools.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.configModel.getRowCount(); ++i) {
            if (!((SleepTool)this.configModel.getValueAt(i, 0)).isDataChanged()) continue;
            return true;
        }
        return false;
    }

    private void configItemsMouseClicked(MouseEvent e) {
        JTable src = (JTable)e.getSource();
        if (e.getClickCount() == 1) {
            int index = src.getSelectedRow();
            this.loadTime(index);
        }
    }

    private void genericAction(ActionEvent e) {
        if (e.getActionCommand() != null) {
            this.updateOnChange(e.getSource());
        }
    }

    private void genericTextFieldFocusLost(FocusEvent e) {
        if (!(e.getOppositeComponent() instanceof JTable)) {
            this.updateOnChange(e.getSource());
        }
    }

    @Override
    public JTable getConfigItems() {
        return this.configItems;
    }

    private void loadConfigurations() {
        ArrayList<AbstractTool> toolList = null;
        try {
            toolList = this.context.tools.loadAllTools(this.context, "Sleep");
            for (AbstractTool atool : toolList) {
                SleepTool tool = (SleepTool)atool;
                this.configModel.addRow(new Object[]{tool});
            }
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogSleep, msg, this.context.cfg.gs("Sleep.title"), 0);
            }
            this.logger.error(msg);
        }
        this.configModel.setToolList(toolList);
        this.configModel.loadJobsConfigurations(this, null);
        if (this.configModel.getRowCount() == 0) {
            this.textFieldTime.setText("");
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
        } else {
            this.loadTime(0);
            this.configItems.requestFocus();
            this.configItems.setRowSelectionInterval(0, 0);
        }
    }

    private void loadTime(int index) {
        if (index >= 0 && index < this.configModel.getRowCount()) {
            this.currentSleepTool = (SleepTool)this.configModel.getValueAt(index, 0);
            this.textFieldTime.setText(Integer.toString(this.currentSleepTool.getSleepTime()));
            this.buttonCopy.setEnabled(true);
            this.buttonDelete.setEnabled(true);
        } else {
            this.currentSleepTool = null;
            this.textFieldTime.setText("");
            this.buttonCopy.setEnabled(false);
            this.buttonDelete.setEnabled(false);
        }
    }

    private void saveConfigurations() {
        SleepTool tool = null;
        try {
            int i;
            for (i = 0; i < this.deletedTools.size(); ++i) {
                tool = (SleepTool)this.deletedTools.get(i);
                File file = new File(tool.getFullPath());
                if (!file.exists()) continue;
                file.delete();
            }
            this.deletedTools = new ArrayList();
            for (i = 0; i < this.configModel.getRowCount(); ++i) {
                tool = (SleepTool)this.configModel.getValueAt(i, 0);
                if (tool.isDataChanged()) {
                    tool.write();
                }
                tool.setDataHasChanged(false);
            }
            this.configModel.saveJobsConfigurations(null);
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                this.logger.error(msg);
                JOptionPane.showMessageDialog(this.context.navigator.dialogSleep, msg, this.context.cfg.gs("Sleep.title"), 0);
            }
            this.logger.error(msg);
        }
    }

    private void savePreferences() {
        this.context.preferences.setToolsSleepHeight(this.getHeight());
        this.context.preferences.setToolsSleepWidth(this.getWidth());
        Point location = this.getLocation();
        this.context.preferences.setToolsSleepXpos(location.x);
        this.context.preferences.setToolsSleepYpos(location.y);
        this.context.preferences.setToolsSleepDividerLocation(this.splitPaneContent.getDividerLocation());
    }

    public void setComponentEnabled(boolean enabled) {
        this.setComponentEnabled(enabled, this.getContentPane());
    }

    private void setComponentEnabled(boolean enabled, Component component) {
        Component[] components;
        component.setEnabled(enabled);
        if (component instanceof Container && (components = ((Container)component).getComponents()) != null && components.length > 0) {
            for (Component comp : components) {
                this.setComponentEnabled(enabled, comp);
            }
        }
    }

    private void setNumberFilter(JTextField field) {
        PlainDocument pd = (PlainDocument)field.getDocument();
        pd.setDocumentFilter(this.numberFilter);
    }

    private void tabKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            this.updateOnChange(e.getSource());
        }
    }

    private void updateOnChange(Object source) {
        String name = null;
        if (source instanceof JTextField) {
            String current = null;
            JTextField tf = (JTextField)source;
            name = tf.getName();
            current = Integer.toString(this.currentSleepTool.getSleepTime());
            if (!current.equals(tf.getText())) {
                this.currentSleepTool.setSleepTime(Integer.parseInt(this.textFieldTime.getText()));
                this.currentSleepTool.setDataHasChanged();
            }
        }
    }

    private void windowClosing(WindowEvent e) {
        this.cancelButton.doClick();
    }

    private void windowHidden(ComponentEvent e) {
        this.context.navigator.enableDisableToolMenus(this, true);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panelTop = new JPanel();
        this.panelTopButtons = new JPanel();
        this.buttonNew = new JButton();
        this.buttonCopy = new JButton();
        this.buttonDelete = new JButton();
        this.panelHelp = new JPanel();
        this.labelHelp = new JLabel();
        this.splitPaneContent = new JSplitPane();
        this.scrollPaneConfig = new JScrollPane();
        this.configItems = new JTable();
        this.panelOptions = new JPanel();
        this.labelTime = new JLabel();
        this.textFieldTime = new JTextField();
        this.buttonBar = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(this.context.cfg.gs("Sleep.title"));
        this.setDefaultCloseOperation(0);
        this.setName("sleepUI");
        this.setPreferredSize(new Dimension(560, 395));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SleepUI.this.windowClosing(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                SleepUI.this.windowHidden(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panelTop.setMinimumSize(new Dimension(140, 38));
        this.panelTop.setPreferredSize(new Dimension(570, 38));
        this.panelTop.setLayout(new BorderLayout());
        this.panelTopButtons.setMinimumSize(new Dimension(140, 38));
        this.panelTopButtons.setLayout(new FlowLayout(0, 2, 4));
        this.buttonNew.setText("New");
        this.buttonNew.setMnemonic('N');
        this.buttonNew.setToolTipText(this.context.cfg.gs("Sleep.add.new.tool.configuration"));
        this.buttonNew.addActionListener(e -> this.actionNewClicked(e));
        this.panelTopButtons.add(this.buttonNew);
        this.buttonCopy.setText(this.context.cfg.gs("Navigator.buttonCopy.text"));
        this.buttonCopy.setMnemonic('C');
        this.buttonCopy.setToolTipText(this.context.cfg.gs("Navigator.buttonCopy.toolTipText"));
        this.buttonCopy.addActionListener(e -> this.actionCopyClicked(e));
        this.panelTopButtons.add(this.buttonCopy);
        this.buttonDelete.setText(this.context.cfg.gs("Navigator.buttonDelete.text"));
        this.buttonDelete.setMnemonic('D');
        this.buttonDelete.setToolTipText(this.context.cfg.gs("Navigator.buttonDelete.toolTipText"));
        this.buttonDelete.addActionListener(e -> this.actionDeleteClicked(e));
        this.panelTopButtons.add(this.buttonDelete);
        this.panelTop.add((Component)this.panelTopButtons, "West");
        this.panelHelp.setPreferredSize(new Dimension(40, 38));
        this.panelHelp.setMinimumSize(new Dimension(0, 38));
        this.panelHelp.setLayout(new FlowLayout(2, 4, 4));
        this.labelHelp.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        this.labelHelp.setPreferredSize(new Dimension(32, 30));
        this.labelHelp.setMinimumSize(new Dimension(32, 30));
        this.labelHelp.setMaximumSize(new Dimension(32, 30));
        this.labelHelp.setToolTipText(this.context.cfg.gs("Sleep.help"));
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setIconTextGap(0);
        this.labelHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SleepUI.this.actionHelpClicked(e);
            }
        });
        this.panelHelp.add(this.labelHelp);
        this.panelTop.add((Component)this.panelHelp, "East");
        this.contentPanel.add((Component)this.panelTop, "North");
        this.splitPaneContent.setDividerLocation(142);
        this.splitPaneContent.setLastDividerLocation(142);
        this.splitPaneContent.setMinimumSize(new Dimension(140, 80));
        this.scrollPaneConfig.setMinimumSize(new Dimension(140, 16));
        this.scrollPaneConfig.setPreferredSize(new Dimension(142, 146));
        this.configItems.setSelectionMode(0);
        this.configItems.setShowVerticalLines(false);
        this.configItems.setFillsViewportHeight(true);
        this.configItems.setShowHorizontalLines(false);
        this.configItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SleepUI.this.configItemsMouseClicked(e);
            }
        });
        this.scrollPaneConfig.setViewportView(this.configItems);
        this.splitPaneContent.setLeftComponent(this.scrollPaneConfig);
        this.panelOptions.setMinimumSize(new Dimension(0, 78));
        this.panelOptions.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panelOptions.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.panelOptions.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.panelOptions.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panelOptions.getLayout()).rowWeights = new double[]{1.0, 1.0E-4};
        this.labelTime.setText(this.context.cfg.gs("Sleep.labelTime.text"));
        this.panelOptions.add((Component)this.labelTime, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.textFieldTime.addActionListener(e -> this.genericAction(e));
        this.textFieldTime.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SleepUI.this.genericTextFieldFocusLost(e);
            }
        });
        this.textFieldTime.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SleepUI.this.tabKeyPressed(e);
            }
        });
        this.panelOptions.add((Component)this.textFieldTime, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.splitPaneContent.setRightComponent(this.panelOptions);
        this.contentPanel.add((Component)this.splitPaneContent, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.saveButton.setText(this.context.cfg.gs("Z.save"));
        this.saveButton.setToolTipText(this.context.cfg.gs("Z.save.toolTip.text"));
        this.saveButton.setMnemonic('S');
        this.saveButton.addActionListener(e -> this.actionSaveClicked(e));
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMnemonic('L');
        this.cancelButton.addActionListener(e -> this.actionCancelClicked(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

