/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui.util;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.gui.util.NumberFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;

public class DirectoryPicker {
    public JCheckBox allCheckbox;
    public JButton browserSelectionButton;
    public JDialog dialog;
    public JTextField directoryPathTextField;
    public JButton directorySelectionButton;
    public JLabel minLabel;
    public JTextField minSize;
    public JOptionPane pane;
    public JPanel panel;
    public JLabel prompt;
    private NumberFilter numberFilter = new NumberFilter();
    public JComboBox scales;
    public JTable table;

    public DirectoryPicker(final Context context, String displayName, String message, boolean includeSize, boolean includeLibraries, String value) {
        this.panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panel.setLayout(gridBagLayout);
        this.prompt = new JLabel(message);
        this.panel.add((Component)this.prompt, new GridBagConstraints(0, 0, 7, 1, 1.0, 0.0, 17, 1, new Insets(4, 0, 4, 4), 0, 0));
        this.directoryPathTextField = new JTextField();
        if (value != null) {
            this.directoryPathTextField.setText(value);
        }
        this.directoryPathTextField.setEditable(true);
        this.directoryPathTextField.setMinimumSize(new Dimension(360, 30));
        this.directoryPathTextField.setPreferredSize(new Dimension(360, 30));
        this.panel.add((Component)this.directoryPathTextField, new GridBagConstraints(0, 1, 6, 1, 1.0, 0.0, 10, 1, new Insets(0, 4, 4, 4), 0, 0));
        this.browserSelectionButton = new JButton(context.cfg.gs("Libraries.browser.button.title"));
        this.browserSelectionButton.setIconTextGap(0);
        this.browserSelectionButton.setHorizontalTextPosition(10);
        this.browserSelectionButton.setToolTipText(context.cfg.gs("Libraries.use.browser.selection"));
        this.panel.add((Component)this.browserSelectionButton, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 4, 4), 0, 0));
        this.directorySelectionButton = new JButton(context.cfg.gs("Z.ellipsis"));
        this.directorySelectionButton.setIconTextGap(0);
        this.directorySelectionButton.setHorizontalTextPosition(10);
        this.directorySelectionButton.setPreferredSize(new Dimension(32, 24));
        this.directorySelectionButton.setMinimumSize(new Dimension(32, 24));
        this.directorySelectionButton.setToolTipText(context.cfg.gs("Libraries.use.directory.picker.tooltip"));
        this.panel.add((Component)this.directorySelectionButton, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 4, 4), 0, 0));
        if (includeSize) {
            this.minLabel = new JLabel(context.cfg.gs("Libraries.minimum.free.space.for.location"));
            this.panel.add((Component)this.minLabel, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 12, 4, 4), 0, 0));
            this.minSize = new JTextField();
            this.minSize.setText(context.preferences.getLibrariesDefaultMinimum());
            this.setNumberFilter(this.minSize);
            this.panel.add((Component)this.minSize, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 4, 4), 0, 0));
            this.scales = new JComboBox();
            this.scales.addItem("KB");
            this.scales.addItem("MB");
            this.scales.addItem("GB");
            this.scales.addItem("TB");
            int defScale = 0;
            switch (context.preferences.getLibrariesDefaultMinimumScale()) {
                case "KB": {
                    defScale = 0;
                    break;
                }
                case "MB": {
                    defScale = 1;
                    break;
                }
                case "GB": {
                    defScale = 2;
                    break;
                }
                case "TB": {
                    defScale = 3;
                }
            }
            this.scales.setSelectedIndex(defScale);
            this.panel.add((Component)this.scales, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 4, 4), 0, 0));
        }
        if (includeLibraries) {
            JSeparator separator = new JSeparator();
            this.panel.add((Component)separator, new GridBagConstraints(0, 3, 8, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 4, 0), 0, 0));
            JLabel sourcesToLibrariesLabel = new JLabel(context.cfg.gs("Libraries.select.new.multiple.source.to.libraries"));
            this.panel.add((Component)sourcesToLibrariesLabel, new GridBagConstraints(0, 4, 8, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 4, 4), 0, 0));
            this.table = new JTable();
            this.table.setCellSelectionEnabled(false);
            this.table.setRowSelectionAllowed(false);
            this.table.setColumnSelectionAllowed(false);
            this.table.setFillsViewportHeight(true);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setMinimumSize(new Dimension(100, 100));
            scrollPane.setPreferredSize(new Dimension(240, 260));
            scrollPane.setViewportView(this.table);
            this.panel.add((Component)scrollPane, new GridBagConstraints(0, 5, 8, 4, 0.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0));
            this.allCheckbox = new JCheckBox(context.cfg.gs("Libraries.toggle.all"));
            this.panel.add((Component)this.allCheckbox, new GridBagConstraints(0, 9, 7, 1, 0.0, 0.0, 17, 1, new Insets(0, 15, 0, 4), 0, 0));
        }
        this.pane = new JOptionPane(this.panel);
        this.pane.setOptionType(2);
        this.dialog = this.pane.createDialog(context.mainFrame, displayName);
        this.dialog.setModal(false);
        if (context.preferences.getDirectoryPickerXpos() != -1 && Utils.isOnScreen(context.preferences.getDirectoryPickerXpos(), context.preferences.getDirectoryPickerYpos())) {
            this.dialog.setLocation(context.preferences.getDirectoryPickerXpos(), context.preferences.getDirectoryPickerYpos());
        } else {
            this.dialog.setLocation(Utils.getRelativePosition(context.mainFrame, this.dialog));
        }
        this.dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                context.preferences.setDirectoryPickerXpos(DirectoryPicker.this.dialog.getX());
                context.preferences.setDirectoryPickerYpos(DirectoryPicker.this.dialog.getY());
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
    }

    private void setNumberFilter(JTextField field) {
        PlainDocument pd = (PlainDocument)field.getDocument();
        pd.setDocumentFilter(this.numberFilter);
    }
}

