/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.hints;

import com.corionis.els.Context;
import com.corionis.els.gui.hints.HintDate;
import com.corionis.els.hints.HintStatus;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class Hint
implements Comparable,
Serializable {
    public long utc = Instant.now().toEpochMilli();
    public String author = null;
    public String system = null;
    public String action = null;
    public String fromLibrary = null;
    public String fromItemPath = null;
    public boolean directory = false;
    public String toLibrary = null;
    public String toItemPath = null;
    public List<HintStatus> statuses = null;
    public transient boolean selected = false;

    public int compareTo(Object o) {
        return this.utc < ((Hint)o).utc ? -1 : (this.utc == ((Hint)o).utc ? 0 : 1);
    }

    public void copyStatusFrom(Hint hint) {
        if (this != hint) {
            this.statuses = new ArrayList<HintStatus>();
            for (HintStatus hs : hint.statuses) {
                this.statuses.add(hs);
            }
        }
    }

    public HintStatus findStatus(String system) {
        HintStatus hs = null;
        if (this.statuses != null && this.statuses.size() > 0) {
            for (int i = 0; i < this.statuses.size(); ++i) {
                HintStatus stat = this.statuses.get(i);
                if (stat == null || !stat.system.toLowerCase().equals(system.toLowerCase())) continue;
                hs = stat;
                break;
            }
        }
        return hs;
    }

    public String getActionSummary(Context context, String forSystem) {
        String summary = "for: " + forSystem + ", ";
        summary = summary + this.action + " \"" + this.fromLibrary + "|" + this.fromItemPath + "\"";
        if (this.toLibrary != null && !this.toLibrary.isEmpty()) {
            summary = summary + " to \"" + this.toLibrary + "|" + this.toItemPath + "\"";
        }
        summary = summary + ", by: " + this.author + " on " + this.system + ", ";
        HintDate hd = new HintDate(context, this.utc);
        summary = summary + hd.toString();
        return summary;
    }

    public String getLocalUtc(Context context) {
        Instant instant = Instant.ofEpochMilli(this.utc);
        ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
        String zdtStr = zdt.format(DateTimeFormatter.ofPattern(context.preferences.getDateFormat()));
        return zdtStr;
    }

    public String getStatus(String system, String defaultStatus) {
        String status = null;
        HintStatus stat = this.findStatus(system);
        status = stat != null ? stat.status : defaultStatus;
        return status;
    }

    public int isFor(String hintSystemName) {
        if (this.statuses != null && this.statuses.size() > 0) {
            for (int i = 0; i < this.statuses.size(); ++i) {
                HintStatus hs = this.statuses.get(i);
                if (!hs.system.trim().equals(hintSystemName)) continue;
                String value = hs.status.trim().toLowerCase();
                if (!value.equals("done") && !value.equals("deleted")) {
                    return i;
                }
                return -2;
            }
        }
        return -1;
    }

    public String setStatus(String system, String status) {
        boolean isNew = false;
        HintStatus stat = null;
        if (this.statuses == null) {
            this.statuses = new ArrayList<HintStatus>();
        }
        if ((stat = this.findStatus(system)) != null && !stat.status.toLowerCase().startsWith("deleted")) {
            stat.status = status;
        }
        if (stat == null) {
            stat = new HintStatus(system, status);
            this.statuses.add(stat);
        }
        return status;
    }

    public String toString() {
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(this);
        return json;
    }
}

