/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.jobs;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.Main;
import com.corionis.els.MungeException;
import com.corionis.els.Persistent;
import com.corionis.els.Utils;
import com.corionis.els.gui.util.ArgumentTokenizer;
import com.corionis.els.jobs.Task;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.operations.OperationsTool;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Job
extends AbstractTool {
    public static String INTERNAL_NAME = "jobs";
    private String configName;
    private ArrayList<Task> tasks;
    transient Context context;
    transient Task currentTask = null;
    private transient Logger logger = LogManager.getLogger("applog");
    private transient Task previousTask = null;
    private transient boolean stop = false;

    public Job(Context context, String name) {
        super(context);
        this.context = context;
        this.configName = name;
        this.tasks = new ArrayList();
    }

    @Override
    public Job clone() {
        Job job = new Job(this.context, this.getConfigName());
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Task task : this.getTasks()) {
            tasks.add(task.clone());
        }
        job.setTasks(tasks);
        return job;
    }

    @Override
    public int compareTo(Object o) {
        return this.getConfigName().compareTo(((Job)o).getConfigName());
    }

    public String generateCommandLineJob(boolean isDryRun) {
        boolean glo = this.context.preferences != null ? this.context.preferences.isGenerateLongOptions() : false;
        String conf = (glo ? "--config \"" : "-C \"") + this.context.cfg.getWorkingDirectory() + "\"" + (this.context.cfg.isLoggerView() ? " --logger" : "");
        boolean setPub = false;
        boolean setSub = false;
        for (Task task : this.getTasks()) {
            if (task.getPublisherKey().equals("_ANY_SERVER_") && !setPub && this.context.publisherRepo != null) {
                conf = conf + " -p \"" + this.context.publisherRepo.getJsonFilename() + "\"";
                setPub = true;
            }
            if (!task.getSubscriberKey().equals("_ANY_SERVER_") || setSub || this.context.subscriberRepo == null) continue;
            conf = conf + " -s \"" + this.context.subscriberRepo.getJsonFilename() + "\"";
            setSub = true;
        }
        String cmd = conf + (isDryRun ? (glo ? " --dry-run" : " -D") : "") + (glo ? " --job \"" : " -j \"") + this.getConfigName() + "\"";
        return cmd;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getDisplayName() {
        return this.context.cfg.gs("jobs.displayName");
    }

    @Override
    public String getFullPath() {
        String path = this.getDirectoryPath() + System.getProperty("file.separator") + Utils.scrubFilename(this.getConfigName()) + ".json";
        return path;
    }

    @Override
    public String getInternalName() {
        return INTERNAL_NAME;
    }

    @Override
    public String getSubsystem() {
        return "";
    }

    @Override
    public String getListName() {
        return this.getDisplayName() + ": " + this.getConfigName();
    }

    public ArrayList<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public boolean isDataChanged() {
        return this.dataHasChanged;
    }

    @Override
    public boolean isRequestStop() {
        return this.stop;
    }

    @Override
    public boolean isToolCachedOrigins() {
        return true;
    }

    @Override
    public boolean isToolPublisher() {
        return false;
    }

    @Override
    public boolean isToolSubscriber() {
        return false;
    }

    @Override
    public void processTool(Task task) throws Exception {
        this.logger.error("SHOULD NOT BE HERE");
    }

    public Job load(String jobName) throws Exception {
        File jobDir;
        Job job = null;
        String path = this.getDirectoryPath();
        if (jobName == null || jobName.length() == 0) {
            jobName = this.getConfigName();
        }
        if ((jobDir = new File(path)).exists() && jobDir.isDirectory()) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new Job(Job.this.context, "");
                }
            }
            builder.registerTypeAdapter((Type)((Object)Job.class), new ObjInstanceCreator());
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(jobDir.toPath());
            for (Path entry : directoryStream) {
                Job tmpJob;
                String json;
                boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || json.length() <= 0 || !(tmpJob = builder.create().fromJson(json, Job.class)).getConfigName().equals(jobName)) continue;
                job = tmpJob;
                break;
            }
            if (job == null) {
                throw new MungeException(jobName + this.context.cfg.gs("Z.not.found"));
            }
        }
        return job;
    }

    public void process(Context context) throws Exception {
        this.processJob(context, this, context.cfg.isDryRun());
    }

    public SwingWorker<Void, Void> process(final Context context, Component comp, String title, Job job, final boolean isDryRun) {
        if (context.navigator.isBlockingProcessRunning()) {
            JOptionPane.showMessageDialog(context.mainFrame, context.cfg.gs("Z.please.wait.for.the.current.operation.to.finish"), context.cfg.getNavigatorName(), 2);
            return null;
        }
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    String cmd = Job.this.generateCommandLineJob(isDryRun);
                    List<String> list = ArgumentTokenizer.tokenize(cmd);
                    String[] args = list.toArray(new String[0]);
                    Job.this.logger.info(context.cfg.gs("Z.launching.job") + Job.this.getConfigName());
                    Context localContext = (Context)context.clone();
                    Main main = new Main(args, localContext, Job.this.getConfigName());
                }
                catch (Exception e) {
                    String msg = context.cfg.gs("Z.exception") + e.getMessage() + "; " + Utils.getStackTrace(e);
                    Job.this.logger.error(msg);
                    JOptionPane.showMessageDialog(context.mainFrame, msg, context.cfg.gs("JobsUI.title"), 0);
                }
                return null;
            }

            @Override
            protected void done() {
            }
        };
        return worker;
    }

    private void processJob(Context context, Job job, boolean isDryRun) throws Exception {
        this.stop = false;
        if (job.getTasks() != null && job.getTasks().size() > 0) {
            this.logger.info(context.cfg.gs("Job.executing.job") + job.getConfigName() + (isDryRun ? context.cfg.gs("Z.dry.run") : ""));
            for (Task task : job.getTasks()) {
                if (this.isRequestStop()) break;
                task.localContext = context;
                this.currentTask = task.clone();
                this.currentTask.setContext((Context)context.clone());
                this.currentTask.setDryRun(isDryRun);
                if (this.currentTask.isJob()) {
                    Job subJob = this.load(this.currentTask.getConfigName());
                    subJob.processJob(context, subJob, isDryRun);
                    if (subJob.previousTask != null) {
                        this.previousTask = subJob.previousTask;
                    }
                    this.logger.info(context.cfg.gs("Job.job.complete") + this.currentTask.getConfigName() + (isDryRun ? context.cfg.gs("Z.dry.run") : ""));
                } else {
                    if (this.previousTask != null && this.currentTask.isToolCachedOrigins(context) && this.currentTask.getPublisherKey().equalsIgnoreCase("_CACHEDLASTTASK_")) {
                        this.currentTask.setPreviousTask(this.previousTask);
                    }
                    if (!this.currentTask.process(context)) {
                        this.requestStop();
                    }
                    if (this.currentTask.isToolCachedOrigins(context)) {
                        this.previousTask = this.currentTask;
                    }
                }
                if (!context.fault) continue;
                break;
            }
            if (context.mainFrame != null) {
                context.mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                context.mainFrame.labelStatusMiddle.setText(null);
            }
        } else {
            throw new MungeException(context.cfg.gs("JobsUI.job.has.no.tasks") + job.getConfigName());
        }
        Persistent.lastPublisherRepo = null;
        Persistent.lastSubscriberRepo = null;
    }

    @Override
    public void requestStop() {
        this.stop = true;
        if (this.currentTask != null) {
            this.currentTask.requestStop();
        }
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setTasks(ArrayList<Task> tasks) {
        this.tasks = tasks;
    }

    public boolean usesPublisher() {
        for (Task task : this.tasks) {
            if (task.getPublisherKey() == null || task.getPublisherKey().length() <= 0 || task.getPublisherKey().equals("_CACHEDLASTTASK_")) continue;
            return true;
        }
        return false;
    }

    public boolean usesSubscriber() {
        for (Task task : this.tasks) {
            if (task.getSubscriberKey() == null || task.getSubscriberKey().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public String validate(Configuration cfg, boolean isThisInstance) {
        boolean hasPub = false;
        Job job = this;
        Object status = "";
        if (job.getTasks() != null && job.getTasks().size() > 0) {
            for (Task task : job.getTasks()) {
                task.setContext(this.context);
                if (task.getInternalName().equals("Sleep") || task.getPublisherKey().equals("_CACHEDLASTTASK_")) continue;
                boolean skip = false;
                if (task.getInternalName().equals("Operations")) {
                    try {
                        OperationsTool tool = (OperationsTool)task.getTool();
                        if (tool.getOperation().equals((Object)OperationsTool.Operations.StatusServer)) {
                            skip = true;
                        }
                    }
                    catch (Exception e) {
                        String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                        this.logger.error(msg);
                        JOptionPane.showMessageDialog(this.context.mainFrame, msg, this.context.cfg.gs("JobsUI.title"), 0);
                    }
                }
                if (!skip && !task.getInternalName().equals(INTERNAL_NAME)) {
                    if (!(task.getOrigins() != null && task.getOrigins().size() != 0 || task.getInternalName().equals("Operations"))) {
                        status = MessageFormat.format(cfg.gs("JobsUI.task.has.no.origins"), task.getConfigName(), job.getConfigName());
                        break;
                    }
                    if (task.getPublisherKey().length() == 0 && task.getSubscriberKey().length() == 0) {
                        if ((hasPub || isThisInstance && this.context.publisherRepo != null) && (task.getInternalName().equals("Archiver") || task.getInternalName().equals("Cleanup"))) continue;
                        status = MessageFormat.format(cfg.gs("JobsUI.task.has.no.publisher.and.or.subscriber"), task.getConfigName(), job.getConfigName());
                        break;
                    }
                }
                hasPub = true;
            }
        } else {
            status = cfg.gs("JobsUI.job.has.no.tasks") + job.getConfigName();
        }
        return status;
    }
}

