/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.jobs;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.gui.browser.NavTreeUserObject;
import com.corionis.els.jobs.Origin;
import java.awt.Component;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Origins {
    private static Logger logger = LogManager.getLogger("applog");

    public static ArrayList<ArrayList<Origin>> makeAllOrigins(Context context, Component component) throws MungeException {
        JTree baseTree = null;
        JTable baseTable = null;
        ArrayList<ArrayList<Origin>> originsArray = new ArrayList<ArrayList<Origin>>(8);
        for (int i = 0; i < 8; ++i) {
            originsArray.add(i, new ArrayList());
        }
        JComponent object = context.browser.lastComponent;
        if (object instanceof JTree) {
            baseTree = (JTree)object;
        } else if (object instanceof JTable) {
            baseTable = (JTable)object;
        }
        Origins.makeOriginsFromSelected(context, component, (ArrayList)originsArray.get(0), context.mainFrame.treeCollectionOne);
        Origins.makeOriginsFromSelected(context, component, (ArrayList)originsArray.get(1), context.mainFrame.tableCollectionOne);
        Origins.makeOriginsFromSelected(context, component, (ArrayList)originsArray.get(2), context.mainFrame.treeSystemOne);
        Origins.makeOriginsFromSelected(context, component, (ArrayList)originsArray.get(3), context.mainFrame.tableSystemOne);
        Origins.makeOriginsFromSelected(context, component, (ArrayList)originsArray.get(4), context.mainFrame.treeCollectionTwo);
        Origins.makeOriginsFromSelected(context, component, (ArrayList)originsArray.get(5), context.mainFrame.tableCollectionTwo);
        Origins.makeOriginsFromSelected(context, component, (ArrayList)originsArray.get(6), context.mainFrame.treeSystemTwo);
        Origins.makeOriginsFromSelected(context, component, (ArrayList)originsArray.get(7), context.mainFrame.tableSystemTwo);
        if (baseTree != null) {
            baseTree.requestFocus();
        } else if (baseTable != null) {
            baseTable.requestFocus();
        }
        return originsArray;
    }

    public static boolean makeOriginsFromSelected(Context context, Component component, ArrayList<Origin> origins) throws MungeException {
        return Origins.makeOriginsFromSelected(context, component, origins, context.browser.lastComponent);
    }

    public static boolean makeOriginsFromSelected(Context context, Component component, ArrayList<Origin> origins, Object fromComponent) throws MungeException {
        boolean isSubscriber = false;
        if (fromComponent instanceof JTree) {
            TreePath[] paths;
            JTree sourceTree = (JTree)fromComponent;
            int row = sourceTree.getLeadSelectionRow();
            if (row > -1 && (paths = sourceTree.getSelectionPaths()) != null) {
                for (TreePath tp : paths) {
                    NavTreeNode ctn = (NavTreeNode)tp.getLastPathComponent();
                    boolean child = false;
                    for (TreePath sp : paths) {
                        NavTreeNode ntn = (NavTreeNode)sp.getLastPathComponent();
                        if (ntn == ctn || !ntn.isNodeChild(ctn)) continue;
                        logger.info(MessageFormat.format(context.cfg.gs("Z.skipping.child"), ctn.getUserObject().name, ntn.getUserObject().name));
                        child = true;
                    }
                    if (child) continue;
                    NavTreeUserObject tuo = ctn.getUserObject();
                    isSubscriber = tuo.isSubscriber();
                    origins.add(new Origin(sourceTree, tp, tuo));
                }
            }
        } else if (fromComponent instanceof JTable) {
            int[] rows;
            JTable sourceTable = (JTable)fromComponent;
            int row = sourceTable.getSelectedRow();
            if (row > -1 && (rows = sourceTable.getSelectedRows()) != null) {
                for (int i = 0; i < rows.length; ++i) {
                    NavTreeUserObject tuo = (NavTreeUserObject)sourceTable.getValueAt(rows[i], 1);
                    isSubscriber = tuo.isSubscriber();
                    NavTreeNode ntn = (NavTreeNode)tuo.node.getMyTree().getLastSelectedPathComponent();
                    TreePath tp = ntn.getTreePath();
                    origins.add(new Origin(sourceTable, tp, rows[i], tuo));
                }
            }
        } else {
            throw new MungeException("fromComponent unknown; logic fault");
        }
        return isSubscriber;
    }

    public static void setAllOrigins(Context context, Component component, ArrayList<ArrayList<Origin>> originsArray) throws MungeException {
        JTree baseTree = null;
        JTable baseTable = null;
        if (originsArray.size() != 8) {
            throw new MungeException(context.cfg.gs("Job.set.all.origins.logic.fault"));
        }
        JComponent object = context.browser.lastComponent;
        if (object instanceof JTree) {
            baseTree = (JTree)object;
        } else if (object instanceof JTable) {
            baseTable = (JTable)object;
        }
        Origins.setSelectedFromOrigins(context, component, originsArray.get(0));
        Origins.setSelectedFromOrigins(context, component, originsArray.get(1));
        Origins.setSelectedFromOrigins(context, component, originsArray.get(2));
        Origins.setSelectedFromOrigins(context, component, originsArray.get(3));
        Origins.setSelectedFromOrigins(context, component, originsArray.get(4));
        Origins.setSelectedFromOrigins(context, component, originsArray.get(5));
        Origins.setSelectedFromOrigins(context, component, originsArray.get(6));
        Origins.setSelectedFromOrigins(context, component, originsArray.get(7));
        if (baseTree != null) {
            baseTree.requestFocus();
        } else if (baseTable != null) {
            baseTable.requestFocus();
        }
    }

    public static void setSelectedFromOrigins(Context context, Component component, ArrayList<Origin> origins) {
        if (origins != null && origins.size() > 0) {
            if (origins.get((int)0).sourceTree != null) {
                JTree tree = origins.get((int)0).sourceTree;
                TreePath[] paths = new TreePath[origins.size()];
                for (int i = 0; i < origins.size(); ++i) {
                    TreePath op;
                    Origin origin = origins.get(i);
                    TreePath tp = origin.treePath;
                    Object[] objs = tp.getPath();
                    String[] pathElements = new String[tp.getPathCount()];
                    paths[i] = tp;
                    for (int j = 0; j < tp.getPathCount(); ++j) {
                        NavTreeNode node = (NavTreeNode)objs[j];
                        pathElements[j] = node.getUserObject().name;
                    }
                    String panel = origin.sourceTree.getName().toLowerCase();
                    if (panel.length() <= 0 || (op = context.browser.scanTreePath(panel, pathElements, true, false, false)) == null) continue;
                    paths[i] = op;
                }
                tree.setExpandsSelectedPaths(true);
                tree.setSelectionPaths(paths);
                tree.scrollPathToVisible(origins.get((int)(origins.size() - 1)).treePath);
                tree.setAnchorSelectionPath(origins.get((int)(origins.size() - 1)).treePath);
                tree.requestFocus();
            } else if (origins.get((int)0).sourceTable != null) {
                TreePath op;
                Origin origin = origins.get(0);
                JTree tree = origin.tuo.node.getMyTree();
                TreePath tp = origin.treePath;
                Object[] objs = tp.getPath();
                String[] pathElements = new String[tp.getPathCount()];
                for (int j = 0; j < tp.getPathCount(); ++j) {
                    NavTreeNode node = (NavTreeNode)objs[j];
                    pathElements[j] = node.getUserObject().name;
                }
                String panel = origin.sourceTable.getName().toLowerCase();
                if (panel.length() > 0 && (op = context.browser.scanTreePath(panel, pathElements, true, false, false)) != null) {
                    tp = op;
                }
                tree.setExpandsSelectedPaths(true);
                tree.setSelectionPath(tp);
                tree.scrollPathToVisible(tp);
                tree.setAnchorSelectionPath(tp);
                JTable table = origin.sourceTable;
                ListSelectionModel model = table.getSelectionModel();
                int row = 0;
                for (int i = 0; i < origins.size(); ++i) {
                    row = origins.get((int)i).tableRow;
                    model.addSelectionInterval(row, row);
                }
                table.scrollRectToVisible(new Rectangle(table.getCellRect(row, row, true)));
                table.requestFocus();
            }
        }
    }
}

