/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.repository;

import java.io.Serializable;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Item
implements Serializable {
    private String fullPath;
    private String itemPath;
    private String library;
    private long size = -1L;
    private boolean directory = false;
    private boolean symLink = false;
    private long modifiedDate;
    private transient List<Item> hasList = new ArrayList<Item>();
    private transient boolean hintExecuted = false;
    private transient String itemShortName;
    private transient String itemSubdirectory;
    private transient boolean reported = false;

    public void addHas(Item item) {
        if (!this.hasList.contains(item)) {
            this.hasList.add(item);
        }
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public List<Item> getHas() {
        return this.hasList;
    }

    public String getItemPath() {
        return this.itemPath;
    }

    public String getItemShortName() {
        return this.itemShortName;
    }

    public String getItemSubdirectory() {
        return this.itemSubdirectory;
    }

    public String getLibrary() {
        return this.library;
    }

    public FileTime getModifiedDate() {
        return FileTime.from(this.modifiedDate, TimeUnit.MILLISECONDS);
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isHintExecuted() {
        return this.hintExecuted;
    }

    public boolean isReported() {
        return this.reported;
    }

    public boolean isSymLink() {
        return this.symLink;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public void setHintExecuted(boolean hintExecuted) {
        this.hintExecuted = hintExecuted;
    }

    public void setItemPath(String itemPath) {
        this.itemPath = itemPath;
    }

    public void setItemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
    }

    public void setItemSubdirectory(String itemSubdirectory) {
        this.itemSubdirectory = itemSubdirectory;
    }

    public void setLibrary(String library) {
        this.library = library;
    }

    public void setModifiedDate(FileTime modifiedDate) {
        this.modifiedDate = modifiedDate.toMillis();
    }

    public void setReported(boolean reported) {
        this.reported = reported;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setSymLink(boolean symLink) {
        this.symLink = symLink;
    }

    public String toString() {
        return this.itemShortName;
    }
}

