/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.repository;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.repository.RepoMeta;
import com.corionis.els.repository.Repository;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Repositories {
    private ArrayList<RepoMeta> metaList = null;
    private ArrayList<Repository> repoList = null;
    private Logger logger = LogManager.getLogger("applog");

    private void addRepo(Context context, String path) {
        block4: {
            Repository found = this.findRepoPath(path);
            if (found == null) {
                try {
                    Repository repo = new Repository(context, 0);
                    if (repo.read(path, "a", false)) {
                        this.repoList.add(repo);
                        RepoMeta repoMeta = new RepoMeta();
                        repoMeta.description = repo.getLibraryData().libraries.description;
                        repoMeta.key = repo.getLibraryData().libraries.key;
                        repoMeta.path = repo.getJsonFilename();
                        this.metaList.add(repoMeta);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage() + " : " + Utils.getStackTrace(e));
                    if (context.mainFrame == null) break block4;
                    JOptionPane.showMessageDialog(context.mainFrame, context.cfg.gs("Z.error.reading") + path, context.cfg.getNavigatorName(), 0);
                }
            }
        }
    }

    public Repository addRepo(Context context, String path, int purpose) {
        Repository repo = null;
        if (path != null && !path.isEmpty()) {
            try {
                Repository found = this.findRepoPath(path);
                if (found == null && (repo = new Repository(context, purpose)).read(path, "a", false)) {
                    this.repoList.add(repo);
                    RepoMeta repoMeta = new RepoMeta();
                    repoMeta.description = repo.getLibraryData().libraries.description;
                    repoMeta.key = repo.getLibraryData().libraries.key;
                    repoMeta.path = repo.getJsonFilename();
                    this.metaList.add(repoMeta);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage() + " : " + Utils.getStackTrace(e));
                if (context.mainFrame != null) {
                    JOptionPane.showMessageDialog(context.mainFrame, context.cfg.gs("Z.error.reading") + path, context.cfg.getNavigatorName(), 0);
                }
                repo = null;
            }
        }
        return repo;
    }

    private RepoMeta findMeta(String key) {
        RepoMeta repoMeta = null;
        if (key != null && !key.isEmpty() && this.metaList != null) {
            for (RepoMeta m : this.metaList) {
                if (!m.key.equals(key)) continue;
                repoMeta = m;
                break;
            }
        }
        return repoMeta;
    }

    public RepoMeta findMetaAdd(Context context, String key, String path, int purpose) {
        RepoMeta repoMeta = null;
        if (!(key == null || key.isEmpty() || (repoMeta = this.findMeta(key)) != null || path.startsWith(this.getDirectoryPath()) || path == null || path.isEmpty())) {
            this.addRepo(context, path, purpose);
            repoMeta = this.findMeta(key);
        }
        return repoMeta;
    }

    public RepoMeta findMetaPath(String path) {
        RepoMeta repoMeta = null;
        if (path != null && !path.isEmpty() && this.metaList != null) {
            path = Utils.pipe(path);
            for (RepoMeta m : this.metaList) {
                String mPath = Utils.pipe(m.path);
                if (!mPath.endsWith(path)) continue;
                repoMeta = m;
                break;
            }
        }
        return repoMeta;
    }

    public Repository findRepoPath(String path) {
        Repository repo = null;
        if (path.length() > 0) {
            for (int i = 0; i < this.repoList.size(); ++i) {
                if (!this.repoList.get(i).getJsonFilename().endsWith(path)) continue;
                repo = this.repoList.get(i);
                break;
            }
        }
        return repo;
    }

    public String getDirectoryPath() {
        String path = System.getProperty("user.dir") + System.getProperty("file.separator") + "libraries";
        return path;
    }

    public ArrayList<RepoMeta> getMetaList() {
        return this.metaList;
    }

    public ArrayList<Repository> getRepoList() {
        return this.repoList;
    }

    public ArrayList<RepoMeta> loadList(Context context) throws Exception {
        boolean dynamicPublisher = false;
        boolean dynamicSubscriber = false;
        boolean dynamicHints = false;
        if (context.publisherRepo != null && context.publisherRepo.getLibraryData().libraries.key != null) {
            dynamicPublisher = context.publisherRepo.isDynamic();
        }
        if (context.subscriberRepo != null && context.subscriberRepo.getLibraryData().libraries.key != null) {
            dynamicSubscriber = context.subscriberRepo.isDynamic();
        }
        if (context.hintsRepo != null && context.hintsRepo.getLibraryData().libraries.key != null) {
            dynamicHints = context.hintsRepo.isDynamic();
        }
        this.repoList = new ArrayList();
        this.metaList = new ArrayList();
        File libDir = new File(this.getDirectoryPath());
        if (libDir.exists() && libDir.isDirectory()) {
            Repository repo;
            RepoMeta meta;
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(libDir.toPath());
            for (Path entry : directoryStream) {
                boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                if (isDir) continue;
                this.addRepo(context, entry.toString());
            }
            if (context.publisherRepo != null && context.publisherRepo.getLibraryData().libraries.key != null && (meta = this.findMetaPath(context.publisherRepo.getJsonFilename())) == null && !context.publisherRepo.getJsonFilename().startsWith(this.getDirectoryPath())) {
                repo = this.addRepo(context, context.publisherRepo.getJsonFilename(), 1);
                repo.setDynamic(dynamicPublisher);
            }
            if (context.subscriberRepo != null && context.subscriberRepo.getLibraryData().libraries.key != null && (meta = this.findMetaPath(context.subscriberRepo.getJsonFilename())) == null && !context.subscriberRepo.getJsonFilename().startsWith(this.getDirectoryPath())) {
                repo = this.addRepo(context, context.subscriberRepo.getJsonFilename(), 2);
                repo.setDynamic(dynamicSubscriber);
            }
            if (context.hintsRepo != null && context.hintsRepo.getLibraryData().libraries.key != null && (meta = this.findMetaPath(context.hintsRepo.getJsonFilename())) == null && !context.hintsRepo.getJsonFilename().startsWith(this.getDirectoryPath())) {
                repo = this.addRepo(context, context.hintsRepo.getJsonFilename(), 3);
                repo.setDynamic(dynamicHints);
            }
            if (this.repoList.size() > 0) {
                Collections.sort(this.repoList);
                Collections.sort(this.metaList);
            }
        }
        return this.metaList;
    }
}

