/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.sftp;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.repository.Repository;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.text.MessageFormat;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientSftp {
    private Context context;
    private String hostListen;
    private String hostname;
    private int hostport;
    private Channel jChannel;
    private Session jSession;
    private JSch jsch;
    private transient Logger logger = LogManager.getLogger("applog");
    private Repository myRepo;
    private String password;
    private String purpose = "";
    private Repository theirRepo;
    private String user;

    private ClientSftp() {
    }

    public ClientSftp(Context context, Repository mine, Repository theirs, boolean primaryServers) {
        String address;
        this.context = context;
        this.myRepo = mine;
        this.theirRepo = theirs;
        if (!context.cfg.getOverrideSubscriberHost().isEmpty()) {
            if (context.cfg.getOverrideSubscriberHost().trim().equals("true")) {
                address = this.theirRepo.getLibraryData().libraries.listen;
                this.hostListen = context.cfg.gs("Z.listen");
                if (address == null || address.isEmpty()) {
                    address = this.theirRepo.getLibraryData().libraries.host;
                    this.hostListen = context.cfg.gs("Z.host");
                }
            } else {
                address = context.cfg.getOverrideSubscriberHost();
                this.hostListen = context.cfg.gs("Z.custom");
            }
        } else {
            address = this.theirRepo.getLibraryData().libraries.host;
            this.hostListen = context.cfg.gs("Z.host");
        }
        this.hostname = Utils.parseHost(address);
        this.hostport = Utils.getPort(address) + (primaryServers ? 1 : 3);
        this.user = this.myRepo.getLibraryData().libraries.key;
        this.password = this.theirRepo.getLibraryData().libraries.key;
    }

    private ChannelSftp connect() {
        ChannelSftp jSftp = null;
        try {
            this.jChannel = this.jSession.openChannel("sftp");
            this.jChannel.connect();
            jSftp = (ChannelSftp)this.jChannel;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return jSftp;
    }

    public void get(String source, String dest) throws Exception {
        ChannelSftp jSftp = this.connect();
        source = Utils.pipe(this.context.cfg.getFullPathSubscriber(source));
        source = Utils.unpipe(source, "/");
        dest = Utils.pipe(Utils.getFullPathLocal(dest));
        dest = Utils.unpipe(dest, "/");
        if (this.context.progress != null) {
            jSftp.get(source, dest, (SftpProgressMonitor)this.context.progress);
        } else {
            jSftp.get(source, dest);
        }
        jSftp.disconnect();
    }

    public boolean isConnected() {
        boolean connected = false;
        if (this.jChannel != null && this.jSession != null) {
            connected = true;
        }
        return connected;
    }

    public synchronized Vector listDirectory(String directory) throws Exception {
        directory = Utils.pipe(this.context.cfg.getFullPathSubscriber(directory));
        directory = Utils.unpipe(directory, "/");
        ChannelSftp jSftp = this.connect();
        Vector listing = jSftp.ls(directory);
        jSftp.disconnect();
        return listing;
    }

    public String makeDirectory(String pathname) throws Exception {
        pathname = Utils.pipe(this.context.cfg.getFullPathSubscriber(pathname));
        String[] parts = pathname.split("\\|");
        String sep = "/";
        Object whole = "";
        for (int i = 0; i < parts.length - 1; ++i) {
            try {
                if (parts[i].endsWith(":") && this.theirRepo.getLibraryData().libraries.flavor.equalsIgnoreCase("Windows")) {
                    whole = sep + parts[i];
                    continue;
                }
                if (((String)(whole = (String)whole + (i > 0 ? sep : "") + parts[i])).length() < 1 || ((String)whole).equals(sep)) continue;
                ChannelSftp jSftp = this.connect();
                jSftp.mkdir((String)whole);
                jSftp.disconnect();
                continue;
            }
            catch (SftpException e) {
                String msg = e.toString().trim().toLowerCase();
                if (msg.contains("alreadyexists")) continue;
                throw new SftpException(e.id, e.getMessage() + ": " + (String)whole);
            }
        }
        return whole;
    }

    public String pwd() throws Exception {
        String pwd = "";
        ChannelSftp jSftp = this.connect();
        pwd = jSftp.pwd();
        jSftp.disconnect();
        return pwd;
    }

    public void remove(String path, boolean isDir) throws Exception {
        ChannelSftp jSftp = this.connect();
        path = Utils.pipe(this.context.cfg.getFullPathSubscriber(path));
        path = Utils.unpipe(path, "/");
        if (isDir) {
            jSftp.rmdir(path);
        } else {
            jSftp.rm(path);
        }
        jSftp.disconnect();
    }

    public void rename(String from, String to) throws Exception {
        ChannelSftp jSftp = this.connect();
        from = Utils.pipe(this.context.cfg.getFullPathSubscriber(from));
        from = Utils.unpipe(from, "/");
        to = Utils.pipe(this.context.cfg.getFullPathSubscriber(to));
        to = Utils.unpipe(to, "/");
        jSftp.rename(from, to);
        jSftp.disconnect();
    }

    public void setDate(String dest, long mtime) throws Exception {
        ChannelSftp jSftp = this.connect();
        dest = Utils.pipe(this.context.cfg.getFullPathSubscriber(dest));
        dest = Utils.unpipe(dest, "/");
        jSftp.setMtime(dest, (int)mtime);
        jSftp.disconnect();
    }

    public boolean startClient(String purpose) {
        this.purpose = purpose;
        try {
            this.logger.info(MessageFormat.format(this.context.cfg.gs("Sftp.opening.sftp.connection.to"), purpose) + (this.hostname == null ? "localhost" : this.hostname) + ":" + this.hostport + this.hostListen);
            this.jsch = new JSch();
            this.jSession = this.jsch.getSession(this.user, this.hostname, this.hostport);
            this.jSession.setConfig("StrictHostKeyChecking", "no");
            this.jSession.setPassword(this.password);
            this.jSession.connect(60000);
            this.logger.trace(this.context.cfg.gs("Sftp.client.sftp.timeout.is") + this.jSession.getTimeout());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized SftpATTRS stat(String path) throws Exception {
        ChannelSftp jSftp = this.connect();
        path = Utils.pipe(this.context.cfg.getFullPathSubscriber(path));
        path = Utils.unpipe(path, "/");
        SftpATTRS attrs = jSftp.stat(path);
        jSftp.disconnect();
        return attrs;
    }

    public void stopClient() {
        this.logger.debug(MessageFormat.format(this.context.cfg.gs("Main.disconnecting.sftp"), this.purpose, this.hostname == null ? "localhost" : this.hostname) + this.hostport);
        if (this.jChannel != null) {
            this.jChannel.disconnect();
        }
        if (this.jSession != null) {
            this.jSession.disconnect();
        }
    }

    public void transmitFile(String src, String dest, boolean overwrite) throws Exception {
        String copyDest;
        ChannelSftp jSftp;
        block10: {
            SftpATTRS destAttr = null;
            long readOffset = 0L;
            long writeOffset = 0L;
            src = Utils.getFullPathLocal(src);
            dest = this.context.cfg.getFullPathSubscriber(dest);
            jSftp = this.connect();
            copyDest = Utils.pipe(dest + ".els-part");
            copyDest = Utils.unpipe(copyDest, "/");
            try {
                destAttr = jSftp.stat(copyDest);
                if (destAttr != null && destAttr.isReg() && destAttr.getSize() > 0L && !overwrite) {
                    readOffset = destAttr.getSize();
                    writeOffset = readOffset + 1L;
                }
            }
            catch (SftpException e) {
                String msg = e.toString().trim().toLowerCase();
                if (!msg.contains("nosuchfileexception")) {
                    throw e;
                }
                destAttr = null;
            }
            if (destAttr == null) {
                this.makeDirectory(copyDest);
            }
            int mode = 0;
            if (writeOffset > 0L) {
                mode = 1;
                this.logger.info(this.context.cfg.gs("Sftp.resuming.transfer.at") + writeOffset);
            }
            if (this.context.progress != null) {
                jSftp.put(Utils.getFullPathLocal(src), copyDest, (SftpProgressMonitor)this.context.progress, mode);
            } else {
                jSftp.put(Utils.getFullPathLocal(src), copyDest, mode);
            }
            try {
                dest = Utils.pipe(dest);
                dest = Utils.unpipe(dest, "/");
                jSftp.rm(dest);
            }
            catch (SftpException e) {
                String msg = e.toString().trim().toLowerCase();
                if (msg.contains("nosuchfileexception") || e.getCause().getMessage().contains("interruptedioexception")) break block10;
                throw e;
            }
        }
        jSftp.rename(copyDest, dest);
        jSftp.disconnect();
    }
}

