/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.sftp;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.hints.HintKey;
import com.corionis.els.hints.HintKeys;
import com.corionis.els.repository.Repository;
import com.corionis.els.sftp.EventListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.session.helpers.TimeoutIndicator;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.SftpErrorStatusDataHandler;
import org.apache.sshd.sftp.server.SftpSubsystemEnvironment;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;

public class ServeSftp
implements SftpErrorStatusDataHandler {
    private Context context;
    private String hostListen;
    private String hostname;
    private int listenport;
    private transient Logger logger = LogManager.getLogger("applog");
    private String loginAttemptAddress = "";
    private int loginAttempts = 1;
    private Repository myRepo;
    private String password;
    private SshServer sshd;
    private Repository theirRepo;
    private String user;

    private ServeSftp() {
    }

    public ServeSftp(Context ctxt, Repository mine, Repository theirs, boolean primaryServers) {
        this.context = ctxt;
        this.myRepo = mine;
        this.theirRepo = theirs;
        String address = "";
        if (this.context.cfg.getOverrideSubscriberHost().isEmpty() || this.context.cfg.getOverrideSubscriberHost().trim().equals("true")) {
            address = this.myRepo.getLibraryData().libraries.listen;
            this.hostListen = this.context.cfg.gs("Z.listen");
            if (address == null || address.isEmpty()) {
                address = this.myRepo.getLibraryData().libraries.host;
                this.hostListen = this.context.cfg.gs("Z.host");
            }
        } else {
            address = this.context.cfg.getOverrideSubscriberHost();
            this.hostListen = this.context.cfg.gs("Z.custom");
        }
        this.hostname = Utils.parseHost(address);
        this.listenport = Utils.getPort(address) + (primaryServers ? 1 : 3);
        if (this.theirRepo != null) {
            this.user = this.theirRepo.getLibraryData().libraries.key;
        }
        this.password = this.myRepo.getLibraryData().libraries.key;
    }

    private String getIps() {
        Object ips = "";
        Set<SocketAddress> addrs = this.sshd.getBoundAddresses();
        for (SocketAddress a : addrs) {
            ips = (String)ips + a.toString() + " ";
        }
        return ips;
    }

    @Override
    public String resolveErrorMessage(SftpSubsystemEnvironment sftpSubsystem, int id, Throwable e, int subStatus, int cmd, Object ... args) {
        return e.toString();
    }

    private boolean isListed(SocketAddress socketAddress, boolean whiteList) throws IOException {
        String inet;
        String filename;
        String file;
        boolean sense = whiteList;
        String string = file = whiteList ? this.context.cfg.getIpWhitelist() : this.context.cfg.getBlacklist();
        if (file != null && file.length() > 0 && (filename = Utils.getFullPathLocal(file)).length() > 0 && (inet = socketAddress.toString()) != null) {
            String line;
            sense = false;
            inet = inet.replaceAll("/", "");
            inet = inet.replaceAll("\\\\", "");
            inet = inet.substring(0, inet.lastIndexOf(":"));
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#") || !inet.equals(line)) continue;
                sense = true;
                break;
            }
            br.close();
        }
        return sense;
    }

    @Override
    public int resolveSubStatus(SftpSubsystemEnvironment sftpSubsystem, int id, Throwable e, int cmd, Object ... args) {
        return 1;
    }

    public void startServer() {
        try {
            this.sshd = SshServer.setUpDefaultServer();
            this.sshd.setHost(this.hostname);
            this.sshd.setPort(this.listenport);
            try {
                this.sshd.setPublickeyAuthenticator(new PublickeyAuthenticator(this){

                    @Override
                    public boolean authenticate(String s, PublicKey publicKey, ServerSession serverSession) throws AsyncAuthException {
                        return true;
                    }
                });
            }
            catch (AsyncAuthException aae) {
                this.logger.warn("AsyncAuthException");
            }
            this.sshd.setKeyPairProvider(new SimpleGeneratorHostKeyProvider());
            SftpSubsystemFactory factory = new SftpSubsystemFactory.Builder().withSftpErrorStatusDataHandler(this).build();
            factory.addSftpEventListener(new EventListener());
            this.sshd.setSubsystemFactories(Collections.singletonList(factory));
            this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

                @Override
                public boolean authenticate(String s, String s1, ServerSession serverSession) throws PasswordChangeRequiredException, AsyncAuthException {
                    boolean authenticated = false;
                    boolean ipVerified = false;
                    try {
                        SocketAddress sa = serverSession.getClientAddress();
                        if (ServeSftp.this.isListed(sa, false)) {
                            ServeSftp.this.logger.warn(ServeSftp.this.context.cfg.gs("Comm.blacklisted.ip") + sa.toString().replaceAll("/", "").replaceAll("\\\\", "") + ServeSftp.this.context.cfg.gs("Comm.attempted.login"));
                        } else if (ServeSftp.this.isListed(sa, true)) {
                            ipVerified = true;
                        } else {
                            ServeSftp.this.logger.warn(ServeSftp.this.context.cfg.gs("Comm.not.whitelisted.ip") + sa.toString().replaceAll("/", "").replaceAll("\\\\", "") + ServeSftp.this.context.cfg.gs("Comm.attempted.login"));
                        }
                    }
                    catch (IOException e) {
                        ServeSftp.this.logger.error(Utils.getStackTrace(e));
                    }
                    if (ipVerified) {
                        HintKeys keys;
                        HintKeys hintKeys = keys = ServeSftp.this.context.authKeys != null ? ServeSftp.this.context.authKeys : ServeSftp.this.context.hintKeys;
                        if (keys != null) {
                            HintKey connectedKey = keys.findKey(ServeSftp.this.password);
                            if (connectedKey != null) {
                                authenticated = true;
                                ServeSftp.this.loginAttempts = 1;
                                ServeSftp.this.loginAttemptAddress = "";
                                String them = "";
                                HintKey theirKey = keys.findKey(s);
                                if (theirKey != null) {
                                    them = MessageFormat.format(ServeSftp.this.context.cfg.gs("Z.at"), theirKey.system);
                                }
                                ServeSftp.this.logger.info(ServeSftp.this.context.cfg.gs("Sftp.server.authenticated") + them + serverSession.getClientAddress().toString());
                            }
                        } else if (s.equals(ServeSftp.this.user) && s1.equals(ServeSftp.this.password)) {
                            authenticated = true;
                            ServeSftp.this.loginAttempts = 1;
                            ServeSftp.this.loginAttemptAddress = "";
                            ServeSftp.this.logger.info(ServeSftp.this.context.cfg.gs("Sftp.server.authenticated") + serverSession.getClientAddress().toString());
                        } else {
                            ServeSftp.this.loginAttempts = serverSession.getClientAddress().toString().equals(ServeSftp.this.loginAttemptAddress) ? ++ServeSftp.this.loginAttempts : 1;
                            ServeSftp.this.loginAttemptAddress = serverSession.getClientAddress().toString();
                            ServeSftp.this.logger.warn(MessageFormat.format(ServeSftp.this.context.cfg.gs("Sftp.login.attempt.failed.user"), ServeSftp.this.loginAttempts) + ServeSftp.this.user + "\n/\"" + ServeSftp.this.password + ServeSftp.this.context.cfg.gs("Sftp.from") + String.valueOf(serverSession.getClientAddress()));
                            if (ServeSftp.this.loginAttempts > 3) {
                                try {
                                    Random rand = new Random();
                                    Thread.sleep((long)rand.nextInt(3) * 2000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    return authenticated;
                }
            });
            SessionDisconnectHandler disconnector = new SessionDisconnectHandler(){

                @Override
                public boolean handleTimeoutDisconnectReason(Session session, TimeoutIndicator timeoutStatus) throws IOException {
                    String tor = timeoutStatus.getStatus().toString();
                    ServeSftp.this.logger.fatal(ServeSftp.this.context.cfg.gs("Sftp.session.time.out.ending.session") + tor);
                    ServeSftp.this.context.timeout = true;
                    ServeSftp.this.context.fault = true;
                    return true;
                }
            };
            this.sshd.setSessionDisconnectHandler(disconnector);
            int tout = 0;
            this.logger.trace(this.context.cfg.gs("Sftp.setting.sftp.idle.timeout.to") + tout);
            this.sshd.getProperties().put("idle-timeout", tout);
            Object o = this.sshd.getProperties().get("idle-timeout");
            this.logger.trace(this.context.cfg.gs("Sftp.idle.timeout.is") + o.toString());
            this.sshd.getProperties().put("sftp-auto-follow-links", true);
            this.sshd.start();
            String ips = this.getIps();
            this.logger.info(this.context.cfg.gs("Sftp.server.is.listening.on") + ips.trim() + this.hostListen);
        }
        catch (IOException e) {
            this.context.fault = true;
            e.printStackTrace();
            this.logger.warn(this.context.cfg.gs("Sftp.server.cannot.start.secure.channel"));
        }
    }

    public void stopServer() {
        try {
            if (this.sshd != null) {
                String ips = this.getIps();
                this.logger.debug(this.context.cfg.gs("Sftp.stopping.sftp.server.on") + ips + this.hostListen);
                List<AbstractSession> sessions = this.sshd.getActiveSessions();
                if (sessions != null) {
                    for (AbstractSession session : sessions) {
                        session.close();
                    }
                }
                this.sshd.stop();
                this.sshd = null;
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
        }
    }
}

