/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty.gui;

import com.corionis.els.Configuration;
import com.corionis.els.Context;
import com.corionis.els.repository.Repository;
import com.corionis.els.stty.ClientStty;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TerminalGui
implements WindowListener,
ActionListener {
    Context context;
    Configuration cfg = null;
    JTextField commandField;
    JFrame frame;
    DataInputStream in = null;
    DataOutputStream out = null;
    JScrollPane scroll;
    ClientStty terminal;
    JTextArea textArea;
    private transient Logger logger = LogManager.getLogger("applog");
    private Repository myRepo;
    private Repository theirRepo;

    public TerminalGui(ClientStty clientStty, Context context, DataInputStream in, DataOutputStream out) {
        this.terminal = clientStty;
        this.context = context;
        this.cfg = context.cfg;
        this.in = in;
        this.out = out;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        String response = "";
        this.logger.info(this.context.cfg.gs("Stty.processing.input") + action + " = " + this.commandField.getText());
        try {
            switch (action) {
                case "clear": {
                    this.textArea.setText("");
                    this.frame.revalidate();
                    JScrollBar sb = this.scroll.getVerticalScrollBar();
                    sb.setValue(sb.getMaximum());
                    this.commandField.setText("");
                    this.commandField.grabFocus();
                    this.commandField.requestFocus();
                    break;
                }
                case "command": {
                    String cmd = this.commandField.getText().trim();
                    if (cmd.equalsIgnoreCase("bye") || cmd.equalsIgnoreCase("quit")) {
                        this.send(cmd);
                        this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
                        break;
                    }
                    response = this.roundTrip(cmd);
                    this.frame.revalidate();
                    JScrollBar sb = this.scroll.getVerticalScrollBar();
                    sb.setValue(sb.getMaximum());
                    this.commandField.setText("");
                    this.commandField.grabFocus();
                    this.commandField.requestFocus();
                    break;
                }
                case "exit": {
                    this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
                    break;
                }
                case "reset": {
                    this.commandField.setText("");
                    this.commandField.grabFocus();
                    this.commandField.requestFocus();
                    break;
                }
                case "send": {
                    response = this.roundTrip(this.commandField.getText());
                    this.frame.revalidate();
                    JScrollBar sb = this.scroll.getVerticalScrollBar();
                    sb.setValue(sb.getMaximum());
                    this.commandField.setText("");
                    this.commandField.grabFocus();
                    this.commandField.requestFocus();
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            response = ex.getMessage();
        }
        if (response != null && response.equalsIgnoreCase("End-Execution")) {
            this.logger.info(this.context.cfg.gs("Stty.end.execution.command.received.from.server"));
            this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
        }
    }

    private int build() {
        this.frame = new JFrame(Configuration.getBuildVersionName() + this.context.cfg.gs("Stty.connected.to") + this.theirRepo.getLibraryData().libraries.description);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(1024, 768);
        this.frame.setLocationRelativeTo(null);
        this.frame.addWindowListener(this);
        JMenuBar mb = new JMenuBar();
        JMenu m1 = new JMenu("File");
        mb.add(m1);
        JMenuItem clearButton = new JMenuItem("Clear");
        clearButton.addActionListener(this);
        clearButton.setActionCommand("clear");
        m1.add(clearButton);
        JMenuItem exitButton = new JMenuItem("Exit");
        exitButton.addActionListener(this);
        exitButton.setActionCommand("exit");
        m1.add(exitButton);
        JPanel panel = new JPanel();
        JLabel label = new JLabel("Command: ");
        this.commandField = new JTextField(40);
        this.commandField.setAutoscrolls(true);
        this.commandField.setActionCommand("command");
        this.commandField.addActionListener(this);
        JPanel buttons = new JPanel();
        JButton send = new JButton("Send");
        send.setActionCommand("send");
        send.addActionListener(this);
        JButton reset = new JButton("Reset");
        reset.setActionCommand("reset");
        reset.addActionListener(this);
        buttons.add(send);
        buttons.add(reset);
        panel.add("West", label);
        panel.add("Center", this.commandField);
        panel.add("After", buttons);
        this.textArea = new JTextArea();
        this.textArea.setAutoscrolls(true);
        this.textArea.setBackground(Color.BLACK);
        this.textArea.setForeground(Color.WHITE);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setFont(new Font("monospaced", 0, 12));
        this.scroll = new JScrollPane(this.textArea);
        this.frame.getContentPane().add("North", mb);
        this.frame.getContentPane().add("Center", this.scroll);
        this.frame.getContentPane().add("South", panel);
        return 0;
    }

    public String receive() throws Exception {
        String response = this.context.main.readStream(this.in, this.theirRepo.getLibraryData().libraries.key);
        this.textArea.append(response);
        return response;
    }

    public String roundTrip(String command) throws Exception {
        this.send(command);
        String response = this.receive();
        return response;
    }

    public int run(Repository myRepo, Repository theirRepo) throws Exception {
        int returnValue = 0;
        this.myRepo = myRepo;
        this.theirRepo = theirRepo;
        returnValue = this.build();
        if (returnValue == 0) {
            this.frame.setVisible(true);
            this.receive();
            this.commandField.grabFocus();
            this.commandField.requestFocus();
        }
        return returnValue;
    }

    public int send(String command) throws Exception {
        this.textArea.append(command + "\r\n");
        this.context.main.writeStream(this.out, this.theirRepo.getLibraryData().libraries.key, command);
        return 0;
    }

    public void stop() {
        this.frame.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.commandField.grabFocus();
        this.commandField.requestFocus();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.stop();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.commandField.grabFocus();
        this.commandField.requestFocus();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.commandField.grabFocus();
        this.commandField.requestFocus();
    }
}

