/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.stty.hintServer;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.hints.Hint;
import com.corionis.els.hints.HintKey;
import com.corionis.els.hints.HintKeys;
import com.corionis.els.repository.Repository;
import com.corionis.els.stty.AbstractDaemon;
import com.corionis.els.stty.ServeStty;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Daemon
extends AbstractDaemon {
    protected static Logger logger = LogManager.getLogger("applog");
    private boolean fault = false;
    private boolean isTerminal = false;
    private ServeStty instance = null;

    public Daemon(ServeStty instance, Context context, Repository mine, Repository theirs) {
        super(context, mine, theirs);
        this.instance = instance;
    }

    public synchronized String dumpStatistics() {
        String data = this.context.cfg.gs("Stty.r.nconsole.currently.connected") + (this.connected ? "true" : "false") + "\r\n";
        data = data + this.context.cfg.gs("Stty.connected.on.port") + this.port + "\r\n";
        data = data + this.context.cfg.gs("Stty.connected.to.address") + String.valueOf(this.address) + "\r\n";
        return data;
    }

    private String getNextToken(StringTokenizer t) {
        String value = "";
        if (t.hasMoreTokens() && (value = t.nextToken()).trim().length() == 0 && t.hasMoreTokens()) {
            value = t.nextToken();
        }
        return value;
    }

    @Override
    public String handshake() {
        String system = "";
        try {
            logger.trace(this.context.cfg.gs("Stty.hint.server.listener.handshake"));
            this.send("HELO", "");
            String input = this.receive("", 5000);
            if (input.equals("DribNit") || input.equals("DribNlt")) {
                this.isTerminal = input.equals("DribNit");
                if (this.isTerminal) {
                    this.send("Terminal session not allowed", "");
                    return system;
                }
                this.send(this.myKey, "");
                input = this.receive("", 5000);
                if (this.context.authKeys != null) {
                    HintKey connectedKey = this.context.authKeys.findKey(input);
                    if (connectedKey != null) {
                        this.send(this.myRepo.getLibraryData().libraries.flavor, "");
                        system = connectedKey.system;
                        logger.info(MessageFormat.format(this.context.cfg.gs("Stty.hint.server.authenticated.choice.terminal.automated.session"), this.isTerminal ? 0 : 1) + system);
                        this.context.fault = false;
                        this.context.timeout = false;
                    } else {
                        logger.error(this.context.cfg.gs("Stty.hint.server.cannot.find.key") + input);
                    }
                } else if (this.theirRepo != null && input.equals(this.theirRepo.getLibraryData().libraries.key)) {
                    this.send(this.myRepo.getLibraryData().libraries.flavor, "");
                    system = this.theirRepo.getLibraryData().libraries.description;
                    logger.info(MessageFormat.format(this.context.cfg.gs("Stty.hint.server.authenticated.choice.terminal.automated.session"), this.isTerminal ? 0 : 1) + system);
                    this.context.fault = false;
                    this.context.timeout = false;
                }
            }
        }
        catch (Exception e) {
            this.fault = true;
            logger.error(e.getMessage());
        }
        return system;
    }

    @Override
    public int process() throws Exception {
        String basePrompt;
        int commandCount = 0;
        String prompt = basePrompt = ": ";
        try {
            if (this.context.cfg.getAuthKeysFile().length() > 0) {
                this.context.authKeys = new HintKeys(this.context);
                this.context.authKeys.read(this.context.cfg.getAuthKeysFile());
            }
        }
        catch (Exception e) {
            this.context.fault = true;
            throw e;
        }
        this.port = this.getSocket().getPort();
        this.address = this.getSocket().getInetAddress();
        this.getSocket().setKeepAlive(true);
        this.in = new DataInputStream(this.getSocket().getInputStream());
        this.out = new DataOutputStream(this.getSocket().getOutputStream());
        this.connected = true;
        String system = this.handshake();
        if (system.length() == 0) {
            if (!this.context.cfg.isKeepGoing()) {
                this.status = 1;
            }
            logger.error(MessageFormat.format(this.context.cfg.gs("Stty.connection.to.failed.handshake"), Utils.formatAddresses(this.socket)));
        } else {
            this.response = this.isTerminal ? this.context.cfg.gs("Stty.enter.help.for.information.r.n") : "CMD";
            Gson gsonBuilder = new GsonBuilder().create();
            Gson gsonParser = new Gson();
            boolean isPing = false;
            while (this.status == 0) {
                try {
                    if (this.context.fault || this.context.timeout) {
                        this.fault = true;
                        this.status = 1;
                        logger.warn(this.context.cfg.gs("Stty.process.fault.ending.stty"));
                        break;
                    }
                    if (!isPing) {
                        String log = this.context.cfg.getDebugLevel().trim().equalsIgnoreCase("trace") ? "writing response " + this.response.length() + " bytes to " + system : "";
                        this.send(this.response + (this.isTerminal ? prompt : ""), log);
                    }
                    this.response = "";
                    String line = this.readStream(this.in, this.myKey);
                    if (line == null) {
                        if (!this.context.cfg.isKeepGoing()) {
                            this.fault = true;
                            this.status = 2;
                            logger.warn(this.context.cfg.gs("Stty.eof.line.process.ended.prematurely"));
                            break;
                        }
                        logger.info(this.context.cfg.gs("Stty.eof.line.listener.keep.going.enabled"));
                        break;
                    }
                    isPing = false;
                    if (line.startsWith("ping")) {
                        isPing = true;
                        logger.trace(this.context.cfg.gs("Stty.heartbeat.received") + system);
                        continue;
                    }
                    if ((line = line.trim()).length() < 1) {
                        this.response = "\r";
                        continue;
                    }
                    ++commandCount;
                    logger.info(MessageFormat.format(this.context.cfg.gs("Stty.processing.command.from"), line) + system);
                    StringTokenizer t = new StringTokenizer(line, "\"");
                    if (!t.hasMoreTokens()) continue;
                    String theCommand = t.nextToken().trim();
                    if (theCommand.equalsIgnoreCase("logout")) {
                        if (this.authorized) {
                            this.authorized = false;
                            prompt = basePrompt;
                            continue;
                        }
                        theCommand = this.context.cfg.isKeepGoing() ? "bye" : "quit";
                    }
                    if (theCommand.equalsIgnoreCase("bye")) {
                        this.out.flush();
                        Thread.sleep(1500L);
                        break;
                    }
                    if (theCommand.equalsIgnoreCase("conflict")) {
                        String json;
                        String itemPath;
                        String lib;
                        ArrayList<Hint> results;
                        boolean valid = false;
                        if (t.hasMoreTokens() && (results = this.context.hintsHandler.checkConflicts(lib = this.getNextToken(t), itemPath = this.getNextToken(t))) != null && results.size() > 0 && (json = gsonBuilder.toJson(results)) != null && json.length() > 0) {
                            valid = true;
                            this.response = json;
                        }
                        if (valid) continue;
                        this.response = "false";
                        continue;
                    }
                    if (theCommand.equalsIgnoreCase("count")) {
                        boolean valid = false;
                        if (t.hasMoreTokens()) {
                            String who = this.getNextToken(t);
                            int count = this.context.datastore.count(who);
                            this.response = Integer.toString(count);
                            valid = true;
                        }
                        if (valid) continue;
                        this.response = "false";
                        continue;
                    }
                    if (theCommand.equalsIgnoreCase("directory")) {
                        this.response = this.context.cfg.getWorkingDirectory();
                        continue;
                    }
                    if (theCommand.equalsIgnoreCase("get")) {
                        String json = "";
                        boolean valid = false;
                        if (t.hasMoreTokens()) {
                            String mode = this.getNextToken(t);
                            if (mode.toLowerCase().equals("all")) {
                                ArrayList<Hint> hints = this.context.datastore.getAll(null, mode);
                                if (hints != null) {
                                    json = gsonBuilder.toJson(hints);
                                }
                            } else if (mode.toLowerCase().equals("for")) {
                                String hintSystemName;
                                ArrayList<Hint> results;
                                if (t.hasMoreTokens() && (results = this.context.datastore.getFor(hintSystemName = this.getNextToken(t))) != null) {
                                    json = gsonBuilder.toJson(results);
                                }
                            } else {
                                int start = 4 + mode.length() + 2;
                                if (line.length() > start) {
                                    json = line.substring(start);
                                    Hint hint = gsonParser.fromJson(json, Hint.class);
                                    json = (hint = this.context.datastore.get(hint, mode)) != null ? gsonBuilder.toJson(hint) : null;
                                }
                            }
                            if (json != null && json.length() > 0) {
                                valid = true;
                                this.response = json;
                            }
                        }
                        if (valid) continue;
                        this.response = "false";
                        continue;
                    }
                    if (theCommand.equalsIgnoreCase("hint")) {
                        boolean valid = false;
                        if (t.hasMoreTokens() && line.length() > 7) {
                            String json = line.substring(7);
                            Hint hint = gsonParser.fromJson(json, Hint.class);
                            this.context.hintsHandler.writeOrUpdateHint(hint, null);
                            valid = true;
                            this.response = "true";
                            logger.info(this.context.cfg.gs("Stty.hint.updated") + hint.getLocalUtc(this.context));
                        }
                        if (valid) continue;
                        this.response = "false";
                        continue;
                    }
                    if (theCommand.equalsIgnoreCase("quit") || theCommand.equalsIgnoreCase("exit")) {
                        this.out.flush();
                        Thread.sleep(1500L);
                        if (this.context.cfg.isKeepGoing()) {
                            logger.info(this.context.cfg.gs("Stty.ignoring.quit.command.listener.keep.going.enabled"));
                            break;
                        }
                        this.status = 1;
                        break;
                    }
                    if (theCommand.equalsIgnoreCase("save")) {
                        boolean valid = false;
                        if (t.hasMoreTokens() && line.length() > 7) {
                            String json = line.substring(7);
                            Type listType = new TypeToken<ArrayList<Hint>>(){}.getType();
                            this.context.datastore.hints = (List)gsonParser.fromJson(json, listType);
                            this.context.datastore.write();
                            valid = true;
                            this.response = "true";
                            logger.info(this.context.cfg.gs("Stty.all.hints.saved"));
                        }
                        if (valid) continue;
                        this.response = "false";
                        continue;
                    }
                    if (theCommand.equalsIgnoreCase("stop")) {
                        this.out.flush();
                        Thread.sleep(1500L);
                        this.status = 2;
                        break;
                    }
                    this.response = this.context.cfg.gs("Stty.r.nunknown.command") + theCommand + "'\r\n";
                }
                catch (SocketTimeoutException toe) {
                    this.context.timeout = true;
                    this.fault = true;
                    this.connected = false;
                    this.status = 1;
                    logger.error(this.context.cfg.gs("Stty.sockettimeoutexception") + Utils.getStackTrace(toe));
                    break;
                }
                catch (SocketException se) {
                    if (se.toString().contains("timed out")) {
                        this.context.timeout = true;
                    }
                    this.fault = true;
                    this.connected = false;
                    this.status = 1;
                    logger.debug(this.context.cfg.gs("Stty.socketexception.timeout.is") + this.context.timeout);
                    logger.error(Utils.getStackTrace(se));
                    break;
                }
                catch (Exception e) {
                    this.fault = true;
                    this.connected = false;
                    this.status = 1;
                    logger.error(Utils.getStackTrace(e));
                    try {
                        if (this.context.timeout) break;
                        this.send(e.getMessage(), this.context.cfg.gs("Stty.hint.server.exception"));
                        Thread.sleep(1500L);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        if (this.fault) {
            this.context.fault = true;
        }
        String statMsg = this.status == 0 ? "Success" : (this.status == 1 ? "Quit" : "Stop");
        logger.trace(this.context.cfg.gs("Stty.hint.server.session.done.status") + statMsg + ", fault = " + this.context.fault);
        return this.status;
    }

    public String readStream(DataInputStream in, String key) throws Exception {
        byte[] buf = new byte[]{};
        String input = "";
        while (true) {
            try {
                int readCount;
                int count = in.readInt();
                int pos = 0;
                if (count <= 0) break;
                buf = new byte[count];
                int remaining = count;
                while ((readCount = in.read(buf, pos, remaining)) >= 0) {
                    remaining -= readCount;
                    if ((pos += readCount) != count) continue;
                    break;
                }
                if (pos == count) break;
                logger.warn(MessageFormat.format(this.context.cfg.gs("Stty.read.counts.do.not.match.expected.received"), count, pos));
            }
            catch (SocketTimeoutException e) {
                continue;
            }
            catch (EOFException e) {
                input = null;
            }
            catch (IOException e) {
                if (e.getMessage().toLowerCase().contains("connection reset")) {
                    logger.warn(this.context.cfg.gs("Stty.connection.closed.by.client"));
                    input = null;
                    break;
                }
                throw e;
            }
            break;
        }
        if (buf.length > 0) {
            input = this.context.main.decrypt(key, buf);
        }
        return input;
    }

    @Override
    public void requestStop() {
        this.status = 1;
        logger.debug(this.context.cfg.gs("Stty.requesting.stop.for.stty.session") + Utils.formatAddresses(this.socket));
    }
}

