/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools;

import com.corionis.els.Context;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.archiver.ArchiverTool;
import com.corionis.els.tools.cleanup.CleanupTool;
import com.corionis.els.tools.email.EmailTool;
import com.corionis.els.tools.junkremover.JunkRemoverTool;
import com.corionis.els.tools.operations.OperationsTool;
import com.corionis.els.tools.renamer.RenamerTool;
import com.corionis.els.tools.sleep.SleepTool;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;

public class Tools {
    private ArrayList<AbstractTool> toolList = null;

    public AbstractTool getTool(String internalName, String configName) {
        for (int i = 0; i < this.toolList.size(); ++i) {
            AbstractTool tool = this.toolList.get(i);
            if (!tool.getInternalName().equals(internalName) || !tool.getConfigName().equals(configName)) continue;
            return tool;
        }
        return null;
    }

    public Object clone() {
        Tools clone = new Tools();
        clone.toolList = (ArrayList)this.toolList.clone();
        return clone;
    }

    public AbstractTool loadTool(Context context, String internalName, String configName) throws Exception {
        AbstractTool tool;
        block8: {
            SleepTool tmpTool;
            File toolDir;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    tool = null;
                                    if (!internalName.equals("Archiver")) break block9;
                                    ArchiverTool tmpTool2 = new ArchiverTool(context);
                                    File toolDir2 = new File(tmpTool2.getDirectoryPath());
                                    if (!toolDir2.exists() || !toolDir2.isDirectory()) break block8;
                                    ArchiverParser ArchiverParser2 = new ArchiverParser(this);
                                    DirectoryStream<Path> directoryStream = Files.newDirectoryStream(toolDir2.toPath());
                                    for (Path entry : directoryStream) {
                                        AbstractTool but;
                                        String json;
                                        boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                                        if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (but = ArchiverParser2.parseTool(context, json)) == null || !but.getConfigName().equalsIgnoreCase(configName)) continue;
                                        tool = but;
                                        break block8;
                                    }
                                    break block8;
                                }
                                if (!internalName.equals("Cleanup")) break block10;
                                CleanupTool tmpTool3 = new CleanupTool(context);
                                File toolDir3 = new File(tmpTool3.getDirectoryPath());
                                if (!toolDir3.exists() || !toolDir3.isDirectory()) break block8;
                                CleanupParser CleanupParser2 = new CleanupParser(this);
                                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(toolDir3.toPath());
                                for (Path entry : directoryStream) {
                                    AbstractTool but;
                                    String json;
                                    boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                                    if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (but = CleanupParser2.parseTool(context, json)) == null || !but.getConfigName().equalsIgnoreCase(configName)) continue;
                                    tool = but;
                                    break block8;
                                }
                                break block8;
                            }
                            if (!internalName.equals("Email")) break block11;
                            EmailTool tmpTool4 = new EmailTool(context);
                            File toolDir4 = new File(tmpTool4.getDirectoryPath());
                            if (!toolDir4.exists() || !toolDir4.isDirectory()) break block8;
                            EmailParser emailParser = new EmailParser(this);
                            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(toolDir4.toPath());
                            for (Path entry : directoryStream) {
                                AbstractTool but;
                                String json;
                                boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                                if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (but = emailParser.parseTool(context, json)) == null || !but.getConfigName().equalsIgnoreCase(configName)) continue;
                                tool = but;
                                break block8;
                            }
                            break block8;
                        }
                        if (!internalName.equals("Operations")) break block12;
                        OperationsTool tmpTool5 = new OperationsTool(context);
                        File toolDir5 = new File(tmpTool5.getDirectoryPath());
                        if (!toolDir5.exists() || !toolDir5.isDirectory()) break block8;
                        OperationParser operationParser = new OperationParser(this);
                        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(toolDir5.toPath());
                        for (Path entry : directoryStream) {
                            AbstractTool but;
                            String json;
                            boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                            if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (but = operationParser.parseTool(context, json)) == null || !but.getConfigName().equalsIgnoreCase(configName)) continue;
                            tool = but;
                            break block8;
                        }
                        break block8;
                    }
                    if (!internalName.equals("JunkRemover")) break block13;
                    JunkRemoverTool tmpTool6 = new JunkRemoverTool(context);
                    File toolDir6 = new File(tmpTool6.getDirectoryPath());
                    if (!toolDir6.exists() || !toolDir6.isDirectory()) break block8;
                    JunkRemoverParser junkRemoverParser = new JunkRemoverParser(this);
                    DirectoryStream<Path> directoryStream = Files.newDirectoryStream(toolDir6.toPath());
                    for (Path entry : directoryStream) {
                        AbstractTool jrt;
                        String json;
                        boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                        if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (jrt = junkRemoverParser.parseTool(context, json)) == null || !jrt.getConfigName().equalsIgnoreCase(configName)) continue;
                        tool = jrt;
                        break block8;
                    }
                    break block8;
                }
                if (!internalName.equals("Renamer")) break block14;
                RenamerTool tmpTool7 = new RenamerTool(context);
                File toolDir7 = new File(tmpTool7.getDirectoryPath());
                if (!toolDir7.exists() || !toolDir7.isDirectory()) break block8;
                RenamerParser renamerParser = new RenamerParser(this);
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(toolDir7.toPath());
                for (Path entry : directoryStream) {
                    AbstractTool jrt;
                    String json;
                    boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                    if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (jrt = renamerParser.parseTool(context, json)) == null || !jrt.getConfigName().equalsIgnoreCase(configName)) continue;
                    tool = jrt;
                    break block8;
                }
                break block8;
            }
            if (internalName.equals("Sleep") && (toolDir = new File((tmpTool = new SleepTool(context)).getDirectoryPath())).exists() && toolDir.isDirectory()) {
                SleepParser sleepParser = new SleepParser(this);
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(toolDir.toPath());
                for (Path entry : directoryStream) {
                    AbstractTool slp;
                    String json;
                    boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                    if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (slp = sleepParser.parseTool(context, json)) == null || !slp.getConfigName().equalsIgnoreCase(configName)) continue;
                    tool = slp;
                    break;
                }
            }
        }
        return tool;
    }

    public ArrayList<AbstractTool> loadAllTools(Context context, String internalName) throws Exception {
        this.toolList = new ArrayList();
        return this.loadAllTools(context, internalName, this.toolList);
    }

    public ArrayList<AbstractTool> loadAllTools(Context context, String internalName, ArrayList<AbstractTool> toolObjects) throws Exception {
        if (internalName != null && internalName.length() == 0) {
            internalName = null;
        }
        File toolDir = null;
        ToolParserI toolParser = null;
        if (this.toolList != toolObjects) {
            this.toolList = new ArrayList();
        }
        if (internalName == null || internalName.equals("Archiver")) {
            toolParser = new ArchiverParser(this);
            ArchiverTool tmpArchiver = new ArchiverTool(context);
            toolDir = new File(tmpArchiver.getDirectoryPath());
            this.toolList = this.scanTools(context, this.toolList, toolParser, toolDir);
        }
        if (internalName == null || internalName.equals("Cleanup")) {
            toolParser = new CleanupParser(this);
            CleanupTool tmpCleanup = new CleanupTool(context);
            toolDir = new File(tmpCleanup.getDirectoryPath());
            this.toolList = this.scanTools(context, this.toolList, toolParser, toolDir);
        }
        if (internalName != null && internalName.equals("Email")) {
            toolParser = new EmailParser(this);
            EmailTool tmpEmail = new EmailTool(context);
            toolDir = new File(tmpEmail.getDirectoryPath());
            this.toolList = this.scanTools(context, this.toolList, toolParser, toolDir);
        }
        if (internalName == null || internalName.equals("Operations")) {
            toolParser = new OperationParser(this);
            OperationsTool tmpOperation = new OperationsTool(context);
            toolDir = new File(tmpOperation.getDirectoryPath());
            this.toolList = this.scanTools(context, this.toolList, toolParser, toolDir);
        }
        if (internalName == null || internalName.equals("JunkRemover")) {
            toolParser = new JunkRemoverParser(this);
            JunkRemoverTool tmpJrt = new JunkRemoverTool(context);
            toolDir = new File(tmpJrt.getDirectoryPath());
            this.toolList = this.scanTools(context, this.toolList, toolParser, toolDir);
        }
        if (internalName == null || internalName.equals("Renamer")) {
            toolParser = new RenamerParser(this);
            RenamerTool tmpRenamer = new RenamerTool(context);
            toolDir = new File(tmpRenamer.getDirectoryPath());
            this.toolList = this.scanTools(context, this.toolList, toolParser, toolDir);
        }
        if (internalName == null || internalName.equals("Sleep")) {
            toolParser = new SleepParser(this);
            SleepTool tmpSleep = new SleepTool(context);
            toolDir = new File(tmpSleep.getDirectoryPath());
            this.toolList = this.scanTools(context, this.toolList, toolParser, toolDir);
        }
        Collections.sort(this.toolList);
        if (toolObjects != null && this.toolList != toolObjects) {
            for (AbstractTool tool : this.toolList) {
                toolObjects.add(tool);
            }
            return toolObjects;
        }
        return this.toolList;
    }

    public AbstractTool makeTempTool(String internalName, Context context) {
        AbstractTool tmpTool = null;
        if (internalName.equals("Archiver")) {
            tmpTool = new ArchiverTool(context);
        } else if (internalName.equals("Cleanup")) {
            tmpTool = new CleanupTool(context);
        } else if (internalName.equals("Email")) {
            tmpTool = new EmailTool(context);
        } else if (internalName.equals("Operations")) {
            tmpTool = new OperationsTool(context);
        } else if (internalName.equals("JunkRemover")) {
            tmpTool = new JunkRemoverTool(context);
        } else if (internalName.equals("Renamer")) {
            tmpTool = new RenamerTool(context);
        } else if (internalName.equals("Sleep")) {
            tmpTool = new SleepTool(context);
        }
        return tmpTool;
    }

    private ArrayList<AbstractTool> scanTools(Context context, ArrayList<AbstractTool> toolList, ToolParserI parser, File toolDir) throws Exception {
        if (toolDir.exists() && toolDir.isDirectory()) {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(toolDir.toPath());
            for (Path entry : directoryStream) {
                AbstractTool tool;
                String json;
                boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                if (isDir || (json = new String(Files.readAllBytes(Paths.get(entry.toString(), new String[0])))) == null || (tool = parser.parseTool(context, json)) == null) continue;
                toolList.add(tool);
            }
        }
        return toolList;
    }

    private class ArchiverParser
    implements ToolParserI {
        private ArchiverParser(Tools tools) {
        }

        @Override
        public AbstractTool parseTool(final Context context, String json) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new ArchiverTool(context);
                }
            }
            builder.registerTypeAdapter((Type)((Object)ArchiverTool.class), new ObjInstanceCreator());
            ArchiverTool tool = builder.create().fromJson(json, ArchiverTool.class);
            return tool;
        }
    }

    private class CleanupParser
    implements ToolParserI {
        private CleanupParser(Tools tools) {
        }

        @Override
        public AbstractTool parseTool(final Context context, String json) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new CleanupTool(context);
                }
            }
            builder.registerTypeAdapter((Type)((Object)CleanupTool.class), new ObjInstanceCreator());
            CleanupTool tool = builder.create().fromJson(json, CleanupTool.class);
            return tool;
        }
    }

    private class EmailParser
    implements ToolParserI {
        private EmailParser(Tools tools) {
        }

        @Override
        public AbstractTool parseTool(final Context context, String json) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new EmailTool(context);
                }
            }
            builder.registerTypeAdapter((Type)((Object)EmailTool.class), new ObjInstanceCreator());
            EmailTool tool = builder.create().fromJson(json, EmailTool.class);
            return tool;
        }
    }

    private class OperationParser
    implements ToolParserI {
        private OperationParser(Tools tools) {
        }

        @Override
        public AbstractTool parseTool(final Context context, String json) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new OperationsTool(context);
                }
            }
            builder.registerTypeAdapter((Type)((Object)OperationsTool.class), new ObjInstanceCreator());
            OperationsTool tool = builder.create().fromJson(json, OperationsTool.class);
            return tool;
        }
    }

    private class JunkRemoverParser
    implements ToolParserI {
        private JunkRemoverParser(Tools tools) {
        }

        @Override
        public AbstractTool parseTool(final Context context, String json) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new JunkRemoverTool(context);
                }
            }
            builder.registerTypeAdapter((Type)((Object)JunkRemoverTool.class), new ObjInstanceCreator());
            JunkRemoverTool tool = builder.create().fromJson(json, JunkRemoverTool.class);
            return tool;
        }
    }

    private class RenamerParser
    implements ToolParserI {
        private RenamerParser(Tools tools) {
        }

        @Override
        public AbstractTool parseTool(final Context context, String json) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new RenamerTool(context);
                }
            }
            builder.registerTypeAdapter((Type)((Object)RenamerTool.class), new ObjInstanceCreator());
            RenamerTool tool = builder.create().fromJson(json, RenamerTool.class);
            return tool;
        }
    }

    private class SleepParser
    implements ToolParserI {
        private SleepParser(Tools tools) {
        }

        @Override
        public AbstractTool parseTool(final Context context, String json) {
            GsonBuilder builder = new GsonBuilder();
            class ObjInstanceCreator
            implements InstanceCreator {
                ObjInstanceCreator() {
                }

                public Object createInstance(Type type) {
                    return new SleepTool(context);
                }
            }
            builder.registerTypeAdapter((Type)((Object)SleepTool.class), new ObjInstanceCreator());
            SleepTool tool = builder.create().fromJson(json, SleepTool.class);
            return tool;
        }
    }

    private static interface ToolParserI {
        public AbstractTool parseTool(Context var1, String var2);
    }
}

