/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools.cleanup;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Persistent;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Task;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanupTool
extends AbstractTool {
    private String configName;
    public static final String INTERNAL_NAME = "Cleanup";
    public static final String SUBSYSTEM = "tools";
    private final String internalName = "Cleanup";
    private int age = 0;
    private transient int deleteCount = 0;
    private transient ArrayList<String> filesToDelete = null;
    private transient Logger logger = LogManager.getLogger("applog");
    private transient long compareUtc = 0L;
    private transient Repository pubRepo = null;
    private transient ArrayList<String> toolPaths;

    public CleanupTool(Context context) {
        super(context);
        this.setDisplayName(this.getCfg().gs("Cleanup.displayName"));
        this.context = context;
        this.dataHasChanged = false;
    }

    @Override
    public CleanupTool clone() {
        assert (this.context != null);
        CleanupTool tool = new CleanupTool(this.context);
        tool.setConfigName(this.getConfigName());
        tool.setDisplayName(this.getDisplayName());
        tool.setAge(this.getAge());
        tool.setDataHasChanged();
        tool.setRemote(this.isRemote());
        return tool;
    }

    private void deleteFiles() {
        Object msg = "";
        for (String path : this.filesToDelete) {
            File file = new File(path);
            if (!file.exists() || !this.isOutOfDate(file)) continue;
            file.delete();
            msg = "  - " + this.context.cfg.gs("Z.deleted") + path;
            this.logger.info((String)msg);
            ++this.deleteCount;
        }
    }

    private void expandOrigins(ArrayList<Origin> origins) throws MungeException {
        if (this.pubRepo == null) {
            return;
        }
        for (Origin origin : origins) {
            if (origin.getType() == 1) {
                if (origin.getLocation().length() > 0 && !this.pubRepo.getLibraryData().libraries.description.equalsIgnoreCase(origin.getLocation())) {
                    throw new MungeException(this.context.cfg.gs("Cleanup.task.definition.and.loaded.repository.do.not.match"));
                }
                for (Library lib : this.pubRepo.getLibraryData().libraries.bibliography) {
                    Collections.addAll(this.toolPaths, lib.sources);
                }
                continue;
            }
            if (origin.getType() == 5) {
                for (Library lib : this.pubRepo.getLibraryData().libraries.bibliography) {
                    if (!lib.name.equalsIgnoreCase(origin.getLocation())) continue;
                    Collections.addAll(this.toolPaths, lib.sources);
                }
                continue;
            }
            if (origin.getType() != 6) continue;
            this.toolPaths.add(origin.getLocation());
        }
    }

    public int getAge() {
        return this.age;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getInternalName() {
        return INTERNAL_NAME;
    }

    @Override
    public String getSubsystem() {
        return SUBSYSTEM;
    }

    @Override
    public boolean isDataChanged() {
        return this.dataHasChanged;
    }

    @Override
    public boolean isToolOriginsUsed() {
        return true;
    }

    @Override
    public boolean isToolPublisher() {
        return false;
    }

    @Override
    public boolean isToolSubscriber() {
        return false;
    }

    @Override
    public void processTool(Task task) throws Exception {
        this.reset();
        if (this.pubRepo == null) {
            this.pubRepo = this.context.publisherRepo;
        }
        if (this.pubRepo == null) {
            this.pubRepo = Persistent.lastPublisherRepo;
        }
        if (this.pubRepo == null) {
            this.logger.error(MessageFormat.format(this.context.cfg.gs("Cleanup.has.no.repository.defined"), this.getConfigName()));
            return;
        }
        this.compareUtc = Instant.now().toEpochMilli();
        this.compareUtc -= (long)this.getAge() * 86400000L;
        this.expandOrigins(task.origins);
        if (this.toolPaths == null || this.toolPaths.size() == 0) {
            return;
        }
        for (String path : this.toolPaths) {
            if (this.isRequestStop()) break;
            this.logger.info(this.getDisplayName() + ", " + this.getConfigName() + ": " + path);
            this.scanForFiles(path);
        }
        if (!this.filesToDelete.isEmpty()) {
            this.deleteFiles();
            String msg = this.getDisplayName() + ", " + this.getConfigName() + this.context.cfg.gs("Cleanup.deleted") + this.deleteCount;
            this.logger.info(msg);
            if (this.context != null && this.context.cfg.isNavigator() && !this.context.cfg.isLoggerView()) {
                if (this.context.navigator.dialogCleanup != null && this.context.navigator.dialogCleanup.isShowing()) {
                    this.context.navigator.dialogCleanup.labelStatus.setText(msg);
                }
                if (this.deleteCount > 0) {
                    this.context.browser.loadCollectionTree(this.context.mainFrame.treeCollectionOne, this.context.publisherRepo, false);
                    this.context.browser.loadSystemTree(this.context.mainFrame.treeSystemOne, this.context.publisherRepo, false);
                }
            }
        } else {
            this.logger.warn(this.context.cfg.gs("Cleanup.no.files.found.to.compress"));
        }
    }

    private boolean isOutOfDate(File file) {
        long mod = file.lastModified();
        return mod < this.compareUtc;
    }

    public void reset() {
        this.deleteCount = 0;
        this.resetStop();
        this.toolPaths = new ArrayList();
        this.filesToDelete = new ArrayList();
        if (this.logger == null) {
            this.logger = LogManager.getLogger("applog");
        }
    }

    private boolean scanForFiles(String path) {
        boolean hadError;
        block6: {
            hadError = false;
            try {
                File file = new File(Utils.getFullPathLocal(path));
                if (!file.isDirectory()) {
                    this.filesToDelete.add(Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), file.getAbsoluteFile().toString()));
                    return true;
                }
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(path, new String[0]));
                for (Path entry : directoryStream) {
                    if (!this.isRequestStop()) {
                        String filename = entry.toAbsolutePath().toString();
                        boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
                        if (isDir) {
                            this.scanForFiles(filename);
                            continue;
                        }
                        this.filesToDelete.add(Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), filename));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                int reply;
                hadError = true;
                String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                this.logger.error(msg);
                if (this.context == null) break block6;
                msg = this.context.cfg.gs("Z.exception") + " " + e.getMessage();
                if (this.context.navigator == null || (reply = JOptionPane.showConfirmDialog(this.context.navigator.dialogCleanup, msg, this.context.cfg.gs("CleanupUI.title"), 0)) != 0) break block6;
                this.requestStop();
            }
        }
        return hadError;
    }

    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void write() throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            File f = new File(this.getFullPath());
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(this.getFullPath());
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.getCfg().gs("Z.error.writing") + this.getFullPath() + ": " + Utils.getStackTrace(fnf));
        }
    }
}

