/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools.junkremover;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Origin;
import com.corionis.els.jobs.Task;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Repository;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JunkRemoverTool
extends AbstractTool {
    public static final String INTERNAL_NAME = "JunkRemover";
    public static final String SUBSYSTEM = "tools";
    private String configName;
    private String internalName = "JunkRemover";
    private ArrayList<JunkItem> junkList;
    private transient int deleteCount = 0;
    private transient boolean isDryRun = false;
    private transient Logger logger = LogManager.getLogger("applog");
    private transient Repository repo;
    private transient ArrayList<String> toolPaths;

    public JunkRemoverTool(Context context) {
        super(context);
        this.setDisplayName(this.getCfg().gs("JunkRemover.displayName"));
        this.context = context;
        this.junkList = new ArrayList();
        this.dataHasChanged = false;
    }

    public JunkItem addJunkItem() {
        JunkItem ji = new JunkItem();
        this.junkList.add(ji);
        this.setDataHasChanged();
        return ji;
    }

    @Override
    public JunkRemoverTool clone() {
        assert (this.context != null);
        JunkRemoverTool jrt = new JunkRemoverTool(this.context);
        jrt.setConfigName(this.getConfigName());
        jrt.setDisplayName(this.getDisplayName());
        jrt.setDataHasChanged();
        jrt.isDryRun = this.isDryRun;
        jrt.setRemote(this.isRemote());
        jrt.setJunkList(this.getJunkList());
        return jrt;
    }

    private int expandOrigins(ArrayList<Origin> origins) throws MungeException {
        int count = 0;
        if (this.repo == null) {
            return -1;
        }
        for (Origin origin : origins) {
            if (origin.getType() == 1) {
                if (origin.getLocation().length() > 0 && !this.repo.getLibraryData().libraries.description.equalsIgnoreCase(origin.getLocation())) {
                    throw new MungeException(this.context.cfg.gs("JunkRemover.task.definition.and.loaded.repository.do.not.match"));
                }
                for (Library lib : this.repo.getLibraryData().libraries.bibliography) {
                    for (String source : lib.sources) {
                        this.toolPaths.add(source);
                        ++count;
                    }
                }
                continue;
            }
            if (origin.getType() == 5) {
                for (Library lib : this.repo.getLibraryData().libraries.bibliography) {
                    if (!lib.name.equalsIgnoreCase(origin.getLocation())) continue;
                    for (String source : lib.sources) {
                        this.toolPaths.add(source);
                        ++count;
                    }
                }
                continue;
            }
            if (origin.getType() != 6) continue;
            this.toolPaths.add(origin.getLocation());
            ++count;
        }
        return count;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public ArrayList<JunkItem> getJunkList() {
        return this.junkList;
    }

    @Override
    public String getSubsystem() {
        return SUBSYSTEM;
    }

    @Override
    public boolean isDataChanged() {
        return this.dataHasChanged;
    }

    @Override
    public boolean isToolOriginsUsed() {
        return true;
    }

    @Override
    public boolean isToolPubOrSub() {
        return true;
    }

    @Override
    public boolean isToolSubscriber() {
        return false;
    }

    private void logDeletion(String fullpath) {
        Object msg = "";
        msg = !this.isDryRun ? "  - " + this.context.cfg.gs("Z.deleted") + fullpath : "  > " + this.context.cfg.gs("Z.would.delete") + fullpath;
        this.logger.info((String)msg);
    }

    private boolean match(String filename, String fullpath, JunkItem junk) {
        boolean isMatch = FilenameUtils.wildcardMatch(filename, junk.wildcard, junk.caseSensitive ? IOCase.SENSITIVE : IOCase.INSENSITIVE);
        return isMatch;
    }

    @Override
    public void processTool(Task task) throws Exception {
        this.reset();
        this.isDryRun = task.dryRun;
        if (task.publisherRepo != null && task.subscriberRepo != null) {
            throw new MungeException(MessageFormat.format(this.context.cfg.gs("JunkRemover.uses.only.one.repository"), this.getInternalName()));
        }
        Repository repository = this.repo = task.publisherRepo != null ? task.publisherRepo : task.subscriberRepo;
        if (this.repo == null) {
            this.logger.error(MessageFormat.format(this.context.cfg.gs("Renamer.has.no.repository.defined"), this.getConfigName()));
            return;
        }
        int count = this.expandOrigins(task.origins);
        if (this.toolPaths == null || this.toolPaths.size() == 0) {
            return;
        }
        if (task.subscriberRepo != null && this.getCfg().isRemoteOperation()) {
            this.setRemote(true);
        }
        for (String path : this.toolPaths) {
            if (this.isRequestStop()) break;
            String rem = this.isRemote() ? this.context.cfg.gs("Z.remote.uppercase") : "";
            this.logger.info(this.getDisplayName() + ", " + this.getConfigName() + ": " + rem + path);
            this.scanForJunk(path);
        }
        this.logger.info(this.getDisplayName() + ", " + this.getConfigName() + ": " + this.deleteCount + (this.isDryRun ? " (dry-run)" : ""));
        if (this.context != null && this.context.cfg.isNavigator() && !this.context.cfg.isLoggerView() && !this.isDryRun && this.deleteCount > 0) {
            if (!this.repo.isSubscriber()) {
                this.context.browser.loadCollectionTree(this.context.mainFrame.treeCollectionOne, this.context.publisherRepo, false);
                this.context.browser.loadSystemTree(this.context.mainFrame.treeSystemOne, this.context.publisherRepo, false);
            } else {
                this.context.browser.loadCollectionTree(this.context.mainFrame.treeCollectionTwo, this.context.subscriberRepo, this.isRemote());
                this.context.browser.loadSystemTree(this.context.mainFrame.treeSystemTwo, this.context.subscriberRepo, this.isRemote());
            }
        }
    }

    public void reset() {
        this.deleteCount = 0;
        this.resetStop();
        this.toolPaths = new ArrayList();
        if (this.logger == null) {
            this.logger = LogManager.getLogger("applog");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanForJunk(String path) {
        boolean hadError = false;
        if (this.isRemote()) {
            try {
                path = this.context.cfg.getFullPathSubscriber(path);
                Vector listing = this.getContext().clientSftp.listDirectory(path);
                block4: for (int i = 0; i < listing.size() && !this.isRequestStop(); ++i) {
                    ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)listing.get(i);
                    if (entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                    SftpATTRS attrs = entry.getAttrs();
                    String filename = entry.getFilename();
                    String fullpath = path + this.repo.getSeparator() + entry.getFilename();
                    if (this.context != null && this.context.progress != null) {
                        this.context.progress.update(" " + fullpath);
                    }
                    if (attrs.isDir()) {
                        this.scanForJunk(fullpath);
                        continue;
                    }
                    for (JunkItem ji : this.junkList) {
                        if (this.isRequestStop()) continue block4;
                        if (!this.match(filename, fullpath, ji)) continue;
                        ++this.deleteCount;
                        if (this.context != null) {
                            this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.count") + this.deleteCount);
                            this.context.mainFrame.labelStatusMiddle.updateUI();
                        }
                        if (!this.isDryRun) {
                            this.getContext().transfer.remove(fullpath, this.isRemote());
                        }
                        this.logDeletion(fullpath);
                    }
                }
                return hadError;
            }
            catch (Exception e) {
                String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
                if (this.context != null) {
                    int reply;
                    this.logger.error(msg);
                    if (this.context.navigator == null || (reply = JOptionPane.showConfirmDialog(this.context.navigator.dialogJunkRemover, this.context.cfg.gs("JunkRemover.title"), this.context.cfg.gs("Z.cancel.run"), 0)) != 0) return hadError;
                    this.requestStop();
                    return hadError;
                }
                this.logger.error(msg);
                return hadError;
            }
        }
        try {
            File file = new File(Utils.getFullPathLocal(path));
            File[] files = file.isDirectory() ? FileSystemView.getFileSystemView().getFiles(file, true) : new File[]{file};
            block6: for (File entry : files) {
                if (this.isRequestStop()) return hadError;
                String filename = entry.getName();
                if (this.context != null && this.context.progress != null) {
                    this.context.progress.update(" " + filename);
                }
                String fullpath = entry.getPath();
                if (entry.isDirectory()) {
                    this.scanForJunk(fullpath);
                    continue;
                }
                for (JunkItem ji : this.junkList) {
                    if (this.isRequestStop()) continue block6;
                    if (!this.match(filename, fullpath, ji)) continue;
                    ++this.deleteCount;
                    if (this.context.mainFrame != null) {
                        this.context.mainFrame.labelStatusMiddle.setText(this.context.cfg.gs("Z.count") + this.deleteCount);
                    }
                    if (!this.isDryRun) {
                        this.getContext().transfer.remove(fullpath, this.isRemote());
                    }
                    this.logDeletion(fullpath);
                    continue block6;
                }
            }
            return hadError;
        }
        catch (Exception e) {
            String msg = this.context.cfg.gs("Z.exception") + " " + Utils.getStackTrace(e);
            if (this.context != null) {
                int reply;
                this.logger.error(msg);
                if (this.context.navigator == null || (reply = JOptionPane.showConfirmDialog(this.context.navigator.dialogJunkRemover, this.context.cfg.gs("JunkRemover.title"), "Z.cancel.run", 0)) != 0) return hadError;
                this.requestStop();
                return hadError;
            }
            this.logger.error(msg);
        }
        return hadError;
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    @Override
    public void setDataHasChanged() {
        this.dataHasChanged = true;
    }

    @Override
    public void setDataHasChanged(boolean state) {
        this.dataHasChanged = state;
    }

    public void setJunkList(ArrayList<JunkItem> junkList) {
        this.junkList = junkList;
    }

    public void write() throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            File f = new File(this.getFullPath());
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(this.getFullPath());
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.getCfg().gs("JunkRemover.error.writing") + this.getFullPath() + ": " + Utils.getStackTrace(fnf));
        }
    }

    public class JunkItem
    implements Serializable {
        public boolean caseSensitive = false;
        public String wildcard;
    }
}

