/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.tools.operations;

import com.corionis.els.Context;
import com.corionis.els.Main;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.gui.util.ArgumentTokenizer;
import com.corionis.els.gui.util.GuiLogAppender;
import com.corionis.els.jobs.Task;
import com.corionis.els.tools.AbstractTool;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OperationsTool
extends AbstractTool {
    public static final String INTERNAL_NAME = "Operations";
    public static final String SUBSYSTEM = "tools";
    private String configName;
    private String internalName = "Operations";
    private Operations operation = Operations.PublisherOperation;
    private Cards card = Cards.Publisher;
    private char[] optAuthorize = null;
    private String optAuthKeys = "";
    private String optBlacklist = "";
    private boolean optCrossCheck = false;
    private boolean optDecimalScale = false;
    private boolean optDuplicates = false;
    private boolean optEmptyDirectories = false;
    private String[] optExclude;
    private String optExportItems = "";
    private String optExportText = "";
    private boolean optForceQuit = false;
    private boolean optIgnored = false;
    private String optIpWhitelist = "";
    private String optKeys = "";
    private String optKeysOnly = "";
    private String[] optLibrary;
    private boolean optListenerKeepGoing = false;
    private boolean optListenerQuit = false;
    private String optMismatches = "";
    private boolean optNavigator = false;
    private boolean optNoBackFill = false;
    private boolean optOverwrite = false;
    private boolean optPreserveDates = true;
    private boolean optQuitStatus = false;
    private String optTargets = "";
    private boolean optValidate = false;
    private String optWhatsNew = "";
    private String optWhatsNewAll = "";
    private transient Logger logger = LogManager.getLogger("applog");
    private transient String emailTool;
    private transient String hintPath;
    private transient String pubPath;
    private transient String subPath;
    private transient Task task = null;
    transient boolean stop = false;

    public OperationsTool(Context context) {
        super(context);
        this.setDisplayName(this.getCfg().gs("Operations.displayName"));
    }

    @Override
    public OperationsTool clone() {
        OperationsTool tool = new OperationsTool(this.context);
        tool.setConfigName(this.getConfigName());
        tool.internalName = INTERNAL_NAME;
        tool.setOperation(this.getOperation());
        tool.setCard(this.getCard());
        tool.setOptAuthorize(this.getOptAuthorize());
        tool.setOptAuthKeys(this.getOptAuthKeys());
        tool.setOptNoBackFill(this.isOptNoBackFill());
        tool.setOptBlacklist(this.getOptBlacklist());
        tool.setOptExportText(this.getOptExportText());
        tool.setOptEmptyDirectories(this.isOptEmptyDirectories());
        tool.setOptListenerKeepGoing(this.isOptListenerKeepGoing());
        tool.setOptListenerQuit(this.isOptListenerQuit());
        tool.setOptExportItems(this.getOptExportItems());
        tool.setOptIpWhitelist(this.getOptIpWhitelist());
        tool.setOptKeys(this.getOptKeys());
        tool.setOptKeysOnly(this.getOptKeysOnly());
        tool.setOptMismatches(this.getOptMismatches());
        tool.setOptNavigator(this.isOptNavigator());
        tool.setOptIgnored(this.isOptIgnored());
        tool.setOptOverwrite(this.isOptOverwrite());
        tool.setOptQuitStatus(this.isOptQuitStatus());
        tool.setOptForceQuit(this.isOptForceQuit());
        tool.setOptTargets(this.getOptTargets());
        tool.setOptDuplicates(this.isOptDuplicates());
        tool.setOptValidate(this.isOptValidate());
        tool.setOptWhatsNew(this.getOptWhatsNew());
        tool.setOptWhatsNewAll(this.getOptWhatsNewAll());
        tool.setOptCrossCheck(this.isOptCrossCheck());
        tool.setOptPreserveDates(this.isOptPreserveDates());
        tool.setOptDecimalScale(this.isOptDecimalScale());
        return tool;
    }

    private String generateCommandLine(boolean dryRun) {
        int i;
        String[] libs;
        boolean glo = this.context.preferences != null ? this.context.preferences.isGenerateLongOptions() : false;
        StringBuilder sb = new StringBuilder();
        String conf = (glo ? "--config \"" : "-C \"") + this.context.cfg.getWorkingDirectory() + "\"";
        sb.append(" " + conf);
        if (this.context.cfg.isLoggerView() && !this.isOptNavigator()) {
            sb.append(" --logger");
        }
        if (dryRun) {
            sb.append(" " + (glo ? "--dry-run" : "-D"));
        }
        if (this.isOptNavigator() != this.context.cfg.isNavigator()) {
            sb.append(" " + (glo ? "--navigator" : "-n"));
        }
        if (this.isOptForceQuit() || this.operation == Operations.StatusServerQuit) {
            sb.append(" " + (glo ? "--force-quit" : "-Q"));
        }
        if (this.isOptQuitStatus()) {
            sb.append(" " + (glo ? "--quit-status" : "-q"));
        }
        if (!this.getOptKeys().isEmpty()) {
            sb.append(" " + (glo ? "--keys" : "-k") + " \"" + this.getOptKeys() + "\"");
        }
        if (!this.getOptKeysOnly().isEmpty()) {
            sb.append(" " + (glo ? "--keys-only" : "-K") + " \"" + this.getOptKeysOnly() + "\"");
        }
        if (!this.hintPath.isEmpty()) {
            this.hintPath = Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), this.hintPath);
            if (this.task.hintsOverrideHost) {
                sb.append(" " + (glo ? "--override-hints-host" : "-J"));
            }
            if (this.task.isHintsRemote() || this.isToolHintServer()) {
                sb.append(" " + (glo ? "--hint-server" : "-H") + " \"" + this.hintPath + "\"");
            } else {
                sb.append(" " + (glo ? "--hints" : "-h") + " \"" + this.hintPath + "\"");
            }
        }
        switch (this.operation) {
            case PublisherOperation: {
                if (!this.task.isSubscriberRemote()) break;
                sb.append(" " + (glo ? "--remote" : "-r") + " P");
                break;
            }
            case SubscriberListener: {
                sb.append(" " + (glo ? "--remote" : "-r") + " S");
                break;
            }
            case PublisherListener: {
                sb.append(" " + (glo ? "--remote" : "-r") + " L");
                break;
            }
            case PublisherManual: {
                sb.append(" " + (glo ? "--remote" : "-r") + " M");
                break;
            }
            case SubscriberTerminal: {
                sb.append(" " + (glo ? "--remote" : "-r") + " T");
                break;
            }
            case StatusServer: 
            case StatusServerQuit: {
                break;
            }
            case SubscriberListenerQuit: {
                sb.append(" " + (glo ? "--listener-quit" : "-G"));
            }
        }
        if (this.operation != Operations.StatusServer) {
            if (!this.pubPath.isEmpty()) {
                this.pubPath = Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), this.pubPath);
                sb.append(" " + (glo ? "--publisher-libraries" : "-p") + " \"" + this.pubPath + "\"");
            }
            if (this.operation != Operations.StatusServerQuit) {
                this.subPath = Utils.makeRelativePath(this.context.cfg.getWorkingDirectory(), this.subPath);
                if (!this.subPath.isEmpty()) {
                    if (!this.task.subscriberOverride.isEmpty()) {
                        sb.append(" " + (glo ? "--override-host" : "-O ") + this.task.subscriberOverride);
                    }
                    sb.append(" " + (glo ? "--subscriber-libraries" : "-s") + " \"" + this.subPath + "\"");
                }
            }
        }
        switch (this.operation) {
            case PublisherOperation: 
            case SubscriberListener: 
            case PublisherListener: {
                sb.append(" " + (glo ? "--targets" : "-t"));
                if (this.getOptTargets().isEmpty()) break;
                sb.append(" \"" + this.getOptTargets() + "\"");
                break;
            }
        }
        if (!this.emailTool.isEmpty()) {
            sb.append(" " + (glo ? "--email" : "-M") + " \"" + this.emailTool + "\"");
        }
        if (this.getOptAuthorize() != null && this.getOptAuthorize().length > 0) {
            sb.append(" " + (glo ? "--authorize" : "-a") + " \"" + this.getOptAuthorizeString() + "\"");
        }
        if (!this.getOptAuthKeys().isEmpty()) {
            sb.append(" " + (glo ? "--auth-keys" : "-A") + " \"" + this.getOptAuthKeys() + "\"");
        }
        if (!this.getOptBlacklist().isEmpty()) {
            sb.append(" " + (glo ? "--blacklist" : "-B") + " \"" + this.getOptBlacklist() + "\"");
        }
        if (!this.getOptIpWhitelist().isEmpty()) {
            sb.append(" " + (glo ? "--ip-whitelist" : "-I") + " \"" + this.getOptIpWhitelist() + "\"");
        }
        if (!this.getOptExportText().isEmpty()) {
            sb.append(" " + (glo ? "--export-text" : "-e") + " \"" + this.getOptExportText() + "\"");
        }
        if (!this.getOptExportItems().isEmpty()) {
            sb.append(" " + (glo ? "--export-items" : "-i") + " \"" + this.getOptExportItems() + "\"");
        }
        if ((libs = this.getOptLibrary()) != null && libs.length > 0) {
            for (i = 0; i < libs.length; ++i) {
                sb.append(" " + (glo ? "--library" : "-l") + " \"" + libs[i] + "\"");
            }
        }
        if ((libs = this.getOptExclude()) != null && libs.length > 0) {
            for (i = 0; i < libs.length; ++i) {
                sb.append(" " + (glo ? "--exclude" : "-L") + " \"" + libs[i] + "\"");
            }
        }
        if (!this.getOptMismatches().isEmpty()) {
            sb.append(" " + (glo ? "--mismatches" : "-m") + " \"" + this.getOptMismatches() + "\"");
        }
        if (!this.getOptWhatsNew().isEmpty()) {
            sb.append(" " + (glo ? "--whatsnew" : "-w") + " \"" + this.getOptWhatsNew() + "\"");
        }
        if (!this.getOptWhatsNewAll().isEmpty()) {
            sb.append(" " + (glo ? "--whatsnew-all" : "-W") + " \"" + this.getOptWhatsNewAll() + "\"");
        }
        if (this.isOptDecimalScale() != !this.context.cfg.isBinaryScale()) {
            sb.append(" " + (glo ? "--decimal-scale" : "-z"));
        }
        if (this.isOptDuplicates() != this.context.cfg.isDuplicateCheck()) {
            sb.append(" " + (glo ? "--duplicates" : "-u"));
        }
        if (this.isOptEmptyDirectories() != this.context.cfg.isEmptyDirectoryCheck()) {
            sb.append(" " + (glo ? "--empty-directories" : "-E"));
        }
        if (this.isOptCrossCheck() != this.context.cfg.isCrossCheck()) {
            sb.append(" " + (glo ? "--cross-check" : "-x"));
        }
        if (this.isOptIgnored() != this.context.cfg.isIgnoredReported()) {
            sb.append(" " + (glo ? "--ignored" : "-N"));
        }
        if (this.isOptListenerQuit() != this.context.cfg.isQuitSubscriberListener()) {
            sb.append(" " + (glo ? "--listener-quit" : "-G"));
        }
        if (this.isOptListenerKeepGoing() != this.context.cfg.isKeepGoing()) {
            sb.append(" " + (glo ? "--listener-keep-going" : "-g"));
        }
        if (this.isOptNoBackFill() != this.context.cfg.isNoBackFill()) {
            sb.append(" " + (glo ? "--no-back-fill" : "-B"));
        }
        if (this.isOptOverwrite() != this.context.cfg.isOverwrite()) {
            sb.append(" " + (glo ? "--overwrite" : "-o"));
        }
        if (this.isOptPreserveDates() != this.context.cfg.isPreserveDates()) {
            sb.append(" " + (glo ? "--preserve-dates" : "-y"));
        }
        if (this.isOptValidate() != this.context.cfg.isValidation()) {
            sb.append(" " + (glo ? "--validate" : "-v"));
        }
        return sb.toString().trim();
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public Cards getCard() {
        return this.card;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public Operations getOperation() {
        return this.operation;
    }

    public String getOptAuthKeys() {
        return this.optAuthKeys;
    }

    public char[] getOptAuthorize() {
        return this.optAuthorize;
    }

    public String getOptAuthorizeString() {
        return new String(this.optAuthorize);
    }

    public String getOptBlacklist() {
        return this.optBlacklist;
    }

    public String[] getOptExclude() {
        return this.optExclude;
    }

    public String getOptExportItems() {
        return this.optExportItems;
    }

    public String getOptExportText() {
        return this.optExportText;
    }

    public String getOptIpWhitelist() {
        return this.optIpWhitelist;
    }

    public String getOptKeys() {
        return this.optKeys;
    }

    public String getOptKeysOnly() {
        return this.optKeysOnly;
    }

    public String[] getOptLibrary() {
        return this.optLibrary;
    }

    public String getOptMismatches() {
        return this.optMismatches;
    }

    public String getOptTargets() {
        return this.optTargets;
    }

    public String getOptWhatsNew() {
        return this.optWhatsNew;
    }

    public String getOptWhatsNewAll() {
        return this.optWhatsNewAll;
    }

    @Override
    public String getSubsystem() {
        return SUBSYSTEM;
    }

    @Override
    public boolean isDataChanged() {
        return this.dataHasChanged;
    }

    public boolean isOptCrossCheck() {
        return this.optCrossCheck;
    }

    public boolean isOptDecimalScale() {
        return this.optDecimalScale;
    }

    public boolean isOptDuplicates() {
        return this.optDuplicates;
    }

    public boolean isOptEmptyDirectories() {
        return this.optEmptyDirectories;
    }

    public boolean isOptForceQuit() {
        return this.optForceQuit;
    }

    public boolean isOptIgnored() {
        return this.optIgnored;
    }

    public boolean isOptListenerKeepGoing() {
        return this.optListenerKeepGoing;
    }

    public boolean isOptListenerQuit() {
        return this.optListenerQuit;
    }

    public boolean isOptNavigator() {
        return this.optNavigator;
    }

    public boolean isOptNoBackFill() {
        return this.optNoBackFill;
    }

    public boolean isOptOverwrite() {
        return this.optOverwrite;
    }

    public boolean isOptPreserveDates() {
        return this.optPreserveDates;
    }

    public boolean isOptQuitStatus() {
        return this.optQuitStatus;
    }

    public boolean isOptValidate() {
        return this.optValidate;
    }

    @Override
    public boolean isToolHintServer() {
        return this.card.equals((Object)Cards.HintServer);
    }

    @Override
    public boolean isToolPublisher() {
        return this.card.equals((Object)Cards.Publisher) || this.card.equals((Object)Cards.Terminal) || this.card.equals((Object)Cards.SubscriberQuit) || this.card.equals((Object)Cards.StatusQuit);
    }

    @Override
    public boolean isToolSubscriber() {
        return this.card.equals((Object)Cards.Listener);
    }

    @Override
    public void processTool(Task task) {
        GuiLogAppender gla;
        this.task = task;
        this.hintPath = task.hintsPath;
        this.pubPath = task.publisherPath;
        this.subPath = task.subscriberPath;
        this.emailTool = task.emailTool;
        String cmd = this.generateCommandLine(task.dryRun);
        List<String> list = ArgumentTokenizer.tokenize(cmd);
        String[] args = list.toArray(new String[0]);
        this.logger.info(this.context.cfg.gs("Z.launching") + this.getConfigName());
        Main main = new Main(args, this.context, this.getConfigName());
        if (task.localContext.cfg.isNavigator() && (gla = task.localContext.guiLogAppender) != null) {
            while (gla.isGuiInitializing()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.logger.trace("Navigator started");
        }
    }

    @Override
    public void requestStop() {
        this.stop = true;
    }

    @Override
    public void resetStop() {
        this.stop = false;
    }

    @Override
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setCard(Cards card) {
        this.card = card;
    }

    @Override
    public void setDataHasChanged() {
        this.dataHasChanged = true;
    }

    @Override
    public void setDataHasChanged(boolean sense) {
        this.dataHasChanged = sense;
    }

    public void setOptAuthKeys(String optAuthKeys) {
        this.optAuthKeys = optAuthKeys;
    }

    public void setOptAuthorize(char[] optAuthorize) {
        this.optAuthorize = optAuthorize;
    }

    public void setOptBlacklist(String optBlacklist) {
        this.optBlacklist = optBlacklist;
    }

    public void setOptCrossCheck(boolean optCrossCheck) {
        this.optCrossCheck = optCrossCheck;
    }

    public void setOptDecimalScale(boolean optDecimalScale) {
        this.optDecimalScale = optDecimalScale;
    }

    public void setOptDuplicates(boolean optDuplicates) {
        this.optDuplicates = optDuplicates;
    }

    public void setOptEmptyDirectories(boolean optEmptyDirectories) {
        this.optEmptyDirectories = optEmptyDirectories;
    }

    public void setOptExclude(String[] optExclude) {
        this.optExclude = optExclude;
    }

    public void setOptExportItems(String optExportItems) {
        this.optExportItems = optExportItems;
    }

    public void setOptExportText(String optExportText) {
        this.optExportText = optExportText;
    }

    public void setOptForceQuit(boolean optForceQuit) {
        this.optForceQuit = optForceQuit;
    }

    public void setOptIgnored(boolean optIgnored) {
        this.optIgnored = optIgnored;
    }

    public void setOptIpWhitelist(String optIpWhitelist) {
        this.optIpWhitelist = optIpWhitelist;
    }

    public void setOptKeys(String optKeys) {
        this.optKeys = optKeys;
    }

    public void setOptKeysOnly(String optKeysOnly) {
        this.optKeysOnly = optKeysOnly;
    }

    public void setOptLibrary(String[] optLibrary) {
        this.optLibrary = optLibrary;
    }

    public void setOptListenerKeepGoing(boolean optListenerKeepGoing) {
        this.optListenerKeepGoing = optListenerKeepGoing;
    }

    public void setOptListenerQuit(boolean optListenerQuit) {
        this.optListenerQuit = optListenerQuit;
    }

    public void setOptMismatches(String optMismatches) {
        this.optMismatches = optMismatches;
    }

    public void setOptNavigator(boolean optNavigator) {
        this.optNavigator = optNavigator;
    }

    public void setOptNoBackFill(boolean optNoBackFill) {
        this.optNoBackFill = optNoBackFill;
    }

    public void setOptOverwrite(boolean optOverwrite) {
        this.optOverwrite = optOverwrite;
    }

    public void setOptPreserveDates(boolean optPreserveDates) {
        this.optPreserveDates = optPreserveDates;
    }

    public void setOptQuitStatus(boolean optQuitStatus) {
        this.optQuitStatus = optQuitStatus;
    }

    public void setOptTargets(String optTargets) {
        this.optTargets = optTargets;
    }

    public void setOptValidate(boolean optValidate) {
        this.optValidate = optValidate;
    }

    public void setOptWhatsNew(String optWhatsNew) {
        this.optWhatsNew = optWhatsNew;
    }

    public void setOptWhatsNewAll(String optWhatsNewAll) {
        this.optWhatsNewAll = optWhatsNewAll;
    }

    public void setOperation(Operations operation) {
        this.operation = operation;
    }

    public void write() throws Exception {
        this.setOptAuthKeys(this.context.cfg.makeRelativePath(this.getOptAuthKeys()));
        this.setOptBlacklist(this.context.cfg.makeRelativePath(this.getOptBlacklist()));
        this.setOptExportItems(this.context.cfg.makeRelativePath(this.getOptExportItems()));
        this.setOptExportText(this.context.cfg.makeRelativePath(this.getOptExportText()));
        this.setOptIpWhitelist(this.context.cfg.makeRelativePath(this.getOptIpWhitelist()));
        this.setOptKeys(this.context.cfg.makeRelativePath(this.getOptKeys()));
        this.setOptKeysOnly(this.context.cfg.makeRelativePath(this.getOptKeysOnly()));
        this.setOptMismatches(this.context.cfg.makeRelativePath(this.getOptMismatches()));
        this.setOptTargets(this.context.cfg.makeRelativePath(this.getOptTargets()));
        this.setOptWhatsNew(this.context.cfg.makeRelativePath(this.getOptWhatsNew()));
        this.setOptWhatsNewAll(this.context.cfg.makeRelativePath(this.getOptWhatsNewAll()));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        try {
            File f = new File(this.getFullPath());
            if (f != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter outputStream = new PrintWriter(this.getFullPath());
            outputStream.println(json);
            outputStream.close();
        }
        catch (FileNotFoundException fnf) {
            throw new MungeException(this.getCfg().gs("Z.error.writing") + this.getFullPath() + ": " + Utils.getStackTrace(fnf));
        }
    }

    public static enum Operations {
        PublisherOperation,
        SubscriberListener,
        PublisherManual,
        PublisherListener,
        SubscriberTerminal,
        StatusServer,
        StatusServerQuit,
        SubscriberListenerQuit;

    }

    public static enum Cards {
        Publisher,
        Listener,
        HintServer,
        Terminal,
        SubscriberQuit,
        StatusQuit;

    }
}

