/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import io.ByteWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import mslinks.LinkInfo;
import mslinks.LinkTargetIDList;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.ShellLinkHeader;
import mslinks.ShellLinkHelper;
import mslinks.data.LinkFlags;
import mslinks.extra.ConsoleData;
import mslinks.extra.ConsoleFEData;
import mslinks.extra.EnvironmentVariable;
import mslinks.extra.Stub;
import mslinks.extra.Tracker;
import mslinks.extra.VistaIDList;

public class ShellLink {
    public static final String VERSION = "1.1.0";
    private static HashMap<Integer, Class<? extends Serializable>> extraTypes = new HashMap<Integer, Class<EnvironmentVariable>>(Map.of(-1610612734, ConsoleData.class, -1610612732, ConsoleFEData.class, -1610612733, Tracker.class, -1610612724, VistaIDList.class, -1610612735, EnvironmentVariable.class));
    private ShellLinkHeader header;
    private LinkTargetIDList idlist;
    private LinkInfo info;
    private String name;
    private String relativePath;
    private String workingDir;
    private String cmdArgs;
    private String iconLocation;
    private HashMap<Integer, Serializable> extra = new HashMap();
    private Path linkFileSource;

    public ShellLink() {
        this.header = new ShellLinkHeader();
        this.header.getLinkFlags().setIsUnicode();
    }

    public ShellLink(String file) throws IOException, ShellLinkException {
        this(Paths.get(file, new String[0]));
    }

    public ShellLink(File file) throws IOException, ShellLinkException {
        this(file.toPath());
    }

    public ShellLink(Path file) throws IOException, ShellLinkException {
        this(Files.newInputStream(file, new OpenOption[0]));
        this.linkFileSource = file.toAbsolutePath();
    }

    public ShellLink(InputStream in) throws IOException, ShellLinkException {
        try (ByteReader reader = new ByteReader(in);){
            this.parse(reader);
        }
    }

    public ShellLink(ByteReader reader) throws IOException, ShellLinkException {
        try (ByteReader byteReader = reader;){
            this.parse(reader);
        }
    }

    private void parse(ByteReader data) throws ShellLinkException, IOException {
        int size;
        this.header = new ShellLinkHeader(data);
        LinkFlags lf = this.header.getLinkFlags();
        if (lf.hasLinkTargetIDList()) {
            this.idlist = new LinkTargetIDList(data);
        }
        if (lf.hasLinkInfo()) {
            this.info = new LinkInfo(data);
        }
        if (lf.hasName()) {
            this.name = data.readUnicodeStringSizePadded();
        }
        if (lf.hasRelativePath()) {
            this.relativePath = data.readUnicodeStringSizePadded();
        }
        if (lf.hasWorkingDir()) {
            this.workingDir = data.readUnicodeStringSizePadded();
        }
        if (lf.hasArguments()) {
            this.cmdArgs = data.readUnicodeStringSizePadded();
        }
        if (lf.hasIconLocation()) {
            this.iconLocation = data.readUnicodeStringSizePadded();
        }
        while ((size = (int)data.read4bytes()) >= 4) {
            int sign = (int)data.read4bytes();
            try {
                Class<? extends Serializable> cl = extraTypes.get(sign);
                if (cl != null) {
                    this.extra.put(sign, cl.getConstructor(ByteReader.class, Integer.TYPE).newInstance(data, size));
                    continue;
                }
                this.extra.put(sign, new Stub(data, size, sign));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void serialize(OutputStream out) throws IOException {
        ByteWriter bw = new ByteWriter(out);
        this.serialize(bw);
        out.close();
    }

    public void serialize(ByteWriter bw) throws IOException {
        LinkFlags lf = this.header.getLinkFlags();
        this.header.serialize(bw);
        if (lf.hasLinkTargetIDList()) {
            this.idlist.serialize(bw);
        }
        if (lf.hasLinkInfo()) {
            this.info.serialize(bw);
        }
        if (lf.hasName()) {
            bw.writeUnicodeStringSizePadded(this.name);
        }
        if (lf.hasRelativePath()) {
            bw.writeUnicodeStringSizePadded(this.relativePath);
        }
        if (lf.hasWorkingDir()) {
            bw.writeUnicodeStringSizePadded(this.workingDir);
        }
        if (lf.hasArguments()) {
            bw.writeUnicodeStringSizePadded(this.cmdArgs);
        }
        if (lf.hasIconLocation()) {
            bw.writeUnicodeStringSizePadded(this.iconLocation);
        }
        for (Serializable i : this.extra.values()) {
            i.serialize(bw);
        }
        bw.write4bytes(0L);
    }

    public ShellLinkHeader getHeader() {
        return this.header;
    }

    public LinkInfo getLinkInfo() {
        return this.info;
    }

    public LinkInfo createLinkInfo() {
        this.info = new LinkInfo();
        this.header.getLinkFlags().setHasLinkInfo();
        return this.info;
    }

    public ShellLink removeLinkInfo() {
        this.info = null;
        this.header.getLinkFlags().clearHasLinkInfo();
        return this;
    }

    public LinkTargetIDList getTargetIdList() {
        return this.idlist;
    }

    public LinkTargetIDList createTargetIdList() {
        if (this.idlist == null) {
            this.idlist = new LinkTargetIDList();
            this.header.getLinkFlags().setHasLinkTargetIDList();
        }
        return this.idlist;
    }

    public ShellLink removeTargetIdList() {
        this.idlist = null;
        this.header.getLinkFlags().clearHasLinkTargetIDList();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ShellLink setName(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasName();
        } else {
            this.header.getLinkFlags().setHasName();
        }
        this.name = s;
        return this;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public ShellLink setRelativePath(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasRelativePath();
        } else {
            this.header.getLinkFlags().setHasRelativePath();
            if (!((String)s).startsWith(".")) {
                s = ".\\" + (String)s;
            }
        }
        this.relativePath = s;
        return this;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public ShellLink setWorkingDir(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasWorkingDir();
        } else {
            this.header.getLinkFlags().setHasWorkingDir();
        }
        this.workingDir = s;
        return this;
    }

    public String getCMDArgs() {
        return this.cmdArgs;
    }

    public ShellLink setCMDArgs(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasArguments();
        } else {
            this.header.getLinkFlags().setHasArguments();
        }
        this.cmdArgs = s;
        return this;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public ShellLink setIconLocation(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasIconLocation();
        } else {
            this.header.getLinkFlags().setHasIconLocation();
        }
        this.iconLocation = s;
        return this;
    }

    public String getLanguage() {
        return this.getConsoleFEData().getLanguage();
    }

    public ShellLink setLanguage(String s) {
        this.getConsoleFEData().setLanguage(s);
        return this;
    }

    public ConsoleData getConsoleData() {
        return (ConsoleData)this.getExtraDataBlock(-1610612734);
    }

    public ShellLink removeConsoleData() {
        this.extra.remove(-1610612734);
        return this;
    }

    public ConsoleFEData getConsoleFEData() {
        return (ConsoleFEData)this.getExtraDataBlock(-1610612732);
    }

    public ShellLink removeConsoleFEData() {
        this.extra.remove(-1610612732);
        return this;
    }

    public EnvironmentVariable getEnvironmentVariable() {
        return (EnvironmentVariable)this.getExtraDataBlock(-1610612735);
    }

    public ShellLink removeEnvironmentVariable() {
        this.extra.remove(-1610612735);
        return this;
    }

    public Tracker getTracker() {
        return (Tracker)this.getExtraDataBlock(-1610612733);
    }

    public ShellLink removeTracker() {
        this.extra.remove(-1610612733);
        return this;
    }

    public VistaIDList getVistaIDList() {
        return (VistaIDList)this.getExtraDataBlock(-1610612724);
    }

    public ShellLink removeVistaIDList() {
        this.extra.remove(-1610612724);
        return this;
    }

    public Path getLinkFileSource() {
        return this.linkFileSource;
    }

    public ShellLink setLinkFileSource(Path path) {
        this.linkFileSource = path;
        return this;
    }

    public String resolveTarget() {
        String path;
        if (this.header.getLinkFlags().hasLinkTargetIDList() && this.idlist != null && this.idlist.canBuildAbsolutePath()) {
            return this.idlist.buildPath();
        }
        if (this.header.getLinkFlags().hasLinkInfo() && this.info != null && (path = this.info.buildPath()) != null) {
            return path;
        }
        if (this.linkFileSource != null && this.header.getLinkFlags().hasRelativePath() && this.relativePath != null) {
            return this.linkFileSource.resolveSibling(this.relativePath).normalize().toString();
        }
        EnvironmentVariable envBlock = (EnvironmentVariable)this.extra.get(-1610612735);
        if (envBlock != null && !envBlock.getVariable().isEmpty()) {
            return envBlock.getVariable();
        }
        if (this.header.getLinkFlags().hasLinkTargetIDList() && this.idlist != null && this.idlist.canBuildPath()) {
            return this.idlist.buildPath();
        }
        return "<unknown>";
    }

    private Serializable getExtraDataBlock(int signature) {
        Serializable block = this.extra.get(signature);
        if (block == null) {
            Class<? extends Serializable> type = extraTypes.get(signature);
            try {
                block = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.extra.put(signature, block);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return block;
    }

    @Deprecated(since="1.0.7", forRemoval=true)
    public ShellLink saveTo(String path) throws IOException {
        new ShellLinkHelper(this).saveTo(path);
        return this;
    }

    @Deprecated(since="1.0.7", forRemoval=true)
    public ShellLink setTarget(String target) {
        target = ShellLinkHelper.resolveEnvVariables(target);
        String targetAbsPath = Paths.get(target, new String[0]).toAbsolutePath().toString();
        try {
            ShellLinkHelper helper = new ShellLinkHelper(this);
            if (targetAbsPath.startsWith("\\\\")) {
                helper.setNetworkTarget(targetAbsPath);
            } else {
                String[] parts = targetAbsPath.split(":");
                if (parts.length == 2) {
                    helper.setLocalTarget(parts[0], parts[1]);
                }
            }
        }
        catch (ShellLinkException shellLinkException) {
            // empty catch block
        }
        return this;
    }

    @Deprecated(since="1.0.7", forRemoval=true)
    public static ShellLink createLink(String target) {
        ShellLink sl = new ShellLink();
        sl.setTarget(target);
        return sl;
    }

    @Deprecated(since="1.0.7", forRemoval=true)
    public static ShellLink createLink(String target, String linkpath) throws IOException {
        return ShellLink.createLink(target).saveTo(linkpath);
    }
}

