/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import mslinks.ShellLinkException;
import mslinks.UnsupportedItemIDException;
import mslinks.data.ItemID;

public class ItemIDFS
extends ItemID {
    protected static final int HIDDEN_ID_EMPTY = 0;
    protected static final int HIDDEN_ID_URLFRAGMENT = 1;
    protected static final int HIDDEN_ID_URLQUERY = 2;
    protected static final int HIDDEN_ID_JUNCTION = 3;
    protected static final int HIDDEN_ID_IDFOLDEREX = 4;
    protected static final int HIDDEN_ID_DOCFINDDATA = 5;
    protected static final int HIDDEN_ID_PERSONALIZED = 6;
    protected static final int HIDDEN_ID_recycle2 = 7;
    protected static final int HIDDEN_ID_RECYCLEBINDATA = 8;
    protected static final int HIDDEN_ID_RECYCLEBINORIGINAL = 9;
    protected static final int HIDDEN_ID_PARENTFOLDER = 10;
    protected static final int HIDDEN_ID_STARTPANEDATA = 11;
    protected static final int HIDDEN_ID_NAVIGATEMARKER = 12;
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    public static final int FILE_ATTRIBUTE_HIDDEN = 2;
    public static final int FILE_ATTRIBUTE_SYSTEM = 4;
    public static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;
    public static final int FILE_ATTRIBUTE_DEVICE = 64;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    public static final int FILE_ATTRIBUTE_TEMPORARY = 256;
    public static final int FILE_ATTRIBUTE_SPARSE_FILE = 512;
    public static final int FILE_ATTRIBUTE_REPARSE_POINT = 1024;
    public static final int FILE_ATTRIBUTE_COMPRESSED = 2048;
    public static final int FILE_ATTRIBUTE_OFFLINE = 4096;
    public static final int FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 8192;
    public static final int FILE_ATTRIBUTE_ENCRYPTED = 16384;
    protected int size;
    protected short attributes;
    protected String shortname;
    protected String longname;

    public ItemIDFS(int flags) throws UnsupportedItemIDException {
        super(flags | 0x30);
        this.onTypeFlagsChanged();
    }

    private void onTypeFlagsChanged() throws UnsupportedItemIDException {
        int subType = this.typeFlags & 0xF;
        if ((subType & 1) == 0 && (subType & 2) == 0) {
            throw new UnsupportedItemIDException(this.typeFlags);
        }
        if (this.longname != null) {
            this.typeFlags = ItemIDFS.isLongFilename(this.longname) ? (this.typeFlags |= 4) : (this.typeFlags &= 0xFFFFFFFB);
        }
        this.attributes = (subType & 1) != 0 ? (short)(this.attributes | 0x10) : (short)(this.attributes & 0xFFFFFFEF);
    }

    @Override
    public void load(ByteReader br, int maxSize) throws IOException, ShellLinkException {
        int startPos = br.getPosition() - 3;
        int endPos = startPos + maxSize + 3;
        super.load(br, maxSize);
        br.read();
        this.size = (int)br.read4bytes();
        br.read2bytes();
        br.read2bytes();
        this.attributes = (short)br.read2bytes();
        if ((this.typeFlags & 4) != 0) {
            this.longname = br.readUnicodeStringNullTerm(endPos - br.getPosition());
        }
        this.shortname = br.readString(endPos - br.getPosition());
        int restOfDataSize = endPos - br.getPosition();
        if (restOfDataSize <= 2) {
            br.seek(restOfDataSize);
            return;
        }
        int bytesParsed = br.getPosition() - startPos;
        byte[] dataChunk = new byte[restOfDataSize - 2];
        br.read(dataChunk, 0, dataChunk.length);
        int hiddenOffset = (int)br.read2bytes();
        if (hiddenOffset == 0 || hiddenOffset < bytesParsed) {
            return;
        }
        int offsetInDataChunk = hiddenOffset - bytesParsed;
        ByteReader hbr = new ByteReader(new ByteArrayInputStream(dataChunk, offsetInDataChunk, dataChunk.length));
        this.loadHiddenPart(hbr, dataChunk.length + 2 - offsetInDataChunk);
    }

    protected void loadHiddenPart(ByteReader br, int maxSize) throws IOException {
        block3: {
            int hiddenSize;
            int startPos;
            while (true) {
                startPos = br.getPosition();
                hiddenSize = (int)br.read2bytes();
                int hiddenVersion = (int)br.read2bytes();
                int hiddenIdField = (int)br.read4bytes();
                int hiddenIdMagic = (hiddenIdField & 0xFFFF0000) >>> 16;
                int hiddenId = hiddenIdField & 0xFFFF;
                int hiddenEndPos = br.getPosition() - 8 + hiddenSize;
                if (hiddenEndPos > maxSize) break block3;
                if (hiddenIdMagic != 48879) {
                    br.seek(hiddenSize - 8);
                    continue;
                }
                if (hiddenId == 4 && hiddenVersion >= 3) break;
            }
            br.read4bytes();
            br.read4bytes();
            int offsetNameUnicode = (int)br.read2bytes();
            br.read2bytes();
            int unicodeNamePos = startPos + offsetNameUnicode;
            br.seek(unicodeNamePos - br.getPosition());
            this.longname = br.readUnicodeStringNullTerm(startPos + hiddenSize - br.getPosition());
            if (!this.longname.equals(this.shortname)) {
                this.typeFlags |= 4;
            }
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        super.serialize(bw);
        bw.write(0);
        bw.write4bytes(this.size);
        bw.write4bytes(0L);
        bw.write2bytes(this.attributes);
        if ((this.typeFlags & 4) != 0) {
            bw.writeUnicodeStringNullTerm(this.longname);
            bw.writeString(this.shortname);
        } else {
            bw.writeString(this.shortname);
            bw.write(0);
        }
    }

    @Override
    public String toString() {
        Object name;
        Object object = name = (this.typeFlags & 4) != 0 ? this.longname : this.shortname;
        if ((this.typeFlags & 1) != 0) {
            name = (String)name + "\\";
        }
        return name;
    }

    @Override
    public ItemID setTypeFlags(int flags) throws ShellLinkException {
        super.setTypeFlags(flags);
        this.onTypeFlagsChanged();
        return this;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public ItemID setSize(int s) {
        this.size = s;
        return this;
    }

    public short getAttributes() {
        return this.attributes;
    }

    public ItemIDFS setAttributes(short attr) throws ShellLinkException {
        this.attributes = attr;
        if ((attr & 0x10) != 0) {
            this.typeFlags |= 1;
            this.typeFlags &= 0xFFFFFFFD;
        } else {
            this.typeFlags &= 0xFFFFFFFE;
            this.typeFlags |= 2;
        }
        return this;
    }

    @Override
    public String getName() {
        if (this.longname != null && !this.longname.equals("")) {
            return this.longname;
        }
        return this.shortname;
    }

    @Override
    public ItemID setName(String s) throws ShellLinkException {
        if (s == null) {
            return this;
        }
        if (s.contains("\\")) {
            throw new ShellLinkException("wrong ItemIDFS name: " + s);
        }
        this.longname = s;
        if (ItemIDFS.isLongFilename(s)) {
            this.shortname = ItemIDFS.generateShortName(s);
            this.typeFlags |= 4;
        } else {
            this.shortname = s;
            this.typeFlags &= 0xFFFFFFFB;
        }
        return this;
    }
}

