/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.mina;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.DefaultIoFilterChain;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.mina.MinaSession;
import org.apache.sshd.mina.MinaSupport;

public abstract class MinaService
extends AbstractCloseable
implements IoService,
org.apache.mina.core.service.IoHandler {
    protected final FactoryManager manager;
    protected final IoHandler handler;
    protected final IoProcessor<NioSession> ioProcessor;
    protected IoSessionConfig sessionConfig;
    private IoServiceEventListener eventListener;

    protected MinaService(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        this.manager = Objects.requireNonNull(manager, "No factory manager provided");
        this.handler = Objects.requireNonNull(handler, "No IoHandler provided");
        this.ioProcessor = Objects.requireNonNull(ioProcessor, "No IoProcessor provided");
    }

    @Override
    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    @Override
    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    protected abstract org.apache.mina.core.service.IoService getIoService();

    public void dispose() {
        org.apache.mina.core.service.IoService ioService = this.getIoService();
        ioService.dispose();
    }

    @Override
    protected void doCloseImmediately() {
        try {
            this.dispose();
        }
        finally {
            super.doCloseImmediately();
        }
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        org.apache.mina.core.service.IoService ioService = this.getIoService();
        Map<Long, org.apache.mina.core.session.IoSession> managedMap = ioService.getManagedSessions();
        HashMap<Long, org.apache.mina.core.session.IoSession> mina = new HashMap<Long, org.apache.mina.core.session.IoSession>(managedMap);
        HashMap<Long, IoSession> sessions = new HashMap<Long, IoSession>(mina.size());
        for (Long id : mina.keySet()) {
            org.apache.mina.core.session.IoSession minaSession = (org.apache.mina.core.session.IoSession)mina.get(id);
            IoSession session = this.getSession(minaSession);
            if (session == null) continue;
            sessions.put(id, session);
        }
        return sessions;
    }

    @Override
    public void sessionOpened(org.apache.mina.core.session.IoSession session) throws Exception {
        ConnectFuture future = (ConnectFuture)session.removeAttribute(DefaultIoFilterChain.SESSION_CREATED_FUTURE);
        if (future != null) {
            future.setSession(session);
            if (future.getSession() != session) {
                session.closeNow();
            }
        }
    }

    @Override
    public void sessionIdle(org.apache.mina.core.session.IoSession session, IdleStatus status) throws Exception {
    }

    @Override
    public void messageSent(org.apache.mina.core.session.IoSession session, Object message) throws Exception {
    }

    @Override
    public void inputClosed(org.apache.mina.core.session.IoSession session) throws Exception {
        session.closeNow();
    }

    protected void sessionCreated(org.apache.mina.core.session.IoSession session, SocketAddress acceptanceAddress) throws Exception {
        MinaSession ioSession = new MinaSession(this, session, acceptanceAddress);
        try {
            session.setAttribute(IoSession.class, ioSession);
            this.handler.sessionCreated(ioSession);
        }
        catch (Exception e) {
            this.log.warn("sessionCreated({}) failed {} to handle creation event: {}", session, e.getClass().getSimpleName(), e.getMessage());
            ioSession.close(true);
            throw e;
        }
    }

    @Override
    public void sessionClosed(org.apache.mina.core.session.IoSession ioSession) throws Exception {
        IoSession session = this.getSession(ioSession);
        this.handler.sessionClosed(session);
    }

    @Override
    public void exceptionCaught(org.apache.mina.core.session.IoSession ioSession, Throwable cause) throws Exception {
        IoSession session = this.getSession(ioSession);
        this.handler.exceptionCaught(session, cause);
    }

    @Override
    public void messageReceived(org.apache.mina.core.session.IoSession ioSession, Object message) throws Exception {
        IoSession session = this.getSession(ioSession);
        Readable ioBuffer = MinaSupport.asReadable((IoBuffer)message);
        this.handler.messageReceived(session, ioBuffer);
    }

    protected IoSession getSession(org.apache.mina.core.session.IoSession session) {
        return (IoSession)session.getAttribute(IoSession.class);
    }

    protected void configure(SocketSessionConfig config) {
        int readBufferSize;
        Integer intVal;
        Boolean boolVal = this.getBoolean(CoreModuleProperties.SOCKET_KEEPALIVE);
        if (boolVal != null) {
            try {
                config.setKeepAlive(boolVal);
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.SOCKET_KEEPALIVE, boolVal, t);
            }
        }
        if ((intVal = this.getInteger(CoreModuleProperties.SOCKET_SNDBUF)) != null) {
            try {
                config.setSendBufferSize(intVal);
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.SOCKET_SNDBUF, intVal, t);
            }
        }
        if ((intVal = this.getInteger(CoreModuleProperties.SOCKET_RCVBUF)) != null) {
            try {
                config.setReceiveBufferSize(intVal);
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.SOCKET_RCVBUF, intVal, t);
            }
        }
        if ((intVal = this.getInteger(CoreModuleProperties.SOCKET_LINGER)) != null) {
            try {
                config.setSoLinger(intVal);
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.SOCKET_LINGER, intVal, t);
            }
        }
        if ((boolVal = this.getBoolean(CoreModuleProperties.TCP_NODELAY)) != null) {
            try {
                config.setTcpNoDelay(boolVal);
            }
            catch (RuntimeIoException t) {
                this.handleConfigurationError(config, CoreModuleProperties.TCP_NODELAY, boolVal, t);
            }
        }
        int defaultMinReadBufferSize = config.getMinReadBufferSize();
        intVal = this.getInteger(CoreModuleProperties.MIN_READ_BUFFER_SIZE);
        if (intVal != null && (readBufferSize = intVal.intValue()) > defaultMinReadBufferSize) {
            readBufferSize = Math.min(readBufferSize, config.getMaxReadBufferSize());
            config.setMinReadBufferSize(readBufferSize);
            int defaultReadBufferSize = config.getReadBufferSize();
            if (defaultReadBufferSize < readBufferSize) {
                config.setReadBufferSize(readBufferSize);
            }
        }
        if ((intVal = this.getInteger(CoreModuleProperties.NIO2_READ_BUFFER_SIZE)) != null && (readBufferSize = intVal.intValue()) >= defaultMinReadBufferSize) {
            readBufferSize = Math.max(readBufferSize, config.getMinReadBufferSize());
            readBufferSize = Math.min(readBufferSize, config.getMaxReadBufferSize());
            config.setReadBufferSize(readBufferSize);
        }
        if (this.sessionConfig != null) {
            config.setAll(this.sessionConfig);
        }
    }

    protected void handleConfigurationError(SocketSessionConfig config, Property<?> property, Object propValue, RuntimeIoException t) {
        Throwable e = ExceptionUtils.resolveExceptionCause(t);
        this.log.warn("handleConfigurationError({}={}) failed ({}) to configure: {}", property.getName(), propValue, e.getClass().getSimpleName(), e.getMessage());
    }

    protected Integer getInteger(Property<Integer> property) {
        return property.getOrNull(this.manager);
    }

    protected Boolean getBoolean(Property<Boolean> property) {
        return property.getOrNull(this.manager);
    }
}

