/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.mina;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;
import org.apache.sshd.mina.MinaService;
import org.apache.sshd.mina.MinaSupport;

public class MinaSession
extends AbstractInnerCloseable
implements IoSession {
    private final MinaService service;
    private final org.apache.mina.core.session.IoSession session;
    private final Object sessionWriteId;
    private final SocketAddress acceptanceAddress;
    private final AtomicBoolean readSuspended = new AtomicBoolean();

    public MinaSession(MinaService service, org.apache.mina.core.session.IoSession session, SocketAddress acceptanceAddress) {
        this.service = service;
        this.session = session;
        this.sessionWriteId = Objects.toString(session);
        this.acceptanceAddress = acceptanceAddress;
    }

    public org.apache.mina.core.session.IoSession getSession() {
        return this.session;
    }

    @Override
    public void suspendRead() {
        if (!this.readSuspended.getAndSet(true)) {
            this.session.suspendRead();
        }
    }

    @Override
    public void resumeRead() {
        if (this.readSuspended.getAndSet(false)) {
            this.session.resumeRead();
        }
    }

    public void suspend() {
        this.session.suspendRead();
        this.session.suspendWrite();
    }

    @Override
    public Object getAttribute(Object key) {
        return this.session.getAttribute(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.session.setAttribute(key, value);
    }

    @Override
    public Object setAttributeIfAbsent(Object key, Object value) {
        return this.session.setAttributeIfAbsent(key, value);
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.session.removeAttribute(key);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    @Override
    public long getId() {
        return this.session.getId();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return new IoSessionCloser(this.toString(), this.session, this.futureLock);
    }

    public IoWriteFuture write(byte[] data) {
        return this.write(data, 0, NumberUtils.length(data));
    }

    public IoWriteFuture write(byte[] data, int offset, int len) {
        return this.write(IoBuffer.wrap(data, offset, len));
    }

    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) {
        return this.write(MinaSupport.asIoBuffer(buffer));
    }

    public IoWriteFuture write(IoBuffer buffer) {
        Future future = new Future(this.sessionWriteId, null);
        this.session.write(buffer).addListener(cf -> {
            Throwable t = cf.getException();
            if (t != null) {
                future.setException(t);
            } else {
                future.setWritten();
            }
        });
        return future;
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    @Override
    public void shutdownOutputStream() throws IOException {
        this.session.closeOnFlush();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.session.getLocalAddress() + ", remote=" + this.session.getRemoteAddress() + "]";
    }

    private static class IoSessionCloser
    extends IoBaseCloseable {
        private final DefaultCloseFuture future;
        private final org.apache.mina.core.session.IoSession session;

        IoSessionCloser(String id, org.apache.mina.core.session.IoSession session, Object futureLock) {
            this.session = session;
            this.future = new DefaultCloseFuture(id, futureLock);
        }

        @Override
        public boolean isClosing() {
            return this.session.isClosing();
        }

        @Override
        public boolean isClosed() {
            return !this.session.isConnected();
        }

        @Override
        public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            this.future.addListener(listener);
        }

        @Override
        public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            this.future.removeListener(listener);
        }

        @Override
        public CloseFuture close(boolean immediately) {
            org.apache.mina.core.future.CloseFuture cf = immediately ? this.session.closeNow() : this.session.closeOnFlush();
            cf.addListener(f -> this.future.setValue(Boolean.TRUE));
            return this.future;
        }
    }

    public static class Future
    extends AbstractIoWriteFuture {
        public Future(Object id, Object lock) {
            super(id, lock);
        }

        public void setWritten() {
            this.setValue(Boolean.TRUE);
        }

        public void setException(Throwable exception) {
            this.setValue(Objects.requireNonNull(exception, "No exception specified"));
        }
    }
}

