/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.sftp.server.DirectoryHandle;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.SftpSubsystemProxy;

public interface SftpFileSystemAccessor {
    public static final List<String> DEFAULT_UNIX_VIEW = Collections.singletonList("unix:*");
    public static final NavigableMap<String, FileInfoExtractor<?>> FILEATTRS_RESOLVERS = ((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)MapEntryUtils.NavigableMapBuilder.builder(String.CASE_INSENSITIVE_ORDER).put("isRegularFile", FileInfoExtractor.ISREG)).put("isDirectory", FileInfoExtractor.ISDIR)).put("isSymbolicLink", FileInfoExtractor.ISSYMLINK)).put("permissions", FileInfoExtractor.PERMISSIONS)).put("size", FileInfoExtractor.SIZE)).put("lastModifiedTime", FileInfoExtractor.LASTMODIFIED)).immutable();
    public static final String PROP_AUTO_SYNC_FILE_ON_CLOSE = "sftp-auto-fsync-on-close";
    public static final boolean DEFAULT_AUTO_SYNC_FILE_ON_CLOSE = true;
    public static final SftpFileSystemAccessor DEFAULT = new SftpFileSystemAccessor(){

        public String toString() {
            return SftpFileSystemAccessor.class.getSimpleName() + "[DEFAULT]";
        }
    };

    default public Path resolveLocalFilePath(SftpSubsystemProxy subsystem, Path rootDir, String remotePath) throws IOException, InvalidPathException {
        String path = SelectorUtils.translateToLocalFileSystemPath(remotePath, '/', rootDir.getFileSystem());
        return rootDir.resolve(path);
    }

    default public LinkOption[] resolveFileAccessLinkOptions(SftpSubsystemProxy subsystem, Path file, int cmd, String extension, boolean followLinks) throws IOException {
        return IoUtils.getLinkOptions(followLinks);
    }

    default public NavigableMap<String, Object> resolveReportedFileAttributes(SftpSubsystemProxy subsystem, Path file, int flags, NavigableMap<String, Object> attrs, LinkOption ... options) throws IOException {
        return attrs;
    }

    default public void applyExtensionFileAttributes(SftpSubsystemProxy subsystem, Path file, Map<String, byte[]> extensions, LinkOption ... options) throws IOException {
    }

    default public void putRemoteFileName(SftpSubsystemProxy subsystem, Path path, Buffer buf, String name, boolean shortName) throws IOException {
        buf.putString(name);
    }

    default public SeekableByteChannel openFile(SftpSubsystemProxy subsystem, FileHandle fileHandle, Path file, String handle, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            attrs = IoUtils.EMPTY_FILE_ATTRIBUTES;
        }
        if (!Arrays.asList(options.toArray(new OpenOption[0])).contains(LinkOption.NOFOLLOW_LINKS)) {
            return FileChannel.open(file, options, attrs);
        }
        return SftpFileSystemAccessor.seekableByteChannelNoLinkFollow(file, options, attrs);
    }

    default public FileLock tryLock(SftpSubsystemProxy subsystem, FileHandle fileHandle, Path file, String handle, Channel channel, long position, long size, boolean shared) throws IOException {
        if (!(channel instanceof FileChannel)) {
            throw new StreamCorruptedException("Non file channel to lock: " + channel);
        }
        return ((FileChannel)channel).lock(position, size, shared);
    }

    default public void syncFileData(SftpSubsystemProxy subsystem, FileHandle fileHandle, Path file, String handle, Channel channel) throws IOException {
        if (!(channel instanceof FileChannel)) {
            throw new StreamCorruptedException("Non file channel to sync: " + channel);
        }
        ((FileChannel)channel).force(true);
    }

    default public void closeFile(SftpSubsystemProxy subsystem, FileHandle fileHandle, Path file, String handle, Channel channel, Set<? extends OpenOption> options) throws IOException {
        if (channel == null || !channel.isOpen()) {
            return;
        }
        if (channel instanceof FileChannel && GenericUtils.containsAny(options, IoUtils.WRITEABLE_OPEN_OPTIONS) && PropertyResolverUtils.getBooleanProperty(subsystem.getSession(), PROP_AUTO_SYNC_FILE_ON_CLOSE, true)) {
            ((FileChannel)channel).force(true);
        }
        channel.close();
    }

    default public DirectoryStream<Path> openDirectory(SftpSubsystemProxy subsystem, DirectoryHandle dirHandle, Path dir, String handle, LinkOption ... linkOptions) throws IOException {
        if (IoUtils.followLinks(linkOptions)) {
            return Files.newDirectoryStream(dir);
        }
        return SftpFileSystemAccessor.secureResolveDirectoryStream(dir);
    }

    default public void closeDirectory(SftpSubsystemProxy subsystem, DirectoryHandle dirHandle, Path dir, String handle, DirectoryStream<Path> ds) throws IOException {
        if (ds == null) {
            return;
        }
        ds.close();
    }

    default public Map<String, ?> readFileAttributes(SftpSubsystemProxy subsystem, Path file, String view, LinkOption ... options) throws IOException {
        return Files.readAttributes(file, view, options);
    }

    default public void setFileAttribute(SftpSubsystemProxy subsystem, Path file, String view, String attribute, Object value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        Files.setAttribute(file, view + ":" + attribute, value, options);
    }

    default public UserPrincipal resolveFileOwner(SftpSubsystemProxy subsystem, Path file, UserPrincipal name) throws IOException {
        FileSystem fileSystem = file.getFileSystem();
        UserPrincipalLookupService lookupService = fileSystem.getUserPrincipalLookupService();
        String username = name.toString();
        if (lookupService == null) {
            throw new UserPrincipalNotFoundException(username);
        }
        return lookupService.lookupPrincipalByName(username);
    }

    default public void setFileOwner(SftpSubsystemProxy subsystem, Path file, Principal value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        FileOwnerAttributeView view = Files.getFileAttributeView(file, FileOwnerAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("Owner view not supported for " + file);
        }
        if (!(value instanceof UserPrincipal)) {
            throw new StreamCorruptedException("Owner is not " + UserPrincipal.class.getSimpleName() + ": " + value.getClass().getSimpleName());
        }
        view.setOwner((UserPrincipal)value);
    }

    default public GroupPrincipal resolveGroupOwner(SftpSubsystemProxy subsystem, Path file, GroupPrincipal name) throws IOException {
        FileSystem fileSystem = file.getFileSystem();
        UserPrincipalLookupService lookupService = fileSystem.getUserPrincipalLookupService();
        String groupName = name.toString();
        if (lookupService == null) {
            throw new UserPrincipalNotFoundException(groupName);
        }
        return lookupService.lookupPrincipalByGroupName(groupName);
    }

    default public void setGroupOwner(SftpSubsystemProxy subsystem, Path file, Principal value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        PosixFileAttributeView view = Files.getFileAttributeView(file, PosixFileAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("POSIX view not supported");
        }
        if (!(value instanceof GroupPrincipal)) {
            throw new StreamCorruptedException("Group is not " + GroupPrincipal.class.getSimpleName() + ": " + value.getClass().getSimpleName());
        }
        view.setGroup((GroupPrincipal)value);
    }

    default public void setFilePermissions(SftpSubsystemProxy subsystem, Path file, Set<PosixFilePermission> perms, LinkOption ... options) throws IOException {
        if (OsUtils.isWin32()) {
            IoUtils.setPermissionsToFile(file.toFile(), perms);
            return;
        }
        PosixFileAttributeView view = Files.getFileAttributeView(file, PosixFileAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("POSIX view not supported for " + file);
        }
        view.setPermissions(perms);
    }

    default public void setFileAccessControl(SftpSubsystemProxy subsystem, Path file, List<AclEntry> acl, LinkOption ... options) throws IOException {
        AclFileAttributeView view = Files.getFileAttributeView(file, AclFileAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("ACL view not supported for " + file);
        }
        view.setAcl(acl);
    }

    default public void createDirectory(SftpSubsystemProxy subsystem, Path path) throws IOException {
        Files.createDirectory(path, new FileAttribute[0]);
    }

    default public void createLink(SftpSubsystemProxy subsystem, Path link, Path existing, boolean symLink) throws IOException {
        if (symLink) {
            Files.createSymbolicLink(link, existing, new FileAttribute[0]);
        } else {
            Files.createLink(link, existing);
        }
    }

    default public String resolveLinkTarget(SftpSubsystemProxy subsystem, Path link) throws IOException {
        Path target = Files.readSymbolicLink(link);
        return target.toString();
    }

    default public void renameFile(SftpSubsystemProxy subsystem, Path oldPath, Path newPath, Collection<CopyOption> opts) throws IOException {
        Files.move(oldPath, newPath, GenericUtils.isEmpty(opts) ? IoUtils.EMPTY_COPY_OPTIONS : opts.toArray(new CopyOption[opts.size()]));
    }

    default public void copyFile(SftpSubsystemProxy subsystem, Path src, Path dst, Collection<CopyOption> opts) throws IOException {
        if (this.noFollow(opts)) {
            try (SeekableByteChannel srcFile = SftpFileSystemAccessor.seekableByteChannelNoLinkFollow(src, Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);){
                if (!(srcFile instanceof FileChannel)) {
                    throw new UnsupportedOperationException("Host file system must return a file channel");
                }
                try (SeekableByteChannel dstFile = SftpFileSystemAccessor.seekableByteChannelNoLinkFollow(src, new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE)), new FileAttribute[0]);){
                    ((FileChannel)srcFile).transferTo(0L, srcFile.size(), dstFile);
                }
            }
            return;
        }
        Files.copy(src, dst, GenericUtils.isEmpty(opts) ? IoUtils.EMPTY_COPY_OPTIONS : opts.toArray(new CopyOption[opts.size()]));
    }

    public static SeekableByteChannel seekableByteChannelNoLinkFollow(Path src, Set<? extends OpenOption> opts, FileAttribute<?> ... fileAttributes) throws IOException {
        Path toResolve;
        if (src.getNameCount() < 1) {
            throw new IllegalArgumentException();
        }
        Path path = toResolve = src.isAbsolute() ? src : src.getFileSystem().getPath(src.toString(), new String[0]);
        if (!Files.isDirectory(src.getParent(), LinkOption.NOFOLLOW_LINKS)) {
            throw new FileNotFoundException(src.getParent().toString());
        }
        toResolve = toResolve.normalize();
        try (SecureDirectoryStream<Path> ds = SftpFileSystemAccessor.secureResolveDirectoryStream(toResolve.getParent());){
            HashSet<? extends OpenOption> newOpts = new HashSet<OpenOption>(opts);
            newOpts.add(LinkOption.NOFOLLOW_LINKS);
            SeekableByteChannel seekableByteChannel = ds.newByteChannel(toResolve.getName(toResolve.getNameCount() - 1), newOpts, fileAttributes);
            return seekableByteChannel;
        }
    }

    public static SecureDirectoryStream<Path> secureResolveDirectoryStream(Path toResolve) throws IOException {
        toResolve = IoUtils.removeCdUpAboveRoot(toResolve);
        DirectoryStream<Path> ds = Files.newDirectoryStream(toResolve.getRoot());
        for (int i = 0; i < toResolve.getNameCount(); ++i) {
            DirectoryStream<Path> dsOld = ds;
            try {
                ds = SftpFileSystemAccessor.secure(ds).newDirectoryStream(toResolve.getName(i), LinkOption.NOFOLLOW_LINKS);
                dsOld.close();
                continue;
            }
            catch (IOException ex) {
                ds.close();
                throw ex;
            }
        }
        return SftpFileSystemAccessor.secure(ds);
    }

    public static SecureDirectoryStream<Path> secure(DirectoryStream<Path> ds) {
        if (ds instanceof SecureDirectoryStream) {
            return (SecureDirectoryStream)ds;
        }
        throw new UnsupportedOperationException("FS Does not support secure directory streams.");
    }

    default public void removeFile(SftpSubsystemProxy subsystem, Path path, boolean isDirectory) throws IOException {
        Files.delete(path);
    }

    default public boolean noFollow(Collection<?> opts) {
        for (Object opt : opts) {
            if (!LinkOption.NOFOLLOW_LINKS.equals(opt)) continue;
            return true;
        }
        return false;
    }
}

