/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.Utils;
import com.corionis.els.hints.Hint;
import com.corionis.els.repository.Item;
import com.corionis.els.repository.Library;
import com.corionis.els.repository.Location;
import com.corionis.els.repository.Repository;
import com.corionis.els.sftp.ClientSftp;
import com.corionis.els.storage.Storage;
import com.corionis.els.storage.Target;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Transfer {
    private final transient Logger logger = LogManager.getLogger("applog");
    private Context context;
    private int copyCount = 0;
    private String currentGroupName = "";
    private long grandTotalItems = 0L;
    private long grandTotalOriginalLocation = 0L;
    private long grandTotalSize = 0L;
    private boolean isInitialized = false;
    private String lastGroupName = "";
    private Storage storageTargets = null;
    private boolean toIsNew = false;

    public Transfer(Context context) {
        this.context = context;
    }

    public synchronized void copyFile(ClientSftp sftp, String from, FileTime filetime, String to, boolean isRemote, boolean overwrite) throws Exception {
        if (isRemote) {
            sftp.transmitFile(from, to, overwrite);
            if (this.context.cfg.isPreserveDates() && filetime != null) {
                sftp.setDate(to, (int)filetime.to(TimeUnit.SECONDS));
            }
        } else {
            File f;
            from = Utils.getFullPathLocal(from);
            if (to.matches("^\\\\[a-zA-Z]:.*") || to.matches("^/[a-zA-Z]:.*")) {
                to = to.substring(1);
            }
            if ((f = new File(to = Utils.getFullPathLocal(to))) != null) {
                f.getParentFile().mkdirs();
            }
            File fileIn = new File(from);
            File fileOut = new File(to);
            long size = fileIn.length();
            byte[] buffer = new byte[32755];
            int received = 0;
            if (this.context.progress != null) {
                this.context.progress.init(2, from, to, size);
            }
            FileInputStream fin = new FileInputStream(fileIn);
            FileOutputStream fout = new FileOutputStream(fileOut);
            while ((received = fin.read(buffer)) != -1 && (this.context.progress == null || this.context.progress.count(received))) {
                fout.write(buffer, 0, received);
            }
            fin.close();
            fout.close();
            if (this.context.progress != null) {
                this.context.progress.end();
            }
            if (this.context.cfg.isPreserveDates() && filetime != null) {
                fileOut.setLastModified(filetime.toMillis());
            }
        }
    }

    public String copyGroup(ArrayList<Item> group, long totalSize, boolean overwrite, PrintWriter whatsNewFile, PrintWriter whatsNewFileHtml, PrintWriter mismatchFile, PrintWriter mismatchFileHtml) throws Exception {
        Object response = "";
        if (!this.context.cfg.isTargetsEnabled()) {
            throw new MungeException(this.context.cfg.gs("Transfer.t.target.is.required.for.this.operation"));
        }
        if (group.size() > 0) {
            for (Item groupItem : group) {
                if (this.context.cfg.isDryRun()) {
                    ++this.copyCount;
                    ++this.grandTotalItems;
                    this.grandTotalSize += groupItem.getSize();
                    this.logger.info("  > " + this.context.cfg.gs("Transfer.would.copy") + " #" + this.copyCount + ", " + Utils.formatLong(groupItem.getSize(), false, this.context.cfg.getLongScale()) + ", " + groupItem.getFullPath());
                    continue;
                }
                String targetPath = this.getTarget(groupItem.getLibrary(), this.context.cfg.isRemoteOperation(), totalSize, groupItem.getItemPath());
                if (targetPath != null) {
                    ++this.copyCount;
                    totalSize -= groupItem.getSize();
                    String to = targetPath + this.context.subscriberRepo.getWriteSeparator();
                    to = to + this.context.subscriberRepo.normalizePath(this.context.subscriberRepo.getLibraryData().libraries.flavor, groupItem.getItemPath());
                    String msg = "  > " + this.context.cfg.gs("Transfer.copying") + " #" + this.copyCount + ", " + Utils.formatLong(groupItem.getSize(), false, this.context.cfg.getLongScale()) + ", " + groupItem.getFullPath() + this.context.cfg.gs("NavTransferHandler.transfer.file.to") + to;
                    this.logger.info(msg);
                    response = (String)response + msg + "\r\n";
                    this.copyFile(this.context.clientSftp, groupItem.getFullPath(), groupItem.getModifiedDate(), to, this.context.cfg.isRemoteOperation(), overwrite);
                    ++this.grandTotalItems;
                    this.grandTotalSize += groupItem.getSize();
                    if (mismatchFile == null) continue;
                    mismatchFile.println("    " + to);
                    mismatchFileHtml.println("&nbsp;&nbsp;&nbsp;&nbsp;" + to + "<br/>");
                    continue;
                }
                response = MessageFormat.format(this.context.cfg.gs("Transfer.no.space.on.any.target.location"), group.get(0).getLibrary(), this.lastGroupName, Utils.formatLong(totalSize, false, this.context.cfg.getLongScale()), groupItem.getItemShortName());
                this.logger.warn((String)response);
                if (this.context.process != null) {
                    this.context.process.setWarnings(this.context.process.getWarnings() + 1);
                }
                if (whatsNewFile != null) {
                    whatsNewFile.println(this.context.cfg.gs("Z.warning") + (String)response);
                    whatsNewFileHtml.println(this.context.cfg.gs("Z.warning") + (String)response);
                }
                if (mismatchFile == null) break;
                mismatchFile.println(this.context.cfg.gs("Z.warning") + (String)response);
                mismatchFileHtml.println(this.context.cfg.gs("Z.warning") + (String)response);
                break;
            }
        }
        this.lastGroupName = this.currentGroupName;
        group.clear();
        return response;
    }

    public int getCopyCount() {
        return this.copyCount;
    }

    public String getCurrentGroupName() {
        return this.currentGroupName;
    }

    public long getFreespace(String path, boolean isRemote) throws Exception {
        long space = isRemote && !this.context.localMode ? this.context.clientStty.availableSpace(this.context.cfg.getFullPathSubscriber(path)) : Utils.availableSpace(Utils.getFullPathLocal(path));
        return space;
    }

    public long getGrandTotalItems() {
        return this.grandTotalItems;
    }

    public long getGrandTotalOriginalLocation() {
        return this.grandTotalOriginalLocation;
    }

    public long getGrandTotalSize() {
        return this.grandTotalSize;
    }

    public String getLastGroupName() {
        return this.lastGroupName;
    }

    private long getLocationMinimum(Repository targetRepo, String path) {
        long minimum = 0L;
        if (targetRepo.getLibraryData().libraries.locations != null) {
            path = Utils.pipe(path);
            for (Location location : targetRepo.getLibraryData().libraries.locations) {
                String loc = Utils.pipe(location.location);
                boolean match = false;
                match = Utils.isRelativePath(loc) ? path.contains(loc) : path.startsWith(loc);
                if (!match) continue;
                minimum = Utils.getScaledValue(location.minimum);
                break;
            }
        }
        if (minimum < 1L) {
            minimum = 0x280000000L;
        }
        return minimum;
    }

    private void getStorageTargets() throws Exception {
        String location = null;
        if (this.context.cfg.isRemoteOperation() && this.context.cfg.isRequestTargets()) {
            location = this.context.clientStty.retrieveRemoteData("targets", this.context.cfg.gs("Transfer.requesting.subscriber.targets"), 20000);
            this.context.cfg.setTargetsFilename(location);
        }
        if (location != null && location.length() > 0) {
            if (this.storageTargets == null) {
                this.storageTargets = new Storage();
            }
            this.storageTargets.read(location, this.context.subscriberRepo.getLibraryData().libraries.flavor);
            if (!this.context.cfg.isRemoteOperation()) {
                this.storageTargets.validate();
            }
        }
    }

    private String getTarget(String library, boolean isRemote, long totalSize, String itemPath) throws Exception {
        String path = this.getTarget(this.context.publisherRepo, library, totalSize, this.context.subscriberRepo, isRemote, itemPath);
        return path;
    }

    public synchronized String getTarget(Repository sourceRepo, String library, long totalSize, Repository targetRepo, boolean isRemote, String itemPath) throws Exception {
        String path = null;
        boolean notFound = true;
        long minimum = 0L;
        Target target = null;
        if (this.storageTargets != null) {
            target = this.storageTargets.getLibraryTarget(library);
        }
        if (target != null) {
            minimum = Utils.getScaledValue(target.minimum);
        }
        if (!this.context.cfg.isNoBackFill() && (path = targetRepo.hasDirectory(library, Utils.pipe(itemPath))) != null) {
            if (this.itFits(targetRepo, path, isRemote, totalSize, minimum, target != null)) {
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Transfer.using.original.storage.location"), itemPath, path));
                ++this.grandTotalOriginalLocation;
                return path;
            }
            this.logger.info(MessageFormat.format(this.context.cfg.gs("Transfer.original.storage.location.too.full"), itemPath, Utils.formatLong(totalSize, false, this.context.cfg.getLongScale()), path));
            path = null;
        }
        if (target != null) {
            notFound = false;
            for (int j = 0; j < target.locations.length; ++j) {
                String candidate = target.locations[j];
                if (!this.itFits(targetRepo, candidate, isRemote, totalSize, minimum, true)) continue;
                path = candidate;
                break;
            }
        } else {
            Library lib = targetRepo.getLibrary(library);
            if (lib != null) {
                notFound = false;
                for (int j = 0; j < lib.sources.length; ++j) {
                    String candidate = this.context.cfg.makeFullPath(targetRepo, lib.sources[j]);
                    if (!this.itFits(targetRepo, candidate, isRemote, totalSize, minimum, false)) continue;
                    path = candidate;
                    break;
                }
            }
        }
        if (notFound) {
            this.logger.error(this.context.cfg.gs("Transfer.no.target.library.match.found.for.library") + library);
        }
        return path;
    }

    public void initialize() throws Exception {
        if (!this.isInitialized) {
            this.isInitialized = true;
            if (this.context.cfg.isRemotePublishOperation() || this.context.cfg.isPublisherListener()) {
                if (this.context.publisherRepo.getLibraryData().libraries.flavor == null || this.context.publisherRepo.getLibraryData().libraries.flavor.length() < 1) {
                    throw new MungeException(this.context.cfg.gs("Transfer.publisher.data.incomplete.missing.flavor"));
                }
                if (this.context.subscriberRepo.getLibraryData().libraries.flavor == null || this.context.subscriberRepo.getLibraryData().libraries.flavor.length() < 1) {
                    throw new MungeException(this.context.cfg.gs("Transfer.subscriber.data.incomplete.missing.flavor"));
                }
                if (this.context.clientStty != null) {
                    if (this.context.clientStty.checkBannerCommands()) {
                        this.logger.info(this.context.cfg.gs("Transfer.received.subscriber.commands") + (this.context.cfg.isRequestCollection() ? "RequestCollection " : "") + (this.context.cfg.isRequestTargets() ? "RequestTargets" : ""));
                    }
                    String directory = this.context.clientStty.getWorkingDirectoryRemote();
                    this.context.cfg.setWorkingDirectorySubscriber(directory);
                }
            }
            if (this.context.cfg.isNavigator() && !this.context.cfg.isLoggerView()) {
                if (this.context.cfg.isRemoteOperation() && this.context.clientStty != null) {
                    this.requestLibrary();
                }
            } else {
                if (this.context.cfg.getSubscriberLibrariesFileName().length() > 0 && this.context.cfg.isRemoteOperation() && this.context.cfg.isRequestCollection()) {
                    this.requestCollection();
                }
                if (this.context.cfg.isTargetsEnabled()) {
                    this.logger.info(this.context.cfg.gs("Transfer.requesting.subscriber.targets"));
                    this.getStorageTargets();
                }
            }
        }
    }

    public boolean isNewGrouping(Item publisherItem) throws MungeException {
        boolean ret = true;
        String p = publisherItem.getItemPath();
        String s = this.context.publisherRepo.getSeparator();
        int i = publisherItem.getItemPath().lastIndexOf(this.context.publisherRepo.getSeparator());
        if (i < 0) {
            this.logger.warn(this.context.cfg.gs("Transfer.no.subdirectory.in.path") + publisherItem.getItemPath());
            if (this.context.process != null) {
                this.context.process.setWarnings(this.context.process.getWarnings() + 1);
            }
            return true;
        }
        String path = publisherItem.getItemPath().substring(0, i);
        if (path.length() < 1) {
            path = publisherItem.getItemPath().substring(0, publisherItem.getItemPath().lastIndexOf(this.context.publisherRepo.getSeparator()));
        }
        if (this.currentGroupName.equalsIgnoreCase(path)) {
            ret = false;
        } else {
            this.currentGroupName = path;
        }
        return ret;
    }

    public boolean itFits(Repository targetRepo, String path, boolean isRemote, long totalSize, long minimum, boolean hasTarget) throws Exception {
        boolean fits = false;
        long space = this.getFreespace(path, isRemote);
        if (!hasTarget) {
            minimum = targetRepo.getLibraryData().libraries.locations != null && targetRepo.getLibraryData().libraries.locations.length > 0 ? this.getLocationMinimum(targetRepo, path) : 0x280000000L;
        }
        this.logger.info(MessageFormat.format(this.context.cfg.gs("Transfer.checking"), hasTarget ? 0 : 1, Utils.formatLong(totalSize, false, this.context.cfg.getLongScale()), Utils.formatLong(minimum, false, this.context.cfg.getLongScale()), isRemote ? 0 : 1, path) + Utils.formatLong(space, false, this.context.cfg.getLongScale()));
        if (space > totalSize + minimum) {
            fits = true;
        }
        return fits;
    }

    public boolean makeDirs(String path, boolean isDir, boolean isRemote) throws Exception {
        String create;
        boolean sense = true;
        String string = create = isDir ? path : Utils.getLeftPath(path, null);
        if (isRemote) {
            this.context.clientSftp.makeDirectory(create);
        } else {
            File f;
            if (create.matches("^\\\\[a-zA-Z]:.*") || create.matches("^/[a-zA-Z]:.*")) {
                create = create.substring(1);
            }
            if ((f = new File(create = Utils.getFullPathLocal(create))) != null) {
                sense = f.mkdirs();
            }
        }
        return sense;
    }

    public boolean move(Repository repo, Hint hint) throws Exception {
        Collection collection;
        boolean libAltered = false;
        this.logger.info(MessageFormat.format(this.context.cfg.gs("Transfer.mv.directory.file"), hint.directory ? 0 : 1) + "\"" + hint.fromLibrary + "|" + hint.fromItemPath + "\"" + this.context.cfg.gs("NavTransferHandler.transfer.file.to") + "\"" + hint.toLibrary + "|" + hint.toItemPath + "\"");
        Library fromLib = repo.getLibrary(hint.fromLibrary);
        if (fromLib == null) {
            this.logger.info(this.context.cfg.gs("Transfer.from.library.not.found") + hint.fromLibrary);
            return false;
        }
        Library toLib = repo.getLibrary(hint.toLibrary);
        if (toLib == null) {
            this.logger.info(this.context.cfg.gs("Transfer.to.library.not.found") + hint.toLibrary);
            return false;
        }
        if (!toLib.name.equalsIgnoreCase(fromLib.name) && toLib.items == null) {
            repo.scan(toLib.name);
        }
        if ((collection = repo.getMapItem(fromLib, Utils.pipe(hint.fromItemPath))) != null) {
            Iterator it = collection.iterator();
            if (collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    Integer j = (Integer)it.next();
                    Item fromItem = fromLib.items.elementAt(j);
                    if (fromItem.isDirectory()) {
                        if (!toLib.name.equalsIgnoreCase(fromLib.name)) {
                            for (Item nextItem : fromLib.items) {
                                if (nextItem.isDirectory() || !nextItem.getItemPath().startsWith(fromItem.getItemPath() + repo.getSeparator())) continue;
                                String nextName = nextItem.getItemPath().substring(fromItem.getItemPath().length() + 1);
                                String nextPath = hint.toItemPath + repo.getSeparator() + nextName;
                                if (!this.moveItem(repo, fromLib, nextItem, toLib, nextPath)) continue;
                                fromLib.rescanNeeded = true;
                                toLib.rescanNeeded = true;
                                libAltered = true;
                            }
                            if (this.context.cfg.isDryRun()) continue;
                            File prevDir = new File(Utils.getFullPathLocal(fromItem.getFullPath()));
                            if (Utils.removeDirectoryTree(prevDir)) {
                                this.logger.warn(this.context.cfg.gs("Transfer.previous.directory.was.not.empty") + fromItem.getFullPath());
                            }
                            fromLib.rescanNeeded = true;
                            toLib.rescanNeeded = true;
                            libAltered = true;
                            continue;
                        }
                        if (!this.moveItem(repo, fromLib, fromItem, toLib, hint.toItemPath)) continue;
                        fromLib.rescanNeeded = true;
                        toLib.rescanNeeded = true;
                        libAltered = true;
                        continue;
                    }
                    if (!this.moveItem(repo, fromLib, fromItem, toLib, hint.toItemPath)) continue;
                    fromLib.rescanNeeded = true;
                    toLib.rescanNeeded = true;
                    libAltered = true;
                }
            } else {
                this.logger.info(this.context.cfg.gs("Transfer.does.not.exist.skipping") + hint.fromLibrary + "|" + hint.fromItemPath);
            }
        } else {
            this.logger.info(this.context.cfg.gs("Transfer.does.not.exist.skipping") + hint.fromLibrary + "|" + hint.fromItemPath);
        }
        return libAltered;
    }

    public synchronized void moveFile(String from, FileTime filetime, String to, boolean overwrite) throws Exception {
        Path fromPath = Paths.get(Utils.getFullPathLocal(from), new String[0]);
        Path toPath = Paths.get(Utils.getFullPathLocal(to), new String[0]);
        File f = new File(Utils.getFullPathLocal(to));
        if (f != null) {
            f.getParentFile().mkdirs();
        }
        Files.move(fromPath, toPath, overwrite ? StandardCopyOption.REPLACE_EXISTING : null);
        if (this.context.cfg.isPreserveDates() && filetime != null) {
            this.touch(to, false);
        }
    }

    private boolean moveItem(Repository repo, Library fromLib, Item fromItem, Library toLib, String toName) throws Exception {
        boolean libAltered = false;
        Item toItem = this.setupToItem(repo, fromLib, fromItem, toLib, toName);
        String fromPath = repo.normalizePath(repo.getLibraryData().libraries.flavor, fromItem.getFullPath());
        File fromFile = new File(Utils.getFullPathLocal(fromPath));
        if (fromFile.exists()) {
            String toPath = repo.normalizePath(repo.getLibraryData().libraries.flavor, toItem.getFullPath());
            if (this.context.cfg.isDryRun()) {
                this.logger.info(MessageFormat.format(this.context.cfg.gs("Transfer.would.mv.directory.file"), fromItem.isDirectory() ? 0 : 1) + "\"" + fromLib.name + "|" + fromPath + "\"" + this.context.cfg.gs("NavTransferHandler.transfer.file.to") + "\"" + toLib.name + "|" + toPath + "\"");
                return false;
            }
            File toFile = new File(Utils.getFullPathLocal(toPath));
            if (toFile.exists()) {
                this.logger.info(this.context.cfg.gs("Transfer.target.exists.will.overwrite") + toItem.getFullPath());
            }
            if (toFile.getParentFile().mkdirs()) {
                toLib.rescanNeeded = true;
                libAltered = true;
            }
            Files.move(fromFile.toPath(), toFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            libAltered = true;
        } else {
            this.logger.info(this.context.cfg.gs("Transfer.does.not.exist.skipping") + fromItem.getFullPath());
        }
        return libAltered;
    }

    public void remove(String path, boolean isRemote) throws Exception {
        block6: {
            if (isRemote) {
                String response = this.context.clientStty.roundTrip("remove \"" + path + "\"", "", 10000);
                if (response != null && !response.equals("true")) {
                    this.logger.warn("Remote delete failed: " + path);
                }
            } else {
                try {
                    if (path.matches("^\\\\[a-zA-Z]:.*") || path.matches("^/[a-zA-Z]:.*")) {
                        path = path.substring(1);
                    }
                    Path fromPath = Paths.get(Utils.getFullPathLocal(path), new String[0]);
                    Files.delete(fromPath);
                }
                catch (Exception e) {
                    if (e instanceof NoSuchFileException) break block6;
                    this.logger.error(Utils.getStackTrace(e));
                }
            }
        }
    }

    public boolean remove(Repository repo, Hint hint) throws Exception {
        boolean libAltered = false;
        Library fromLib = repo.getLibrary(hint.fromLibrary);
        if (fromLib == null) {
            this.logger.info(this.context.cfg.gs("Transfer.from.library.not.found") + hint.fromLibrary);
            return false;
        }
        Collection collection = repo.getMapItem(fromLib, Utils.pipe(hint.fromItemPath));
        if (collection != null) {
            Iterator it = collection.iterator();
            if (collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    String rmPath;
                    Integer j = (Integer)it.next();
                    Item fromItem = fromLib.items.elementAt(j);
                    if (fromItem.isDirectory()) {
                        if (this.context.cfg.isDryRun()) {
                            this.logger.info(this.context.cfg.gs("Transfer.would.rm.directory") + "\"" + hint.fromLibrary + "|" + fromItem.getFullPath() + "\"");
                            continue;
                        }
                        rmPath = repo.normalizePath(repo.getLibraryData().libraries.flavor, fromItem.getFullPath());
                        File rmdir = new File(Utils.getFullPathLocal(rmPath));
                        if (Utils.removeDirectoryTree(rmdir)) {
                            this.logger.warn(this.context.cfg.gs("Transfer.previous.directory.was.not.empty") + fromItem.getFullPath());
                        }
                        this.logger.info(this.context.cfg.gs("Transfer.rm.directory") + "\"" + fromItem.getFullPath() + "\"");
                        fromLib.rescanNeeded = true;
                        libAltered = true;
                        continue;
                    }
                    if (this.context.cfg.isDryRun()) {
                        this.logger.info(this.context.cfg.gs("Transfer.would.rm.file") + hint.fromLibrary + "|" + fromItem.getFullPath());
                        continue;
                    }
                    rmPath = repo.normalizePath(repo.getLibraryData().libraries.flavor, fromItem.getFullPath());
                    File rmFile = new File(Utils.getFullPathLocal(rmPath));
                    if (!rmFile.delete()) continue;
                    this.logger.info(this.context.cfg.gs("Transfer.rm.file") + "\"" + fromItem.getFullPath() + "\"");
                    fromLib.rescanNeeded = true;
                    libAltered = true;
                }
            } else {
                this.logger.info(this.context.cfg.gs("Transfer.does.not.exist.skipping") + hint.fromLibrary + "|" + hint.fromItemPath);
            }
        } else {
            this.logger.info(this.context.cfg.gs("Transfer.does.not.exist.skipping") + hint.fromLibrary + "|" + hint.fromItemPath);
        }
        return libAltered;
    }

    public void rename(String from, String to, boolean isRemote) throws Exception {
        if (isRemote) {
            this.context.clientSftp.rename(from, to);
        } else {
            if (to.matches("^\\\\[a-zA-Z]:.*") || to.matches("^/[a-zA-Z]:.*")) {
                to = to.substring(1);
            }
            Files.move(Paths.get(Utils.getFullPathLocal(from), new String[0]), Paths.get(Utils.getFullPathLocal(to), new String[0]), StandardCopyOption.ATOMIC_MOVE);
        }
    }

    public void requestCollection() throws Exception {
        if (this.context.cfg.isRemoteOperation()) {
            String log = MessageFormat.format(this.context.cfg.gs("Transfer.requesting.subscriber.collection"), this.context.subscriberRepo.getLibraryData().libraries.description);
            String location = this.context.clientStty.retrieveRemoteData("collection", log, -1);
            if (location == null || location.length() < 1) {
                throw new MungeException(this.context.cfg.gs("Transfer.could.not.retrieve.remote.collection.file"));
            }
            this.context.cfg.setSubscriberLibrariesFileName("");
            this.context.cfg.setSubscriberCollectionFilename(location);
            this.context.subscriberRepo.read(this.context.cfg.getSubscriberCollectionFilename(), "Subscriber", true);
        }
    }

    public void requestLibrary() throws Exception {
        if (this.context.cfg.isRemoteOperation()) {
            String log = MessageFormat.format(this.context.cfg.gs("Transfer.requesting.subscriber.library"), this.context.subscriberRepo.getLibraryData().libraries.description);
            String location = this.context.clientStty.retrieveRemoteData("library", log, 20000);
            if (location == null || location.length() < 1) {
                throw new MungeException(this.context.cfg.gs("Transfer.could.not.retrieve.remote.library.file"));
            }
            this.context.cfg.setSubscriberCollectionFilename("");
            this.context.cfg.setSubscriberLibrariesFileName(location);
            this.context.subscriberRepo.read(this.context.cfg.getSubscriberLibrariesFileName(), "Subscriber", true);
            this.context.subscriberRepo.setDynamic(true);
        }
    }

    private Item setupToItem(Repository repo, Library fromLib, Item fromItem, Library toLib, String toName) throws Exception {
        Object path;
        Item toItem;
        this.toIsNew = false;
        if (!toLib.name.equalsIgnoreCase(fromLib.name)) {
            toItem = repo.hasItem(fromItem, toLib.name, Utils.pipe(repo, toName));
            if (toItem == null) {
                this.toIsNew = true;
                toItem = SerializationUtils.clone(fromItem);
                toItem.setLibrary(toLib.name);
                toItem.setItemPath(toName);
                path = this.getTarget(repo, toItem.getLibrary(), toItem.getSize(), repo, false, toItem.getItemPath());
                path = (String)path + repo.getSeparator() + toName;
            } else {
                toItem.setLibrary(toLib.name);
                toItem.setItemPath(toName);
                String base = toItem.getFullPath().substring(0, toItem.getFullPath().length() - fromItem.getItemPath().length());
                path = base + toName;
            }
        } else {
            toItem = SerializationUtils.clone(fromItem);
            toItem.setItemPath(toName);
            String base = toItem.getFullPath().substring(0, toItem.getFullPath().length() - fromItem.getItemPath().length());
            path = base + toName;
        }
        toItem.setFullPath((String)path);
        return toItem;
    }

    public long touch(String path, boolean isRemote) throws Exception {
        long millis = System.currentTimeMillis();
        if (isRemote) {
            this.context.clientSftp.setDate(path, (int)(millis / 1000L));
        } else {
            if (path.matches("^\\\\[a-zA-Z]:.*") || path.matches("^/[a-zA-Z]:.*")) {
                path = path.substring(1);
            }
            Path file = Paths.get(Utils.getFullPathLocal(path), new String[0]);
            FileTime ft = FileTime.fromMillis(millis);
            Files.setLastModifiedTime(file, ft);
        }
        return millis /= 1000L;
    }
}

