/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els;

import com.corionis.els.Context;
import com.corionis.els.MungeException;
import com.corionis.els.gui.Preferences;
import com.corionis.els.gui.browser.NavTreeNode;
import com.corionis.els.repository.Repository;
import com.google.gson.Gson;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.sshd.common.util.io.IoUtils;

public class Utils {
    private static Logger logger = LogManager.getLogger("applog");

    private Utils() {
    }

    public static synchronized long availableSpace(String location) {
        long space = 0L;
        try {
            do {
                File f;
                if (!(f = new File(location)).exists()) continue;
                space = f.getUsableSpace();
                break;
            } while ((location = Utils.getLeftPath(location, Utils.getSeparatorFromPath(location))).length() != 0);
        }
        catch (SecurityException e) {
            logger.error("Exception '" + e.getMessage() + "' getting usable space from " + location);
        }
        return space;
    }

    public static String compactString(String value) {
        String bad = "\\.[]{}()<>*+-=!?^$| ";
        Object clean = "";
        for (int i = 0; i < value.length(); ++i) {
            boolean skip = false;
            for (int j = 0; j < bad.length(); ++j) {
                if (value.charAt(i) != bad.charAt(j)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            clean = (String)clean + value.charAt(i);
        }
        return clean;
    }

    public static int compareTreePaths(TreePath tp1, TreePath tp2) {
        String[] sa1 = Utils.getTreePathStringArray(tp1);
        String[] sa2 = Utils.getTreePathStringArray(tp2);
        int max = Integer.min(sa1.length, sa2.length);
        for (int i = 0; i < max; ++i) {
            int comp = sa1[i].compareTo(sa2[i]);
            if (comp == 0) continue;
            return comp;
        }
        if (tp1.getPathCount() < tp2.getPathCount()) {
            return -1;
        }
        if (tp1.getPathCount() > tp2.getPathCount()) {
            return 1;
        }
        return 0;
    }

    public static String concatStringArray(String[] array, String divider) {
        Object result = "";
        for (int i = 0; i < array.length; ++i) {
            result = array[i].length() == 0 ? (String)result + "?" : (String)result + array[i];
            if (i + 1 >= array.length) continue;
            result = (String)result + divider;
        }
        return result;
    }

    public static synchronized String ellipseFileString(Component component, String text) {
        int max;
        FontMetrics metrics = component.getFontMetrics(component.getFont());
        int width = metrics.stringWidth((String)text);
        if (width > (max = component.getWidth()) && ((String)text).length() > 4) {
            String ext = Utils.getFileExtension((String)text);
            int l = metrics.stringWidth(ext);
            max = max - l - 4;
            text = ((String)text).substring(0, ((String)text).length() - ext.length());
            while (width > max && ((String)text).length() > 4) {
                text = StringUtils.abbreviate((String)text, ((String)text).length() - 1);
                width = metrics.stringWidth((String)text);
            }
            text = (String)text + ext;
        }
        return text;
    }

    public static String formatAddresses(Socket socket) {
        return socket.getInetAddress().toString() + ":" + socket.getPort() + ", local " + socket.getLocalAddress().toString() + ":" + socket.getLocalPort();
    }

    public static String formatDuration(long seconds) {
        Duration duration = Duration.ofSeconds(seconds);
        int hours = duration.toHoursPart();
        int mins = duration.toMinutesPart();
        int secs = duration.toSecondsPart();
        String fd = (String)(hours > 0 ? hours + "h " : "") + (String)(mins > 0 ? mins + "m " : "") + (String)(secs > 0 ? secs + "s" : "");
        return fd;
    }

    public static synchronized String formatHex(int value, int width) {
        Object result = Integer.toHexString(value);
        while (((String)result).length() < width) {
            result = "0" + (String)result;
        }
        return result;
    }

    public static synchronized String formatInteger(int value) {
        DecimalFormat form = new DecimalFormat("###,###,###,###");
        return form.format(value);
    }

    public static synchronized String formatLong(long value, boolean isFull, double scale) {
        String brief;
        DecimalFormat longForm = new DecimalFormat("###,###,###,###,###,###,###,###.###");
        DecimalFormat shortForm = new DecimalFormat("###,###,###,###,###,###,###,###.#");
        String full = brief = shortForm.format(value) + " B";
        if ((double)value >= scale) {
            brief = shortForm.format((double)value / scale) + " KB";
            full = full + ", " + brief;
        }
        if ((double)value >= scale * scale) {
            brief = shortForm.format((double)value / (scale * scale)) + " MB";
            full = full + ", " + brief;
        }
        if ((double)value >= scale * scale * scale) {
            brief = shortForm.format((double)value / (scale * scale * scale)) + " GB";
            full = full + ", " + brief;
        }
        if ((double)value >= scale * scale * scale * scale) {
            brief = longForm.format((double)value / (scale * scale * scale * scale)) + " TB";
            full = full + ", " + brief;
        }
        return isFull ? full : brief;
    }

    public static synchronized String formatRate(long value, double scale) {
        DecimalFormat form = new DecimalFormat("###,###,###,###,###,###,###,###.##");
        String result = form.format(value) + " bps";
        if ((double)value >= scale) {
            result = form.format((double)value / scale) + " Kbs";
        }
        if ((double)value >= scale * scale) {
            result = form.format((double)value / (scale * scale)) + " Mbps";
        }
        if ((double)value >= scale * scale * scale) {
            result = form.format((double)value / (scale * scale * scale)) + " Gbps";
        }
        if ((double)value >= scale * scale * scale * scale) {
            result = form.format((double)value / (scale * scale * scale * scale)) + " Tbps";
        }
        return result;
    }

    public static String getFullPathLocal(String filename) {
        if (filename.matches("^\\\\[a-zA-Z]:.*") || filename.matches("^/[a-zA-Z]:.*")) {
            filename = filename.substring(1);
        }
        Object location = Utils.isRelativePath(filename) ? System.getProperty("user.dir") + System.getProperty("file.separator") + filename : filename;
        location = Utils.pipe((String)location);
        location = Utils.unpipe((String)location, System.getProperty("file.separator"));
        return location;
    }

    public static synchronized String getDuration(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Duration must be greater than zero!");
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        if (days > 0L) {
            sb.append(days);
            sb.append(" days ");
        }
        if (hours > 0L) {
            sb.append(hours);
            sb.append(" hrs ");
        }
        if (minutes > 0L) {
            sb.append(minutes);
            sb.append(" mins ");
        }
        sb.append(seconds);
        sb.append(" secs");
        return sb.toString();
    }

    public static synchronized String getFileExtension(String name) {
        String ext = "";
        int i = name.lastIndexOf(".");
        if (i > 0) {
            ext = name.substring(i + 1);
        }
        return ext;
    }

    public static synchronized String getFileSeparator(String flavor) {
        String separator = "";
        if (flavor.equalsIgnoreCase("Windows")) {
            separator = "\\";
        } else if (flavor.equalsIgnoreCase("Linux")) {
            separator = "/";
        } else if (flavor.equalsIgnoreCase("Mac")) {
            separator = "/";
        }
        return separator;
    }

    public static synchronized String getHostname() {
        Object hostname = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
            int i = ((String)hostname).indexOf(".");
            if (i > 0) {
                hostname = ((String)hostname).substring(0, i);
            }
            hostname = ((String)hostname).toLowerCase();
            hostname = ((String)hostname).substring(0, 1).toUpperCase() + ((String)hostname).substring(1);
        }
        catch (UnknownHostException ex) {
            hostname = "";
        }
        return hostname;
    }

    public static synchronized String getLastExistingPath(String full, String sep) {
        File file;
        String path = full;
        if (sep == null) {
            sep = Utils.getSeparatorFromPath(full);
        }
        while (path.length() > 0 && !(file = new File(path)).exists()) {
            path = Utils.getLeftPath(path, sep);
        }
        return path;
    }

    public static synchronized String getLastPath(String full, String sep) {
        int p;
        String path = "";
        if (sep == null) {
            sep = Utils.getSeparatorFromPath(full);
        }
        path = (p = (full = Utils.pipe(full)).indexOf("|")) >= 0 ? full.substring(0, p) : full;
        path = Utils.unpipe(path, sep);
        return path;
    }

    public static synchronized String getLeftPath(String full, String sep) {
        int p;
        String path = "";
        if (sep == null) {
            sep = Utils.getSeparatorFromPath(full);
        }
        path = (p = (full = Utils.pipe(full)).lastIndexOf("|")) >= 0 ? full.substring(0, p) : full;
        path = Utils.unpipe(path, sep);
        return path;
    }

    public static synchronized FileTime getLocalFileTime(String path) {
        if (path != null && path.length() > 0) {
            try {
                return Files.getLastModifiedTime(Paths.get(path, new String[0]), new LinkOption[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FileTime.from(0L, TimeUnit.SECONDS);
    }

    public static String getLocalHardDrives() {
        File[] drives = File.listRoots();
        Object driveList = "";
        for (int i = 0; i < drives.length; ++i) {
            File drive = drives[i];
            boolean empty = false;
            try {
                FileStore fileStore = Files.getFileStore(drive.toPath());
            }
            catch (IOException ioe) {
                empty = true;
            }
            if (empty) continue;
            if (i > 0) {
                driveList = (String)driveList + "|";
            }
            driveList = (String)driveList + drive.getPath();
        }
        return driveList;
    }

    public static synchronized int getLocalPermissions(String thing) {
        int perms = 0;
        Path p = Paths.get(thing, new String[0]);
        if (Files.isWritable(p)) {
            perms = 644;
        }
        if (Files.isExecutable(p)) {
            perms = 755;
        }
        return perms;
    }

    public static String getOS() {
        String os = System.getProperty("os.name");
        os = os.toLowerCase().startsWith("windows") ? "Windows" : (os.toLowerCase().startsWith("mac") ? "Mac" : "Linux");
        return os;
    }

    public static synchronized int getPort(String site) {
        int port = 0;
        String sport = Utils.parsePort(site);
        if (sport == null || sport.length() < 1) {
            sport = "50271";
            logger.info(site + " port not defined, using default: " + sport);
        }
        if ((port = Integer.valueOf(sport).intValue()) < 1) {
            logger.info(site + " is disabled, port < 1");
        }
        return port;
    }

    public static Point getRelativePosition(Window parent, Window window) {
        Point parentPos = parent.getLocation();
        Dimension parentSize = parent.getSize();
        Dimension mySize = window.getSize();
        Point center = new Point(parentPos.x + parentSize.width / 2, parentPos.y + parentSize.height / 2);
        int x = center.x - mySize.width / 2;
        int y = center.y - mySize.height / 2;
        Point position = new Point(x, y);
        return position;
    }

    public static synchronized String getRightPath(String full, String sep) {
        int p;
        String path = "";
        if (sep == null) {
            sep = Utils.getSeparatorFromPath(full);
        }
        if ((p = (full = Utils.pipe(full)).lastIndexOf("|")) >= 0 && p < full.length() - 1) {
            path = full.substring(p + 1);
        }
        if (path.length() == 0) {
            path = full;
        }
        path = Utils.unpipe(path, sep);
        return path;
    }

    public static synchronized long getScaledValue(String size) {
        long returnValue = -1L;
        Pattern patt = Pattern.compile("([\\d.]+)([TGMK]B)", 2);
        Matcher matcher = patt.matcher(size);
        HashMap<String, Integer> powerMap = new HashMap<String, Integer>();
        powerMap.put("TB", 4);
        powerMap.put("GB", 3);
        powerMap.put("MB", 2);
        powerMap.put("KB", 1);
        if (matcher.find()) {
            String number = matcher.group(1);
            int pow = (Integer)powerMap.get(matcher.group(2).toUpperCase());
            BigDecimal bytes = new BigDecimal(number);
            bytes = bytes.multiply(BigDecimal.valueOf(1024L).pow(pow));
            returnValue = bytes.longValue();
        }
        return returnValue;
    }

    public static synchronized String getSeparatorFromPath(String path) {
        String separator = "";
        if (path.contains("\\")) {
            separator = "\\";
        } else if (path.contains("/")) {
            separator = "/";
        } else if (path.contains(":")) {
            separator = ":";
        }
        return separator;
    }

    public static synchronized String getShortPath(String full, String sep) {
        String path = "";
        int p = (full = Utils.pipe(full)).lastIndexOf("|");
        path = p >= 0 ? (full.length() > p + 1 ? full.substring(p + 1) : full.substring(0, p)) : full;
        path = Utils.unpipe(path, sep);
        return path;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getStampedFilename(Repository repo, String filename) {
        Object stamped = "";
        if (repo.getLibraryData().libraries.temp_dated != null && repo.getLibraryData().libraries.temp_dated.booleanValue()) {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
            LocalDateTime now = LocalDateTime.now();
            stamped = filename + "-" + dtf.format(now);
        } else {
            stamped = filename;
        }
        return stamped;
    }

    public static String getTempUpdaterDirectory() {
        Object path = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "ELS_Updater_" + System.getProperty("user.name");
        path = Utils.pipe((String)path);
        path = ((String)path).replaceAll("\\|\\|", "|");
        path = Utils.unpipe((String)path, System.getProperty("file.separator"));
        return path;
    }

    public static String getTemporaryFilePrefix(Repository repo, String filename) {
        String sep;
        Object location = filename;
        Object path = "";
        path = repo.getLibraryData().libraries.temp_location != null && repo.getLibraryData().libraries.temp_location.length() > 0 ? repo.getLibraryData().libraries.temp_location : "output";
        if (!((String)path).endsWith(sep = repo.getSeparator())) {
            path = (String)path + sep;
        }
        location = (String)path + filename;
        location = Utils.getFullPathLocal((String)location);
        return location;
    }

    public static String[] getTreePathStringArray(TreePath tp) {
        String[] ps = null;
        if (tp.getPathCount() > 0) {
            ps = new String[tp.getPathCount()];
            Object[] objs = tp.getPath();
            for (int i = 0; i < tp.getPathCount(); ++i) {
                NavTreeNode node = (NavTreeNode)objs[i];
                ps[i] = node.getUserObject().name;
            }
        }
        return ps;
    }

    public static synchronized Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static boolean isFileOnly(String path) {
        return !path.contains("/") && !path.contains("\\") && !path.contains("|");
    }

    public static boolean isOffScreen(int locX, int locY) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = ge.getScreenDevices();
        for (int screenIndex = 0; screenIndex < devices.length; ++screenIndex) {
            Rectangle bounds = devices[screenIndex].getDefaultConfiguration().getBounds();
            if (!bounds.contains(locX, locY)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOnScreen(int locX, int locY) {
        return !Utils.isOffScreen(locX, locY);
    }

    public static boolean isOsLinux() {
        return Utils.getOS().equalsIgnoreCase("linux");
    }

    public static boolean isOsMac() {
        return Utils.getOS().equalsIgnoreCase("mac");
    }

    public static boolean isOsWindows() {
        return Utils.getOS().equalsIgnoreCase("windows");
    }

    public static boolean isRelativePath(String path) {
        if (path.matches("^[a-zA-Z]:.*")) {
            return false;
        }
        return !path.startsWith("/") && !path.startsWith("\\") && !path.startsWith("|");
    }

    public static String makeLinuxPath(String path) {
        path = Utils.pipe(path);
        path = Utils.unpipe(path, "/");
        return path;
    }

    public static String makeRelativePath(String workingDirectory, String path) {
        workingDirectory = Utils.pipe(workingDirectory);
        if (!(path = Utils.pipe(path)).equals(workingDirectory) && path.startsWith(workingDirectory)) {
            path = path.substring(workingDirectory.length() + 1);
        }
        path = Utils.unpipe(path, "/");
        return path;
    }

    public static String[] parseCommandLIne(String commandLine) {
        Object arg = "";
        ArrayList<String> list = new ArrayList<String>();
        int len = commandLine.length();
        for (int i = 0; i < commandLine.length(); ++i) {
            String c = i < commandLine.length() - 1 ? commandLine.substring(i, i + 1) : commandLine.substring(i);
            if (c.equals("\"")) {
                ++i;
                while (i < commandLine.length() - 1 && !(c = commandLine.substring(i, i + 1)).equals("\"")) {
                    arg = (String)arg + c;
                    ++i;
                }
                list.add((String)arg);
                arg = "";
                ++i;
                continue;
            }
            if (c.equals(" ") || c.equals("\t")) {
                list.add((String)arg);
                arg = "";
                continue;
            }
            arg = (String)arg + c;
        }
        if (((String)arg).length() > 0) {
            list.add((String)arg);
        }
        String[] results = list.toArray(new String[0]);
        return results;
    }

    public static synchronized String parseHost(String location) {
        String host = null;
        String[] a = location.split(":");
        if (a.length >= 1) {
            host = a[0];
        }
        if (host.length() < 1) {
            host = "localhost";
        }
        return host;
    }

    public static synchronized String parsePort(String location) {
        String port = "";
        String[] a = location.split(":");
        if (a.length == 2) {
            port = a[1];
        }
        return port;
    }

    public static synchronized String pipe(String path) {
        String separator = "\\\\";
        path = path.replaceAll(separator, "|");
        separator = "/";
        path = path.replaceAll(separator, "|");
        path = path.replaceAll("\\|\\|", "|");
        return path;
    }

    public static synchronized String pipe(Repository repo, String path) throws MungeException {
        String separator = repo.getWriteSeparator();
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        String p = path.replaceAll(separator, "|");
        return p;
    }

    public static synchronized String pipe(String path, String separator) {
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        String p = path.replaceAll(separator, "|");
        return p;
    }

    public static void readPreferences(Context context) {
        try {
            Gson gson = new Gson();
            String json = new String(Files.readAllBytes(Paths.get(context.preferences.getFullPath(context.cfg.getWorkingDirectory()), new String[0])));
            Preferences prefs = (Preferences)gson.fromJson(json, context.preferences.getClass());
            if (prefs != null) {
                context.preferences = (Preferences)gson.fromJson(json, context.preferences.getClass());
                context.preferences.setContext(context);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized String readString(String filename) throws Exception {
        Object content = "";
        File file = new File(filename);
        if (file.exists()) {
            URL url = new URL("file:" + filename);
            List<String> lines = IoUtils.readAllLines(url);
            for (int i = 0; i < lines.size(); ++i) {
                content = (String)content + lines.get(i) + System.getProperty("line.separator");
            }
        }
        return content;
    }

    public static synchronized boolean removeDirectoryTree(File directory) {
        File[] all;
        boolean notAllDirectories = false;
        for (File entry : all = directory.listFiles()) {
            if (!entry.isDirectory()) {
                notAllDirectories = true;
                entry.delete();
                continue;
            }
            Utils.removeDirectoryTree(entry);
        }
        directory.delete();
        return notAllDirectories;
    }

    public static String[] removeEmptyElements(String[] elements) {
        int i;
        String[] cleaned = new String[elements.length];
        int j = 0;
        for (i = 0; i < elements.length; ++i) {
            if (elements[i] == null || elements[i].length() <= 0) continue;
            cleaned[j++] = elements[i];
        }
        elements = new String[j];
        for (i = 0; i < j; ++i) {
            elements[i] = cleaned[i];
        }
        return elements;
    }

    public static synchronized int rightIndexOf(String value, String find, int rightSideOccurrence) {
        int count = 0;
        for (int i = value.length() - 1; i > -1; --i) {
            if (value.charAt(i) != find.charAt(0)) continue;
            if (count == rightSideOccurrence) {
                return i;
            }
            ++count;
        }
        return -1;
    }

    public static synchronized String scrubFilename(String name) {
        String scubbed = name.replaceAll("[\\/:*?\"<>|]", "");
        return scubbed;
    }

    public static Set<PosixFilePermission> translateModeToPosix(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 1) > 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((mode & 2) > 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 4) > 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 8) > 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 0x10) > 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 0x20) > 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x40) > 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x80) > 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x100) > 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        return perms;
    }

    public static synchronized String unpipe(Repository repo, String path) throws MungeException {
        String separator = repo.getWriteSeparator();
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        String p = path.replaceAll("\\|", separator);
        return p;
    }

    public static synchronized String unpipe(String path, String separator) {
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        String p = path.replaceAll("\\|", separator);
        return p;
    }
}

