/*
 * Decompiled with CFR 0.152.
 */
package com.corionis.els.gui;

import com.corionis.els.Context;
import com.corionis.els.Utils;
import com.corionis.els.jobs.Job;
import com.corionis.els.tools.AbstractTool;
import com.corionis.els.tools.operations.OperationsTool;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import mslinks.ShellLink;
import mslinks.ShellLinkHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Generator {
    private String consoleLevel = "";
    private Context context;
    private String debugLevel = "";
    private boolean dryRun = false;
    private int dryRunPreset = -1;
    private boolean fileGenerate = false;
    private String generated = "";
    private File logFile = null;
    private Logger logger = LogManager.getLogger("applog");

    private Generator() {
    }

    public Generator(Context context, boolean isFileGenerate) {
        this.context = context;
        this.fileGenerate = isFileGenerate;
    }

    private void createDesktopShortcut(JDialog owner, String name, String commandLine) {
        JPanel panelName = new JPanel();
        panelName.setLayout(new FlowLayout(0, 0, 0));
        JLabel labelName = new JLabel();
        JTextField fieldName = new JTextField();
        JPanel panelComment = new JPanel();
        panelComment.setLayout(new FlowLayout(0, 0, 0));
        JLabel labelComment = new JLabel();
        JTextField fieldComment = new JTextField();
        JPanel panelTerminal = new JPanel();
        panelTerminal.setLayout(new FlowLayout(0, 0, 0));
        JLabel labelTerminal = new JLabel();
        JCheckBox checkboxTerminal = new JCheckBox();
        JPanel panelWarning = new JPanel();
        panelTerminal.setLayout(new FlowLayout(0, 0, 0));
        JLabel labelWarning = new JLabel();
        labelName.setText(this.context.cfg.gs("Generator.shortcut.name"));
        labelName.setPreferredSize(new Dimension(100, 16));
        panelName.add(labelName);
        fieldName.setText(name);
        fieldName.setPreferredSize(new Dimension(200, 30));
        panelName.add(fieldName);
        labelComment.setText(this.context.cfg.gs("Generator.shortcut.comment"));
        labelComment.setPreferredSize(new Dimension(100, 16));
        panelComment.add(labelComment);
        fieldComment.setText(this.context.cfg.gs("Generator.launch.els") + name);
        fieldComment.setPreferredSize(new Dimension(200, 30));
        panelComment.add(fieldComment);
        labelTerminal.setText(this.context.cfg.gs("Generator.shortcut.launch.in.terminal"));
        panelTerminal.add(labelTerminal);
        panelTerminal.add(checkboxTerminal);
        boolean tooLong = false;
        if (commandLine.length() > 260 && Utils.getOS().toLowerCase().equals("windows")) {
            tooLong = true;
            labelWarning.setText(this.context.cfg.gs("Generator.warning.command.line.too.long"));
            panelWarning.add(labelWarning);
        }
        JDialog dialog = new JDialog(owner);
        dialog.setAlwaysOnTop(true);
        Object[] params = new Object[]{panelName, panelComment, panelTerminal, panelWarning};
        int resp = JOptionPane.showConfirmDialog(owner == null ? this.context.mainFrame.panelMain : owner, params, this.context.cfg.gs("Generator.shortcut.title"), tooLong ? -1 : 2, tooLong ? 2 : -1);
        if (resp == 0 && !tooLong) {
            name = fieldName.getText();
            String shortcut = System.getProperty("user.home") + System.getProperty("file.separator") + "Desktop" + System.getProperty("file.separator") + name + (Utils.isOsWindows() ? ".lnk" : (Utils.isOsMac() ? "" : ".desktop"));
            File shortFile = new File(shortcut);
            boolean skip = false;
            if (name.length() == 0) {
                skip = true;
                JOptionPane.showMessageDialog(this.context.mainFrame, this.context.cfg.gs("Generator.name.required"), this.context.cfg.getNavigatorName(), 2);
            } else if (shortFile.exists() && (resp = JOptionPane.showConfirmDialog(this.context.mainFrame, this.context.cfg.gs("Generator.exists.overwrite"), this.context.cfg.getNavigatorName(), 0)) != 0) {
                skip = true;
            }
            if (!skip) {
                if (Utils.isOsMac()) {
                    try {
                        PrintWriter outputStream = new PrintWriter(shortcut);
                        outputStream.println(commandLine);
                        outputStream.close();
                        shortFile.setExecutable(true);
                    }
                    catch (Exception e) {
                        System.out.println(Utils.getStackTrace(e));
                    }
                } else if (Utils.isOsLinux()) {
                    StringBuilder sb = new StringBuilder();
                    name = fieldName.getText();
                    if (name != null && name.length() > 0) {
                        sb.append("[Desktop Entry]\n");
                        sb.append("Name=" + name + "\n");
                        sb.append("Exec=" + commandLine + "\n");
                        sb.append("Comment=" + fieldComment.getText() + "\n");
                        sb.append("Terminal=" + checkboxTerminal.isSelected() + "\n");
                        sb.append("Icon=" + this.context.cfg.getIconPath() + "\n");
                        sb.append("Type=Application\n");
                    }
                    try {
                        PrintWriter outputStream = new PrintWriter(shortcut);
                        outputStream.println(sb);
                        outputStream.close();
                        shortFile.setExecutable(true);
                    }
                    catch (Exception e) {
                        System.out.println(Utils.getStackTrace(e));
                    }
                } else {
                    try {
                        name = fieldName.getText();
                        if (name != null && name.length() > 0) {
                            ShellLink shellLink = new ShellLink();
                            shellLink.setWorkingDir(this.context.cfg.getWorkingDirectory());
                            shellLink.setIconLocation(this.context.cfg.getIconPath());
                            shellLink.getHeader().setIconIndex(0);
                            String exec = this.context.cfg.getExecutablePath();
                            commandLine = commandLine.substring(exec.length()).trim();
                            shellLink.setCMDArgs(commandLine);
                            Path target = Paths.get(this.context.cfg.getExecutablePath(), new String[0]).toAbsolutePath().normalize();
                            String root = target.getRoot().toString();
                            String pathNoRoot = target.subpath(0, target.getNameCount()).toString();
                            ShellLinkHelper helper = new ShellLinkHelper(shellLink);
                            helper.setLocalTarget(root, pathNoRoot, ShellLinkHelper.Options.ForceTypeFile);
                            helper.saveTo(shortcut);
                            this.logger.info(this.context.cfg.gs("Generator.created.shortcut") + shortcut);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(Utils.getStackTrace(e));
                    }
                }
            }
        }
    }

    private String generate(AbstractTool tool, String consoleLevel, String debugLevel, boolean overwrite, String log, boolean foreground) {
        try {
            if (tool == null) {
                this.generated = this.context.cfg.generateCommandLine(consoleLevel, debugLevel, overwrite, log);
            } else if (tool instanceof Job) {
                this.generated = this.generateCommandLineJob(tool, consoleLevel, debugLevel, overwrite, log, foreground);
            }
        }
        catch (Exception e) {
            this.logger.error(Utils.getStackTrace(e));
        }
        return this.generated;
    }

    private String generateCommandLineJob(AbstractTool tool, String consoleLevel, String debugLevel, boolean overwriteLog, String log, boolean foreground) throws Exception {
        boolean glo = this.context.preferences.isGenerateLongOptions();
        String exec = this.context.cfg.getExecutablePath();
        String jar = "";
        Object opts = ((Job)tool).generateCommandLineJob(this.dryRun);
        if (foreground) {
            opts = (String)opts + " --logger";
        }
        String overOpt = overwriteLog ? (glo ? "--log-overwrite" : "-F") : (glo ? "--log-file" : "-f");
        String cmd = exec + (String)(jar.length() > 0 ? " -jar \"" + jar + "\"" : "") + " " + (String)opts + (glo ? " --console-level " : " -c ") + consoleLevel + (glo ? " --debug-level " : " -d ") + debugLevel + " " + overOpt + " \"" + log + "\"";
        return cmd;
    }

    private String getTitle(AbstractTool tool) {
        if (tool == null) {
            return "ELS Navigator";
        }
        if (tool instanceof Job) {
            return this.context.cfg.gs("JobsUI.title");
        }
        if (tool instanceof OperationsTool) {
            return this.context.cfg.gs("Operations.displayName");
        }
        return "unknown";
    }

    public void setDryRunPreset(int dryRunPreset) {
        this.dryRunPreset = dryRunPreset;
    }

    public void showDialog(final JDialog owner, final AbstractTool tool, final String configName) {
        this.context.mainFrame.labelStatusMiddle.setText("");
        String messasge = "<html><body>" + this.context.cfg.gs(this.fileGenerate ? "Generator.generate" : "Generator.generate.run") + " <b>" + configName + "</b><br/>&nbsp;<br/></body></html>";
        JPanel panelLogLevels = new JPanel();
        panelLogLevels.setLayout(new FlowLayout(0, 4, 0));
        JLabel labelConsoleLogLevels = new JLabel();
        JLabel labelDebugLogLevels = new JLabel();
        final JComboBox<String> comboBoxConsoleLevel = new JComboBox<String>();
        final JComboBox<String> comboBoxDebugLevel = new JComboBox<String>();
        JPanel panelLogFile = new JPanel();
        panelLogFile.setLayout(new FlowLayout(0, 4, 0));
        JLabel labelLogFile = new JLabel();
        final JComboBox<String> comboboxLogOverwrite = new JComboBox<String>();
        JButton selectLogButton = new JButton();
        JPanel panelDryrun = new JPanel();
        panelDryrun.setLayout(new FlowLayout(0, 4, 0));
        final JRadioButton foreground = new JRadioButton(this.context.cfg.gs("Generator.foreground"));
        JRadioButton background = new JRadioButton(this.context.cfg.gs("Generator.background"));
        JPanel panelHorizontal1 = new JPanel();
        panelHorizontal1.setLayout(new FlowLayout(0, 0, 2));
        JPanel panelHorizontal2 = new JPanel();
        panelHorizontal2.setLayout(new FlowLayout(0, 0, 2));
        JPanel panelGenerated = new JPanel();
        panelGenerated.setLayout(new FlowLayout(0, 0, 0));
        final JTextField generatedTextField = new JTextField();
        JPanel panelActions = new JPanel();
        panelActions.setLayout(new FlowLayout(0, 4, 0));
        JButton copyButton = new JButton();
        JButton shortcutButton = new JButton();
        labelConsoleLogLevels.setText(this.context.cfg.gs("Generator.labelConsoleLogLevels.text"));
        panelLogLevels.add(labelConsoleLogLevels);
        comboBoxConsoleLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "Trace", "Debug", "Info", "Warn", "Error", "Fatal", "Off"}));
        comboBoxConsoleLevel.setSelectedIndex(3);
        comboBoxConsoleLevel.setToolTipText(this.context.cfg.gs("Generator.comboConsoleLogLevels.tooltip"));
        comboBoxConsoleLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String cmd = actionEvent.getActionCommand();
                if (cmd.equals("comboBoxChanged")) {
                    int selected = comboBoxConsoleLevel.getSelectedIndex();
                    Generator.this.consoleLevel = (String)comboBoxConsoleLevel.getItemAt(selected);
                    String generated = "";
                    generated = Generator.this.generate(tool, Generator.this.consoleLevel, (String)comboBoxDebugLevel.getItemAt(comboBoxDebugLevel.getSelectedIndex()), comboboxLogOverwrite.getSelectedIndex() != 0, Generator.this.logFile.getPath(), foreground.isSelected());
                    generatedTextField.setText(generated);
                }
            }
        });
        panelLogLevels.add(comboBoxConsoleLevel);
        labelDebugLogLevels.setText(this.context.cfg.gs("Generator.labelDebugLogLevels.text"));
        panelLogLevels.add(labelDebugLogLevels);
        comboBoxDebugLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "Trace", "Debug", "Info", "Warn", "Error", "Fatal", "Off"}));
        comboBoxDebugLevel.setSelectedIndex(2);
        comboBoxDebugLevel.setToolTipText(this.context.cfg.gs("Generator.comboDebugLogLevels.tooltip"));
        comboBoxDebugLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String cmd = actionEvent.getActionCommand();
                if (cmd.equals("comboBoxChanged")) {
                    int selected = comboBoxDebugLevel.getSelectedIndex();
                    Generator.this.debugLevel = (String)comboBoxDebugLevel.getItemAt(selected);
                    String generated = "";
                    generated = Generator.this.generate(tool, (String)comboBoxConsoleLevel.getItemAt(comboBoxConsoleLevel.getSelectedIndex()), Generator.this.debugLevel, comboboxLogOverwrite.getSelectedIndex() != 0, Generator.this.logFile.getPath(), foreground.isSelected());
                    generatedTextField.setText(generated);
                }
            }
        });
        panelLogLevels.add(comboBoxDebugLevel);
        labelLogFile.setText(this.context.cfg.gs("Generator.labelLogFile.text"));
        panelLogFile.add(labelLogFile);
        comboboxLogOverwrite.setModel(new DefaultComboBoxModel<String>(new String[]{this.context.cfg.gs("Generator.combobox.log.overwrite.0.log"), this.context.cfg.gs("Generator.combobox.log.overwrite.1.logOverwrite")}));
        comboboxLogOverwrite.setSelectedIndex(this.context.cfg.isLogOverwrite() ? 1 : 0);
        comboboxLogOverwrite.setToolTipText(this.context.cfg.gs("Generator.combobox.log.overwrite.tooltip"));
        comboboxLogOverwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String cmd = actionEvent.getActionCommand();
                if (cmd.equals("comboBoxChanged")) {
                    String generated = "";
                    String logOption = comboboxLogOverwrite.getSelectedIndex() == 0 ? "-f" : "-F";
                    generated = Generator.this.generate(tool, (String)comboBoxConsoleLevel.getItemAt(comboBoxConsoleLevel.getSelectedIndex()), (String)comboBoxDebugLevel.getItemAt(comboBoxDebugLevel.getSelectedIndex()), comboboxLogOverwrite.getSelectedIndex() != 0, Generator.this.logFile.getPath(), foreground.isSelected());
                    generatedTextField.setText(generated);
                }
            }
        });
        panelLogFile.add(comboboxLogOverwrite);
        selectLogButton.setText(this.context.cfg.gs("Generator.select.log.button"));
        selectLogButton.setMnemonic(this.context.cfg.gs("Generator.select.log.button.mnemonic").charAt(0));
        selectLogButton.setToolTipText(this.context.cfg.gs("Generator.select.log.button.tooltip"));
        selectLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(Generator.this.context.cfg.gs("Generator.open.log.file"));
                    fc.setFileHidingEnabled(false);
                    File logDir = new File(Generator.this.context.cfg.getLogFilePath());
                    fc.setCurrentDirectory(logDir);
                    File lf = new File(configName + ".log");
                    fc.setSelectedFile(lf);
                    int selection = fc.showOpenDialog(owner == null ? Generator.this.context.mainFrame.panelMain : owner);
                    if (selection != 0) break block2;
                    File last = fc.getCurrentDirectory();
                    File file = fc.getSelectedFile();
                    if (file.isDirectory()) {
                        JOptionPane.showMessageDialog(owner == null ? Generator.this.context.mainFrame.panelMain : owner, Generator.this.context.cfg.gs("Navigator.open.error.select.a.file.only"), Generator.this.context.cfg.getNavigatorName(), 0);
                    } else {
                        Generator.this.logFile = file;
                        String generated = "";
                        generated = Generator.this.generate(tool, (String)comboBoxConsoleLevel.getItemAt(comboBoxConsoleLevel.getSelectedIndex()), (String)comboBoxDebugLevel.getItemAt(comboBoxDebugLevel.getSelectedIndex()), comboboxLogOverwrite.getSelectedIndex() != 0, Generator.this.logFile.getPath(), foreground.isSelected());
                        generatedTextField.setText(generated);
                    }
                }
            }
        });
        panelLogFile.add(selectLogButton);
        Dimension dimC = comboBoxConsoleLevel.getPreferredSize();
        Dimension dimL = comboboxLogOverwrite.getPreferredSize();
        int margin = dimL.width >= dimC.width ? dimL.width - dimC.width : dimC.width - dimL.width;
        Border before = labelDebugLogLevels.getBorder();
        EmptyBorder spacer = new EmptyBorder(0, margin, 0, 0);
        labelDebugLogLevels.setBorder(new CompoundBorder(before, spacer));
        final JCheckBox checkboxDryrun = new JCheckBox(this.context.cfg.gs("Navigator.dryrun"));
        Dimension dim = labelConsoleLogLevels.getPreferredSize();
        checkboxDryrun.setMargin(new Insets(-8, (int)dim.getWidth() + 5, -12, 0));
        checkboxDryrun.setToolTipText(this.context.cfg.gs("Navigator.dryrun.tooltip"));
        checkboxDryrun.setSelected(this.dryRunPreset > -1 ? this.dryRunPreset != 0 : this.context.preferences.isDefaultDryrun());
        checkboxDryrun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String generated = "";
                Generator.this.dryRun = checkboxDryrun.isSelected();
                generated = Generator.this.generate(tool, (String)comboBoxConsoleLevel.getItemAt(comboBoxConsoleLevel.getSelectedIndex()), (String)comboBoxDebugLevel.getItemAt(comboBoxDebugLevel.getSelectedIndex()), comboboxLogOverwrite.getSelectedIndex() != 0, Generator.this.logFile.getPath(), foreground.isSelected());
                generatedTextField.setText(generated);
            }
        });
        if (!this.fileGenerate) {
            panelDryrun.add(checkboxDryrun);
            JPanel genSpacer1 = new JPanel();
            genSpacer1.setMinimumSize(new Dimension(22, 6));
            genSpacer1.setPreferredSize(new Dimension(22, 6));
            panelDryrun.add(genSpacer1);
            ButtonGroup bg = new ButtonGroup();
            foreground.setToolTipText(this.context.cfg.gs("Generator.foreground.tooltip"));
            foreground.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String generated = "";
                    Generator.this.dryRun = checkboxDryrun.isSelected();
                    generated = Generator.this.generate(tool, (String)comboBoxConsoleLevel.getItemAt(comboBoxConsoleLevel.getSelectedIndex()), (String)comboBoxDebugLevel.getItemAt(comboBoxDebugLevel.getSelectedIndex()), comboboxLogOverwrite.getSelectedIndex() != 0, Generator.this.logFile.getPath(), foreground.isSelected());
                    generatedTextField.setText(generated);
                }
            });
            background.setToolTipText(this.context.cfg.gs("Generator.background.tooltip"));
            background.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String generated = "";
                    Generator.this.dryRun = checkboxDryrun.isSelected();
                    generated = Generator.this.generate(tool, (String)comboBoxConsoleLevel.getItemAt(comboBoxConsoleLevel.getSelectedIndex()), (String)comboBoxDebugLevel.getItemAt(comboBoxDebugLevel.getSelectedIndex()), comboboxLogOverwrite.getSelectedIndex() != 0, Generator.this.logFile.getPath(), foreground.isSelected());
                    generatedTextField.setText(generated);
                }
            });
            bg.add(foreground);
            bg.add(background);
            panelDryrun.add(foreground);
            panelDryrun.add(background);
            if (this.context.preferences.getRunOption() == 0) {
                foreground.setSelected(true);
            } else {
                background.setSelected(true);
            }
        }
        JSeparator horizontalLine = new JSeparator(0);
        generatedTextField.setPreferredSize(new Dimension(558, 30));
        String logDir = this.context.cfg.getLogFilePath();
        this.logFile = new File(logDir + configName + ".log");
        String generated = this.generate(tool, (String)comboBoxConsoleLevel.getItemAt(comboBoxConsoleLevel.getSelectedIndex()), (String)comboBoxDebugLevel.getItemAt(comboBoxDebugLevel.getSelectedIndex()), comboboxLogOverwrite.getSelectedIndex() != 0, this.logFile.getPath(), foreground.isSelected());
        generatedTextField.setText(generated);
        panelGenerated.add(generatedTextField);
        copyButton.setText(this.context.cfg.gs("Generator.clipboard.copy"));
        copyButton.setMnemonic(this.context.cfg.gs("Generator.clipboard.copy.mnemonic").charAt(0));
        copyButton.setToolTipText(this.context.cfg.gs("Generator.clipboard.copy.tooltip"));
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                generatedTextField.selectAll();
                generatedTextField.requestFocus();
                StringSelection selection = new StringSelection(generatedTextField.getText());
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(selection, null);
            }
        });
        panelActions.add(copyButton);
        shortcutButton.setText(this.context.cfg.gs("Generator.shortcut"));
        shortcutButton.setMnemonic(this.context.cfg.gs("Generator.shortcut.mnemonic").charAt(0));
        shortcutButton.setToolTipText(this.context.cfg.gs("Generator.shortcut.tooltip"));
        shortcutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Generator.this.createDesktopShortcut(owner, configName, generatedTextField.getText());
            }
        });
        panelActions.add(shortcutButton);
        if (!this.fileGenerate) {
            JPanel genSpacer2 = new JPanel();
            genSpacer2.setMinimumSize(new Dimension(22, 6));
            genSpacer2.setPreferredSize(new Dimension(22, 6));
            panelActions.add(genSpacer2);
            JButton runButton = new JButton();
            runButton.setText(this.context.cfg.gs("Z.run.ellipsis"));
            runButton.setMnemonic(this.context.cfg.gs("Z.run.mnemonic").charAt(0));
            runButton.setToolTipText(this.context.cfg.gs("Z.run.tooltip"));
            runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object message;
                    Object[] params;
                    String status;
                    if (tool.isDataChanged()) {
                        JOptionPane.showMessageDialog(owner == null ? Generator.this.context.mainFrame.panelMain : owner, Generator.this.context.cfg.gs("Z.please.save.then.run"), Generator.this.context.cfg.gs("JobsUI.title"), 2);
                        return;
                    }
                    if (tool.getInternalName().equalsIgnoreCase(Job.INTERNAL_NAME) && (status = ((Job)tool).validate(Generator.this.context.cfg, false)).length() > 0) {
                        JOptionPane.showMessageDialog(owner == null ? Generator.this.context.mainFrame.panelMain : owner, status, Generator.this.context.cfg.gs("JobsUI.title"), 2);
                        return;
                    }
                    int reply = JOptionPane.showConfirmDialog(owner == null ? Generator.this.context.mainFrame.panelMain : owner, params = new Object[]{message = MessageFormat.format(Generator.this.context.cfg.gs("JobsUI.run.as.defined"), tool.getConfigName())}, Generator.this.context.cfg.gs("JobsUI.title"), 0);
                    if (reply == 0) {
                        try {
                            String cmd = Generator.this.generate(tool, (String)comboBoxConsoleLevel.getItemAt(comboBoxConsoleLevel.getSelectedIndex()), (String)comboBoxDebugLevel.getItemAt(comboBoxDebugLevel.getSelectedIndex()), comboboxLogOverwrite.getSelectedIndex() != 0, Generator.this.logFile.getPath(), foreground.isSelected());
                            String[] parms = Utils.parseCommandLIne(cmd);
                            Generator.this.logger.info(Generator.this.context.cfg.gs("Z.launching") + cmd);
                            Process process = Runtime.getRuntime().exec(parms);
                        }
                        catch (Exception e) {
                            Generator.this.logger.error(Utils.getStackTrace(e));
                            message = Generator.this.context.cfg.gs("Generator.error.launching") + tool.getConfigName() + ", " + e.getMessage();
                            Object[] opts = new Object[]{Generator.this.context.cfg.gs("Z.ok")};
                            JOptionPane.showOptionDialog(owner == null ? Generator.this.context.mainFrame.panelMain : owner, message, Generator.this.getTitle(tool), -1, 0, null, opts, opts[0]);
                        }
                    }
                }
            });
            panelActions.add(runButton);
        }
        Object[] params = new Object[]{messasge, panelLogLevels, panelLogFile, panelDryrun, panelHorizontal1, horizontalLine, panelHorizontal2, panelGenerated, panelActions};
        JOptionPane.showMessageDialog(owner == null ? this.context.mainFrame.panelMain : owner, params, this.getTitle(tool), -1);
        if (!this.fileGenerate) {
            if (foreground.isSelected()) {
                this.context.preferences.setRunOption(0);
            } else if (background.isSelected()) {
                this.context.preferences.setRunOption(1);
            }
        }
    }
}

